module Chake
  class ConfigManager
    class ItamaeBase < ConfigManager
      def converge
        recipes = node.data[name]
        return if recipes.empty?

        run_itamae(false, *recipes)
      end

      def preview
        recipes = node.data['itamae-remote']
        return if recipes.empty?

        run_itamae(true, *recipes)
      end

      def apply(config)
        run_itamae(false, config)
      end
    end
  end
end
