README for Debian devscripts package
====================================

Devscripts provides several scripts which may be of use to Debian
developers.  The following gives a summary of the available scripts --
please read the manpages for full details about the use of these
scripts.  They are contributed by multiple developers; for details of
the authors, please see the code or manpages.

Also, many of these scripts have dependencies on other packages, but
rather than burden the package with a large number of dependencies,
most of which will not be needed by most people, the individual
dependencies are listed as "Recommends" in the control file; lastly,
scripts that are unlikely to be used by many people have their dependencies
categorized as "Suggests" in the control file.  This
ensures that the packages will be installed by default but allows
users to remove them if desired.  The dependencies and recommendations
are listed in square brackets in the description below, as well as in
the Description field in the control file.
The scripts marked with an asterisk ('*') are considered "core", and as
such have their dependencies all listed as hard "Depends".

And now, in alphabetical order, the scripts:

- annotate-output: run a command and prepend time and stream (O for stdout,
  E for stderr) for every line of output.

- archpath: Prints arch (tla/Bazaar 1.x) package names. Also supports
  calculating the package names for other branches. [tla]

- bts: Comprehensive CLI for the Debian Bug Tracking System (BTS).
  Supports 1) reading and finding bugs in CLI email clients (MUAs) or
  a web-browser, 2) changing bugs non-interactively, 3) submitting and
  replying to bugs efficiently from your shell or MUA and finally 4) fetching
  bug information directly from the BTS SOAP interface.
  [www-browser, libauthen-sasl-perl, libsoap-lite-perl, liburi-perl,
  libwww-perl, default-mta | mail-transport-agent]

- build-rdeps: Searches for all packages that build-depend on a given
  package. [dctrl-tools, dose-extra, libdpkg-perl]

- chdist: tool to easily play with several distributions. [dctrl-tools]

- checkbashisms: check whether a /bin/sh script contains any common
  bash-specific constructs.

- cowpoke: upload a Debian source package to a cowbuilder host and build it,
  optionally also signing and uploading the result to an incoming queue.
  [ssh-client]

- dcmd: run a given command replacing the name of a .changes or .dsc file
  with each of the files referenced therein. *

- dd-list: given a list of packages, pretty-print it ordered by maintainer. *

- debbisect: bisect snapshot.debian.org to find which change in the archive
  introduced a certain problem. [debvm, mmdebstrap, python3-debian]

- debc: List contents of current package.  Do this after a successful
  "debuild" to see if the package looks all right.

- debchange (abbreviation dch): Modifies debian/changelog and manages version
  numbers for you.  It will either increment the version number or add an
  entry for the current version, depending upon the options given to it.
  [libdistro-info-perl, libsoap-lite-perl]*

- debcheckout: checkout the development repository of a Debian package. *

- debclean: Clean a Debian source tree.  Debclean will clean all Debian
  source trees below the current directory, and if requested, also remove
  all files that were generated from these source trees (that is .deb, .dsc
  and .changes files).  It will keep the .diffs and original files, though,
  so that the binaries and other files can be rebuilt if necessary. *

- debcommit: Commits changes to cvs, darcs, svn, svk, tla, bzr, git, or hg,
  using new entries in debian/changelog as the commit message. Also supports
  tagging Debian package releases. [cvs | darcs | subversion | svk | tla |
  bzr | git-core | mercurial, libtimedate-perl]

- debdiff: A program which examines two .deb files or two .changes files and
  reports on any difference found in their file lists.  Useful for ensuring
  that no files were inadvertently lost between versions.  Can also examine
  two .dsc files and report on the changes between source versions.
  For a deeper comparison one can use the diffoscope package.
  [wdiff, patchutils]*

- debdiff-apply: Apply unified diffs of two Debian source packages, such as
  those generated by debdiff, to a target Debian source package. Any changes
  to debian/changelog are dealt with specially, to avoid the conflicts that
  changelog diffs typically produce when applied naively. May be used to
  check that old patches still apply to newer versions of those packages.
  [python3-debian, python3-unidiff, quilt]

- debftbfs: list source packages which have FTBFS bugs filed against them
  and print them with the bug number and title.
  [postgresql-client, python3-debian, python3-debianbts]

- debi: Installs the current package by using dpkg.  It assumes that the
  current package has just been built (for example by debuild), and the .deb
  lives in the parent directory, and will effectively run dpkg -i on the .deb.
  The ability to install the package with a very short command is very
  useful when troubleshooting packages.

- debootsnap: Combines debootstrap and snapshot.debian.org to create a chroot
  containing exactly the requested selection of packages. This can be used
  to re-create a chroot from the past, for example to reproduce a bug. The
  tool is also used by debrebuild to build a package in a chroot with build
  dependencies in the same version as recorded in the buildinfo file.
  [apt-utils, equivs, mmdebstrap, python3-debian, python3-pycurl,
  python3-requests]

- debrelease: A wrapper around dupload or dput which figures out which
  version to upload, and then calls dupload or dput to actually perform
  the upload. [dupload | dput, ssh-client]

- debrebuild: Given a buildinfo file, builds the referenced source package
  in an environment documented in the provided buildinfo file. The build
  can be performed by sbuild or other builders in a chroot environment created
  by debootsnap. The generated artifacts will be verified against the hashes
  from the buildinfo file. [sbuild | mmdebstrap, python3-pycurl,
  libdpkg-perl, libstring-shellquote-perl]

- debrepro: A script that tests reproducibility of Debian packages. It will
  build a given source directory twice, with a set of variation between the
  first and second build, and compare the binary packages produced. If
  diffoscope is installed, it is used to compare non-matching binaries. If
  disorderfs is installed, it is used during the build to inject
  non-determinism in filesystem listing operations.
  [faketime, diffoscope, disorderfs]

- debrsign: This transfers a .changes/.dsc pair to a remote machine for
  signing, and runs debsign on the remote machine over an SSH connection.
  [gnupg, debian-keyring, ssh-client]

- debsign: Use GNU Privacy Guard to sign the changes (and possibly dsc)
  files created by running dpkg-buildpackage with no-sign options.  Useful
  if you are building a package on a remote machine and wish to sign it on
  a local one.  This script is capable of automatically downloading the
  .changes and .dsc files from a remote machine. [gnupg, debian-keyring,
  ssh-client]*

- debsnap: grab packages from https://snapshot.debian.org [libwww-perl,
  libjson-perl]

- debuild: A wrapper for building a package (i.e., dpkg-buildpackage) to
  avoid problems with insufficient permissions and wrong paths etc.
  Debuild will set up the proper environment for building a package.
  Debuild will also run lintian to check that the package does not
  have any major policy violations. [lintian, gnupg]*

- deb-check-file-conflicts: Check (using apt-file) if a Debian package
  installs files in the exact same path as any other package, and if
  there are Breaks/Replaces (or Conflicts) defined in debian/control
  to avoid the package installation failing on file conflicts.

- deb-janitor: command-line client for interacting with the Debian Janitor.

- deb-reversion: increases a binary package version number and repacks the
  package, useful for porters and the like.

- deb-why-removed: shows the reason a package was removed from the archive.
  [libdpkg-perl]

- deb2apptainer: build a Singularity/Apptainer image with given Debian
  packages.

- deb2docker: build a docker image with given Debian packages. [docker.io]

- dep3changelog: generate a changelog entry from a DEP3-style patch header.

- dep-14-convert-git-branch-names: Convert git branches to follow DEP-14.

- dget: Downloads Debian source and binary packages. Point at a .changes or
  .dsc to download all references files. Specify a package name to download
  it from the configured apt repository. [wget | curl]

- diff2patches: extracts patches from a .diff.gz file placing them under
  debian/ or, if present, debian/patches. [patchutils]

- dpkg-depcheck, dpkg-genbuilddeps: Runs a specified command (such as
  debian/rules build) or dpkg-buildpackage, respectively, to determine the
  packages used during the build process.  This information can be helpful
  when trying to determine the packages needed in the Build-Depends etc.
  lines in the debian/control file. [build-essential, strace]

- dscextract: extract a single file from a Debian source package.
  [patchutils]

- dscverify: check the signature and MD5 sums of a dsc file against the most
  current Debian keyring on your system.
  [gnupg, debian-keyring, debian-tag2upload-keyring]

- edit-patch: add/edit a patch for a source package and commit the changes.
  [quilt]

- getbuildlog: download package build logs from Debian auto-builders. [wget]

- grep-excuses: grep britney's excuses to find out what is happening to your
  packages.
  [libdbd-pg-perl, libterm-size-perl, libyaml-libyaml-perl, wget, w3m]

- hardening-check: report the hardening characteristics of a set of binaries.

- list-unreleased: searches for packages marked UNRELEASED in their
  changelog.

- ltnu (Long Time No Upload): List all uploads of packages by the
  given uploader or maintainer and display them ordered by the last
  upload of that package, oldest uploads first.

- manpage-alert: locate binaries without corresponding manpages. [man-db]

- mass-bug: mass-file bug reports. [bsd-mailx | mailx]

- mergechanges: merge .changes files from the same release but built
  on different architectures.

- mk-build-deps: Given a package name and/or control file, generate a binary
  package which may be installed to satisfy the build-dependencies of the
  given package. [equivs]

- mk-origtargz: Rename upstream tarball, optionally changing the compression
  and removing unwanted files.
  [libfile-which-perl, unzip, xz-utils, file]

- namecheck: Check project names are not already taken.

- nmudiff: prepare a diff of this version (presumably an NMU against the
  previously released version (as per the changelog) and submit the diff
  to the BTS. [patchutils, mutt]

- origtargz: fetch the orig tarball of a Debian package from various sources,
  and unpack it. [pristine-tar, pristine-lfs]

- plotchangelog: display information from a changelog graphically using
  gnuplot. [libtimedate-perl, gnuplot]

- pts-subscribe: subscribe to the PTS (Package Tracking System) for a
  limited period of time. [bsd-mailx | mailx, at]

- rc-alert: list installed packages which have release-critical bugs.
  [wget | curl]

- reproducible-check: reports on the reproducible status of installed
  packages. For more details please see <https://reproducible-builds.org>.

- rmadison: remotely query the Debian archive database about packages.
  [liburi-perl, wget | curl]

- sadt: run DEP-8 tests. [python3-debian, autodep8]

- salsa: manipulates salsa.debian.org repositories and users
  [libgitlab-api-v4-perl]

- suspicious-source: output a list of files which are not common source
  files. [python3-magic]

- svnpath: Prints the path to the Subversion repository of a Subversion
  checkout. Also supports calculating the paths for branches and
  tags in a repository independent fashion. Used by debcommit to generate
  svn tags. [subversion]

- tagpending: runs from a Debian source tree and tags bugs that are to be
  closed in the latest changelog as pending. [libsoap-lite-perl]

- transition-check: Check a list of source packages for involvement in
  transitions for which uploads to unstable are currently blocked.
  [libwww-perl, libyaml-libyaml-perl]

- uscan: Automatically scan for and download upstream updates.  Uscan can
  also call a program such as uupdate to attempt to update the Debianised
  version based on the new update.  Whilst uscan could be used to release
  the updated version automatically, it is probably better not to without
  testing it first.  Uscan can also verify detached OpenPGP signatures if
  upstream's signing key is known. [file, sopv | gpgv,
  libfile-dirlist-perl, libfile-touch-perl, libfile-which-perl,
  liblwp-protocol-https-perl, libmoo-perl, libwww-perl, unzip, xz-utils]*

- uupdate: Update the package with an archive or patches from
  an upstream author.  This will be of help if you have to update your
  package.  It will try to apply the latest diffs to your package and
  tell you how successful it was. [patch]

- whodepends: check which maintainers' packages depend on a package.

- who-permits-upload: Retrieve information about Debian Maintainer access
  control lists. [gnupg, libencode-locale-perl, libwww-perl, debian-keyring]

- who-uploads: determine the most recent uploaders of a package to the Debian
  archive. [gnupg, debian-keyring, debian-maintainers, wget]

- wnpp-alert: list installed packages which are orphaned or up for adoption.
  [wget | curl]

- wnpp-check: check whether there is an open request for packaging or
  intention to package bug for a package. [wget | curl]

- wrap-and-sort: wrap long lines and sort items in packaging files.
  [python3-debian]

- /usr/share/doc/devscripts/examples: This directory contains an example
  exim script for sorting mail arriving to Debian mailing lists.

Typical Maintenance cycle with devscripts
-----------------------------------------

1. cd <source directory of package>

2. Editing of files

3. Log the changes with: dch -i "I changed this"
   If desired, use debcommit to commit changes to cvs, svn, arch or git.

4. Run debuild to compile it.  If it fails, return to 2.  (You could
   also just test the compilation by running the appropriate part of
   debian/rules.)

5. Check if package contents appear to be ok with "debc"

6. Install the package with "debi" and test the functionality it
   should provide.  (Note that this step requires debpkg to be setuid
   root, or you to be logged in as root or similar.)

7. If all is ok release it by running debrelease.

8. Optionally, use debcommit --release to commit and tag the release
   in revision control.


Originally by Christoph Lameter <clameter@waterf.org>
Modified extensively by Julian Gilbey <jdg@debian.org>
