// Code generated by smithy-go-codegen DO NOT EDIT.

package observabilityadmin

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/observabilityadmin/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Returns a list of telemetry configurations for Amazon Web Services resources
//
// supported by telemetry config in the organization.
func (c *Client) ListResourceTelemetryForOrganization(ctx context.Context, params *ListResourceTelemetryForOrganizationInput, optFns ...func(*Options)) (*ListResourceTelemetryForOrganizationOutput, error) {
	if params == nil {
		params = &ListResourceTelemetryForOrganizationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListResourceTelemetryForOrganization", params, optFns, c.addOperationListResourceTelemetryForOrganizationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListResourceTelemetryForOrganizationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListResourceTelemetryForOrganizationInput struct {

	//  A list of Amazon Web Services accounts used to filter the resources to those
	// associated with the specified accounts.
	AccountIdentifiers []string

	//  A number field used to limit the number of results within the returned list.
	MaxResults *int32

	//  The token for the next set of items to return. A previous call provides this
	// token.
	NextToken *string

	//  A string used to filter resources in the organization which have a
	// ResourceIdentifier starting with the ResourceIdentifierPrefix .
	ResourceIdentifierPrefix *string

	//  A key-value pair to filter resources in the organization based on tags
	// associated with the resource. Fore more information about tags, see [What are tags?]
	//
	// [What are tags?]: https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/what-are-tags.html
	ResourceTags map[string]string

	//  A list of resource types used to filter resources in the organization. If this
	// parameter is provided, the resources will be returned in the same order used in
	// the request.
	ResourceTypes []types.ResourceType

	//  A key-value pair to filter resources in the organization based on the
	// telemetry type and the state of the telemetry configuration. The key is the
	// telemetry type and the value is the state.
	TelemetryConfigurationState map[string]types.TelemetryState

	noSmithyDocumentSerde
}

type ListResourceTelemetryForOrganizationOutput struct {

	//  The token for the next set of items to return. A previous call provides this
	// token.
	NextToken *string

	//  A list of telemetry configurations for Amazon Web Services resources supported
	// by telemetry config in the organization.
	TelemetryConfigurations []types.TelemetryConfiguration

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListResourceTelemetryForOrganizationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListResourceTelemetryForOrganization{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListResourceTelemetryForOrganization{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListResourceTelemetryForOrganization"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListResourceTelemetryForOrganization(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListResourceTelemetryForOrganizationPaginatorOptions is the paginator options
// for ListResourceTelemetryForOrganization
type ListResourceTelemetryForOrganizationPaginatorOptions struct {
	//  A number field used to limit the number of results within the returned list.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListResourceTelemetryForOrganizationPaginator is a paginator for
// ListResourceTelemetryForOrganization
type ListResourceTelemetryForOrganizationPaginator struct {
	options   ListResourceTelemetryForOrganizationPaginatorOptions
	client    ListResourceTelemetryForOrganizationAPIClient
	params    *ListResourceTelemetryForOrganizationInput
	nextToken *string
	firstPage bool
}

// NewListResourceTelemetryForOrganizationPaginator returns a new
// ListResourceTelemetryForOrganizationPaginator
func NewListResourceTelemetryForOrganizationPaginator(client ListResourceTelemetryForOrganizationAPIClient, params *ListResourceTelemetryForOrganizationInput, optFns ...func(*ListResourceTelemetryForOrganizationPaginatorOptions)) *ListResourceTelemetryForOrganizationPaginator {
	if params == nil {
		params = &ListResourceTelemetryForOrganizationInput{}
	}

	options := ListResourceTelemetryForOrganizationPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListResourceTelemetryForOrganizationPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListResourceTelemetryForOrganizationPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListResourceTelemetryForOrganization page.
func (p *ListResourceTelemetryForOrganizationPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListResourceTelemetryForOrganizationOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListResourceTelemetryForOrganization(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListResourceTelemetryForOrganizationAPIClient is a client that implements the
// ListResourceTelemetryForOrganization operation.
type ListResourceTelemetryForOrganizationAPIClient interface {
	ListResourceTelemetryForOrganization(context.Context, *ListResourceTelemetryForOrganizationInput, ...func(*Options)) (*ListResourceTelemetryForOrganizationOutput, error)
}

var _ ListResourceTelemetryForOrganizationAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListResourceTelemetryForOrganization(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListResourceTelemetryForOrganization",
	}
}
