//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappservice_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2023-01-01/examples/ListOperations.json
func ExampleDomainRegistrationProviderClient_NewListOperationsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDomainRegistrationProviderClient().NewListOperationsPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CsmOperationCollection = armappservice.CsmOperationCollection{
		// 	Value: []*armappservice.CsmOperationDescription{
		// 		{
		// 			Name: to.Ptr("Microsoft.DomainRegistration/domains/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get the list of domains"),
		// 				Operation: to.Ptr("Get Domains"),
		// 				Provider: to.Ptr("Microsoft Domains"),
		// 				Resource: to.Ptr("Domain"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DomainRegistration/domains/Write"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Add a new Domain or update an existing one"),
		// 				Operation: to.Ptr("Add or Update Domain"),
		// 				Provider: to.Ptr("Microsoft Domains"),
		// 				Resource: to.Ptr("Domain"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DomainRegistration/domains/Delete"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Delete an existing domain."),
		// 				Operation: to.Ptr("Delete Domain"),
		// 				Provider: to.Ptr("Microsoft Domains"),
		// 				Resource: to.Ptr("Domain"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DomainRegistration/domains/operationresults/Read"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Get a domain operation"),
		// 				Operation: to.Ptr("Get Domain Operation"),
		// 				Provider: to.Ptr("Microsoft Domains"),
		// 				Resource: to.Ptr("Domain operation"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DomainRegistration/generateSsoRequest/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Generate a request for signing into domain control center."),
		// 				Operation: to.Ptr("Generate Domain Control Center Single Sign On Request"),
		// 				Provider: to.Ptr("Microsoft Domains"),
		// 				Resource: to.Ptr("Domain Control Center Single Sign On Request"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DomainRegistration/validateDomainRegistrationInformation/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Validate domain purchase object without submitting it"),
		// 				Operation: to.Ptr("Domain Purchase Info Validation"),
		// 				Provider: to.Ptr("Microsoft Domains"),
		// 				Resource: to.Ptr("Domain Validation"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DomainRegistration/checkDomainAvailability/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Check if a domain is available for purchase"),
		// 				Operation: to.Ptr("Check Domain Availability"),
		// 				Provider: to.Ptr("Microsoft Domains"),
		// 				Resource: to.Ptr("Domain Availability Result"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DomainRegistration/listDomainRecommendations/Action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Retrieve the list domain recommendations based on keywords"),
		// 				Operation: to.Ptr("Retrieve Domain Recommendations"),
		// 				Provider: to.Ptr("Microsoft Domains"),
		// 				Resource: to.Ptr("Domain Recommendations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DomainRegistration/register/action"),
		// 			Display: &armappservice.CsmOperationDisplay{
		// 				Description: to.Ptr("Register the Microsoft Domains resource provider for the subscription"),
		// 				Operation: to.Ptr("Register Microsoft Domains resource provider"),
		// 				Provider: to.Ptr("Microsoft Domains"),
		// 				Resource: to.Ptr("Microsoft Domains resource provider"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 	}},
		// }
	}
}
