#
# Gramps - a GTK+/GNOME based genealogy program
#
# Copyright (C) 2002-2006  Donald N. Allingham
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, see <https://www.gnu.org/licenses/>.
#

# -------------------------------------------------------------------------
#
# Standard Python modules
#
# -------------------------------------------------------------------------
from ....const import GRAMPS_LOCALE as glocale
from ....db import Database

_ = glocale.translation.gettext

# -------------------------------------------------------------------------
#
# Gramps modules
#
# -------------------------------------------------------------------------
from .. import HasGrampsId


# -------------------------------------------------------------------------
#
# HasIdOf
#
# -------------------------------------------------------------------------
class HasIdOf(HasGrampsId):
    """Rule that checks for a family with a specific Gramps ID"""

    name = _("Family with <Id>")
    description = _("Matches a family with a specified Gramps ID")

    def prepare(self, db: Database, user):
        data = db._get_raw_family_from_id_data(self.list[0])
        if data:
            self.selected_handles = set([data.handle])
        else:
            self.selected_handles = set([])
