The rate estimator can match on estimated rates as collected by the RATEEST
target. It supports matching on absolute bps/pps values, comparing two rate
estimators and matching on the difference between two rate estimators.
.PP
For a better understanding of the available options, these are all possible
combinations:
.TP
Absolute:
.IP \(bu 4
\fBrateest\fP \fIoperator\fP \fBrateest-bps\fP
.IP \(bu 4
\fBrateest\fP \fIoperator\fP \fBrateest-pps\fP
.TP
Absolute + Delta:
.IP \(bu 4
(\fBrateest\fP minus \fBrateest-bps1\fP) \fIoperator\fP \fBrateest-bps2\fP
.IP \(bu 4
(\fBrateest\fP minus \fBrateest-pps1\fP) \fIoperator\fP \fBrateest-pps2\fP
.TP
Relative:
.IP \(bu 4
\fBrateest1\fP \fIoperator\fP \fBrateest2\fP \fBrateest-bps\fP(without rate!)
.IP \(bu 4
\fBrateest1\fP \fIoperator\fP \fBrateest2\fP \fBrateest-pps\fP(without rate!)
.TP
Relative + Delta:
.IP \(bu 4
(\fBrateest1\fP minus \fBrateest-bps1\fP) \fIoperator\fP
(\fBrateest2\fP minus \fBrateest-bps2\fP)
.IP \(bu 4
(\fBrateest1\fP minus \fBrateest-pps1\fP) \fIoperator\fP
(\fBrateest2\fP minus \fBrateest-pps2\fP)
.TP
\fB\-\-rateest\-delta\fP
For each estimator (either absolute or relative mode), calculate the difference
between the estimator-determined flow rate and the static value chosen with the
BPS/PPS options. If the flow rate is higher than the specified BPS/PPS, 0 will
be used instead of a negative value. In other words, "max(0, rateest#_rate \-
rateest#_bps)" is used.
.TP
[\fB!\fP] \fB\-\-rateest\-lt\fP
Match if rate is less than given rate/estimator.
.TP
[\fB!\fP] \fB\-\-rateest\-gt\fP
Match if rate is greater than given rate/estimator.
.TP
[\fB!\fP] \fB\-\-rateest\-eq\fP
Match if rate is equal to given rate/estimator.
.PP
In the so-called "absolute mode", only one rate estimator is used and compared
against a static value, while in "relative mode", two rate estimators are
compared against another.
.TP
\fB\-\-rateest\fP \fIname\fP
Name of the one rate estimator for absolute mode.
.TP
\fB\-\-rateest1\fP \fIname\fP
.TP
\fB\-\-rateest2\fP \fIname\fP
The names of the two rate estimators for relative mode.
.TP
\fB\-\-rateest\-bps\fP [\fIvalue\fP]
.TP
\fB\-\-rateest\-pps\fP [\fIvalue\fP]
.TP
\fB\-\-rateest\-bps1\fP [\fIvalue\fP]
.TP
\fB\-\-rateest\-bps2\fP [\fIvalue\fP]
.TP
\fB\-\-rateest\-pps1\fP [\fIvalue\fP]
.TP
\fB\-\-rateest\-pps2\fP [\fIvalue\fP]
Compare the estimator(s) by bytes or packets per second, and compare against
the chosen value. See the above bullet list for which option is to be used in
which case. A unit suffix may be used \(em available ones are: bit, [kmgt]bit,
[KMGT]ibit, Bps, [KMGT]Bps, [KMGT]iBps.
.PP
Example: This is what can be used to route outgoing data connections from an
FTP server over two lines based on the available bandwidth at the time the data
connection was started:
.PP
# Estimate outgoing rates
.PP
iptables \-t mangle \-A POSTROUTING \-o eth0 \-j RATEEST \-\-rateest\-name eth0
\-\-rateest\-interval 250ms \-\-rateest\-ewma 0.5s
.PP
iptables \-t mangle \-A POSTROUTING \-o ppp0 \-j RATEEST \-\-rateest\-name ppp0
\-\-rateest\-interval 250ms \-\-rateest\-ewma 0.5s
.PP
# Mark based on available bandwidth
.PP
iptables \-t mangle \-A balance \-m conntrack \-\-ctstate NEW \-m helper \-\-helper ftp
\-m rateest \-\-rateest\-delta \-\-rateest1 eth0 \-\-rateest\-bps1 2.5mbit \-\-rateest\-gt
\-\-rateest2 ppp0 \-\-rateest\-bps2 2mbit \-j CONNMARK \-\-set\-mark 1
.PP
iptables \-t mangle \-A balance \-m conntrack \-\-ctstate NEW \-m helper \-\-helper ftp
\-m rateest \-\-rateest\-delta \-\-rateest1 ppp0 \-\-rateest\-bps1 2mbit \-\-rateest\-gt
\-\-rateest2 eth0 \-\-rateest\-bps2 2.5mbit \-j CONNMARK \-\-set\-mark 2
.PP
iptables \-t mangle \-A balance \-j CONNMARK \-\-restore\-mark
