; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 6
; RUN: llc -mtriple=thumbv6m-none-eabi < %s | FileCheck %s

; This test verifies that Thumb1 (ARMv6-M) generates correct code for backend KCFI.
; Thumb1 uses the backend KCFI implementation with Thumb1-specific instructions.

; Test function without KCFI annotation
; CHECK-LABEL: .globl nosan
; CHECK-NEXT:  .p2align 1
; CHECK-NEXT:  .type nosan,%function
; CHECK-NEXT:  .code 16
; CHECK-NEXT:  .thumb_func
define dso_local void @nosan() nounwind {
; CHECK-LABEL: nosan:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    bx lr
  ret void
}

; Test function with KCFI annotation - verifies type hash emission
;; The alignment is at least 4 to avoid unaligned type hash loads when this
;; instrumented function is indirectly called.
; CHECK-LABEL: .globl target_func
; CHECK-NEXT:  .p2align 2
; CHECK-NEXT:  .type target_func,%function
; CHECK-NEXT:  .long 3170468932
; CHECK-NEXT:  .code 16
; CHECK-NEXT:  .thumb_func
define void @target_func() !kcfi_type !1 {
; CHECK-LABEL: target_func:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    bx lr
  ret void
}

; Test indirect call with KCFI check using operand bundles
; CHECK-LABEL: .globl f1
; CHECK:       .p2align 2
; CHECK-NEXT:  .type f1,%function
; CHECK-NEXT:  .long 3170468932
; CHECK-NEXT:  .code 16
; CHECK-NEXT:  .thumb_func
define void @f1(ptr noundef %x) !kcfi_type !1 {
; CHECK-LABEL: f1:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    movs r3, #1
; CHECK-NEXT:    mov r2, r0
; CHECK-NEXT:    bics r2, r3
; CHECK-NEXT:    subs r2, #4
; CHECK-NEXT:    ldr r2, [r2]
; CHECK-NEXT:    movs r3, #188
; CHECK-NEXT:    lsls r3, r3, #8
; CHECK-NEXT:    adds r3, #249
; CHECK-NEXT:    lsls r3, r3, #8
; CHECK-NEXT:    adds r3, #132
; CHECK-NEXT:    lsls r3, r3, #8
; CHECK-NEXT:    adds r3, #68
; CHECK-NEXT:    cmp r2, r3
; CHECK-NEXT:    beq .Ltmp0
; CHECK-NEXT:    bkpt #0
; CHECK-NEXT:  .Ltmp0:
; CHECK-NEXT:    blx r0
; CHECK-NEXT:    pop {r7, pc}
  call void %x() [ "kcfi"(i32 -1124498364) ]
  ret void
}

; Test with tail call - backend KCFI supports tail calls
define void @f2(ptr noundef %x) !kcfi_type !1 {
; CHECK-LABEL: f2:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    movs r3, #1
; CHECK-NEXT:    mov r2, r0
; CHECK-NEXT:    bics r2, r3
; CHECK-NEXT:    subs r2, #4
; CHECK-NEXT:    ldr r2, [r2]
; CHECK-NEXT:    movs r3, #188
; CHECK-NEXT:    lsls r3, r3, #8
; CHECK-NEXT:    adds r3, #249
; CHECK-NEXT:    lsls r3, r3, #8
; CHECK-NEXT:    adds r3, #132
; CHECK-NEXT:    lsls r3, r3, #8
; CHECK-NEXT:    adds r3, #68
; CHECK-NEXT:    cmp r2, r3
; CHECK-NEXT:    beq .Ltmp1
; CHECK-NEXT:    bkpt #0
; CHECK-NEXT:  .Ltmp1:
; CHECK-NEXT:    blx r0
; CHECK-NEXT:    pop {r7, pc}
  tail call void %x() [ "kcfi"(i32 -1124498364) ]
  ret void
}

; Test with R2 live (3 arguments) - compiler shuffles args, no spilling needed
define void @f3_r2_live(ptr noundef %x, i32 %a, i32 %b, i32 %c) !kcfi_type !1 {
; CHECK-LABEL: f3_r2_live:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    mov r4, r0
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    mov r1, r2
; CHECK-NEXT:    mov r2, r3
; CHECK-NEXT:    push {r2}
; CHECK-NEXT:    movs r3, #1
; CHECK-NEXT:    mov r2, r4
; CHECK-NEXT:    bics r2, r3
; CHECK-NEXT:    subs r2, #4
; CHECK-NEXT:    ldr r2, [r2]
; CHECK-NEXT:    movs r3, #188
; CHECK-NEXT:    lsls r3, r3, #8
; CHECK-NEXT:    adds r3, #249
; CHECK-NEXT:    lsls r3, r3, #8
; CHECK-NEXT:    adds r3, #132
; CHECK-NEXT:    lsls r3, r3, #8
; CHECK-NEXT:    adds r3, #68
; CHECK-NEXT:    cmp r2, r3
; CHECK-NEXT:    pop {r2}
; CHECK-NEXT:    beq .Ltmp2
; CHECK-NEXT:    bkpt #0
; CHECK-NEXT:  .Ltmp2:
; CHECK-NEXT:    blx r4
; CHECK-NEXT:    pop {r4, pc}
; Compiler shuffles: target→r4, c→r2, a→r0, b→r1
; R2 is live (3rd arg), so we push it, then uses R3 as temp, R2 as scratch
  call void %x(i32 %a, i32 %b, i32 %c) [ "kcfi"(i32 -1124498364) ]
  ret void
}

; Test with both R2 and R3 live (4 arguments) - compiler moves to r5/r4, uses R3 temp and R12 scratch
define void @f4_r2_r3_live(ptr noundef %x, i32 %a, i32 %b, i32 %c, i32 %d) !kcfi_type !1 {
; CHECK-LABEL: f4_r2_r3_live:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r4, r5, r7, lr}
; CHECK-NEXT:    push {r4, r5, r7, lr}
; CHECK-NEXT:    mov r5, r3
; CHECK-NEXT:    mov r4, r0
; CHECK-NEXT:    ldr r3, [sp, #16]
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    mov r1, r2
; CHECK-NEXT:    mov r2, r5
; CHECK-NEXT:    push {r3}
; CHECK-NEXT:    push {r2}
; CHECK-NEXT:    movs r3, #1
; CHECK-NEXT:    mov r2, r4
; CHECK-NEXT:    bics r2, r3
; CHECK-NEXT:    subs r2, #4
; CHECK-NEXT:    ldr r2, [r2]
; CHECK-NEXT:    movs r3, #188
; CHECK-NEXT:    lsls r3, r3, #8
; CHECK-NEXT:    adds r3, #249
; CHECK-NEXT:    lsls r3, r3, #8
; CHECK-NEXT:    adds r3, #132
; CHECK-NEXT:    lsls r3, r3, #8
; CHECK-NEXT:    adds r3, #68
; CHECK-NEXT:    cmp r2, r3
; CHECK-NEXT:    pop {r2}
; CHECK-NEXT:    pop {r3}
; CHECK-NEXT:    beq .Ltmp3
; CHECK-NEXT:    bkpt #0
; CHECK-NEXT:  .Ltmp3:
; CHECK-NEXT:    blx r4
; CHECK-NEXT:    pop {r4, r5, r7, pc}
; Compiler shuffles: r3→r5, target→r4, d→r3 (from stack), a→r0, b→r1, c→r2
; Then pushes r3 (d value), then r2, uses R3 as temp, R2 as scratch
  call void %x(i32 %a, i32 %b, i32 %c, i32 %d) [ "kcfi"(i32 -1124498364) ]
  ret void
}

; Test where target ends up in R12, forcing R2 as scratch, with both R2 and R3 live
; This uses inline asm to force target into R12, with 4 call arguments to make R2/R3 live
define void @f5_r12_target_r2_r3_live(i32 %a, i32 %b, i32 %c, i32 %d) !kcfi_type !1 {
; CHECK-LABEL: f5_r12_target_r2_r3_live:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    @APP
; CHECK-NEXT:    @NO_APP
; CHECK-NEXT:    push {r3}
; CHECK-NEXT:    push {r2}
; CHECK-NEXT:    movs r3, #1
; CHECK-NEXT:    mov r2, r12
; CHECK-NEXT:    bics r2, r3
; CHECK-NEXT:    subs r2, #4
; CHECK-NEXT:    ldr r2, [r2]
; CHECK-NEXT:    movs r3, #188
; CHECK-NEXT:    lsls r3, r3, #8
; CHECK-NEXT:    adds r3, #249
; CHECK-NEXT:    lsls r3, r3, #8
; CHECK-NEXT:    adds r3, #132
; CHECK-NEXT:    lsls r3, r3, #8
; CHECK-NEXT:    adds r3, #68
; CHECK-NEXT:    cmp r2, r3
; CHECK-NEXT:    pop {r2}
; CHECK-NEXT:    pop {r3}
; CHECK-NEXT:    beq .Ltmp4
; CHECK-NEXT:    bkpt #0
; CHECK-NEXT:  .Ltmp4:
; CHECK-NEXT:    blx r12
; CHECK-NEXT:    pop {r7, pc}
; Use inline asm to get function pointer into R12
; With 4 arguments (r0-r3), both R2 and R3 are live
; Target in R12 means R2 is scratch, R3 is temp, and both need spilling
  %target = call ptr asm "", "={r12}"()
  call void %target(i32 %a, i32 %b, i32 %c, i32 %d) [ "kcfi"(i32 -1124498364) ]
  ret void
}

!llvm.module.flags = !{!0}
!0 = !{i32 4, !"kcfi", i32 1}
!1 = !{i32 -1124498364}
