; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -ppc-gpr-icmps=all -mtriple=powerpc64-unknown-linux-gnu \
; RUN:     -verify-machineinstrs -mcpu=pwr7 < %s | FileCheck %s
; RUN: llc -ppc-gpr-icmps=all -mtriple=powerpc64-unknown-linux-gnu \
; RUN:     -verify-machineinstrs -mcpu=pwr7 -mattr=-isel < %s | \
; RUN:     FileCheck --check-prefix=CHECK-NO-ISEL %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu -O2 \
; RUN:     -ppc-asm-full-reg-names -mcpu=pwr10 -ppc-gpr-icmps=none < %s | \
; RUN:     FileCheck %s --check-prefix=CHECK-P10
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu -O2 \
; RUN:     -ppc-asm-full-reg-names -mcpu=pwr10 -ppc-gpr-icmps=none < %s | \
; RUN:     FileCheck %s --check-prefix=CHECK-P10

; Function Attrs: nounwind readnone
define zeroext i1 @test1(float %v1, float %v2) #0 {
; CHECK-LABEL: test1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    xxlxor 0, 0, 0
; CHECK-NEXT:    li 3, 1
; CHECK-NEXT:    fcmpu 1, 2, 2
; CHECK-NEXT:    crnor 20, 3, 0
; CHECK-NEXT:    fcmpu 0, 2, 0
; CHECK-NEXT:    crnor 21, 7, 1
; CHECK-NEXT:    crnand 20, 20, 21
; CHECK-NEXT:    isel 3, 0, 3, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: test1:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    xxlxor 0, 0, 0
; CHECK-NO-ISEL-NEXT:    li 3, 0
; CHECK-NO-ISEL-NEXT:    fcmpu 1, 2, 2
; CHECK-NO-ISEL-NEXT:    crnor 20, 3, 0
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 2, 0
; CHECK-NO-ISEL-NEXT:    bclr 4, 20, 0
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    crnor 20, 7, 1
; CHECK-NO-ISEL-NEXT:    bclr 4, 20, 0
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    li 3, 1
; CHECK-NO-ISEL-NEXT:    blr
;
; CHECK-P10-LABEL: test1:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    fcmpu cr0, f1, f2
; CHECK-P10-NEXT:    xxlxor f0, f0, f0
; CHECK-P10-NEXT:    fcmpu cr1, f2, f2
; CHECK-P10-NEXT:    crnor 4*cr5+lt, un, lt
; CHECK-P10-NEXT:    fcmpu cr0, f2, f0
; CHECK-P10-NEXT:    crnor 4*cr5+gt, 4*cr1+un, gt
; CHECK-P10-NEXT:    crand 4*cr5+lt, 4*cr5+lt, 4*cr5+gt
; CHECK-P10-NEXT:    setbc r3, 4*cr5+lt
; CHECK-P10-NEXT:    blr
entry:
  %cmp = fcmp oge float %v1, %v2
  %cmp2 = fcmp ole float %v2, 0.000000e+00
  %and5 = and i1 %cmp, %cmp2
  ret i1 %and5


}

; Function Attrs: nounwind readnone
define zeroext i1 @test2(float %v1, float %v2) #0 {
; CHECK-LABEL: test2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    xxlxor 0, 0, 0
; CHECK-NEXT:    li 3, 1
; CHECK-NEXT:    fcmpu 1, 2, 2
; CHECK-NEXT:    crnor 20, 3, 0
; CHECK-NEXT:    fcmpu 0, 2, 0
; CHECK-NEXT:    crnor 21, 7, 1
; CHECK-NEXT:    creqv 20, 20, 21
; CHECK-NEXT:    isel 3, 0, 3, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: test2:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    xxlxor 0, 0, 0
; CHECK-NO-ISEL-NEXT:    li 3, 0
; CHECK-NO-ISEL-NEXT:    fcmpu 1, 2, 2
; CHECK-NO-ISEL-NEXT:    crnor 20, 3, 0
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 2, 0
; CHECK-NO-ISEL-NEXT:    crnor 21, 7, 1
; CHECK-NO-ISEL-NEXT:    creqv 20, 20, 21
; CHECK-NO-ISEL-NEXT:    bclr 12, 20, 0
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    li 3, 1
; CHECK-NO-ISEL-NEXT:    blr
;
; CHECK-P10-LABEL: test2:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    fcmpu cr0, f1, f2
; CHECK-P10-NEXT:    xxlxor f0, f0, f0
; CHECK-P10-NEXT:    fcmpu cr1, f2, f2
; CHECK-P10-NEXT:    crnor 4*cr5+lt, un, lt
; CHECK-P10-NEXT:    fcmpu cr0, f2, f0
; CHECK-P10-NEXT:    crnor 4*cr5+gt, 4*cr1+un, gt
; CHECK-P10-NEXT:    crxor 4*cr5+lt, 4*cr5+lt, 4*cr5+gt
; CHECK-P10-NEXT:    setbc r3, 4*cr5+lt
; CHECK-P10-NEXT:    blr
entry:
  %cmp = fcmp oge float %v1, %v2
  %cmp2 = fcmp ole float %v2, 0.000000e+00
  %xor5 = xor i1 %cmp, %cmp2
  ret i1 %xor5


}

; Function Attrs: nounwind readnone
define zeroext i1 @test3(float %v1, float %v2, i32 signext %x) #0 {
; CHECK-LABEL: test3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    xxlxor 0, 0, 0
; CHECK-NEXT:    li 3, 1
; CHECK-NEXT:    fcmpu 1, 2, 2
; CHECK-NEXT:    crnor 20, 3, 0
; CHECK-NEXT:    fcmpu 0, 2, 0
; CHECK-NEXT:    crnor 21, 7, 1
; CHECK-NEXT:    cmpwi 5, -2
; CHECK-NEXT:    crandc 21, 21, 2
; CHECK-NEXT:    creqv 20, 20, 21
; CHECK-NEXT:    isel 3, 0, 3, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: test3:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    xxlxor 0, 0, 0
; CHECK-NO-ISEL-NEXT:    li 3, 0
; CHECK-NO-ISEL-NEXT:    fcmpu 1, 2, 2
; CHECK-NO-ISEL-NEXT:    crnor 20, 3, 0
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 2, 0
; CHECK-NO-ISEL-NEXT:    crnor 21, 7, 1
; CHECK-NO-ISEL-NEXT:    cmpwi 5, -2
; CHECK-NO-ISEL-NEXT:    crandc 21, 21, 2
; CHECK-NO-ISEL-NEXT:    creqv 20, 20, 21
; CHECK-NO-ISEL-NEXT:    bclr 12, 20, 0
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    li 3, 1
; CHECK-NO-ISEL-NEXT:    blr
;
; CHECK-P10-LABEL: test3:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    fcmpu cr0, f1, f2
; CHECK-P10-NEXT:    xxlxor f0, f0, f0
; CHECK-P10-NEXT:    fcmpu cr1, f2, f2
; CHECK-P10-NEXT:    crnor 4*cr5+lt, un, lt
; CHECK-P10-NEXT:    fcmpu cr0, f2, f0
; CHECK-P10-NEXT:    crnor 4*cr5+gt, 4*cr1+un, gt
; CHECK-P10-NEXT:    cmpwi r5, -2
; CHECK-P10-NEXT:    crandc 4*cr5+gt, 4*cr5+gt, eq
; CHECK-P10-NEXT:    crxor 4*cr5+lt, 4*cr5+lt, 4*cr5+gt
; CHECK-P10-NEXT:    setbc r3, 4*cr5+lt
; CHECK-P10-NEXT:    blr
entry:
  %cmp = fcmp oge float %v1, %v2
  %cmp2 = fcmp ole float %v2, 0.000000e+00
  %cmp4 = icmp ne i32 %x, -2
  %and7 = and i1 %cmp2, %cmp4
  %xor8 = xor i1 %cmp, %and7
  ret i1 %xor8


}

; Function Attrs: nounwind readnone
define zeroext i1 @test4(i1 zeroext %v1, i1 zeroext %v2, i1 zeroext %v3) #0 {
; CHECK-LABEL: test4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    and 3, 3, 4
; CHECK-NEXT:    or 3, 3, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: test4:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    and 3, 3, 4
; CHECK-NO-ISEL-NEXT:    or 3, 3, 5
; CHECK-NO-ISEL-NEXT:    blr
;
; CHECK-P10-LABEL: test4:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    blr
entry:
  %and8 = and i1 %v1, %v2
  %or9 = or i1 %and8, %v3
  ret i1 %or9

}

; Function Attrs: nounwind readnone
define zeroext i1 @test5(i1 zeroext %v1, i1 zeroext %v2, i32 signext %v3) #0 {
; CHECK-LABEL: test5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    and 3, 3, 4
; CHECK-NEXT:    li 4, -2
; CHECK-NEXT:    xor 4, 5, 4
; CHECK-NEXT:    clrldi 3, 3, 63
; CHECK-NEXT:    cntlzw 4, 4
; CHECK-NEXT:    srwi 4, 4, 5
; CHECK-NEXT:    xori 4, 4, 1
; CHECK-NEXT:    or 3, 3, 4
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: test5:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    and 3, 3, 4
; CHECK-NO-ISEL-NEXT:    li 4, -2
; CHECK-NO-ISEL-NEXT:    xor 4, 5, 4
; CHECK-NO-ISEL-NEXT:    clrldi 3, 3, 63
; CHECK-NO-ISEL-NEXT:    cntlzw 4, 4
; CHECK-NO-ISEL-NEXT:    srwi 4, 4, 5
; CHECK-NO-ISEL-NEXT:    xori 4, 4, 1
; CHECK-NO-ISEL-NEXT:    or 3, 3, 4
; CHECK-NO-ISEL-NEXT:    blr
;
; CHECK-P10-LABEL: test5:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    cmpwi cr1, r5, -2
; CHECK-P10-NEXT:    andi. r3, r3, 1
; CHECK-P10-NEXT:    crorc 4*cr5+lt, gt, 4*cr1+eq
; CHECK-P10-NEXT:    setbc r3, 4*cr5+lt
; CHECK-P10-NEXT:    blr
entry:
  %and6 = and i1 %v1, %v2
  %cmp = icmp ne i32 %v3, -2
  %or7 = or i1 %and6, %cmp
  ret i1 %or7


}

; Function Attrs: nounwind readnone
define zeroext i1 @test6(i1 zeroext %v1, i1 zeroext %v2, i32 signext %v3) #0 {
; CHECK-LABEL: test6:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li 6, -2
; CHECK-NEXT:    clrldi 4, 4, 63
; CHECK-NEXT:    clrldi 3, 3, 63
; CHECK-NEXT:    xor 5, 5, 6
; CHECK-NEXT:    cntlzw 5, 5
; CHECK-NEXT:    srwi 5, 5, 5
; CHECK-NEXT:    xori 5, 5, 1
; CHECK-NEXT:    or 4, 5, 4
; CHECK-NEXT:    and 3, 4, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: test6:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    li 6, -2
; CHECK-NO-ISEL-NEXT:    clrldi 4, 4, 63
; CHECK-NO-ISEL-NEXT:    clrldi 3, 3, 63
; CHECK-NO-ISEL-NEXT:    xor 5, 5, 6
; CHECK-NO-ISEL-NEXT:    cntlzw 5, 5
; CHECK-NO-ISEL-NEXT:    srwi 5, 5, 5
; CHECK-NO-ISEL-NEXT:    xori 5, 5, 1
; CHECK-NO-ISEL-NEXT:    or 4, 5, 4
; CHECK-NO-ISEL-NEXT:    and 3, 4, 3
; CHECK-NO-ISEL-NEXT:    blr
;
; CHECK-P10-LABEL: test6:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    andi. r3, r3, 1
; CHECK-P10-NEXT:    cmpwi cr1, r5, -2
; CHECK-P10-NEXT:    crmove 4*cr5+lt, gt
; CHECK-P10-NEXT:    andi. r3, r4, 1
; CHECK-P10-NEXT:    crorc 4*cr5+gt, gt, 4*cr1+eq
; CHECK-P10-NEXT:    crand 4*cr5+lt, 4*cr5+gt, 4*cr5+lt
; CHECK-P10-NEXT:    setbc r3, 4*cr5+lt
; CHECK-P10-NEXT:    blr
entry:
  %cmp = icmp ne i32 %v3, -2
  %or6 = or i1 %cmp, %v2
  %and7 = and i1 %or6, %v1
  ret i1 %and7


}

; Function Attrs: nounwind readnone
define signext i32 @test7(i1 zeroext %v2, i32 signext %i1, i32 signext %i2) #0 {
; CHECK-LABEL: test7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi. 3, 3, 1
; CHECK-NEXT:    iselgt 3, 4, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: test7:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    andi. 3, 3, 1
; CHECK-NO-ISEL-NEXT:    bc 12, 1, .LBB6_2
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    mr 4, 5
; CHECK-NO-ISEL-NEXT:  .LBB6_2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 4
; CHECK-NO-ISEL-NEXT:    blr
;
; CHECK-P10-LABEL: test7:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    andi. r3, r3, 1
; CHECK-P10-NEXT:    iselgt r3, r4, r5
; CHECK-P10-NEXT:    blr
entry:
  %cond = select i1 %v2, i32 %i1, i32 %i2
  ret i32 %cond

}

define signext i32 @exttest7(i32 signext %a) #0 {
; CHECK-LABEL: exttest7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplwi 3, 5
; CHECK-NEXT:    li 3, 8
; CHECK-NEXT:    li 4, 7
; CHECK-NEXT:    iseleq 3, 4, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: exttest7:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmplwi 3, 5
; CHECK-NO-ISEL-NEXT:    li 3, 7
; CHECK-NO-ISEL-NEXT:    beqlr 0
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    li 3, 8
; CHECK-NO-ISEL-NEXT:    blr
;
; CHECK-P10-LABEL: exttest7:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    cmplwi r3, 5
; CHECK-P10-NEXT:    li r3, 8
; CHECK-P10-NEXT:    li r4, 7
; CHECK-P10-NEXT:    iseleq r3, r4, r3
; CHECK-P10-NEXT:    blr
entry:
  %cmp = icmp eq i32 %a, 5
  %cond = select i1 %cmp, i32 7, i32 8
  ret i32 %cond

}

define zeroext i32 @exttest8() #0 {
; CHECK-LABEL: exttest8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld 3, 0(3)
; CHECK-NEXT:    subfic 3, 3, 80
; CHECK-NEXT:    rldicl 3, 3, 63, 1
; CHECK-NEXT:    cmplwi 3, 80
; CHECK-NEXT:    iselgt 3, 0, 3
; CHECK-NEXT:    clrldi 3, 3, 32
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: exttest8:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    ld 3, 0(3)
; CHECK-NO-ISEL-NEXT:    li 4, 0
; CHECK-NO-ISEL-NEXT:    subfic 3, 3, 80
; CHECK-NO-ISEL-NEXT:    rldicl 3, 3, 63, 1
; CHECK-NO-ISEL-NEXT:    cmplwi 3, 80
; CHECK-NO-ISEL-NEXT:    bgt 0, .LBB8_2
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    mr 4, 3
; CHECK-NO-ISEL-NEXT:  .LBB8_2: # %entry
; CHECK-NO-ISEL-NEXT:    clrldi 3, 4, 32
; CHECK-NO-ISEL-NEXT:    blr
;
; CHECK-P10-LABEL: exttest8:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    ld r3, 0(r3)
; CHECK-P10-NEXT:    subfic r3, r3, 80
; CHECK-P10-NEXT:    rldicl r3, r3, 63, 1
; CHECK-P10-NEXT:    cmplwi r3, 80
; CHECK-P10-NEXT:    iselgt r3, 0, r3
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
entry:
  %v0 = load i64, ptr undef, align 8
  %sub = sub i64 80, %v0
  %div = lshr i64 %sub, 1
  %conv13 = trunc i64 %div to i32
  %cmp14 = icmp ugt i32 %conv13, 80
  %.conv13 = select i1 %cmp14, i32 0, i32 %conv13
  ret i32 %.conv13
; This is a don't-crash test: %conv13 is both one of the possible select output
; values and also an input to the conditional feeding it.
}

; Function Attrs: nounwind readnone
define float @test8(i1 zeroext %v2, float %v1, float %v3) #0 {
; CHECK-LABEL: test8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi. 3, 3, 1
; CHECK-NEXT:    bclr 12, 1, 0
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fmr 1, 2
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: test8:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    andi. 3, 3, 1
; CHECK-NO-ISEL-NEXT:    bclr 12, 1, 0
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 2
; CHECK-NO-ISEL-NEXT:    blr
;
; CHECK-P10-LABEL: test8:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    andi. r3, r3, 1
; CHECK-P10-NEXT:    bclr 12, gt, 0
; CHECK-P10-NEXT:  # %bb.1: # %entry
; CHECK-P10-NEXT:    fmr f1, f2
; CHECK-P10-NEXT:    blr
entry:
  %cond = select i1 %v2, float %v1, float %v3
  ret float %cond

}

; Function Attrs: nounwind readnone
define signext i32 @test10(i32 signext %v1, i32 signext %v2) #0 {
; CHECK-LABEL: test10:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cntlzw 3, 3
; CHECK-NEXT:    cntlzw 4, 4
; CHECK-NEXT:    srwi 3, 3, 5
; CHECK-NEXT:    srwi 4, 4, 5
; CHECK-NEXT:    xori 3, 3, 1
; CHECK-NEXT:    and 3, 3, 4
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: test10:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cntlzw 3, 3
; CHECK-NO-ISEL-NEXT:    cntlzw 4, 4
; CHECK-NO-ISEL-NEXT:    srwi 3, 3, 5
; CHECK-NO-ISEL-NEXT:    srwi 4, 4, 5
; CHECK-NO-ISEL-NEXT:    xori 3, 3, 1
; CHECK-NO-ISEL-NEXT:    and 3, 3, 4
; CHECK-NO-ISEL-NEXT:    blr
;
; CHECK-P10-LABEL: test10:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    cmpwi r3, 0
; CHECK-P10-NEXT:    cmpwi cr1, r4, 0
; CHECK-P10-NEXT:    crandc 4*cr5+lt, 4*cr1+eq, eq
; CHECK-P10-NEXT:    setbc r3, 4*cr5+lt
; CHECK-P10-NEXT:    blr
entry:
  %tobool = icmp ne i32 %v1, 0
  %lnot = icmp eq i32 %v2, 0
  %and3 = and i1 %tobool, %lnot
  %and = zext i1 %and3 to i32
  ret i32 %and


}

attributes #0 = { nounwind readnone }

