; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=powerpc-unknown-unknown \
; RUN:   -verify-machineinstrs -ppc-asm-full-reg-names < %s | FileCheck %s \
; RUN:   --check-prefix=PPC32
; RUN: llc -mcpu=pwr8 -mtriple=powerpc64le-unknown-unknown \
; RUN:   -verify-machineinstrs -ppc-asm-full-reg-names < %s | FileCheck %s \
; RUN:   --check-prefixes=CHECK,P8
; RUN: llc -mcpu=pwr9 -mtriple=powerpc64le-unknown-unknown \
; RUN:   -verify-machineinstrs -ppc-asm-full-reg-names < %s | FileCheck %s \
; RUN:   --check-prefixes=CHECK,P9
; RUN: llc -mcpu=pwr9 -mtriple=powerpc64le-unknown-unknown -mattr=-hard-float \
; RUN:   -verify-machineinstrs -ppc-asm-full-reg-names < %s | FileCheck %s \
; RUN:   --check-prefix=SOFT
; RUN: llc -mtriple=powerpc64-unknown-unknown \
; RUN:   -verify-machineinstrs -ppc-asm-full-reg-names < %s | FileCheck %s \
; RUN:   --check-prefix=BE

; Tests for various operations on half precison float. Much of the test is
; copied from test/CodeGen/X86/half.ll.

define void @store(half %x, ptr %p) nounwind {
; PPC32-LABEL: store:
; PPC32:       # %bb.0:
; PPC32-NEXT:    sth r3, 0(r4)
; PPC32-NEXT:    blr
;
; CHECK-LABEL: store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sth r3, 0(r4)
; CHECK-NEXT:    blr
;
; SOFT-LABEL: store:
; SOFT:       # %bb.0:
; SOFT-NEXT:    sth r3, 0(r4)
; SOFT-NEXT:    blr
;
; BE-LABEL: store:
; BE:       # %bb.0:
; BE-NEXT:    sth r3, 0(r4)
; BE-NEXT:    blr
  store half %x, ptr %p
  ret void
}

define half @return(ptr %p) nounwind {
; PPC32-LABEL: return:
; PPC32:       # %bb.0:
; PPC32-NEXT:    lhz r3, 0(r3)
; PPC32-NEXT:    blr
;
; CHECK-LABEL: return:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lhz r3, 0(r3)
; CHECK-NEXT:    blr
;
; SOFT-LABEL: return:
; SOFT:       # %bb.0:
; SOFT-NEXT:    lhz r3, 0(r3)
; SOFT-NEXT:    blr
;
; BE-LABEL: return:
; BE:       # %bb.0:
; BE-NEXT:    lhz r3, 0(r3)
; BE-NEXT:    blr
  %r = load half, ptr %p
  ret half %r
}

define dso_local double @loadd(ptr nocapture readonly %a) local_unnamed_addr nounwind {
; PPC32-LABEL: loadd:
; PPC32:       # %bb.0: # %entry
; PPC32-NEXT:    mflr r0
; PPC32-NEXT:    stwu r1, -16(r1)
; PPC32-NEXT:    stw r0, 20(r1)
; PPC32-NEXT:    lhz r3, 2(r3)
; PPC32-NEXT:    bl __extendhfsf2
; PPC32-NEXT:    lwz r0, 20(r1)
; PPC32-NEXT:    addi r1, r1, 16
; PPC32-NEXT:    mtlr r0
; PPC32-NEXT:    blr
;
; P8-LABEL: loadd:
; P8:       # %bb.0: # %entry
; P8-NEXT:    mflr r0
; P8-NEXT:    stdu r1, -32(r1)
; P8-NEXT:    std r0, 48(r1)
; P8-NEXT:    lhz r3, 2(r3)
; P8-NEXT:    bl __extendhfsf2
; P8-NEXT:    nop
; P8-NEXT:    addi r1, r1, 32
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; P9-LABEL: loadd:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addi r3, r3, 2
; P9-NEXT:    lxsihzx f0, 0, r3
; P9-NEXT:    xscvhpdp f1, f0
; P9-NEXT:    blr
;
; SOFT-LABEL: loadd:
; SOFT:       # %bb.0: # %entry
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    stdu r1, -32(r1)
; SOFT-NEXT:    std r0, 48(r1)
; SOFT-NEXT:    lhz r3, 2(r3)
; SOFT-NEXT:    bl __extendhfsf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    bl __extendsfdf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    addi r1, r1, 32
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    blr
;
; BE-LABEL: loadd:
; BE:       # %bb.0: # %entry
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -112(r1)
; BE-NEXT:    std r0, 128(r1)
; BE-NEXT:    lhz r3, 2(r3)
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    addi r1, r1, 112
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds i16, ptr %a, i64 1
  %0 = load i16, ptr %arrayidx, align 2
  %1 = tail call double @llvm.convert.from.fp16.f64(i16 %0)
  ret double %1
}

declare double @llvm.convert.from.fp16.f64(i16)

define dso_local float @loadf(ptr nocapture readonly %a) local_unnamed_addr nounwind {
; PPC32-LABEL: loadf:
; PPC32:       # %bb.0: # %entry
; PPC32-NEXT:    mflr r0
; PPC32-NEXT:    stwu r1, -16(r1)
; PPC32-NEXT:    stw r0, 20(r1)
; PPC32-NEXT:    lhz r3, 2(r3)
; PPC32-NEXT:    bl __extendhfsf2
; PPC32-NEXT:    lwz r0, 20(r1)
; PPC32-NEXT:    addi r1, r1, 16
; PPC32-NEXT:    mtlr r0
; PPC32-NEXT:    blr
;
; P8-LABEL: loadf:
; P8:       # %bb.0: # %entry
; P8-NEXT:    mflr r0
; P8-NEXT:    stdu r1, -32(r1)
; P8-NEXT:    std r0, 48(r1)
; P8-NEXT:    lhz r3, 2(r3)
; P8-NEXT:    bl __extendhfsf2
; P8-NEXT:    nop
; P8-NEXT:    addi r1, r1, 32
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; P9-LABEL: loadf:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addi r3, r3, 2
; P9-NEXT:    lxsihzx f0, 0, r3
; P9-NEXT:    xscvhpdp f1, f0
; P9-NEXT:    blr
;
; SOFT-LABEL: loadf:
; SOFT:       # %bb.0: # %entry
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    stdu r1, -32(r1)
; SOFT-NEXT:    std r0, 48(r1)
; SOFT-NEXT:    lhz r3, 2(r3)
; SOFT-NEXT:    bl __extendhfsf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    addi r1, r1, 32
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    blr
;
; BE-LABEL: loadf:
; BE:       # %bb.0: # %entry
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -112(r1)
; BE-NEXT:    std r0, 128(r1)
; BE-NEXT:    lhz r3, 2(r3)
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    addi r1, r1, 112
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds i16, ptr %a, i64 1
  %0 = load i16, ptr %arrayidx, align 2
  %1 = tail call float @llvm.convert.from.fp16.f32(i16 %0)
  ret float %1
}

declare float @llvm.convert.from.fp16.f32(i16)

define dso_local void @stored(ptr nocapture %a, double %b) local_unnamed_addr nounwind {
; PPC32-LABEL: stored:
; PPC32:       # %bb.0: # %entry
; PPC32-NEXT:    mflr r0
; PPC32-NEXT:    stwu r1, -16(r1)
; PPC32-NEXT:    stw r0, 20(r1)
; PPC32-NEXT:    stw r30, 8(r1) # 4-byte Folded Spill
; PPC32-NEXT:    mr r30, r3
; PPC32-NEXT:    bl __truncdfhf2
; PPC32-NEXT:    sth r3, 0(r30)
; PPC32-NEXT:    lwz r30, 8(r1) # 4-byte Folded Reload
; PPC32-NEXT:    lwz r0, 20(r1)
; PPC32-NEXT:    addi r1, r1, 16
; PPC32-NEXT:    mtlr r0
; PPC32-NEXT:    blr
;
; P8-LABEL: stored:
; P8:       # %bb.0: # %entry
; P8-NEXT:    mflr r0
; P8-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; P8-NEXT:    stdu r1, -48(r1)
; P8-NEXT:    std r0, 64(r1)
; P8-NEXT:    mr r30, r3
; P8-NEXT:    bl __truncdfhf2
; P8-NEXT:    nop
; P8-NEXT:    sth r3, 0(r30)
; P8-NEXT:    addi r1, r1, 48
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; P9-LABEL: stored:
; P9:       # %bb.0: # %entry
; P9-NEXT:    xscvdphp f0, f1
; P9-NEXT:    stxsihx f0, 0, r3
; P9-NEXT:    blr
;
; SOFT-LABEL: stored:
; SOFT:       # %bb.0: # %entry
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; SOFT-NEXT:    stdu r1, -48(r1)
; SOFT-NEXT:    mr r30, r3
; SOFT-NEXT:    mr r3, r4
; SOFT-NEXT:    std r0, 64(r1)
; SOFT-NEXT:    bl __truncdfhf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    sth r3, 0(r30)
; SOFT-NEXT:    addi r1, r1, 48
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    blr
;
; BE-LABEL: stored:
; BE:       # %bb.0: # %entry
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -128(r1)
; BE-NEXT:    std r0, 144(r1)
; BE-NEXT:    std r30, 112(r1) # 8-byte Folded Spill
; BE-NEXT:    mr r30, r3
; BE-NEXT:    bl __truncdfhf2
; BE-NEXT:    nop
; BE-NEXT:    sth r3, 0(r30)
; BE-NEXT:    ld r30, 112(r1) # 8-byte Folded Reload
; BE-NEXT:    addi r1, r1, 128
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
entry:
  %0 = tail call i16 @llvm.convert.to.fp16.f64(double %b)
  store i16 %0, ptr %a, align 2
  ret void
}

declare i16 @llvm.convert.to.fp16.f64(double)

define dso_local void @storef(ptr nocapture %a, float %b) local_unnamed_addr nounwind {
; PPC32-LABEL: storef:
; PPC32:       # %bb.0: # %entry
; PPC32-NEXT:    mflr r0
; PPC32-NEXT:    stwu r1, -16(r1)
; PPC32-NEXT:    stw r0, 20(r1)
; PPC32-NEXT:    stw r30, 8(r1) # 4-byte Folded Spill
; PPC32-NEXT:    mr r30, r3
; PPC32-NEXT:    bl __truncsfhf2
; PPC32-NEXT:    sth r3, 0(r30)
; PPC32-NEXT:    lwz r30, 8(r1) # 4-byte Folded Reload
; PPC32-NEXT:    lwz r0, 20(r1)
; PPC32-NEXT:    addi r1, r1, 16
; PPC32-NEXT:    mtlr r0
; PPC32-NEXT:    blr
;
; P8-LABEL: storef:
; P8:       # %bb.0: # %entry
; P8-NEXT:    mflr r0
; P8-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; P8-NEXT:    stdu r1, -48(r1)
; P8-NEXT:    std r0, 64(r1)
; P8-NEXT:    mr r30, r3
; P8-NEXT:    bl __truncsfhf2
; P8-NEXT:    nop
; P8-NEXT:    sth r3, 0(r30)
; P8-NEXT:    addi r1, r1, 48
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; P9-LABEL: storef:
; P9:       # %bb.0: # %entry
; P9-NEXT:    xscvdphp f0, f1
; P9-NEXT:    stxsihx f0, 0, r3
; P9-NEXT:    blr
;
; SOFT-LABEL: storef:
; SOFT:       # %bb.0: # %entry
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; SOFT-NEXT:    stdu r1, -48(r1)
; SOFT-NEXT:    mr r30, r3
; SOFT-NEXT:    clrldi r3, r4, 32
; SOFT-NEXT:    std r0, 64(r1)
; SOFT-NEXT:    bl __truncsfhf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    sth r3, 0(r30)
; SOFT-NEXT:    addi r1, r1, 48
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    blr
;
; BE-LABEL: storef:
; BE:       # %bb.0: # %entry
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -128(r1)
; BE-NEXT:    std r0, 144(r1)
; BE-NEXT:    std r30, 112(r1) # 8-byte Folded Spill
; BE-NEXT:    mr r30, r3
; BE-NEXT:    bl __truncsfhf2
; BE-NEXT:    nop
; BE-NEXT:    sth r3, 0(r30)
; BE-NEXT:    ld r30, 112(r1) # 8-byte Folded Reload
; BE-NEXT:    addi r1, r1, 128
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
entry:
  %0 = tail call i16 @llvm.convert.to.fp16.f32(float %b)
  store i16 %0, ptr %a, align 2
  ret void
}

declare i16 @llvm.convert.to.fp16.f32(float)
define void @test_load_store(ptr %in, ptr %out) nounwind {
; PPC32-LABEL: test_load_store:
; PPC32:       # %bb.0:
; PPC32-NEXT:    lhz r3, 0(r3)
; PPC32-NEXT:    sth r3, 0(r4)
; PPC32-NEXT:    blr
;
; CHECK-LABEL: test_load_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lhz r3, 0(r3)
; CHECK-NEXT:    sth r3, 0(r4)
; CHECK-NEXT:    blr
;
; SOFT-LABEL: test_load_store:
; SOFT:       # %bb.0:
; SOFT-NEXT:    lhz r3, 0(r3)
; SOFT-NEXT:    sth r3, 0(r4)
; SOFT-NEXT:    blr
;
; BE-LABEL: test_load_store:
; BE:       # %bb.0:
; BE-NEXT:    lhz r3, 0(r3)
; BE-NEXT:    sth r3, 0(r4)
; BE-NEXT:    blr
  %val = load half, ptr %in
  store half %val, ptr %out
  ret void
}
define i16 @test_bitcast_from_half(ptr %addr) nounwind {
; PPC32-LABEL: test_bitcast_from_half:
; PPC32:       # %bb.0:
; PPC32-NEXT:    lhz r3, 0(r3)
; PPC32-NEXT:    blr
;
; CHECK-LABEL: test_bitcast_from_half:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lhz r3, 0(r3)
; CHECK-NEXT:    blr
;
; SOFT-LABEL: test_bitcast_from_half:
; SOFT:       # %bb.0:
; SOFT-NEXT:    lhz r3, 0(r3)
; SOFT-NEXT:    blr
;
; BE-LABEL: test_bitcast_from_half:
; BE:       # %bb.0:
; BE-NEXT:    lhz r3, 0(r3)
; BE-NEXT:    blr
  %val = load half, ptr %addr
  %val_int = bitcast half %val to i16
  ret i16 %val_int
}
define void @test_bitcast_to_half(ptr %addr, i16 %in) nounwind {
; PPC32-LABEL: test_bitcast_to_half:
; PPC32:       # %bb.0:
; PPC32-NEXT:    sth r4, 0(r3)
; PPC32-NEXT:    blr
;
; CHECK-LABEL: test_bitcast_to_half:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sth r4, 0(r3)
; CHECK-NEXT:    blr
;
; SOFT-LABEL: test_bitcast_to_half:
; SOFT:       # %bb.0:
; SOFT-NEXT:    sth r4, 0(r3)
; SOFT-NEXT:    blr
;
; BE-LABEL: test_bitcast_to_half:
; BE:       # %bb.0:
; BE-NEXT:    sth r4, 0(r3)
; BE-NEXT:    blr
  %val_fp = bitcast i16 %in to half
  store half %val_fp, ptr %addr
  ret void
}


; Checks for https://github.com/llvm/llvm-project/issues/97981
define half @from_bits(i16 %x) nounwind {
; PPC32-LABEL: from_bits:
; PPC32:       # %bb.0:
; PPC32-NEXT:    blr
;
; CHECK-LABEL: from_bits:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
;
; SOFT-LABEL: from_bits:
; SOFT:       # %bb.0:
; SOFT-NEXT:    blr
;
; BE-LABEL: from_bits:
; BE:       # %bb.0:
; BE-NEXT:    blr
  %res = bitcast i16 %x to half
  ret half %res
}

define i16 @to_bits(half %x) nounwind {
; PPC32-LABEL: to_bits:
; PPC32:       # %bb.0:
; PPC32-NEXT:    blr
;
; CHECK-LABEL: to_bits:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
;
; SOFT-LABEL: to_bits:
; SOFT:       # %bb.0:
; SOFT-NEXT:    blr
;
; BE-LABEL: to_bits:
; BE:       # %bb.0:
; BE-NEXT:    blr
    %res = bitcast half %x to i16
    ret i16 %res
}

define float @test_extend32(ptr %addr) nounwind {
; PPC32-LABEL: test_extend32:
; PPC32:       # %bb.0:
; PPC32-NEXT:    mflr r0
; PPC32-NEXT:    stwu r1, -16(r1)
; PPC32-NEXT:    stw r0, 20(r1)
; PPC32-NEXT:    lhz r3, 0(r3)
; PPC32-NEXT:    bl __extendhfsf2
; PPC32-NEXT:    lwz r0, 20(r1)
; PPC32-NEXT:    addi r1, r1, 16
; PPC32-NEXT:    mtlr r0
; PPC32-NEXT:    blr
;
; P8-LABEL: test_extend32:
; P8:       # %bb.0:
; P8-NEXT:    mflr r0
; P8-NEXT:    stdu r1, -32(r1)
; P8-NEXT:    std r0, 48(r1)
; P8-NEXT:    lhz r3, 0(r3)
; P8-NEXT:    bl __extendhfsf2
; P8-NEXT:    nop
; P8-NEXT:    addi r1, r1, 32
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; P9-LABEL: test_extend32:
; P9:       # %bb.0:
; P9-NEXT:    lxsihzx f0, 0, r3
; P9-NEXT:    xscvhpdp f1, f0
; P9-NEXT:    blr
;
; SOFT-LABEL: test_extend32:
; SOFT:       # %bb.0:
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    stdu r1, -32(r1)
; SOFT-NEXT:    std r0, 48(r1)
; SOFT-NEXT:    lhz r3, 0(r3)
; SOFT-NEXT:    bl __extendhfsf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    addi r1, r1, 32
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    blr
;
; BE-LABEL: test_extend32:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -112(r1)
; BE-NEXT:    std r0, 128(r1)
; BE-NEXT:    lhz r3, 0(r3)
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    addi r1, r1, 112
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
  %val16 = load half, ptr %addr
  %val32 = fpext half %val16 to float
  ret float %val32
}
define double @test_extend64(ptr %addr) nounwind {
; PPC32-LABEL: test_extend64:
; PPC32:       # %bb.0:
; PPC32-NEXT:    mflr r0
; PPC32-NEXT:    stwu r1, -16(r1)
; PPC32-NEXT:    stw r0, 20(r1)
; PPC32-NEXT:    lhz r3, 0(r3)
; PPC32-NEXT:    bl __extendhfsf2
; PPC32-NEXT:    lwz r0, 20(r1)
; PPC32-NEXT:    addi r1, r1, 16
; PPC32-NEXT:    mtlr r0
; PPC32-NEXT:    blr
;
; P8-LABEL: test_extend64:
; P8:       # %bb.0:
; P8-NEXT:    mflr r0
; P8-NEXT:    stdu r1, -32(r1)
; P8-NEXT:    std r0, 48(r1)
; P8-NEXT:    lhz r3, 0(r3)
; P8-NEXT:    bl __extendhfsf2
; P8-NEXT:    nop
; P8-NEXT:    addi r1, r1, 32
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; P9-LABEL: test_extend64:
; P9:       # %bb.0:
; P9-NEXT:    lxsihzx f0, 0, r3
; P9-NEXT:    xscvhpdp f1, f0
; P9-NEXT:    blr
;
; SOFT-LABEL: test_extend64:
; SOFT:       # %bb.0:
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    stdu r1, -32(r1)
; SOFT-NEXT:    std r0, 48(r1)
; SOFT-NEXT:    lhz r3, 0(r3)
; SOFT-NEXT:    bl __extendhfsf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    bl __extendsfdf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    addi r1, r1, 32
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    blr
;
; BE-LABEL: test_extend64:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -112(r1)
; BE-NEXT:    std r0, 128(r1)
; BE-NEXT:    lhz r3, 0(r3)
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    addi r1, r1, 112
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
  %val16 = load half, ptr %addr
  %val32 = fpext half %val16 to double
  ret double %val32
}
define void @test_trunc32(float %in, ptr %addr) nounwind {
; PPC32-LABEL: test_trunc32:
; PPC32:       # %bb.0:
; PPC32-NEXT:    mflr r0
; PPC32-NEXT:    stwu r1, -16(r1)
; PPC32-NEXT:    stw r0, 20(r1)
; PPC32-NEXT:    stw r30, 8(r1) # 4-byte Folded Spill
; PPC32-NEXT:    mr r30, r3
; PPC32-NEXT:    bl __truncsfhf2
; PPC32-NEXT:    sth r3, 0(r30)
; PPC32-NEXT:    lwz r30, 8(r1) # 4-byte Folded Reload
; PPC32-NEXT:    lwz r0, 20(r1)
; PPC32-NEXT:    addi r1, r1, 16
; PPC32-NEXT:    mtlr r0
; PPC32-NEXT:    blr
;
; P8-LABEL: test_trunc32:
; P8:       # %bb.0:
; P8-NEXT:    mflr r0
; P8-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; P8-NEXT:    stdu r1, -48(r1)
; P8-NEXT:    std r0, 64(r1)
; P8-NEXT:    mr r30, r4
; P8-NEXT:    bl __truncsfhf2
; P8-NEXT:    nop
; P8-NEXT:    sth r3, 0(r30)
; P8-NEXT:    addi r1, r1, 48
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; P9-LABEL: test_trunc32:
; P9:       # %bb.0:
; P9-NEXT:    xscvdphp f0, f1
; P9-NEXT:    stxsihx f0, 0, r4
; P9-NEXT:    blr
;
; SOFT-LABEL: test_trunc32:
; SOFT:       # %bb.0:
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; SOFT-NEXT:    stdu r1, -48(r1)
; SOFT-NEXT:    clrldi r3, r3, 32
; SOFT-NEXT:    std r0, 64(r1)
; SOFT-NEXT:    mr r30, r4
; SOFT-NEXT:    bl __truncsfhf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    sth r3, 0(r30)
; SOFT-NEXT:    addi r1, r1, 48
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    blr
;
; BE-LABEL: test_trunc32:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -128(r1)
; BE-NEXT:    std r0, 144(r1)
; BE-NEXT:    std r30, 112(r1) # 8-byte Folded Spill
; BE-NEXT:    mr r30, r4
; BE-NEXT:    bl __truncsfhf2
; BE-NEXT:    nop
; BE-NEXT:    sth r3, 0(r30)
; BE-NEXT:    ld r30, 112(r1) # 8-byte Folded Reload
; BE-NEXT:    addi r1, r1, 128
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
  %val16 = fptrunc float %in to half
  store half %val16, ptr %addr
  ret void
}
define void @test_trunc64(double %in, ptr %addr) nounwind {
; PPC32-LABEL: test_trunc64:
; PPC32:       # %bb.0:
; PPC32-NEXT:    mflr r0
; PPC32-NEXT:    stwu r1, -16(r1)
; PPC32-NEXT:    stw r0, 20(r1)
; PPC32-NEXT:    stw r30, 8(r1) # 4-byte Folded Spill
; PPC32-NEXT:    mr r30, r3
; PPC32-NEXT:    bl __truncdfhf2
; PPC32-NEXT:    sth r3, 0(r30)
; PPC32-NEXT:    lwz r30, 8(r1) # 4-byte Folded Reload
; PPC32-NEXT:    lwz r0, 20(r1)
; PPC32-NEXT:    addi r1, r1, 16
; PPC32-NEXT:    mtlr r0
; PPC32-NEXT:    blr
;
; P8-LABEL: test_trunc64:
; P8:       # %bb.0:
; P8-NEXT:    mflr r0
; P8-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; P8-NEXT:    stdu r1, -48(r1)
; P8-NEXT:    std r0, 64(r1)
; P8-NEXT:    mr r30, r4
; P8-NEXT:    bl __truncdfhf2
; P8-NEXT:    nop
; P8-NEXT:    sth r3, 0(r30)
; P8-NEXT:    addi r1, r1, 48
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; P9-LABEL: test_trunc64:
; P9:       # %bb.0:
; P9-NEXT:    xscvdphp f0, f1
; P9-NEXT:    stxsihx f0, 0, r4
; P9-NEXT:    blr
;
; SOFT-LABEL: test_trunc64:
; SOFT:       # %bb.0:
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; SOFT-NEXT:    stdu r1, -48(r1)
; SOFT-NEXT:    std r0, 64(r1)
; SOFT-NEXT:    mr r30, r4
; SOFT-NEXT:    bl __truncdfhf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    sth r3, 0(r30)
; SOFT-NEXT:    addi r1, r1, 48
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    blr
;
; BE-LABEL: test_trunc64:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -128(r1)
; BE-NEXT:    std r0, 144(r1)
; BE-NEXT:    std r30, 112(r1) # 8-byte Folded Spill
; BE-NEXT:    mr r30, r4
; BE-NEXT:    bl __truncdfhf2
; BE-NEXT:    nop
; BE-NEXT:    sth r3, 0(r30)
; BE-NEXT:    ld r30, 112(r1) # 8-byte Folded Reload
; BE-NEXT:    addi r1, r1, 128
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
  %val16 = fptrunc double %in to half
  store half %val16, ptr %addr
  ret void
}
define i64 @test_fptosi_i64(ptr %p) nounwind {
; PPC32-LABEL: test_fptosi_i64:
; PPC32:       # %bb.0:
; PPC32-NEXT:    mflr r0
; PPC32-NEXT:    stwu r1, -16(r1)
; PPC32-NEXT:    stw r0, 20(r1)
; PPC32-NEXT:    lhz r3, 0(r3)
; PPC32-NEXT:    bl __extendhfsf2
; PPC32-NEXT:    bl __fixsfdi
; PPC32-NEXT:    lwz r0, 20(r1)
; PPC32-NEXT:    addi r1, r1, 16
; PPC32-NEXT:    mtlr r0
; PPC32-NEXT:    blr
;
; P8-LABEL: test_fptosi_i64:
; P8:       # %bb.0:
; P8-NEXT:    mflr r0
; P8-NEXT:    stdu r1, -32(r1)
; P8-NEXT:    std r0, 48(r1)
; P8-NEXT:    lhz r3, 0(r3)
; P8-NEXT:    bl __extendhfsf2
; P8-NEXT:    nop
; P8-NEXT:    xscvdpsxds f0, f1
; P8-NEXT:    mffprd r3, f0
; P8-NEXT:    addi r1, r1, 32
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; P9-LABEL: test_fptosi_i64:
; P9:       # %bb.0:
; P9-NEXT:    lhz r3, 0(r3)
; P9-NEXT:    mtfprwz f0, r3
; P9-NEXT:    xscvhpdp f0, f0
; P9-NEXT:    xscvdpsxds f0, f0
; P9-NEXT:    mffprd r3, f0
; P9-NEXT:    blr
;
; SOFT-LABEL: test_fptosi_i64:
; SOFT:       # %bb.0:
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    stdu r1, -32(r1)
; SOFT-NEXT:    std r0, 48(r1)
; SOFT-NEXT:    lhz r3, 0(r3)
; SOFT-NEXT:    bl __extendhfsf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    bl __fixsfdi
; SOFT-NEXT:    nop
; SOFT-NEXT:    addi r1, r1, 32
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    blr
;
; BE-LABEL: test_fptosi_i64:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -128(r1)
; BE-NEXT:    std r0, 144(r1)
; BE-NEXT:    lhz r3, 0(r3)
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    fctidz f0, f1
; BE-NEXT:    stfd f0, 120(r1)
; BE-NEXT:    ld r3, 120(r1)
; BE-NEXT:    addi r1, r1, 128
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
  %a = load half, ptr %p, align 2
  %r = fptosi half %a to i64
  ret i64 %r
}
define void @test_sitofp_i64(i64 %a, ptr %p) nounwind {
; PPC32-LABEL: test_sitofp_i64:
; PPC32:       # %bb.0:
; PPC32-NEXT:    mflr r0
; PPC32-NEXT:    stwu r1, -16(r1)
; PPC32-NEXT:    stw r0, 20(r1)
; PPC32-NEXT:    stw r30, 8(r1) # 4-byte Folded Spill
; PPC32-NEXT:    mr r30, r5
; PPC32-NEXT:    bl __floatdisf
; PPC32-NEXT:    bl __truncsfhf2
; PPC32-NEXT:    sth r3, 0(r30)
; PPC32-NEXT:    lwz r30, 8(r1) # 4-byte Folded Reload
; PPC32-NEXT:    lwz r0, 20(r1)
; PPC32-NEXT:    addi r1, r1, 16
; PPC32-NEXT:    mtlr r0
; PPC32-NEXT:    blr
;
; P8-LABEL: test_sitofp_i64:
; P8:       # %bb.0:
; P8-NEXT:    mflr r0
; P8-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; P8-NEXT:    stdu r1, -48(r1)
; P8-NEXT:    mtfprd f0, r3
; P8-NEXT:    std r0, 64(r1)
; P8-NEXT:    mr r30, r4
; P8-NEXT:    xscvsxdsp f1, f0
; P8-NEXT:    bl __truncsfhf2
; P8-NEXT:    nop
; P8-NEXT:    sth r3, 0(r30)
; P8-NEXT:    addi r1, r1, 48
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; P9-LABEL: test_sitofp_i64:
; P9:       # %bb.0:
; P9-NEXT:    mtfprd f0, r3
; P9-NEXT:    xscvsxdsp f0, f0
; P9-NEXT:    xscvdphp f0, f0
; P9-NEXT:    mffprwz r3, f0
; P9-NEXT:    sth r3, 0(r4)
; P9-NEXT:    blr
;
; SOFT-LABEL: test_sitofp_i64:
; SOFT:       # %bb.0:
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; SOFT-NEXT:    stdu r1, -48(r1)
; SOFT-NEXT:    std r0, 64(r1)
; SOFT-NEXT:    mr r30, r4
; SOFT-NEXT:    bl __floatdisf
; SOFT-NEXT:    nop
; SOFT-NEXT:    clrldi r3, r3, 32
; SOFT-NEXT:    bl __truncsfhf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    sth r3, 0(r30)
; SOFT-NEXT:    addi r1, r1, 48
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    blr
;
; BE-LABEL: test_sitofp_i64:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -144(r1)
; BE-NEXT:    sradi r5, r3, 53
; BE-NEXT:    std r0, 160(r1)
; BE-NEXT:    addi r5, r5, 1
; BE-NEXT:    cmpldi r5, 1
; BE-NEXT:    std r30, 128(r1) # 8-byte Folded Spill
; BE-NEXT:    mr r30, r4
; BE-NEXT:    ble cr0, .LBB16_2
; BE-NEXT:  # %bb.1:
; BE-NEXT:    clrldi r4, r3, 53
; BE-NEXT:    addi r4, r4, 2047
; BE-NEXT:    or r3, r4, r3
; BE-NEXT:    rldicr r3, r3, 0, 52
; BE-NEXT:  .LBB16_2:
; BE-NEXT:    std r3, 120(r1)
; BE-NEXT:    lfd f0, 120(r1)
; BE-NEXT:    fcfid f0, f0
; BE-NEXT:    frsp f1, f0
; BE-NEXT:    bl __truncsfhf2
; BE-NEXT:    nop
; BE-NEXT:    sth r3, 0(r30)
; BE-NEXT:    ld r30, 128(r1) # 8-byte Folded Reload
; BE-NEXT:    addi r1, r1, 144
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
  %r = sitofp i64 %a to half
  store half %r, ptr %p
  ret void
}
define i64 @test_fptoui_i64(ptr %p) nounwind {
; PPC32-LABEL: test_fptoui_i64:
; PPC32:       # %bb.0:
; PPC32-NEXT:    mflr r0
; PPC32-NEXT:    stwu r1, -16(r1)
; PPC32-NEXT:    stw r0, 20(r1)
; PPC32-NEXT:    lhz r3, 0(r3)
; PPC32-NEXT:    bl __extendhfsf2
; PPC32-NEXT:    bl __fixunssfdi
; PPC32-NEXT:    lwz r0, 20(r1)
; PPC32-NEXT:    addi r1, r1, 16
; PPC32-NEXT:    mtlr r0
; PPC32-NEXT:    blr
;
; P8-LABEL: test_fptoui_i64:
; P8:       # %bb.0:
; P8-NEXT:    mflr r0
; P8-NEXT:    stdu r1, -32(r1)
; P8-NEXT:    std r0, 48(r1)
; P8-NEXT:    lhz r3, 0(r3)
; P8-NEXT:    bl __extendhfsf2
; P8-NEXT:    nop
; P8-NEXT:    xscvdpuxds f0, f1
; P8-NEXT:    mffprd r3, f0
; P8-NEXT:    addi r1, r1, 32
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; P9-LABEL: test_fptoui_i64:
; P9:       # %bb.0:
; P9-NEXT:    lhz r3, 0(r3)
; P9-NEXT:    mtfprwz f0, r3
; P9-NEXT:    xscvhpdp f0, f0
; P9-NEXT:    xscvdpuxds f0, f0
; P9-NEXT:    mffprd r3, f0
; P9-NEXT:    blr
;
; SOFT-LABEL: test_fptoui_i64:
; SOFT:       # %bb.0:
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    stdu r1, -32(r1)
; SOFT-NEXT:    std r0, 48(r1)
; SOFT-NEXT:    lhz r3, 0(r3)
; SOFT-NEXT:    bl __extendhfsf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    bl __fixunssfdi
; SOFT-NEXT:    nop
; SOFT-NEXT:    addi r1, r1, 32
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    blr
;
; BE-LABEL: test_fptoui_i64:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -128(r1)
; BE-NEXT:    std r0, 144(r1)
; BE-NEXT:    lhz r3, 0(r3)
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    addis r3, r2, .LCPI17_0@toc@ha
; BE-NEXT:    lfs f0, .LCPI17_0@toc@l(r3)
; BE-NEXT:    fsubs f2, f1, f0
; BE-NEXT:    fcmpu cr0, f1, f0
; BE-NEXT:    fctidz f2, f2
; BE-NEXT:    stfd f2, 120(r1)
; BE-NEXT:    fctidz f2, f1
; BE-NEXT:    stfd f2, 112(r1)
; BE-NEXT:    blt cr0, .LBB17_2
; BE-NEXT:  # %bb.1:
; BE-NEXT:    ld r3, 120(r1)
; BE-NEXT:    li r4, 1
; BE-NEXT:    rldic r4, r4, 63, 0
; BE-NEXT:    xor r3, r3, r4
; BE-NEXT:    b .LBB17_3
; BE-NEXT:  .LBB17_2:
; BE-NEXT:    ld r3, 112(r1)
; BE-NEXT:  .LBB17_3:
; BE-NEXT:    addi r1, r1, 128
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
  %a = load half, ptr %p, align 2
  %r = fptoui half %a to i64
  ret i64 %r
}
define void @test_uitofp_i64(i64 %a, ptr %p) nounwind {
; PPC32-LABEL: test_uitofp_i64:
; PPC32:       # %bb.0:
; PPC32-NEXT:    mflr r0
; PPC32-NEXT:    stwu r1, -16(r1)
; PPC32-NEXT:    stw r0, 20(r1)
; PPC32-NEXT:    stw r30, 8(r1) # 4-byte Folded Spill
; PPC32-NEXT:    mr r30, r5
; PPC32-NEXT:    bl __floatundisf
; PPC32-NEXT:    bl __truncsfhf2
; PPC32-NEXT:    sth r3, 0(r30)
; PPC32-NEXT:    lwz r30, 8(r1) # 4-byte Folded Reload
; PPC32-NEXT:    lwz r0, 20(r1)
; PPC32-NEXT:    addi r1, r1, 16
; PPC32-NEXT:    mtlr r0
; PPC32-NEXT:    blr
;
; P8-LABEL: test_uitofp_i64:
; P8:       # %bb.0:
; P8-NEXT:    mflr r0
; P8-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; P8-NEXT:    stdu r1, -48(r1)
; P8-NEXT:    mtfprd f0, r3
; P8-NEXT:    std r0, 64(r1)
; P8-NEXT:    mr r30, r4
; P8-NEXT:    xscvuxdsp f1, f0
; P8-NEXT:    bl __truncsfhf2
; P8-NEXT:    nop
; P8-NEXT:    sth r3, 0(r30)
; P8-NEXT:    addi r1, r1, 48
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; P9-LABEL: test_uitofp_i64:
; P9:       # %bb.0:
; P9-NEXT:    mtfprd f0, r3
; P9-NEXT:    xscvuxdsp f0, f0
; P9-NEXT:    xscvdphp f0, f0
; P9-NEXT:    mffprwz r3, f0
; P9-NEXT:    sth r3, 0(r4)
; P9-NEXT:    blr
;
; SOFT-LABEL: test_uitofp_i64:
; SOFT:       # %bb.0:
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; SOFT-NEXT:    stdu r1, -48(r1)
; SOFT-NEXT:    std r0, 64(r1)
; SOFT-NEXT:    mr r30, r4
; SOFT-NEXT:    bl __floatundisf
; SOFT-NEXT:    nop
; SOFT-NEXT:    bl __truncsfhf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    sth r3, 0(r30)
; SOFT-NEXT:    addi r1, r1, 48
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    blr
;
; BE-LABEL: test_uitofp_i64:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -144(r1)
; BE-NEXT:    sradi r5, r3, 53
; BE-NEXT:    std r0, 160(r1)
; BE-NEXT:    addi r5, r5, 1
; BE-NEXT:    cmpldi r5, 1
; BE-NEXT:    std r30, 128(r1) # 8-byte Folded Spill
; BE-NEXT:    mr r30, r4
; BE-NEXT:    bgt cr0, .LBB18_2
; BE-NEXT:  # %bb.1:
; BE-NEXT:    mr r4, r3
; BE-NEXT:    b .LBB18_3
; BE-NEXT:  .LBB18_2:
; BE-NEXT:    clrldi r4, r3, 53
; BE-NEXT:    addi r4, r4, 2047
; BE-NEXT:    or r4, r4, r3
; BE-NEXT:    rldicr r4, r4, 0, 52
; BE-NEXT:  .LBB18_3:
; BE-NEXT:    rldicl r5, r3, 10, 54
; BE-NEXT:    clrldi r6, r3, 63
; BE-NEXT:    std r4, 112(r1)
; BE-NEXT:    addi r5, r5, 1
; BE-NEXT:    cmpldi r5, 1
; BE-NEXT:    rldicl r5, r3, 63, 1
; BE-NEXT:    or r4, r6, r5
; BE-NEXT:    ble cr0, .LBB18_5
; BE-NEXT:  # %bb.4:
; BE-NEXT:    clrldi r4, r4, 53
; BE-NEXT:    addi r4, r4, 2047
; BE-NEXT:    or r4, r4, r5
; BE-NEXT:    rldicl r4, r4, 53, 11
; BE-NEXT:    rldicl r4, r4, 11, 1
; BE-NEXT:  .LBB18_5:
; BE-NEXT:    cmpdi r3, 0
; BE-NEXT:    std r4, 120(r1)
; BE-NEXT:    bc 12, lt, .LBB18_7
; BE-NEXT:  # %bb.6:
; BE-NEXT:    lfd f0, 112(r1)
; BE-NEXT:    fcfid f0, f0
; BE-NEXT:    frsp f1, f0
; BE-NEXT:    b .LBB18_8
; BE-NEXT:  .LBB18_7:
; BE-NEXT:    lfd f0, 120(r1)
; BE-NEXT:    fcfid f0, f0
; BE-NEXT:    frsp f0, f0
; BE-NEXT:    fadds f1, f0, f0
; BE-NEXT:  .LBB18_8:
; BE-NEXT:    bl __truncsfhf2
; BE-NEXT:    nop
; BE-NEXT:    sth r3, 0(r30)
; BE-NEXT:    ld r30, 128(r1) # 8-byte Folded Reload
; BE-NEXT:    addi r1, r1, 144
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
  %r = uitofp i64 %a to half
  store half %r, ptr %p
  ret void
}
define <4 x float> @test_extend32_vec4(ptr %p) nounwind {
; PPC32-LABEL: test_extend32_vec4:
; PPC32:       # %bb.0:
; PPC32-NEXT:    mflr r0
; PPC32-NEXT:    stwu r1, -48(r1)
; PPC32-NEXT:    stw r0, 52(r1)
; PPC32-NEXT:    stw r30, 16(r1) # 4-byte Folded Spill
; PPC32-NEXT:    mr r30, r3
; PPC32-NEXT:    lhz r3, 0(r3)
; PPC32-NEXT:    stfd f29, 24(r1) # 8-byte Folded Spill
; PPC32-NEXT:    stfd f30, 32(r1) # 8-byte Folded Spill
; PPC32-NEXT:    stfd f31, 40(r1) # 8-byte Folded Spill
; PPC32-NEXT:    bl __extendhfsf2
; PPC32-NEXT:    lhz r3, 2(r30)
; PPC32-NEXT:    fmr f31, f1
; PPC32-NEXT:    bl __extendhfsf2
; PPC32-NEXT:    lhz r3, 4(r30)
; PPC32-NEXT:    fmr f30, f1
; PPC32-NEXT:    bl __extendhfsf2
; PPC32-NEXT:    lhz r3, 6(r30)
; PPC32-NEXT:    fmr f29, f1
; PPC32-NEXT:    bl __extendhfsf2
; PPC32-NEXT:    fmr f4, f1
; PPC32-NEXT:    fmr f1, f31
; PPC32-NEXT:    fmr f2, f30
; PPC32-NEXT:    fmr f3, f29
; PPC32-NEXT:    lfd f31, 40(r1) # 8-byte Folded Reload
; PPC32-NEXT:    lfd f30, 32(r1) # 8-byte Folded Reload
; PPC32-NEXT:    lfd f29, 24(r1) # 8-byte Folded Reload
; PPC32-NEXT:    lwz r30, 16(r1) # 4-byte Folded Reload
; PPC32-NEXT:    lwz r0, 52(r1)
; PPC32-NEXT:    addi r1, r1, 48
; PPC32-NEXT:    mtlr r0
; PPC32-NEXT:    blr
;
; P8-LABEL: test_extend32_vec4:
; P8:       # %bb.0:
; P8-NEXT:    mflr r0
; P8-NEXT:    stdu r1, -144(r1)
; P8-NEXT:    li r4, 80
; P8-NEXT:    std r0, 160(r1)
; P8-NEXT:    std r29, 120(r1) # 8-byte Folded Spill
; P8-NEXT:    std r30, 128(r1) # 8-byte Folded Spill
; P8-NEXT:    stxvd2x vs62, r1, r4 # 16-byte Folded Spill
; P8-NEXT:    li r4, 96
; P8-NEXT:    stxvd2x vs63, r1, r4 # 16-byte Folded Spill
; P8-NEXT:    lwz r4, 4(r3)
; P8-NEXT:    stw r4, 64(r1)
; P8-NEXT:    lwz r3, 0(r3)
; P8-NEXT:    stw r3, 48(r1)
; P8-NEXT:    addi r3, r1, 64
; P8-NEXT:    lxvd2x vs62, 0, r3
; P8-NEXT:    addi r3, r1, 48
; P8-NEXT:    lxvd2x vs0, 0, r3
; P8-NEXT:    mffprd r30, f0
; P8-NEXT:    clrldi r3, r30, 48
; P8-NEXT:    clrlwi r3, r3, 16
; P8-NEXT:    bl __extendhfsf2
; P8-NEXT:    nop
; P8-NEXT:    mfvsrd r29, vs62
; P8-NEXT:    xxlor vs63, f1, f1
; P8-NEXT:    clrldi r3, r29, 48
; P8-NEXT:    clrlwi r3, r3, 16
; P8-NEXT:    bl __extendhfsf2
; P8-NEXT:    nop
; P8-NEXT:    rldicl r3, r30, 48, 48
; P8-NEXT:    xxmrghd vs0, vs1, vs63
; P8-NEXT:    clrlwi r3, r3, 16
; P8-NEXT:    xvcvdpsp vs62, vs0
; P8-NEXT:    bl __extendhfsf2
; P8-NEXT:    nop
; P8-NEXT:    rldicl r3, r29, 48, 48
; P8-NEXT:    xxlor vs63, f1, f1
; P8-NEXT:    clrlwi r3, r3, 16
; P8-NEXT:    bl __extendhfsf2
; P8-NEXT:    nop
; P8-NEXT:    xxmrghd vs0, vs1, vs63
; P8-NEXT:    li r3, 96
; P8-NEXT:    ld r30, 128(r1) # 8-byte Folded Reload
; P8-NEXT:    ld r29, 120(r1) # 8-byte Folded Reload
; P8-NEXT:    xvcvdpsp vs34, vs0
; P8-NEXT:    lxvd2x vs63, r1, r3 # 16-byte Folded Reload
; P8-NEXT:    li r3, 80
; P8-NEXT:    vmrgew v2, v2, v30
; P8-NEXT:    lxvd2x vs62, r1, r3 # 16-byte Folded Reload
; P8-NEXT:    addi r1, r1, 144
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; P9-LABEL: test_extend32_vec4:
; P9:       # %bb.0:
; P9-NEXT:    lwz r4, 4(r3)
; P9-NEXT:    stw r4, -16(r1)
; P9-NEXT:    lwz r3, 0(r3)
; P9-NEXT:    lxv vs34, -16(r1)
; P9-NEXT:    stw r3, -32(r1)
; P9-NEXT:    li r3, 0
; P9-NEXT:    lxv vs35, -32(r1)
; P9-NEXT:    vextuhrx r4, r3, v3
; P9-NEXT:    vextuhrx r3, r3, v2
; P9-NEXT:    clrlwi r4, r4, 16
; P9-NEXT:    clrlwi r3, r3, 16
; P9-NEXT:    mtfprwz f0, r4
; P9-NEXT:    mtfprwz f1, r3
; P9-NEXT:    li r3, 2
; P9-NEXT:    xscvhpdp f0, f0
; P9-NEXT:    xscvhpdp f1, f1
; P9-NEXT:    vextuhrx r4, r3, v3
; P9-NEXT:    vextuhrx r3, r3, v2
; P9-NEXT:    clrlwi r4, r4, 16
; P9-NEXT:    clrlwi r3, r3, 16
; P9-NEXT:    xxmrghd vs0, vs1, vs0
; P9-NEXT:    mtfprwz f1, r3
; P9-NEXT:    xvcvdpsp vs36, vs0
; P9-NEXT:    mtfprwz f0, r4
; P9-NEXT:    xscvhpdp f0, f0
; P9-NEXT:    xscvhpdp f1, f1
; P9-NEXT:    xxmrghd vs0, vs1, vs0
; P9-NEXT:    xvcvdpsp vs34, vs0
; P9-NEXT:    vmrgew v2, v2, v4
; P9-NEXT:    blr
;
; SOFT-LABEL: test_extend32_vec4:
; SOFT:       # %bb.0:
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    std r27, -40(r1) # 8-byte Folded Spill
; SOFT-NEXT:    std r28, -32(r1) # 8-byte Folded Spill
; SOFT-NEXT:    std r29, -24(r1) # 8-byte Folded Spill
; SOFT-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; SOFT-NEXT:    stdu r1, -80(r1)
; SOFT-NEXT:    std r0, 96(r1)
; SOFT-NEXT:    mr r30, r3
; SOFT-NEXT:    lhz r3, 0(r3)
; SOFT-NEXT:    bl __extendhfsf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    mr r29, r3
; SOFT-NEXT:    lhz r3, 2(r30)
; SOFT-NEXT:    bl __extendhfsf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    mr r28, r3
; SOFT-NEXT:    lhz r3, 4(r30)
; SOFT-NEXT:    bl __extendhfsf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    mr r27, r3
; SOFT-NEXT:    lhz r3, 6(r30)
; SOFT-NEXT:    bl __extendhfsf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    mr r6, r3
; SOFT-NEXT:    mr r3, r29
; SOFT-NEXT:    mr r4, r28
; SOFT-NEXT:    mr r5, r27
; SOFT-NEXT:    addi r1, r1, 80
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; SOFT-NEXT:    ld r29, -24(r1) # 8-byte Folded Reload
; SOFT-NEXT:    ld r28, -32(r1) # 8-byte Folded Reload
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    ld r27, -40(r1) # 8-byte Folded Reload
; SOFT-NEXT:    blr
;
; BE-LABEL: test_extend32_vec4:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -192(r1)
; BE-NEXT:    std r0, 208(r1)
; BE-NEXT:    lwz r4, 0(r3)
; BE-NEXT:    stw r4, 160(r1)
; BE-NEXT:    lwz r3, 4(r3)
; BE-NEXT:    stw r3, 176(r1)
; BE-NEXT:    addi r3, r1, 160
; BE-NEXT:    lvx v2, 0, r3
; BE-NEXT:    addi r3, r1, 176
; BE-NEXT:    lvx v3, 0, r3
; BE-NEXT:    addi r3, r1, 128
; BE-NEXT:    stvx v3, 0, r3
; BE-NEXT:    addi r3, r1, 112
; BE-NEXT:    stvx v2, 0, r3
; BE-NEXT:    lhz r3, 130(r1)
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    lhz r3, 128(r1)
; BE-NEXT:    stfs f1, 156(r1)
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    lhz r3, 114(r1)
; BE-NEXT:    stfs f1, 152(r1)
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    lhz r3, 112(r1)
; BE-NEXT:    stfs f1, 148(r1)
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    stfs f1, 144(r1)
; BE-NEXT:    addi r3, r1, 144
; BE-NEXT:    lvx v2, 0, r3
; BE-NEXT:    addi r1, r1, 192
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
  %a = load <4 x half>, ptr %p, align 8
  %b = fpext <4 x half> %a to <4 x float>
  ret <4 x float> %b
}
define <4 x double> @test_extend64_vec4(ptr %p) nounwind {
; PPC32-LABEL: test_extend64_vec4:
; PPC32:       # %bb.0:
; PPC32-NEXT:    mflr r0
; PPC32-NEXT:    stwu r1, -48(r1)
; PPC32-NEXT:    stw r0, 52(r1)
; PPC32-NEXT:    stw r30, 16(r1) # 4-byte Folded Spill
; PPC32-NEXT:    mr r30, r3
; PPC32-NEXT:    lhz r3, 0(r3)
; PPC32-NEXT:    stfd f29, 24(r1) # 8-byte Folded Spill
; PPC32-NEXT:    stfd f30, 32(r1) # 8-byte Folded Spill
; PPC32-NEXT:    stfd f31, 40(r1) # 8-byte Folded Spill
; PPC32-NEXT:    bl __extendhfsf2
; PPC32-NEXT:    lhz r3, 2(r30)
; PPC32-NEXT:    fmr f31, f1
; PPC32-NEXT:    bl __extendhfsf2
; PPC32-NEXT:    lhz r3, 4(r30)
; PPC32-NEXT:    fmr f30, f1
; PPC32-NEXT:    bl __extendhfsf2
; PPC32-NEXT:    lhz r3, 6(r30)
; PPC32-NEXT:    fmr f29, f1
; PPC32-NEXT:    bl __extendhfsf2
; PPC32-NEXT:    fmr f4, f1
; PPC32-NEXT:    fmr f1, f31
; PPC32-NEXT:    fmr f2, f30
; PPC32-NEXT:    fmr f3, f29
; PPC32-NEXT:    lfd f31, 40(r1) # 8-byte Folded Reload
; PPC32-NEXT:    lfd f30, 32(r1) # 8-byte Folded Reload
; PPC32-NEXT:    lfd f29, 24(r1) # 8-byte Folded Reload
; PPC32-NEXT:    lwz r30, 16(r1) # 4-byte Folded Reload
; PPC32-NEXT:    lwz r0, 52(r1)
; PPC32-NEXT:    addi r1, r1, 48
; PPC32-NEXT:    mtlr r0
; PPC32-NEXT:    blr
;
; P8-LABEL: test_extend64_vec4:
; P8:       # %bb.0:
; P8-NEXT:    mflr r0
; P8-NEXT:    stdu r1, -112(r1)
; P8-NEXT:    std r0, 128(r1)
; P8-NEXT:    li r4, 48
; P8-NEXT:    std r28, 80(r1) # 8-byte Folded Spill
; P8-NEXT:    lhz r28, 2(r3)
; P8-NEXT:    std r29, 88(r1) # 8-byte Folded Spill
; P8-NEXT:    std r30, 96(r1) # 8-byte Folded Spill
; P8-NEXT:    lhz r30, 6(r3)
; P8-NEXT:    lhz r29, 4(r3)
; P8-NEXT:    lhz r3, 0(r3)
; P8-NEXT:    stxvd2x vs62, r1, r4 # 16-byte Folded Spill
; P8-NEXT:    li r4, 64
; P8-NEXT:    stxvd2x vs63, r1, r4 # 16-byte Folded Spill
; P8-NEXT:    bl __extendhfsf2
; P8-NEXT:    nop
; P8-NEXT:    mr r3, r28
; P8-NEXT:    xxlor vs63, f1, f1
; P8-NEXT:    bl __extendhfsf2
; P8-NEXT:    nop
; P8-NEXT:    mr r3, r29
; P8-NEXT:    xxmrghd vs63, vs1, vs63
; P8-NEXT:    bl __extendhfsf2
; P8-NEXT:    nop
; P8-NEXT:    mr r3, r30
; P8-NEXT:    xxlor vs62, f1, f1
; P8-NEXT:    bl __extendhfsf2
; P8-NEXT:    nop
; P8-NEXT:    li r3, 64
; P8-NEXT:    vmr v2, v31
; P8-NEXT:    xxmrghd vs35, vs1, vs62
; P8-NEXT:    ld r30, 96(r1) # 8-byte Folded Reload
; P8-NEXT:    ld r29, 88(r1) # 8-byte Folded Reload
; P8-NEXT:    ld r28, 80(r1) # 8-byte Folded Reload
; P8-NEXT:    lxvd2x vs63, r1, r3 # 16-byte Folded Reload
; P8-NEXT:    li r3, 48
; P8-NEXT:    lxvd2x vs62, r1, r3 # 16-byte Folded Reload
; P8-NEXT:    addi r1, r1, 112
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; P9-LABEL: test_extend64_vec4:
; P9:       # %bb.0:
; P9-NEXT:    lhz r4, 6(r3)
; P9-NEXT:    lhz r5, 4(r3)
; P9-NEXT:    lhz r6, 2(r3)
; P9-NEXT:    lhz r3, 0(r3)
; P9-NEXT:    mtfprwz f0, r3
; P9-NEXT:    mtfprwz f1, r6
; P9-NEXT:    xscvhpdp f0, f0
; P9-NEXT:    xscvhpdp f1, f1
; P9-NEXT:    xxmrghd vs34, vs1, vs0
; P9-NEXT:    mtfprwz f0, r5
; P9-NEXT:    mtfprwz f1, r4
; P9-NEXT:    xscvhpdp f0, f0
; P9-NEXT:    xscvhpdp f1, f1
; P9-NEXT:    xxmrghd vs35, vs1, vs0
; P9-NEXT:    blr
;
; SOFT-LABEL: test_extend64_vec4:
; SOFT:       # %bb.0:
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    std r27, -40(r1) # 8-byte Folded Spill
; SOFT-NEXT:    std r28, -32(r1) # 8-byte Folded Spill
; SOFT-NEXT:    std r29, -24(r1) # 8-byte Folded Spill
; SOFT-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; SOFT-NEXT:    stdu r1, -80(r1)
; SOFT-NEXT:    std r0, 96(r1)
; SOFT-NEXT:    mr r30, r3
; SOFT-NEXT:    lhz r3, 0(r3)
; SOFT-NEXT:    bl __extendhfsf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    bl __extendsfdf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    mr r29, r3
; SOFT-NEXT:    lhz r3, 2(r30)
; SOFT-NEXT:    bl __extendhfsf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    bl __extendsfdf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    mr r28, r3
; SOFT-NEXT:    lhz r3, 4(r30)
; SOFT-NEXT:    bl __extendhfsf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    bl __extendsfdf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    mr r27, r3
; SOFT-NEXT:    lhz r3, 6(r30)
; SOFT-NEXT:    bl __extendhfsf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    bl __extendsfdf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    mr r6, r3
; SOFT-NEXT:    mr r3, r29
; SOFT-NEXT:    mr r4, r28
; SOFT-NEXT:    mr r5, r27
; SOFT-NEXT:    addi r1, r1, 80
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; SOFT-NEXT:    ld r29, -24(r1) # 8-byte Folded Reload
; SOFT-NEXT:    ld r28, -32(r1) # 8-byte Folded Reload
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    ld r27, -40(r1) # 8-byte Folded Reload
; SOFT-NEXT:    blr
;
; BE-LABEL: test_extend64_vec4:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -176(r1)
; BE-NEXT:    std r0, 192(r1)
; BE-NEXT:    std r28, 120(r1) # 8-byte Folded Spill
; BE-NEXT:    std r29, 128(r1) # 8-byte Folded Spill
; BE-NEXT:    std r30, 136(r1) # 8-byte Folded Spill
; BE-NEXT:    lhz r30, 6(r3)
; BE-NEXT:    lhz r29, 4(r3)
; BE-NEXT:    lhz r28, 2(r3)
; BE-NEXT:    lhz r3, 0(r3)
; BE-NEXT:    stfd f29, 152(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f30, 160(r1) # 8-byte Folded Spill
; BE-NEXT:    stfd f31, 168(r1) # 8-byte Folded Spill
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    mr r3, r28
; BE-NEXT:    fmr f31, f1
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    mr r3, r29
; BE-NEXT:    fmr f30, f1
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    mr r3, r30
; BE-NEXT:    fmr f29, f1
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    fmr f4, f1
; BE-NEXT:    fmr f1, f31
; BE-NEXT:    lfd f31, 168(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r30, 136(r1) # 8-byte Folded Reload
; BE-NEXT:    fmr f2, f30
; BE-NEXT:    fmr f3, f29
; BE-NEXT:    lfd f30, 160(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f29, 152(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r29, 128(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r28, 120(r1) # 8-byte Folded Reload
; BE-NEXT:    addi r1, r1, 176
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
  %a = load <4 x half>, ptr %p, align 8
  %b = fpext <4 x half> %a to <4 x double>
  ret <4 x double> %b
}
define void @test_trunc32_vec4(<4 x float> %a, ptr %p) nounwind {
; PPC32-LABEL: test_trunc32_vec4:
; PPC32:       # %bb.0:
; PPC32-NEXT:    mflr r0
; PPC32-NEXT:    stwu r1, -64(r1)
; PPC32-NEXT:    stw r0, 68(r1)
; PPC32-NEXT:    stw r27, 20(r1) # 4-byte Folded Spill
; PPC32-NEXT:    stw r28, 24(r1) # 4-byte Folded Spill
; PPC32-NEXT:    stw r29, 28(r1) # 4-byte Folded Spill
; PPC32-NEXT:    stw r30, 32(r1) # 4-byte Folded Spill
; PPC32-NEXT:    mr r30, r3
; PPC32-NEXT:    stfd f29, 40(r1) # 8-byte Folded Spill
; PPC32-NEXT:    fmr f29, f2
; PPC32-NEXT:    stfd f30, 48(r1) # 8-byte Folded Spill
; PPC32-NEXT:    fmr f30, f3
; PPC32-NEXT:    stfd f31, 56(r1) # 8-byte Folded Spill
; PPC32-NEXT:    fmr f31, f4
; PPC32-NEXT:    bl __truncsfhf2
; PPC32-NEXT:    fmr f1, f29
; PPC32-NEXT:    mr r29, r3
; PPC32-NEXT:    bl __truncsfhf2
; PPC32-NEXT:    fmr f1, f30
; PPC32-NEXT:    mr r28, r3
; PPC32-NEXT:    bl __truncsfhf2
; PPC32-NEXT:    fmr f1, f31
; PPC32-NEXT:    mr r27, r3
; PPC32-NEXT:    bl __truncsfhf2
; PPC32-NEXT:    sth r27, 4(r30)
; PPC32-NEXT:    sth r28, 2(r30)
; PPC32-NEXT:    sth r3, 6(r30)
; PPC32-NEXT:    sth r29, 0(r30)
; PPC32-NEXT:    lfd f31, 56(r1) # 8-byte Folded Reload
; PPC32-NEXT:    lfd f30, 48(r1) # 8-byte Folded Reload
; PPC32-NEXT:    lfd f29, 40(r1) # 8-byte Folded Reload
; PPC32-NEXT:    lwz r30, 32(r1) # 4-byte Folded Reload
; PPC32-NEXT:    lwz r29, 28(r1) # 4-byte Folded Reload
; PPC32-NEXT:    lwz r28, 24(r1) # 4-byte Folded Reload
; PPC32-NEXT:    lwz r27, 20(r1) # 4-byte Folded Reload
; PPC32-NEXT:    lwz r0, 68(r1)
; PPC32-NEXT:    addi r1, r1, 64
; PPC32-NEXT:    mtlr r0
; PPC32-NEXT:    blr
;
; P8-LABEL: test_trunc32_vec4:
; P8:       # %bb.0:
; P8-NEXT:    mflr r0
; P8-NEXT:    stdu r1, -112(r1)
; P8-NEXT:    xxsldwi vs0, vs34, vs34, 3
; P8-NEXT:    li r3, 48
; P8-NEXT:    std r0, 128(r1)
; P8-NEXT:    std r27, 72(r1) # 8-byte Folded Spill
; P8-NEXT:    std r28, 80(r1) # 8-byte Folded Spill
; P8-NEXT:    std r29, 88(r1) # 8-byte Folded Spill
; P8-NEXT:    xscvspdpn f1, vs0
; P8-NEXT:    std r30, 96(r1) # 8-byte Folded Spill
; P8-NEXT:    stxvd2x vs63, r1, r3 # 16-byte Folded Spill
; P8-NEXT:    mr r30, r5
; P8-NEXT:    vmr v31, v2
; P8-NEXT:    bl __truncsfhf2
; P8-NEXT:    nop
; P8-NEXT:    xxswapd vs0, vs63
; P8-NEXT:    mr r29, r3
; P8-NEXT:    xscvspdpn f1, vs0
; P8-NEXT:    bl __truncsfhf2
; P8-NEXT:    nop
; P8-NEXT:    xxsldwi vs0, vs63, vs63, 1
; P8-NEXT:    mr r28, r3
; P8-NEXT:    xscvspdpn f1, vs0
; P8-NEXT:    bl __truncsfhf2
; P8-NEXT:    nop
; P8-NEXT:    xscvspdpn f1, vs63
; P8-NEXT:    mr r27, r3
; P8-NEXT:    bl __truncsfhf2
; P8-NEXT:    nop
; P8-NEXT:    sth r3, 6(r30)
; P8-NEXT:    li r3, 48
; P8-NEXT:    sth r27, 4(r30)
; P8-NEXT:    ld r27, 72(r1) # 8-byte Folded Reload
; P8-NEXT:    sth r28, 2(r30)
; P8-NEXT:    sth r29, 0(r30)
; P8-NEXT:    ld r30, 96(r1) # 8-byte Folded Reload
; P8-NEXT:    ld r29, 88(r1) # 8-byte Folded Reload
; P8-NEXT:    lxvd2x vs63, r1, r3 # 16-byte Folded Reload
; P8-NEXT:    ld r28, 80(r1) # 8-byte Folded Reload
; P8-NEXT:    addi r1, r1, 112
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; P9-LABEL: test_trunc32_vec4:
; P9:       # %bb.0:
; P9-NEXT:    xxsldwi vs0, vs34, vs34, 3
; P9-NEXT:    xxsldwi vs1, vs34, vs34, 1
; P9-NEXT:    xscvspdpn f0, vs0
; P9-NEXT:    xscvspdpn f1, vs1
; P9-NEXT:    xscvdphp f0, f0
; P9-NEXT:    mffprwz r3, f0
; P9-NEXT:    xxswapd vs0, vs34
; P9-NEXT:    xscvspdpn f0, vs0
; P9-NEXT:    xscvdphp f0, f0
; P9-NEXT:    xscvdphp f1, f1
; P9-NEXT:    mffprwz r4, f1
; P9-NEXT:    xscvspdpn f1, vs34
; P9-NEXT:    xscvdphp f1, f1
; P9-NEXT:    sth r4, 4(r5)
; P9-NEXT:    mffprwz r4, f0
; P9-NEXT:    sth r3, 0(r5)
; P9-NEXT:    sth r4, 2(r5)
; P9-NEXT:    mffprwz r6, f1
; P9-NEXT:    sth r6, 6(r5)
; P9-NEXT:    blr
;
; SOFT-LABEL: test_trunc32_vec4:
; SOFT:       # %bb.0:
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    std r26, -48(r1) # 8-byte Folded Spill
; SOFT-NEXT:    std r27, -40(r1) # 8-byte Folded Spill
; SOFT-NEXT:    std r28, -32(r1) # 8-byte Folded Spill
; SOFT-NEXT:    std r29, -24(r1) # 8-byte Folded Spill
; SOFT-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; SOFT-NEXT:    stdu r1, -80(r1)
; SOFT-NEXT:    clrldi r3, r3, 32
; SOFT-NEXT:    std r0, 96(r1)
; SOFT-NEXT:    mr r30, r7
; SOFT-NEXT:    mr r29, r6
; SOFT-NEXT:    mr r28, r5
; SOFT-NEXT:    mr r27, r4
; SOFT-NEXT:    bl __truncsfhf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    mr r26, r3
; SOFT-NEXT:    clrldi r3, r27, 32
; SOFT-NEXT:    bl __truncsfhf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    mr r27, r3
; SOFT-NEXT:    clrldi r3, r28, 32
; SOFT-NEXT:    bl __truncsfhf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    mr r28, r3
; SOFT-NEXT:    clrldi r3, r29, 32
; SOFT-NEXT:    bl __truncsfhf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    sth r3, 6(r30)
; SOFT-NEXT:    sth r28, 4(r30)
; SOFT-NEXT:    sth r27, 2(r30)
; SOFT-NEXT:    sth r26, 0(r30)
; SOFT-NEXT:    addi r1, r1, 80
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; SOFT-NEXT:    ld r29, -24(r1) # 8-byte Folded Reload
; SOFT-NEXT:    ld r28, -32(r1) # 8-byte Folded Reload
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    ld r27, -40(r1) # 8-byte Folded Reload
; SOFT-NEXT:    ld r26, -48(r1) # 8-byte Folded Reload
; SOFT-NEXT:    blr
;
; BE-LABEL: test_trunc32_vec4:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -176(r1)
; BE-NEXT:    addi r3, r1, 112
; BE-NEXT:    std r0, 192(r1)
; BE-NEXT:    std r27, 136(r1) # 8-byte Folded Spill
; BE-NEXT:    std r28, 144(r1) # 8-byte Folded Spill
; BE-NEXT:    std r29, 152(r1) # 8-byte Folded Spill
; BE-NEXT:    std r30, 160(r1) # 8-byte Folded Spill
; BE-NEXT:    mr r30, r5
; BE-NEXT:    stvx v2, 0, r3
; BE-NEXT:    lfs f1, 112(r1)
; BE-NEXT:    bl __truncsfhf2
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 116(r1)
; BE-NEXT:    mr r29, r3
; BE-NEXT:    bl __truncsfhf2
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 120(r1)
; BE-NEXT:    mr r28, r3
; BE-NEXT:    bl __truncsfhf2
; BE-NEXT:    nop
; BE-NEXT:    lfs f1, 124(r1)
; BE-NEXT:    mr r27, r3
; BE-NEXT:    bl __truncsfhf2
; BE-NEXT:    nop
; BE-NEXT:    sth r27, 4(r30)
; BE-NEXT:    sth r28, 2(r30)
; BE-NEXT:    sth r3, 6(r30)
; BE-NEXT:    sth r29, 0(r30)
; BE-NEXT:    ld r30, 160(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r29, 152(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r28, 144(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r27, 136(r1) # 8-byte Folded Reload
; BE-NEXT:    addi r1, r1, 176
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
  %v = fptrunc <4 x float> %a to <4 x half>
  store <4 x half> %v, ptr %p
  ret void
}
define void @test_trunc64_vec4(<4 x double> %a, ptr %p) nounwind {
; PPC32-LABEL: test_trunc64_vec4:
; PPC32:       # %bb.0:
; PPC32-NEXT:    mflr r0
; PPC32-NEXT:    stwu r1, -64(r1)
; PPC32-NEXT:    stw r0, 68(r1)
; PPC32-NEXT:    stw r27, 20(r1) # 4-byte Folded Spill
; PPC32-NEXT:    stw r28, 24(r1) # 4-byte Folded Spill
; PPC32-NEXT:    stw r29, 28(r1) # 4-byte Folded Spill
; PPC32-NEXT:    stw r30, 32(r1) # 4-byte Folded Spill
; PPC32-NEXT:    mr r30, r3
; PPC32-NEXT:    stfd f29, 40(r1) # 8-byte Folded Spill
; PPC32-NEXT:    fmr f29, f2
; PPC32-NEXT:    stfd f30, 48(r1) # 8-byte Folded Spill
; PPC32-NEXT:    fmr f30, f3
; PPC32-NEXT:    stfd f31, 56(r1) # 8-byte Folded Spill
; PPC32-NEXT:    fmr f31, f4
; PPC32-NEXT:    bl __truncdfhf2
; PPC32-NEXT:    fmr f1, f29
; PPC32-NEXT:    mr r29, r3
; PPC32-NEXT:    bl __truncdfhf2
; PPC32-NEXT:    fmr f1, f30
; PPC32-NEXT:    mr r28, r3
; PPC32-NEXT:    bl __truncdfhf2
; PPC32-NEXT:    fmr f1, f31
; PPC32-NEXT:    mr r27, r3
; PPC32-NEXT:    bl __truncdfhf2
; PPC32-NEXT:    sth r27, 4(r30)
; PPC32-NEXT:    sth r28, 2(r30)
; PPC32-NEXT:    sth r3, 6(r30)
; PPC32-NEXT:    sth r29, 0(r30)
; PPC32-NEXT:    lfd f31, 56(r1) # 8-byte Folded Reload
; PPC32-NEXT:    lfd f30, 48(r1) # 8-byte Folded Reload
; PPC32-NEXT:    lfd f29, 40(r1) # 8-byte Folded Reload
; PPC32-NEXT:    lwz r30, 32(r1) # 4-byte Folded Reload
; PPC32-NEXT:    lwz r29, 28(r1) # 4-byte Folded Reload
; PPC32-NEXT:    lwz r28, 24(r1) # 4-byte Folded Reload
; PPC32-NEXT:    lwz r27, 20(r1) # 4-byte Folded Reload
; PPC32-NEXT:    lwz r0, 68(r1)
; PPC32-NEXT:    addi r1, r1, 64
; PPC32-NEXT:    mtlr r0
; PPC32-NEXT:    blr
;
; P8-LABEL: test_trunc64_vec4:
; P8:       # %bb.0:
; P8-NEXT:    mflr r0
; P8-NEXT:    stdu r1, -128(r1)
; P8-NEXT:    li r3, 48
; P8-NEXT:    std r0, 144(r1)
; P8-NEXT:    xxswapd vs1, vs34
; P8-NEXT:    std r27, 88(r1) # 8-byte Folded Spill
; P8-NEXT:    std r28, 96(r1) # 8-byte Folded Spill
; P8-NEXT:    std r29, 104(r1) # 8-byte Folded Spill
; P8-NEXT:    std r30, 112(r1) # 8-byte Folded Spill
; P8-NEXT:    mr r30, r7
; P8-NEXT:    stxvd2x vs62, r1, r3 # 16-byte Folded Spill
; P8-NEXT:    li r3, 64
; P8-NEXT:    vmr v30, v2
; P8-NEXT:    stxvd2x vs63, r1, r3 # 16-byte Folded Spill
; P8-NEXT:    vmr v31, v3
; P8-NEXT:    bl __truncdfhf2
; P8-NEXT:    nop
; P8-NEXT:    xxswapd vs1, vs63
; P8-NEXT:    mr r29, r3
; P8-NEXT:    bl __truncdfhf2
; P8-NEXT:    nop
; P8-NEXT:    xxlor f1, vs62, vs62
; P8-NEXT:    mr r28, r3
; P8-NEXT:    bl __truncdfhf2
; P8-NEXT:    nop
; P8-NEXT:    xxlor f1, vs63, vs63
; P8-NEXT:    mr r27, r3
; P8-NEXT:    bl __truncdfhf2
; P8-NEXT:    nop
; P8-NEXT:    sth r3, 6(r30)
; P8-NEXT:    li r3, 64
; P8-NEXT:    sth r27, 2(r30)
; P8-NEXT:    ld r27, 88(r1) # 8-byte Folded Reload
; P8-NEXT:    sth r28, 4(r30)
; P8-NEXT:    sth r29, 0(r30)
; P8-NEXT:    ld r30, 112(r1) # 8-byte Folded Reload
; P8-NEXT:    ld r29, 104(r1) # 8-byte Folded Reload
; P8-NEXT:    lxvd2x vs63, r1, r3 # 16-byte Folded Reload
; P8-NEXT:    li r3, 48
; P8-NEXT:    ld r28, 96(r1) # 8-byte Folded Reload
; P8-NEXT:    lxvd2x vs62, r1, r3 # 16-byte Folded Reload
; P8-NEXT:    addi r1, r1, 128
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; P9-LABEL: test_trunc64_vec4:
; P9:       # %bb.0:
; P9-NEXT:    xxswapd vs0, vs34
; P9-NEXT:    xscvdphp f0, f0
; P9-NEXT:    mffprwz r3, f0
; P9-NEXT:    xxswapd vs0, vs35
; P9-NEXT:    xscvdphp f0, f0
; P9-NEXT:    xscvdphp f1, vs34
; P9-NEXT:    mffprwz r4, f1
; P9-NEXT:    xscvdphp f1, vs35
; P9-NEXT:    sth r3, 0(r7)
; P9-NEXT:    sth r4, 2(r7)
; P9-NEXT:    mffprwz r4, f0
; P9-NEXT:    sth r4, 4(r7)
; P9-NEXT:    mffprwz r5, f1
; P9-NEXT:    sth r5, 6(r7)
; P9-NEXT:    blr
;
; SOFT-LABEL: test_trunc64_vec4:
; SOFT:       # %bb.0:
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    std r26, -48(r1) # 8-byte Folded Spill
; SOFT-NEXT:    std r27, -40(r1) # 8-byte Folded Spill
; SOFT-NEXT:    std r28, -32(r1) # 8-byte Folded Spill
; SOFT-NEXT:    std r29, -24(r1) # 8-byte Folded Spill
; SOFT-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; SOFT-NEXT:    stdu r1, -80(r1)
; SOFT-NEXT:    std r0, 96(r1)
; SOFT-NEXT:    mr r30, r7
; SOFT-NEXT:    mr r29, r6
; SOFT-NEXT:    mr r28, r5
; SOFT-NEXT:    mr r27, r4
; SOFT-NEXT:    bl __truncdfhf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    mr r26, r3
; SOFT-NEXT:    mr r3, r27
; SOFT-NEXT:    bl __truncdfhf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    mr r27, r3
; SOFT-NEXT:    mr r3, r28
; SOFT-NEXT:    bl __truncdfhf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    mr r28, r3
; SOFT-NEXT:    mr r3, r29
; SOFT-NEXT:    bl __truncdfhf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    sth r3, 6(r30)
; SOFT-NEXT:    sth r28, 4(r30)
; SOFT-NEXT:    sth r27, 2(r30)
; SOFT-NEXT:    sth r26, 0(r30)
; SOFT-NEXT:    addi r1, r1, 80
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; SOFT-NEXT:    ld r29, -24(r1) # 8-byte Folded Reload
; SOFT-NEXT:    ld r28, -32(r1) # 8-byte Folded Reload
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    ld r27, -40(r1) # 8-byte Folded Reload
; SOFT-NEXT:    ld r26, -48(r1) # 8-byte Folded Reload
; SOFT-NEXT:    blr
;
; BE-LABEL: test_trunc64_vec4:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -176(r1)
; BE-NEXT:    std r0, 192(r1)
; BE-NEXT:    std r27, 112(r1) # 8-byte Folded Spill
; BE-NEXT:    std r28, 120(r1) # 8-byte Folded Spill
; BE-NEXT:    std r29, 128(r1) # 8-byte Folded Spill
; BE-NEXT:    std r30, 136(r1) # 8-byte Folded Spill
; BE-NEXT:    mr r30, r7
; BE-NEXT:    stfd f29, 152(r1) # 8-byte Folded Spill
; BE-NEXT:    fmr f29, f2
; BE-NEXT:    stfd f30, 160(r1) # 8-byte Folded Spill
; BE-NEXT:    fmr f30, f3
; BE-NEXT:    stfd f31, 168(r1) # 8-byte Folded Spill
; BE-NEXT:    fmr f31, f4
; BE-NEXT:    bl __truncdfhf2
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f29
; BE-NEXT:    mr r29, r3
; BE-NEXT:    bl __truncdfhf2
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f30
; BE-NEXT:    mr r28, r3
; BE-NEXT:    bl __truncdfhf2
; BE-NEXT:    nop
; BE-NEXT:    fmr f1, f31
; BE-NEXT:    mr r27, r3
; BE-NEXT:    bl __truncdfhf2
; BE-NEXT:    nop
; BE-NEXT:    sth r27, 4(r30)
; BE-NEXT:    sth r28, 2(r30)
; BE-NEXT:    sth r3, 6(r30)
; BE-NEXT:    sth r29, 0(r30)
; BE-NEXT:    lfd f31, 168(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f30, 160(r1) # 8-byte Folded Reload
; BE-NEXT:    lfd f29, 152(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r30, 136(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r29, 128(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r28, 120(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r27, 112(r1) # 8-byte Folded Reload
; BE-NEXT:    addi r1, r1, 176
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
  %v = fptrunc <4 x double> %a to <4 x half>
  store <4 x half> %v, ptr %p
  ret void
}
define float @test_sitofp_fadd_i32(i32 %a, ptr %b) nounwind {
; PPC32-LABEL: test_sitofp_fadd_i32:
; PPC32:       # %bb.0:
; PPC32-NEXT:    mflr r0
; PPC32-NEXT:    stwu r1, -32(r1)
; PPC32-NEXT:    stw r0, 36(r1)
; PPC32-NEXT:    lis r5, 17200
; PPC32-NEXT:    xoris r3, r3, 32768
; PPC32-NEXT:    stw r30, 16(r1) # 4-byte Folded Spill
; PPC32-NEXT:    lhz r30, 0(r4)
; PPC32-NEXT:    stw r5, 8(r1)
; PPC32-NEXT:    stw r3, 12(r1)
; PPC32-NEXT:    lis r3, .LCPI23_0@ha
; PPC32-NEXT:    lfd f0, 8(r1)
; PPC32-NEXT:    lfs f1, .LCPI23_0@l(r3)
; PPC32-NEXT:    stfd f31, 24(r1) # 8-byte Folded Spill
; PPC32-NEXT:    fsub f0, f0, f1
; PPC32-NEXT:    frsp f1, f0
; PPC32-NEXT:    bl __truncsfhf2
; PPC32-NEXT:    clrlwi r3, r3, 16
; PPC32-NEXT:    bl __extendhfsf2
; PPC32-NEXT:    mr r3, r30
; PPC32-NEXT:    fmr f31, f1
; PPC32-NEXT:    bl __extendhfsf2
; PPC32-NEXT:    fadds f1, f1, f31
; PPC32-NEXT:    bl __truncsfhf2
; PPC32-NEXT:    clrlwi r3, r3, 16
; PPC32-NEXT:    bl __extendhfsf2
; PPC32-NEXT:    lfd f31, 24(r1) # 8-byte Folded Reload
; PPC32-NEXT:    lwz r30, 16(r1) # 4-byte Folded Reload
; PPC32-NEXT:    lwz r0, 36(r1)
; PPC32-NEXT:    addi r1, r1, 32
; PPC32-NEXT:    mtlr r0
; PPC32-NEXT:    blr
;
; P8-LABEL: test_sitofp_fadd_i32:
; P8:       # %bb.0:
; P8-NEXT:    mflr r0
; P8-NEXT:    std r30, -24(r1) # 8-byte Folded Spill
; P8-NEXT:    stfd f31, -8(r1) # 8-byte Folded Spill
; P8-NEXT:    stdu r1, -64(r1)
; P8-NEXT:    mtfprwa f0, r3
; P8-NEXT:    std r0, 80(r1)
; P8-NEXT:    lhz r30, 0(r4)
; P8-NEXT:    xscvsxdsp f1, f0
; P8-NEXT:    bl __truncsfhf2
; P8-NEXT:    nop
; P8-NEXT:    clrldi r3, r3, 48
; P8-NEXT:    bl __extendhfsf2
; P8-NEXT:    nop
; P8-NEXT:    mr r3, r30
; P8-NEXT:    fmr f31, f1
; P8-NEXT:    bl __extendhfsf2
; P8-NEXT:    nop
; P8-NEXT:    xsaddsp f1, f1, f31
; P8-NEXT:    bl __truncsfhf2
; P8-NEXT:    nop
; P8-NEXT:    clrldi r3, r3, 48
; P8-NEXT:    bl __extendhfsf2
; P8-NEXT:    nop
; P8-NEXT:    addi r1, r1, 64
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    lfd f31, -8(r1) # 8-byte Folded Reload
; P8-NEXT:    ld r30, -24(r1) # 8-byte Folded Reload
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; P9-LABEL: test_sitofp_fadd_i32:
; P9:       # %bb.0:
; P9-NEXT:    mtfprwa f0, r3
; P9-NEXT:    lhz r4, 0(r4)
; P9-NEXT:    xscvsxdsp f0, f0
; P9-NEXT:    xscvdphp f0, f0
; P9-NEXT:    mffprwz r3, f0
; P9-NEXT:    mtfprwz f0, r4
; P9-NEXT:    clrlwi r3, r3, 16
; P9-NEXT:    xscvhpdp f0, f0
; P9-NEXT:    mtfprwz f1, r3
; P9-NEXT:    xscvhpdp f1, f1
; P9-NEXT:    xsaddsp f0, f0, f1
; P9-NEXT:    xscvdphp f0, f0
; P9-NEXT:    mffprwz r3, f0
; P9-NEXT:    clrlwi r3, r3, 16
; P9-NEXT:    mtfprwz f0, r3
; P9-NEXT:    xscvhpdp f1, f0
; P9-NEXT:    blr
;
; SOFT-LABEL: test_sitofp_fadd_i32:
; SOFT:       # %bb.0:
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    std r29, -24(r1) # 8-byte Folded Spill
; SOFT-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; SOFT-NEXT:    stdu r1, -64(r1)
; SOFT-NEXT:    extsw r3, r3
; SOFT-NEXT:    std r0, 80(r1)
; SOFT-NEXT:    mr r30, r4
; SOFT-NEXT:    bl __floatsisf
; SOFT-NEXT:    nop
; SOFT-NEXT:    clrldi r3, r3, 32
; SOFT-NEXT:    bl __truncsfhf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    mr r29, r3
; SOFT-NEXT:    lhz r3, 0(r30)
; SOFT-NEXT:    bl __extendhfsf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    mr r30, r3
; SOFT-NEXT:    clrldi r3, r29, 48
; SOFT-NEXT:    bl __extendhfsf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    mr r4, r3
; SOFT-NEXT:    mr r3, r30
; SOFT-NEXT:    bl __addsf3
; SOFT-NEXT:    nop
; SOFT-NEXT:    bl __truncsfhf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    clrldi r3, r3, 48
; SOFT-NEXT:    bl __extendhfsf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    addi r1, r1, 64
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; SOFT-NEXT:    ld r29, -24(r1) # 8-byte Folded Reload
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    blr
;
; BE-LABEL: test_sitofp_fadd_i32:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -144(r1)
; BE-NEXT:    std r0, 160(r1)
; BE-NEXT:    extsw r3, r3
; BE-NEXT:    std r30, 120(r1) # 8-byte Folded Spill
; BE-NEXT:    lhz r30, 0(r4)
; BE-NEXT:    std r3, 112(r1)
; BE-NEXT:    lfd f0, 112(r1)
; BE-NEXT:    fcfid f0, f0
; BE-NEXT:    stfd f31, 136(r1) # 8-byte Folded Spill
; BE-NEXT:    frsp f1, f0
; BE-NEXT:    bl __truncsfhf2
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    mr r3, r30
; BE-NEXT:    fmr f31, f1
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    fadds f1, f1, f31
; BE-NEXT:    bl __truncsfhf2
; BE-NEXT:    nop
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    lfd f31, 136(r1) # 8-byte Folded Reload
; BE-NEXT:    ld r30, 120(r1) # 8-byte Folded Reload
; BE-NEXT:    addi r1, r1, 144
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
  %tmp0 = load half, ptr %b
  %tmp1 = sitofp i32 %a to half
  %tmp2 = fadd half %tmp0, %tmp1
  %tmp3 = fpext half %tmp2 to float
  ret float %tmp3
}
define half @PR40273(half) nounwind {
; PPC32-LABEL: PR40273:
; PPC32:       # %bb.0:
; PPC32-NEXT:    mflr r0
; PPC32-NEXT:    stwu r1, -16(r1)
; PPC32-NEXT:    clrlwi r3, r3, 16
; PPC32-NEXT:    stw r0, 20(r1)
; PPC32-NEXT:    bl __extendhfsf2
; PPC32-NEXT:    lis r3, .LCPI24_0@ha
; PPC32-NEXT:    lfs f0, .LCPI24_0@l(r3)
; PPC32-NEXT:    li r3, 15360
; PPC32-NEXT:    fcmpu cr0, f1, f0
; PPC32-NEXT:    bne cr0, .LBB24_2
; PPC32-NEXT:  # %bb.1:
; PPC32-NEXT:    li r3, 0
; PPC32-NEXT:  .LBB24_2:
; PPC32-NEXT:    lwz r0, 20(r1)
; PPC32-NEXT:    addi r1, r1, 16
; PPC32-NEXT:    mtlr r0
; PPC32-NEXT:    blr
;
; P8-LABEL: PR40273:
; P8:       # %bb.0:
; P8-NEXT:    mflr r0
; P8-NEXT:    stdu r1, -32(r1)
; P8-NEXT:    clrldi r3, r3, 48
; P8-NEXT:    std r0, 48(r1)
; P8-NEXT:    bl __extendhfsf2
; P8-NEXT:    nop
; P8-NEXT:    xxlxor f0, f0, f0
; P8-NEXT:    li r3, 15360
; P8-NEXT:    fcmpu cr0, f1, f0
; P8-NEXT:    iseleq r3, 0, r3
; P8-NEXT:    addi r1, r1, 32
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; P9-LABEL: PR40273:
; P9:       # %bb.0:
; P9-NEXT:    clrlwi r3, r3, 16
; P9-NEXT:    xxlxor f1, f1, f1
; P9-NEXT:    mtfprwz f0, r3
; P9-NEXT:    li r3, 15360
; P9-NEXT:    xscvhpdp f0, f0
; P9-NEXT:    fcmpu cr0, f0, f1
; P9-NEXT:    iseleq r3, 0, r3
; P9-NEXT:    blr
;
; SOFT-LABEL: PR40273:
; SOFT:       # %bb.0:
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    stdu r1, -32(r1)
; SOFT-NEXT:    clrldi r3, r3, 48
; SOFT-NEXT:    std r0, 48(r1)
; SOFT-NEXT:    bl __extendhfsf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    li r4, 0
; SOFT-NEXT:    bl __nesf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    cmplwi r3, 0
; SOFT-NEXT:    li r3, 15360
; SOFT-NEXT:    iseleq r3, 0, r3
; SOFT-NEXT:    addi r1, r1, 32
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    blr
;
; BE-LABEL: PR40273:
; BE:       # %bb.0:
; BE-NEXT:    mflr r0
; BE-NEXT:    stdu r1, -112(r1)
; BE-NEXT:    clrldi r3, r3, 48
; BE-NEXT:    std r0, 128(r1)
; BE-NEXT:    bl __extendhfsf2
; BE-NEXT:    nop
; BE-NEXT:    addis r3, r2, .LCPI24_0@toc@ha
; BE-NEXT:    lfs f0, .LCPI24_0@toc@l(r3)
; BE-NEXT:    li r3, 15360
; BE-NEXT:    fcmpu cr0, f1, f0
; BE-NEXT:    bne cr0, .LBB24_2
; BE-NEXT:  # %bb.1:
; BE-NEXT:    li r3, 0
; BE-NEXT:  .LBB24_2:
; BE-NEXT:    addi r1, r1, 112
; BE-NEXT:    ld r0, 16(r1)
; BE-NEXT:    mtlr r0
; BE-NEXT:    blr
  %2 = fcmp une half %0, 0xH0000
  %3 = uitofp i1 %2 to half
  ret half %3
}

; Trivial operations shouldn't need a libcall

define half @fabs(half %x) nounwind {
; PPC32-LABEL: fabs:
; PPC32:       # %bb.0:
; PPC32-NEXT:    clrlwi r3, r3, 17
; PPC32-NEXT:    blr
;
; CHECK-LABEL: fabs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    clrldi r3, r3, 49
; CHECK-NEXT:    blr
;
; SOFT-LABEL: fabs:
; SOFT:       # %bb.0:
; SOFT-NEXT:    clrldi r3, r3, 49
; SOFT-NEXT:    blr
;
; BE-LABEL: fabs:
; BE:       # %bb.0:
; BE-NEXT:    clrldi r3, r3, 49
; BE-NEXT:    blr
  %a = call half @llvm.fabs.f16(half %x)
  ret half %a
}

define half @fcopysign(half %x, half %y) nounwind {
; PPC32-LABEL: fcopysign:
; PPC32:       # %bb.0:
; PPC32-NEXT:    rlwimi r3, r4, 0, 0, 16
; PPC32-NEXT:    blr
;
; CHECK-LABEL: fcopysign:
; CHECK:       # %bb.0:
; CHECK-NEXT:    rotldi r4, r4, 49
; CHECK-NEXT:    clrldi r3, r3, 49
; CHECK-NEXT:    rldimi r3, r4, 15, 32
; CHECK-NEXT:    blr
;
; SOFT-LABEL: fcopysign:
; SOFT:       # %bb.0:
; SOFT-NEXT:    rotldi r4, r4, 49
; SOFT-NEXT:    clrldi r3, r3, 49
; SOFT-NEXT:    rldimi r3, r4, 15, 32
; SOFT-NEXT:    blr
;
; BE-LABEL: fcopysign:
; BE:       # %bb.0:
; BE-NEXT:    rotldi r4, r4, 49
; BE-NEXT:    clrldi r3, r3, 49
; BE-NEXT:    rldimi r3, r4, 15, 32
; BE-NEXT:    blr
  %a = call half @llvm.copysign.f16(half %x, half %y)
  ret half %a
}
