/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QTableView>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/OligomerCollection.hpp>


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes


namespace MsXpS
{
namespace MassXpert
{


class MassSearchDlg;

class MassSearchOligomerTableView : public QTableView
{
  Q_OBJECT

  public:
  MassSearchOligomerTableView(QWidget *parent = 0);
  ~MassSearchOligomerTableView();

  void setOligomerCollection(libXpertMassCore::OligomerCollection *);
  const libXpertMassCore::OligomerCollection *oligomerList();

  void setParentDlg(MassSearchDlg *);
  MassSearchDlg *parentDlg();

  int selectedOligomers(libXpertMassCore::OligomerCollection *,
                        std::size_t index = 0) const;
  QString *describeSelectedOligomersAsPlainText(
    QString                       = "$",
    bool                          = false,
    bool                          = false,
    libXpertMassCore::Enums::MassType = libXpertMassCore::Enums::MassType::MONO) const;

  void mousePressEvent(QMouseEvent *);
  void mouseMoveEvent(QMouseEvent *);

  public slots:
  void itemActivated(const QModelIndex &);
  void copyMono();
  void copyAvg();

  protected:
  MassSearchDlg *mp_parentDlg;

  libXpertMassCore::OligomerCollection *mp_oligomers;

  // For drag operations.
  QPoint m_dragStartPos;

  // We do not want to hide the parent class function here.
  using QAbstractItemView::startDrag;
  void startDrag();

  ///////// Contextual menu for copying to clipboard of mono/avg
  ///////// masses.
  QMenu *contextMenu;
  QAction *copyMonoAct;
  QAction *copyAvgAct;
  /////////


  void currentChanged(const QModelIndex &, const QModelIndex &);
  void copyMassList(libXpertMassCore::Enums::MassType mass_type);
};


} // namespace MassXpert
} // namespace MsXpS
