'use strict';
require('../../../common');
const assert = require('node:assert');
const Module = require('node:module');
Error.stackTraceLimit = 5;

assert.deepStrictEqual(Module.getSourceMapsSupport(), {
  __proto__: null,
  enabled: false,
  nodeModules: false,
  generatedCode: false,
});
Module.setSourceMapsSupport(true, {
  nodeModules: true,
});
assert.deepStrictEqual(Module.getSourceMapsSupport(), {
  __proto__: null,
  enabled: true,
  nodeModules: true,
  generatedCode: false,
});
assert.strictEqual(process.sourceMapsEnabled, true);

try {
  require('../node_modules/error-stack/enclosing-call-site-min.js').simpleErrorStack();
} catch (e) {
  console.log(e);
}

delete require.cache[require
  .resolve('../node_modules/error-stack/enclosing-call-site-min.js')];

Module.setSourceMapsSupport(true, {
  nodeModules: false,
});
assert.deepStrictEqual(Module.getSourceMapsSupport(), {
  __proto__: null,
  enabled: true,
  nodeModules: false,
  generatedCode: false,
});
assert.strictEqual(process.sourceMapsEnabled, true);

try {
  require('../node_modules/error-stack/enclosing-call-site-min.js').simpleErrorStack();
} catch (e) {
  console.log(e);
}
