# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.devtestlabs import DevTestLabsClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDevTestLabsVirtualMachinesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DevTestLabsClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list(self, resource_group):
        response = self.client.virtual_machines.list(
            resource_group_name=resource_group.name,
            lab_name="str",
            api_version="2018-09-15",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.virtual_machines.get(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            api_version="2018-09-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_or_update(self, resource_group):
        response = self.client.virtual_machines.begin_create_or_update(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            lab_virtual_machine={
                "allowClaim": False,
                "applicableSchedule": {
                    "id": "str",
                    "labVmsShutdown": {
                        "createdDate": "2020-02-20 00:00:00",
                        "dailyRecurrence": {"time": "str"},
                        "hourlyRecurrence": {"minute": 0},
                        "id": "str",
                        "location": "str",
                        "name": "str",
                        "notificationSettings": {
                            "emailRecipient": "str",
                            "notificationLocale": "str",
                            "status": "str",
                            "timeInMinutes": 0,
                            "webhookUrl": "str",
                        },
                        "provisioningState": "str",
                        "status": "str",
                        "tags": {"str": "str"},
                        "targetResourceId": "str",
                        "taskType": "str",
                        "timeZoneId": "str",
                        "type": "str",
                        "uniqueIdentifier": "str",
                        "weeklyRecurrence": {"time": "str", "weekdays": ["str"]},
                    },
                    "labVmsStartup": {
                        "createdDate": "2020-02-20 00:00:00",
                        "dailyRecurrence": {"time": "str"},
                        "hourlyRecurrence": {"minute": 0},
                        "id": "str",
                        "location": "str",
                        "name": "str",
                        "notificationSettings": {
                            "emailRecipient": "str",
                            "notificationLocale": "str",
                            "status": "str",
                            "timeInMinutes": 0,
                            "webhookUrl": "str",
                        },
                        "provisioningState": "str",
                        "status": "str",
                        "tags": {"str": "str"},
                        "targetResourceId": "str",
                        "taskType": "str",
                        "timeZoneId": "str",
                        "type": "str",
                        "uniqueIdentifier": "str",
                        "weeklyRecurrence": {"time": "str", "weekdays": ["str"]},
                    },
                    "location": "str",
                    "name": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                },
                "artifactDeploymentStatus": {"artifactsApplied": 0, "deploymentStatus": "str", "totalArtifacts": 0},
                "artifacts": [
                    {
                        "artifactId": "str",
                        "artifactTitle": "str",
                        "deploymentStatusMessage": "str",
                        "installTime": "2020-02-20 00:00:00",
                        "parameters": [{"name": "str", "value": "str"}],
                        "status": "str",
                        "vmExtensionStatusMessage": "str",
                    }
                ],
                "computeId": "str",
                "computeVm": {
                    "dataDiskIds": ["str"],
                    "dataDisks": [{"diskSizeGiB": 0, "diskUri": "str", "managedDiskId": "str", "name": "str"}],
                    "networkInterfaceId": "str",
                    "osDiskId": "str",
                    "osType": "str",
                    "statuses": [{"code": "str", "displayStatus": "str", "message": "str"}],
                    "vmSize": "str",
                },
                "createdByUser": "str",
                "createdByUserId": "str",
                "createdDate": "2020-02-20 00:00:00",
                "customImageId": "str",
                "dataDiskParameters": [
                    {
                        "attachNewDataDiskOptions": {"diskName": "str", "diskSizeGiB": 0, "diskType": "str"},
                        "existingLabDiskId": "str",
                        "hostCaching": "str",
                    }
                ],
                "disallowPublicIpAddress": False,
                "environmentId": "str",
                "expirationDate": "2020-02-20 00:00:00",
                "fqdn": "str",
                "galleryImageReference": {
                    "offer": "str",
                    "osType": "str",
                    "publisher": "str",
                    "sku": "str",
                    "version": "str",
                },
                "id": "str",
                "isAuthenticationWithSshKey": bool,
                "labSubnetName": "str",
                "labVirtualNetworkId": "str",
                "lastKnownPowerState": "str",
                "location": "str",
                "name": "str",
                "networkInterface": {
                    "dnsName": "str",
                    "privateIpAddress": "str",
                    "publicIpAddress": "str",
                    "publicIpAddressId": "str",
                    "rdpAuthority": "str",
                    "sharedPublicIpAddressConfiguration": {
                        "inboundNatRules": [{"backendPort": 0, "frontendPort": 0, "transportProtocol": "str"}]
                    },
                    "sshAuthority": "str",
                    "subnetId": "str",
                    "virtualNetworkId": "str",
                },
                "notes": "str",
                "osType": "str",
                "ownerObjectId": "dynamicValue",
                "ownerUserPrincipalName": "str",
                "password": "str",
                "planId": "str",
                "provisioningState": "str",
                "scheduleParameters": [
                    {
                        "dailyRecurrence": {"time": "str"},
                        "hourlyRecurrence": {"minute": 0},
                        "location": "str",
                        "name": "str",
                        "notificationSettings": {
                            "emailRecipient": "str",
                            "notificationLocale": "str",
                            "status": "str",
                            "timeInMinutes": 0,
                            "webhookUrl": "str",
                        },
                        "status": "str",
                        "tags": {"str": "str"},
                        "targetResourceId": "str",
                        "taskType": "str",
                        "timeZoneId": "str",
                        "weeklyRecurrence": {"time": "str", "weekdays": ["str"]},
                    }
                ],
                "size": "str",
                "sshKey": "str",
                "storageType": "labStorageType",
                "tags": {"str": "str"},
                "type": "str",
                "uniqueIdentifier": "str",
                "userName": "str",
                "virtualMachineCreationSource": "str",
            },
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete(self, resource_group):
        response = self.client.virtual_machines.begin_delete(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update(self, resource_group):
        response = self.client.virtual_machines.update(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            api_version="2018-09-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_add_data_disk(self, resource_group):
        response = self.client.virtual_machines.begin_add_data_disk(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            data_disk_properties={
                "attachNewDataDiskOptions": {"diskName": "str", "diskSizeGiB": 0, "diskType": "str"},
                "existingLabDiskId": "str",
                "hostCaching": "str",
            },
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_apply_artifacts(self, resource_group):
        response = self.client.virtual_machines.begin_apply_artifacts(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_claim(self, resource_group):
        response = self.client.virtual_machines.begin_claim(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_detach_data_disk(self, resource_group):
        response = self.client.virtual_machines.begin_detach_data_disk(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_rdp_file_contents(self, resource_group):
        response = self.client.virtual_machines.get_rdp_file_contents(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            api_version="2018-09-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_applicable_schedules(self, resource_group):
        response = self.client.virtual_machines.list_applicable_schedules(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            api_version="2018-09-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_redeploy(self, resource_group):
        response = self.client.virtual_machines.begin_redeploy(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_resize(self, resource_group):
        response = self.client.virtual_machines.begin_resize(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_restart(self, resource_group):
        response = self.client.virtual_machines.begin_restart(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_start(self, resource_group):
        response = self.client.virtual_machines.begin_start(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_stop(self, resource_group):
        response = self.client.virtual_machines.begin_stop(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_transfer_disks(self, resource_group):
        response = self.client.virtual_machines.begin_transfer_disks(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_un_claim(self, resource_group):
        response = self.client.virtual_machines.begin_un_claim(
            resource_group_name=resource_group.name,
            lab_name="str",
            name="str",
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
