# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.astro.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.astro.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.astro.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.astro.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class LiftrBaseDataOrganizationProperties(_serialization.Model):
    """Properties specific to Data Organization resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar marketplace: Marketplace details of the resource. Required.
    :vartype marketplace: ~azure.mgmt.astro.models.LiftrBaseMarketplaceDetails
    :ivar user: Details of the user. Required.
    :vartype user: ~azure.mgmt.astro.models.LiftrBaseUserDetails
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.astro.models.ResourceProvisioningState
    :ivar partner_organization_properties: Organization properties.
    :vartype partner_organization_properties:
     ~azure.mgmt.astro.models.LiftrBaseDataPartnerOrganizationProperties
    """

    _validation = {
        "marketplace": {"required": True},
        "user": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "marketplace": {"key": "marketplace", "type": "LiftrBaseMarketplaceDetails"},
        "user": {"key": "user", "type": "LiftrBaseUserDetails"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "partner_organization_properties": {
            "key": "partnerOrganizationProperties",
            "type": "LiftrBaseDataPartnerOrganizationProperties",
        },
    }

    def __init__(
        self,
        *,
        marketplace: "_models.LiftrBaseMarketplaceDetails",
        user: "_models.LiftrBaseUserDetails",
        partner_organization_properties: Optional["_models.LiftrBaseDataPartnerOrganizationProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword marketplace: Marketplace details of the resource. Required.
        :paramtype marketplace: ~azure.mgmt.astro.models.LiftrBaseMarketplaceDetails
        :keyword user: Details of the user. Required.
        :paramtype user: ~azure.mgmt.astro.models.LiftrBaseUserDetails
        :keyword partner_organization_properties: Organization properties.
        :paramtype partner_organization_properties:
         ~azure.mgmt.astro.models.LiftrBaseDataPartnerOrganizationProperties
        """
        super().__init__(**kwargs)
        self.marketplace = marketplace
        self.user = user
        self.provisioning_state = None
        self.partner_organization_properties = partner_organization_properties


class LiftrBaseDataPartnerOrganizationProperties(_serialization.Model):
    """Properties specific to Partner's organization.

    All required parameters must be populated in order to send to Azure.

    :ivar organization_id: Organization Id in partner's system.
    :vartype organization_id: str
    :ivar workspace_id: Workspace Id in partner's system.
    :vartype workspace_id: str
    :ivar organization_name: Organization name in partner's system. Required.
    :vartype organization_name: str
    :ivar workspace_name: Workspace name in partner's system.
    :vartype workspace_name: str
    :ivar single_sign_on_properties: Single Sign On properties for the organization.
    :vartype single_sign_on_properties: ~azure.mgmt.astro.models.LiftrBaseSingleSignOnProperties
    """

    _validation = {
        "organization_name": {
            "required": True,
            "max_length": 50,
            "min_length": 1,
            "pattern": r"^[a-zA-Z0-9][a-zA-Z0-9_\-.: ]*$",
        },
        "workspace_name": {"max_length": 50, "min_length": 1, "pattern": r"^[a-zA-Z0-9][a-zA-Z0-9_\-.: ]*$"},
    }

    _attribute_map = {
        "organization_id": {"key": "organizationId", "type": "str"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "organization_name": {"key": "organizationName", "type": "str"},
        "workspace_name": {"key": "workspaceName", "type": "str"},
        "single_sign_on_properties": {"key": "singleSignOnProperties", "type": "LiftrBaseSingleSignOnProperties"},
    }

    def __init__(
        self,
        *,
        organization_name: str,
        organization_id: Optional[str] = None,
        workspace_id: Optional[str] = None,
        workspace_name: Optional[str] = None,
        single_sign_on_properties: Optional["_models.LiftrBaseSingleSignOnProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword organization_id: Organization Id in partner's system.
        :paramtype organization_id: str
        :keyword workspace_id: Workspace Id in partner's system.
        :paramtype workspace_id: str
        :keyword organization_name: Organization name in partner's system. Required.
        :paramtype organization_name: str
        :keyword workspace_name: Workspace name in partner's system.
        :paramtype workspace_name: str
        :keyword single_sign_on_properties: Single Sign On properties for the organization.
        :paramtype single_sign_on_properties: ~azure.mgmt.astro.models.LiftrBaseSingleSignOnProperties
        """
        super().__init__(**kwargs)
        self.organization_id = organization_id
        self.workspace_id = workspace_id
        self.organization_name = organization_name
        self.workspace_name = workspace_name
        self.single_sign_on_properties = single_sign_on_properties


class LiftrBaseDataPartnerOrganizationPropertiesUpdate(_serialization.Model):
    """Properties specific to Partner's organization.

    :ivar organization_id: Organization Id in partner's system.
    :vartype organization_id: str
    :ivar workspace_id: Workspace Id in partner's system.
    :vartype workspace_id: str
    :ivar organization_name: Organization name in partner's system.
    :vartype organization_name: str
    :ivar workspace_name: Workspace name in partner's system.
    :vartype workspace_name: str
    :ivar single_sign_on_properties: Single Sign On properties for the organization.
    :vartype single_sign_on_properties: ~azure.mgmt.astro.models.LiftrBaseSingleSignOnProperties
    """

    _validation = {
        "organization_name": {"max_length": 50, "min_length": 1, "pattern": r"^[a-zA-Z0-9][a-zA-Z0-9_\-.: ]*$"},
        "workspace_name": {"max_length": 50, "min_length": 1, "pattern": r"^[a-zA-Z0-9][a-zA-Z0-9_\-.: ]*$"},
    }

    _attribute_map = {
        "organization_id": {"key": "organizationId", "type": "str"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "organization_name": {"key": "organizationName", "type": "str"},
        "workspace_name": {"key": "workspaceName", "type": "str"},
        "single_sign_on_properties": {"key": "singleSignOnProperties", "type": "LiftrBaseSingleSignOnProperties"},
    }

    def __init__(
        self,
        *,
        organization_id: Optional[str] = None,
        workspace_id: Optional[str] = None,
        organization_name: Optional[str] = None,
        workspace_name: Optional[str] = None,
        single_sign_on_properties: Optional["_models.LiftrBaseSingleSignOnProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword organization_id: Organization Id in partner's system.
        :paramtype organization_id: str
        :keyword workspace_id: Workspace Id in partner's system.
        :paramtype workspace_id: str
        :keyword organization_name: Organization name in partner's system.
        :paramtype organization_name: str
        :keyword workspace_name: Workspace name in partner's system.
        :paramtype workspace_name: str
        :keyword single_sign_on_properties: Single Sign On properties for the organization.
        :paramtype single_sign_on_properties: ~azure.mgmt.astro.models.LiftrBaseSingleSignOnProperties
        """
        super().__init__(**kwargs)
        self.organization_id = organization_id
        self.workspace_id = workspace_id
        self.organization_name = organization_name
        self.workspace_name = workspace_name
        self.single_sign_on_properties = single_sign_on_properties


class LiftrBaseMarketplaceDetails(_serialization.Model):
    """Marketplace details for an organization.

    All required parameters must be populated in order to send to Azure.

    :ivar subscription_id: Azure subscription id for the the marketplace offer is purchased from.
     Required.
    :vartype subscription_id: str
    :ivar subscription_status: Marketplace subscription status. Known values are:
     "PendingFulfillmentStart", "Subscribed", "Suspended", and "Unsubscribed".
    :vartype subscription_status: str or ~azure.mgmt.astro.models.MarketplaceSubscriptionStatus
    :ivar offer_details: Offer details for the marketplace that is selected by the user. Required.
    :vartype offer_details: ~azure.mgmt.astro.models.LiftrBaseOfferDetails
    """

    _validation = {
        "subscription_id": {"required": True},
        "offer_details": {"required": True},
    }

    _attribute_map = {
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "subscription_status": {"key": "subscriptionStatus", "type": "str"},
        "offer_details": {"key": "offerDetails", "type": "LiftrBaseOfferDetails"},
    }

    def __init__(
        self,
        *,
        subscription_id: str,
        offer_details: "_models.LiftrBaseOfferDetails",
        subscription_status: Optional[Union[str, "_models.MarketplaceSubscriptionStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword subscription_id: Azure subscription id for the the marketplace offer is purchased
         from. Required.
        :paramtype subscription_id: str
        :keyword subscription_status: Marketplace subscription status. Known values are:
         "PendingFulfillmentStart", "Subscribed", "Suspended", and "Unsubscribed".
        :paramtype subscription_status: str or ~azure.mgmt.astro.models.MarketplaceSubscriptionStatus
        :keyword offer_details: Offer details for the marketplace that is selected by the user.
         Required.
        :paramtype offer_details: ~azure.mgmt.astro.models.LiftrBaseOfferDetails
        """
        super().__init__(**kwargs)
        self.subscription_id = subscription_id
        self.subscription_status = subscription_status
        self.offer_details = offer_details


class LiftrBaseOfferDetails(_serialization.Model):
    """Offer details for the marketplace that is selected by the user.

    All required parameters must be populated in order to send to Azure.

    :ivar publisher_id: Publisher Id for the marketplace offer. Required.
    :vartype publisher_id: str
    :ivar offer_id: Offer Id for the marketplace offer. Required.
    :vartype offer_id: str
    :ivar plan_id: Plan Id for the marketplace offer. Required.
    :vartype plan_id: str
    :ivar plan_name: Plan Name for the marketplace offer.
    :vartype plan_name: str
    :ivar term_unit: Plan Display Name for the marketplace offer.
    :vartype term_unit: str
    :ivar term_id: Plan Display Name for the marketplace offer.
    :vartype term_id: str
    """

    _validation = {
        "publisher_id": {"required": True},
        "offer_id": {"required": True},
        "plan_id": {"required": True},
    }

    _attribute_map = {
        "publisher_id": {"key": "publisherId", "type": "str"},
        "offer_id": {"key": "offerId", "type": "str"},
        "plan_id": {"key": "planId", "type": "str"},
        "plan_name": {"key": "planName", "type": "str"},
        "term_unit": {"key": "termUnit", "type": "str"},
        "term_id": {"key": "termId", "type": "str"},
    }

    def __init__(
        self,
        *,
        publisher_id: str,
        offer_id: str,
        plan_id: str,
        plan_name: Optional[str] = None,
        term_unit: Optional[str] = None,
        term_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher_id: Publisher Id for the marketplace offer. Required.
        :paramtype publisher_id: str
        :keyword offer_id: Offer Id for the marketplace offer. Required.
        :paramtype offer_id: str
        :keyword plan_id: Plan Id for the marketplace offer. Required.
        :paramtype plan_id: str
        :keyword plan_name: Plan Name for the marketplace offer.
        :paramtype plan_name: str
        :keyword term_unit: Plan Display Name for the marketplace offer.
        :paramtype term_unit: str
        :keyword term_id: Plan Display Name for the marketplace offer.
        :paramtype term_id: str
        """
        super().__init__(**kwargs)
        self.publisher_id = publisher_id
        self.offer_id = offer_id
        self.plan_id = plan_id
        self.plan_name = plan_name
        self.term_unit = term_unit
        self.term_id = term_id


class LiftrBaseSingleSignOnProperties(_serialization.Model):
    """Properties specific to Single Sign On Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar single_sign_on_state: State of the Single Sign On for the organization. Known values are:
     "Initial", "Enable", and "Disable".
    :vartype single_sign_on_state: str or ~azure.mgmt.astro.models.SingleSignOnStates
    :ivar enterprise_app_id: AAD enterprise application Id used to setup SSO.
    :vartype enterprise_app_id: str
    :ivar single_sign_on_url: URL for SSO to be used by the partner to redirect the user to their
     system.
    :vartype single_sign_on_url: str
    :ivar aad_domains: List of AAD domains fetched from Microsoft Graph for user.
    :vartype aad_domains: list[str]
    :ivar provisioning_state: Provisioning State of the resource. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.astro.models.ResourceProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "single_sign_on_state": {"key": "singleSignOnState", "type": "str"},
        "enterprise_app_id": {"key": "enterpriseAppId", "type": "str"},
        "single_sign_on_url": {"key": "singleSignOnUrl", "type": "str"},
        "aad_domains": {"key": "aadDomains", "type": "[str]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        single_sign_on_state: Optional[Union[str, "_models.SingleSignOnStates"]] = None,
        enterprise_app_id: Optional[str] = None,
        single_sign_on_url: Optional[str] = None,
        aad_domains: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword single_sign_on_state: State of the Single Sign On for the organization. Known values
         are: "Initial", "Enable", and "Disable".
        :paramtype single_sign_on_state: str or ~azure.mgmt.astro.models.SingleSignOnStates
        :keyword enterprise_app_id: AAD enterprise application Id used to setup SSO.
        :paramtype enterprise_app_id: str
        :keyword single_sign_on_url: URL for SSO to be used by the partner to redirect the user to
         their system.
        :paramtype single_sign_on_url: str
        :keyword aad_domains: List of AAD domains fetched from Microsoft Graph for user.
        :paramtype aad_domains: list[str]
        """
        super().__init__(**kwargs)
        self.single_sign_on_state = single_sign_on_state
        self.enterprise_app_id = enterprise_app_id
        self.single_sign_on_url = single_sign_on_url
        self.aad_domains = aad_domains
        self.provisioning_state = None


class LiftrBaseUserDetails(_serialization.Model):
    """User details for an organization.

    All required parameters must be populated in order to send to Azure.

    :ivar first_name: First name of the user. Required.
    :vartype first_name: str
    :ivar last_name: Last name of the user. Required.
    :vartype last_name: str
    :ivar email_address: Email address of the user. Required.
    :vartype email_address: str
    :ivar upn: User's principal name.
    :vartype upn: str
    :ivar phone_number: User's phone number.
    :vartype phone_number: str
    """

    _validation = {
        "first_name": {"required": True},
        "last_name": {"required": True},
        "email_address": {"required": True, "pattern": r"^[A-Za-z0-9._%+-]+@(?:[A-Za-z0-9-]+\.)+[A-Za-z]{2,}$"},
    }

    _attribute_map = {
        "first_name": {"key": "firstName", "type": "str"},
        "last_name": {"key": "lastName", "type": "str"},
        "email_address": {"key": "emailAddress", "type": "str"},
        "upn": {"key": "upn", "type": "str"},
        "phone_number": {"key": "phoneNumber", "type": "str"},
    }

    def __init__(
        self,
        *,
        first_name: str,
        last_name: str,
        email_address: str,
        upn: Optional[str] = None,
        phone_number: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword first_name: First name of the user. Required.
        :paramtype first_name: str
        :keyword last_name: Last name of the user. Required.
        :paramtype last_name: str
        :keyword email_address: Email address of the user. Required.
        :paramtype email_address: str
        :keyword upn: User's principal name.
        :paramtype upn: str
        :keyword phone_number: User's phone number.
        :paramtype phone_number: str
        """
        super().__init__(**kwargs)
        self.first_name = first_name
        self.last_name = last_name
        self.email_address = email_address
        self.upn = upn
        self.phone_number = phone_number


class LiftrBaseUserDetailsUpdate(_serialization.Model):
    """User details for an organization.

    :ivar first_name: First name of the user.
    :vartype first_name: str
    :ivar last_name: Last name of the user.
    :vartype last_name: str
    :ivar email_address: Email address of the user.
    :vartype email_address: str
    :ivar upn: User's principal name.
    :vartype upn: str
    :ivar phone_number: User's phone number.
    :vartype phone_number: str
    """

    _validation = {
        "email_address": {"pattern": r"^[A-Za-z0-9._%+-]+@(?:[A-Za-z0-9-]+\.)+[A-Za-z]{2,}$"},
    }

    _attribute_map = {
        "first_name": {"key": "firstName", "type": "str"},
        "last_name": {"key": "lastName", "type": "str"},
        "email_address": {"key": "emailAddress", "type": "str"},
        "upn": {"key": "upn", "type": "str"},
        "phone_number": {"key": "phoneNumber", "type": "str"},
    }

    def __init__(
        self,
        *,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        email_address: Optional[str] = None,
        upn: Optional[str] = None,
        phone_number: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword first_name: First name of the user.
        :paramtype first_name: str
        :keyword last_name: Last name of the user.
        :paramtype last_name: str
        :keyword email_address: Email address of the user.
        :paramtype email_address: str
        :keyword upn: User's principal name.
        :paramtype upn: str
        :keyword phone_number: User's phone number.
        :paramtype phone_number: str
        """
        super().__init__(**kwargs)
        self.first_name = first_name
        self.last_name = last_name
        self.email_address = email_address
        self.upn = upn
        self.phone_number = phone_number


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned, UserAssigned".
    :vartype type: str or ~azure.mgmt.astro.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.astro.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned, UserAssigned".
        :paramtype type: str or ~azure.mgmt.astro.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str, ~azure.mgmt.astro.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.astro.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.astro.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.astro.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.astro.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.astro.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.astro.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.astro.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class OrganizationResource(TrackedResource):
    """Organization Resource by Astronomer.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.astro.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.astro.models.LiftrBaseDataOrganizationProperties
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.astro.models.ManagedServiceIdentity
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "LiftrBaseDataOrganizationProperties"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.LiftrBaseDataOrganizationProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.astro.models.LiftrBaseDataOrganizationProperties
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity: ~azure.mgmt.astro.models.ManagedServiceIdentity
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties
        self.identity = identity


class OrganizationResourceListResult(_serialization.Model):
    """The response of a OrganizationResource list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The OrganizationResource items on this page. Required.
    :vartype value: list[~azure.mgmt.astro.models.OrganizationResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OrganizationResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.OrganizationResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The OrganizationResource items on this page. Required.
        :paramtype value: list[~azure.mgmt.astro.models.OrganizationResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OrganizationResourceUpdate(_serialization.Model):
    """The type used for update operations of the OrganizationResource.

    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.astro.models.ManagedServiceIdentity
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The updatable properties of the OrganizationResource.
    :vartype properties: ~azure.mgmt.astro.models.OrganizationResourceUpdateProperties
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "OrganizationResourceUpdateProperties"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.OrganizationResourceUpdateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity: ~azure.mgmt.astro.models.ManagedServiceIdentity
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The updatable properties of the OrganizationResource.
        :paramtype properties: ~azure.mgmt.astro.models.OrganizationResourceUpdateProperties
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.tags = tags
        self.properties = properties


class OrganizationResourceUpdateProperties(_serialization.Model):
    """The updatable properties of the OrganizationResource.

    :ivar user: Details of the user.
    :vartype user: ~azure.mgmt.astro.models.LiftrBaseUserDetailsUpdate
    :ivar partner_organization_properties: Organization properties.
    :vartype partner_organization_properties:
     ~azure.mgmt.astro.models.LiftrBaseDataPartnerOrganizationPropertiesUpdate
    """

    _attribute_map = {
        "user": {"key": "user", "type": "LiftrBaseUserDetailsUpdate"},
        "partner_organization_properties": {
            "key": "partnerOrganizationProperties",
            "type": "LiftrBaseDataPartnerOrganizationPropertiesUpdate",
        },
    }

    def __init__(
        self,
        *,
        user: Optional["_models.LiftrBaseUserDetailsUpdate"] = None,
        partner_organization_properties: Optional["_models.LiftrBaseDataPartnerOrganizationPropertiesUpdate"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user: Details of the user.
        :paramtype user: ~azure.mgmt.astro.models.LiftrBaseUserDetailsUpdate
        :keyword partner_organization_properties: Organization properties.
        :paramtype partner_organization_properties:
         ~azure.mgmt.astro.models.LiftrBaseDataPartnerOrganizationPropertiesUpdate
        """
        super().__init__(**kwargs)
        self.user = user
        self.partner_organization_properties = partner_organization_properties


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.astro.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.astro.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.astro.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.astro.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
