# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.networkcloud import NetworkCloudMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkCloudMgmtKubernetesClustersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkCloudMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_kubernetes_clusters_list_by_subscription(self, resource_group):
        response = self.client.kubernetes_clusters.list_by_subscription(
            api_version="2025-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_kubernetes_clusters_list_by_resource_group(self, resource_group):
        response = self.client.kubernetes_clusters.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_kubernetes_clusters_get(self, resource_group):
        response = self.client.kubernetes_clusters.get(
            resource_group_name=resource_group.name,
            kubernetes_cluster_name="str",
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_kubernetes_clusters_begin_create_or_update(self, resource_group):
        response = self.client.kubernetes_clusters.begin_create_or_update(
            resource_group_name=resource_group.name,
            kubernetes_cluster_name="str",
            kubernetes_cluster_parameters={
                "controlPlaneNodeConfiguration": {
                    "count": 0,
                    "vmSkuName": "str",
                    "administratorConfiguration": {"adminUsername": "str", "sshPublicKeys": [{"keyData": "str"}]},
                    "availabilityZones": ["str"],
                },
                "extendedLocation": {"name": "str", "type": "str"},
                "initialAgentPoolConfigurations": [
                    {
                        "count": 0,
                        "mode": "str",
                        "name": "str",
                        "vmSkuName": "str",
                        "administratorConfiguration": {"adminUsername": "str", "sshPublicKeys": [{"keyData": "str"}]},
                        "agentOptions": {"hugepagesCount": 0, "hugepagesSize": "2M"},
                        "attachedNetworkConfiguration": {
                            "l2Networks": [{"networkId": "str", "pluginType": "str"}],
                            "l3Networks": [{"networkId": "str", "ipamEnabled": "False", "pluginType": "str"}],
                            "trunkedNetworks": [{"networkId": "str", "pluginType": "str"}],
                        },
                        "availabilityZones": ["str"],
                        "labels": [{"key": "str", "value": "str"}],
                        "taints": [{"key": "str", "value": "str"}],
                        "upgradeSettings": {"drainTimeout": 0, "maxSurge": "str", "maxUnavailable": "str"},
                    }
                ],
                "kubernetesVersion": "str",
                "location": "str",
                "networkConfiguration": {
                    "cloudServicesNetworkId": "str",
                    "cniNetworkId": "str",
                    "attachedNetworkConfiguration": {
                        "l2Networks": [{"networkId": "str", "pluginType": "str"}],
                        "l3Networks": [{"networkId": "str", "ipamEnabled": "False", "pluginType": "str"}],
                        "trunkedNetworks": [{"networkId": "str", "pluginType": "str"}],
                    },
                    "bgpServiceLoadBalancerConfiguration": {
                        "bgpAdvertisements": [
                            {
                                "ipAddressPools": ["str"],
                                "advertiseToFabric": "True",
                                "communities": ["str"],
                                "peers": ["str"],
                            }
                        ],
                        "bgpPeers": [
                            {
                                "name": "str",
                                "peerAddress": "str",
                                "peerAsn": 0,
                                "bfdEnabled": "str",
                                "bgpMultiHop": "False",
                                "holdTime": "str",
                                "keepAliveTime": "str",
                                "myAsn": 0,
                                "password": "str",
                                "peerPort": 179,
                            }
                        ],
                        "fabricPeeringEnabled": "True",
                        "ipAddressPools": [
                            {"addresses": ["str"], "name": "str", "autoAssign": "str", "onlyUseHostIps": "str"}
                        ],
                    },
                    "dnsServiceIp": "str",
                    "l2ServiceLoadBalancerConfiguration": {
                        "ipAddressPools": [
                            {"addresses": ["str"], "name": "str", "autoAssign": "str", "onlyUseHostIps": "str"}
                        ]
                    },
                    "podCidrs": ["str"],
                    "serviceCidrs": ["str"],
                },
                "aadConfiguration": {"adminGroupObjectIds": ["str"]},
                "administratorConfiguration": {"adminUsername": "str", "sshPublicKeys": [{"keyData": "str"}]},
                "attachedNetworkIds": ["str"],
                "availableUpgrades": [{"availabilityLifecycle": "str", "version": "str"}],
                "clusterId": "str",
                "connectedClusterId": "str",
                "controlPlaneKubernetesVersion": "str",
                "detailedStatus": "str",
                "detailedStatusMessage": "str",
                "etag": "str",
                "featureStatuses": [
                    {"detailedStatus": "str", "detailedStatusMessage": "str", "name": "str", "version": "str"}
                ],
                "id": "str",
                "managedResourceGroupConfiguration": {"location": "str", "name": "str"},
                "name": "str",
                "nodes": [
                    {
                        "agentPoolId": "str",
                        "availabilityZone": "str",
                        "bareMetalMachineId": "str",
                        "cpuCores": 0,
                        "detailedStatus": "str",
                        "detailedStatusMessage": "str",
                        "diskSizeGB": 0,
                        "image": "str",
                        "kubernetesVersion": "str",
                        "labels": [{"key": "str", "value": "str"}],
                        "memorySizeGB": 0,
                        "mode": "str",
                        "name": "str",
                        "networkAttachments": [
                            {
                                "attachedNetworkId": "str",
                                "ipAllocationMethod": "str",
                                "defaultGateway": "str",
                                "ipv4Address": "str",
                                "ipv6Address": "str",
                                "macAddress": "str",
                                "networkAttachmentName": "str",
                            }
                        ],
                        "powerState": "str",
                        "role": "str",
                        "taints": [{"key": "str", "value": "str"}],
                        "vmSkuName": "str",
                    }
                ],
                "provisioningState": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_kubernetes_clusters_begin_delete(self, resource_group):
        response = self.client.kubernetes_clusters.begin_delete(
            resource_group_name=resource_group.name,
            kubernetes_cluster_name="str",
            api_version="2025-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_kubernetes_clusters_begin_update(self, resource_group):
        response = self.client.kubernetes_clusters.begin_update(
            resource_group_name=resource_group.name,
            kubernetes_cluster_name="str",
            api_version="2025-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_kubernetes_clusters_begin_restart_node(self, resource_group):
        response = self.client.kubernetes_clusters.begin_restart_node(
            resource_group_name=resource_group.name,
            kubernetes_cluster_name="str",
            kubernetes_cluster_restart_node_parameters={"nodeName": "str"},
            api_version="2025-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
