% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend_api-Future-class.R
\name{Future-class}
\alias{Future-class}
\alias{Future}
\title{A future represents a value that will be available at some point in the future}
\usage{
Future(
  expr = NULL,
  envir = parent.frame(),
  substitute = TRUE,
  stdout = TRUE,
  conditions = "condition",
  globals = list(),
  packages = NULL,
  seed = FALSE,
  lazy = FALSE,
  label = NULL,
  ...
)
}
\arguments{
\item{expr}{An \R \link[base]{expression}.}

\item{envir}{The \link{environment} from where global objects should be
identified.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{stdout}{If TRUE (default), then the standard output is captured,
and re-outputted when \code{value()} is called.
If FALSE, any output is silenced (by sinking it to the null device as
it is outputted).
Using \code{stdout = structure(TRUE, drop = TRUE)} causes the captured
standard output to be dropped from the future object as soon as it has
been relayed. This can help decrease the overall memory consumed by
captured output across futures.
Using \code{stdout = NA} fully avoids intercepting the standard output;
behavior of such unhandled standard output depends on the future backend.}

\item{conditions}{A character string of conditions classes to be captured
and relayed.  The default is to relay all conditions, including messages
and warnings.  To drop all conditions, use \code{conditions = character(0)}.
Errors are always relayed.
Attribute \code{exclude} can be used to ignore specific classes, e.g.
\code{conditions = structure("condition", exclude = "message")} will capture
all \code{condition} classes except those that inherits from the \code{message} class.
Using \code{conditions = structure(..., drop = TRUE)} causes any captured
conditions to be dropped from the future object as soon as it has
been relayed, e.g. by \code{value(f)}. This can help decrease the overall
memory consumed by captured conditions across futures.
Using \code{conditions = NULL} (not recommended) avoids intercepting conditions,
except from errors; behavior of such unhandled conditions depends on the
future backend and the environment from which R runs.}

\item{globals}{(optional) a logical, a character vector, or a named list
to control how globals are handled.
For details, see section 'Globals used by future expressions'
in the help for \code{\link[=future]{future()}}.}

\item{packages}{(optional) a character vector specifying packages
to be attached in the \R environment evaluating the future.}

\item{seed}{(optional) If TRUE, the random seed, that is, the state of the
random number generator (RNG) will be set such that statistically sound
random numbers are produced (also during parallelization).
If FALSE (default), it is assumed that the future expression does neither
need nor use random numbers generation.
To use a fixed random seed, specify a L'Ecuyer-CMRG seed (seven integer)
or a regular RNG seed (a single integer).  If the latter, then a
L'Ecuyer-CMRG seed will be automatically created based on the given seed.
Furthermore, if FALSE, then the future will be monitored to make sure it
does not use random numbers.  If it does and depending on the value of
option \link{future.rng.onMisuse}, the check is
ignored, an informative warning, or error will be produced.
If \code{seed} is NULL, then the effect is as with \code{seed = FALSE}
but without the RNG check being performed.}

\item{lazy}{If FALSE (default), the future is resolved
eagerly (starting immediately), otherwise not.}

\item{label}{A character string label attached to the future.}

\item{\ldots}{Additional named elements of the future.}
}
\value{
\code{Future()} returns an object of class \code{Future}.
}
\description{
A \emph{future} is an abstraction for a \emph{value} that may
available at some point in the future.  A future can either be
\code{unresolved} or \code{resolved}, a state which can be checked
with \code{\link[=resolved]{resolved()}}.  As long as it is \emph{unresolved}, the
value is not available.  As soon as it is \emph{resolved}, the value
is available via \code{\link[future]{value}()}.
}
\details{
A Future object is itself an \link{environment}.
}
\seealso{
One function that creates a Future is \code{\link[=future]{future()}}.
It returns a Future that evaluates an \R expression in the future.
An alternative approach is to use the \code{\link{\%<-\%}} infix
assignment operator, which creates a future from the
right-hand-side (RHS) \R expression and assigns its future value
to a variable as a \emph{\link[base:delayedAssign]{promise}}.
}
\keyword{internal}
