% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsa.R
\name{rsa_encrypt}
\alias{rsa_encrypt}
\alias{rsa}
\alias{encrypt}
\alias{rsa_decrypt}
\title{Low-level RSA encryption}
\usage{
rsa_encrypt(data, pubkey = my_pubkey(), oaep = FALSE)

rsa_decrypt(data, key = my_key(), password = askpass, oaep = FALSE)
}
\arguments{
\item{data}{raw vector of max 245 bytes (for 2048 bit keys) with data to encrypt/decrypt}

\item{pubkey}{public key or file path. See \code{\link[=read_pubkey]{read_pubkey()}}.}

\item{oaep}{if TRUE, changes padding to EME-OAEP as defined in PKCS #1 v2.0}

\item{key}{private key or file path. See \code{\link[=read_key]{read_key()}}.}

\item{password}{string or a function to read protected keys. See \code{\link[=read_key]{read_key()}}.}
}
\description{
Asymmetric encryption and decryption with RSA. Because RSA can only encrypt messages
smaller than the size of the key, it is typically used only for exchanging a random
session-key. This session key is used to encipher arbitrary sized data via a stream
cipher such as \link{aes_cbc}. See \link{encrypt_envelope} or \link{pkcs7_encrypt} for a high-level
wrappers combining RSA and AES in this way.
}
\examples{
# Generate test keys
key <- rsa_keygen()
pubkey <- key$pubkey

# Encrypt data with AES
tempkey <- rand_bytes(32)
iv <- rand_bytes(16)
blob <- aes_cbc_encrypt(system.file("CITATION"), tempkey, iv = iv)

# Encrypt tempkey using receivers public RSA key
ciphertext <- rsa_encrypt(tempkey, pubkey)

# Receiver decrypts tempkey from private RSA key
tempkey <- rsa_decrypt(ciphertext, key)
message <- aes_cbc_decrypt(blob, tempkey, iv)
out <- rawToChar(message)
}
