### New features

* [#14516](https://github.com/rubocop/rubocop/issues/14516): Add `AllowImplicitArrayLiterals` to `Layout/FirstArrayElementLineBreak`. ([@koic][])
* [#14750](https://github.com/rubocop/rubocop/pull/14750): Add new `Style/ReverseFind` cop. ([@koic][])
* [#12343](https://github.com/rubocop/rubocop/issues/12343): Add new `Style/EmptyClassDefinition` cop to enforce consistent style for empty class definitions. The cop can enforce either a two-line class definition or `Class.new` for classes with no body. ([@ydakuka][])
* [#14769](https://github.com/rubocop/rubocop/pull/14769): Add new `Style/HashLookupMethod` cop to enforce `Hash#[]` vs `Hash#fetch` preference. ([@sferik][])
* [#12051](https://github.com/rubocop/rubocop/issues/12051): Add new `Style/NegativeArrayIndex` cop to enforce using negative array indices instead of calculating array length minus a value. The cop handles both simple index patterns and range patterns, and recognizes preserving methods and their combinations. ([@ydakuka][])
* [#14633](https://github.com/rubocop/rubocop/pull/14633): Make a new system to handle push and pop locally. ([@Magikdidi24][])
* [#14722](https://github.com/rubocop/rubocop/pull/14722): Support `TargetRubyVersion 4.1` (experimental). ([@koic][])

### Bug fixes

* [#14697](https://github.com/rubocop/rubocop/issues/14697): Allow non-method calls in `Categories` for `Layout/ClassStructure`. ([@fatkodima][])
* [#14784](https://github.com/rubocop/rubocop/pull/14784): Fix an error for `Style/GuardClause` when using heredoc as an argument of raise in `else` branch and `if` branch is empty. ([@koic][])
* [#14790](https://github.com/rubocop/rubocop/pull/14790): Fix an error for `Style/HashLookupMethod` cop when there's no receiver. ([@viralpraxis][])
* [#14779](https://github.com/rubocop/rubocop/issues/14779): Fix autocorrect crash with `ruby_extractor` when using `offset: 0` and different source buffers. ([@ydakuka][])
* [#14762](https://github.com/rubocop/rubocop/pull/14762): Fix false negatives for `Style/RedundantCondition` when the branches contains constant assignment. ([@koic][])
* [#14751](https://github.com/rubocop/rubocop/issues/14751): Fix `--force-default-config` not preventing project config loading when used with options that access configuration. ([@sakuro][])
* [#14783](https://github.com/rubocop/rubocop/issues/14783): Fix incorrect autocorrect for `Style/HashSyntax` when shorthand syntax is used in condition of `if`/`unless`/`while`/`until`. ([@ydakuka][])
* [#14747](https://github.com/rubocop/rubocop/issues/14747): Fix a regression in`Layout/IndentationWidth` by adding a new `EnforcedStyleAlignWith` style parameter. ([@MikeMcQuaid][])
* [#14716](https://github.com/rubocop/rubocop/issues/14716): Fix an infinite loop error for `Layout/LineLength` when `SplitStrings` option is enabled and strings span multiple lines. ([@HariprasanthMSH][])
* [#14763](https://github.com/rubocop/rubocop/issues/14763): Fix an infinite loop error for `Layout/IndentationWidth` and `Layout/IndentationConsistency` when using `EnforcedStyle: indented_internal_methods` with method chain blocks. ([@ydakuka][])
* [#9373](https://github.com/rubocop/rubocop/issues/9373): Fix an infinite loop error for `Layout/IndentationWidth` when autocorrecting mixed tabs and spaces in blocks. Fix an infinite loop error for `Layout/DefEndAlignment` and `Layout/IndentationStyle` when autocorrecting mixed tabs and spaces. Autocorrection for tabs is disabled in `AlignmentCorrector` for indentation offenses, but enabled for `align_end`. ([@ydakuka][])
* [#12295](https://github.com/rubocop/rubocop/issues/12295): Fix `Layout/FirstArgumentIndentation` to correct entire method calls and chains for nested calls. ([@ydakuka][])
* [#12527](https://github.com/rubocop/rubocop/issues/12527): Fix `Offense#highlighted_area` to return a valid `Parser::Source::Range`. ([@ydakuka][])
* [#14801](https://github.com/rubocop/rubocop/pull/14801): Preserve source tabs in Clang and Tap formatters when displaying offense highlight. ([@lovro-bikic][])
* [#14761](https://github.com/rubocop/rubocop/issues/14761): Improved the remote configuration file name on the cache location. ([@Jack12816][])
* [#14778](https://github.com/rubocop/rubocop/pull/14778): Fix a false positive for `Security/JSONLoad` when `create_additions` option is passed with other options in a hash. ([@wktk][])
* [#14796](https://github.com/rubocop/rubocop/pull/14796): Handle logical and operator assignment nodes in variable branch handling. ([@lovro-bikic][])

### Changes

* [#14753](https://github.com/rubocop/rubocop/pull/14753): Add support for `squish` and `squish!` applied to heredoc to `Layout/HeredocIndentation`. ([@lovro-bikic][])
* [#14798](https://github.com/rubocop/rubocop/pull/14798): Recognize `Forwardable` methods in `Lint/DuplicateMethods`. ([@lovro-bikic][])
* [#14793](https://github.com/rubocop/rubocop/pull/14793): Make `Lint/RedundantSplatExpansion` aware of constant assignment. ([@koic][])
* [#14770](https://github.com/rubocop/rubocop/pull/14770): Make `Style/AccessModifierDeclarations` aware of self class. ([@koic][])
* [#14748](https://github.com/rubocop/rubocop/pull/14748): Add support for other `Module` member existence methods to `Style/ModuleMemberExistenceCheck`. ([@lovro-bikic][])
* [#14795](https://github.com/rubocop/rubocop/pull/14795): Add `AllowedMethods` configuration to `Style/ModuleMemberExistenceCheck`. ([@lovro-bikic][])

[@koic]: https://github.com/koic
[@ydakuka]: https://github.com/ydakuka
[@sferik]: https://github.com/sferik
[@Magikdidi24]: https://github.com/Magikdidi24
[@fatkodima]: https://github.com/fatkodima
[@viralpraxis]: https://github.com/viralpraxis
[@sakuro]: https://github.com/sakuro
[@MikeMcQuaid]: https://github.com/MikeMcQuaid
[@HariprasanthMSH]: https://github.com/HariprasanthMSH
[@lovro-bikic]: https://github.com/lovro-bikic
[@Jack12816]: https://github.com/Jack12816
[@wktk]: https://github.com/wktk
