---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, mots, typographie, espace insécable
---

# Comment obtenir une espace insécable ?

Le caractère `~` est interprété par LaTeX et permet d'obtenir une 
[espace insécable](wpfr:Espace_ins%C3%A9cable). 
Voici un exemple d'utilisation, illustrant l'impact sur la composition de LaTeX.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{eurosym}        % Accès au symbole de l'euro

\begin{document}
Voici quelques cas nécessitant l'utilisation d'une espace insécable : 
10 \%, 10 000 \euro{} (incorrect).

Voici quelques cas nécessitant l'utilisation d'une espace insécable : 
10~\%, 10~000~\euro{} (correct).
\end{document}
```

:::{seealso}
Quelques autres commandes d'espacement sont présentées à la question 
"[](/2_programmation/macros/single_letter_commands)".
:::