---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, sciences, chimie, 
              tableau périodique des éléments
---

# Comment obtenir le tableau périodique des éléments ?

L'extension <ctanpkg:pgf-PeriodicTable>, 
de [Hugo Gomes](https://www.ctan.org/author/gomes), permet de générer
le [tableau périodique des éléments](wpfr:Tableau_périodique_des_éléments)
avec les fonctionnalités apportées par <ctanpkg:pgf>. 

En voici la présentation par défaut :
- en activant la version française avec l'option d'extension `fr` ;
- et en redimensionnant le tableau obtenu pour qu'il tienne sur notre page
  en largeur avec l'extension <ctanpkg:graphicx> et sa commande `\resizebox`
  (illustrée également à la question 
  "[](/3_composition/texte/symboles/polices/changer_la_taille_d_une_fonte)").

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}       % Encodage T1 (adapté au français)
  \usepackage{lmodern}           % Caractères plus lisibles
  \pagestyle{empty}              % N'affiche pas de numéro de page
  \usepackage[a4paper]{geometry} % Un format A4
  \usepackage{graphicx}          % Des fonctions graphiques 
  \usepackage[fr]{pgf-PeriodicTable}

\begin{document}
\resizebox{\textwidth}{!}{
  \pgfPT
  }
\end{document}
```

Le tableau est largement configurable : couleurs, regroupement par famille
des éléments, repérage de certains éléments, choix des informations affichées
pour chaque élément, titre, sous-titre et ainsi de suite. 
La [documentation](texdoc:pgf-PeriodicTable) de l'extension, de plus 
de 130 pages, illustre ces nombreuses possibilités avec beaucoup d'exemples. 
Les deux exemples ci-dessous sont directement issus de cette documentation.

``` 
\documentclass[french]{article}
  \usepackage[T1]{fontenc}       % Encodage T1 (adapté au français)
  \usepackage{lmodern}           % Caractères plus lisibles
  \pagestyle{empty}              % N'affiche pas de numéro de page
  \usepackage[a4paper]{geometry} % Un format A4
  \usepackage{graphicx}          % Des fonctions graphiques 
  \usepackage[fr]{pgf-PeriodicTable}

\begin{document}
\resizebox{\textwidth}{!}{
  \pgfPT[show blocks,show title=false]
}

\resizebox{\textwidth}{!}{
  \pgfPT[csSolid,group numbers=CAS]
}
\end{document}
```


:::{sources}
- [Documentation](texdoc:pgf-PeriodicTable) 
  de l'extension <ctanpkg:pgf-PeriodicTable>
:::