---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, index, makeindex
---

# Comment générer un index ?

Par défaut, un index s'obtient en utilisant l'extension <ctanpkg:makeidx>
et des programmes de traitement d'index. L'extension définit en particulier
la commande `\printindex` décrite ci-dessous et redéfinit 
quelques commandes présentes dans LaTeX.


## Les commandes à placer dans le document

Dans les faits, pour générer un index, trois commandes sont nécessaires :

- `\makeindex` à mettre dans le préambule pour indiquer à LaTeX
  qu'il doit stocker, dans un fichier IDX, les entrées de l'index. 
  Sans cette commande, l'index sera vide ;
- `\index{⟨mot⟩}` permet d'ajouter l'entrée `⟨mot⟩` dans l'index. 
  Elle se trouve donc à de multiples reprises dans le corps du texte 
  et permet, par le biais de certains symboles, d'obtenir 
  des effets particuliers (comme le montre la question 
  "[](/3_composition/annexes/index/construire_un_index_hierarchique)") ;
- `\printindex` place l'index dans le document à l'endroit où cette commande
  est disposée. Cette commande a principalement pour rôle d'inclure le fichier
  IND contenant l'index trié.

Voici un exemple minimaliste de cette utilisation :

```
%!TEX makeindex document
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{makeidx}
  
  \makeindex

\begin{document}
Il ne se passe pas un jour\index{jour} sans que je pense à cette
mélodie\index{mélodie}.
\printindex
\end{document}
```


## L'appel à un programme de génération d'index

Le fichier IDX contient vos entrées d'index (avec leur numéro de page)
telles qu'elles arrivent au fur et à mesure dans votre document. Elles sont
dès lors sans mise en forme et non triées. La résolution de ces deux problèmes
passe par l'utilisation d'un des programmes évoqués à la question 
"[](/3_composition/annexes/index/generateurs_d_index)". Ces programmes lisent
le fichier IDX et le transforment en fichier IND contenant 
vos entrées ordonnées mises en forme, intégré par la commande 
`\printindex`.

Voici le cas du programme <ctanpkg:makeindex>. Pour créer l'index 
de votre fichier `mondoc.tex`, vous exécuteriez (après avoir compilé 
votre document LaTeX une première fois) :

```bash
makeindex mondoc.idx
```

C'est lors d'une compilation consécutive de votre document `mondoc.tex` 
que vous pourrez observer l'index.

Dans le cas de `makeindex`, il est possible d'indiquer un fichier de style 
d'index (fichier IST) par l'option `-s`. Dans le cas où vous disposeriez
d'un fichier de style `monstyle.ist`, vous exécuteriez :

```bash
makeindex -s monstyle.ist mondoc.idx
```


:::{sources}
- [Documentation] de <ctanpkg:makeidx>
:::