from _typeshed import Incomplete
from types import TracebackType
from typing import Any, ClassVar
from typing_extensions import Self

class DirtyClient:
    socket_path: str
    timeout: float

    def __init__(self, socket_path: str, timeout: float = 30.0) -> None: ...
    def connect(self) -> None: ...
    # Arguments and result depend on app path and method name passed to action
    def execute(self, app_path: str, action: str, *args: Any, **kwargs: Any) -> Any: ...
    def stream(self, app_path: str, action: str, *args: Any, **kwargs: Any) -> DirtyStreamIterator: ...
    def close(self) -> None: ...
    async def connect_async(self) -> None: ...
    async def execute_async(self, app_path: str, action: str, *args: Any, **kwargs: Any) -> Any: ...
    def stream_async(self, app_path: str, action: str, *args: Any, **kwargs: Any) -> DirtyAsyncStreamIterator: ...
    async def close_async(self) -> None: ...
    def __enter__(self) -> Self: ...
    def __exit__(
        self, exc_type: type[BaseException] | None, exc_val: BaseException | None, exc_tb: TracebackType | None
    ) -> None: ...
    async def __aenter__(self) -> Self: ...
    async def __aexit__(
        self, exc_type: type[BaseException] | None, exc_val: BaseException | None, exc_tb: TracebackType | None
    ) -> None: ...

class DirtyStreamIterator:
    DEFAULT_IDLE_TIMEOUT: ClassVar[float]
    client: DirtyClient
    app_path: str
    action: str
    args: tuple[Incomplete, ...]
    kwargs: dict[str, Incomplete]

    def __init__(
        self,
        client: DirtyClient,
        app_path: str,
        action: str,
        args: tuple[Incomplete, ...],
        kwargs: dict[str, Incomplete],
        idle_timeout: float | None = None,
    ) -> None: ...
    def __iter__(self) -> Self: ...
    def __next__(self) -> Incomplete | None: ...

class DirtyAsyncStreamIterator:
    DEFAULT_IDLE_TIMEOUT: ClassVar[float]
    client: DirtyClient
    app_path: str
    action: str
    args: tuple[Incomplete, ...]
    kwargs: dict[str, Incomplete]

    def __init__(
        self,
        client: DirtyClient,
        app_path: str,
        action: str,
        args: tuple[Incomplete, ...],
        kwargs: dict[str, Incomplete],
        idle_timeout: float | None = None,
    ) -> None: ...
    def __aiter__(self) -> Self: ...
    async def __anext__(self) -> Incomplete | None: ...

def set_dirty_socket_path(path: str) -> None: ...
def get_dirty_socket_path() -> str: ...
def get_dirty_client(timeout: float = 30.0) -> DirtyClient: ...
async def get_dirty_client_async(timeout: float = 30.0) -> DirtyClient: ...
def close_dirty_client() -> None: ...
async def close_dirty_client_async() -> None: ...
