#!/usr/bin/env python3
# DESCRIPTION: Verilator: Verilog Test driver/expect definition
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of either the GNU Lesser General Public License Version 3
# or the Perl Artistic License Version 2.0.
# SPDX-FileCopyrightText: 2024 Wilson Snyder
# SPDX-License-Identifier: LGPL-3.0-only OR Artistic-2.0

import vltest_bootstrap

test.scenarios('simulator')
test.top_filename = "t/t_unopt_converge.v"
#test.verilated_debug = 1

test.compile(v_flags2=['+define+ALLOW_UNOPT', '--output-split 0', "-fno-dfg"],
             make_flags=['CPPFLAGS_ADD=-DVL_DEBUG'])

if test.vlt_all:
    test.execute(fails=True, expect_filename=test.golden_filename)

test.passes()
