# GNU Guix --- Functional package management for GNU
# Copyright © 2012-2025 Ludovic Courtès <ludo@gnu.org>
# Copyright © 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020, 2022, 2023, 2024, 2025 Andreas Enge <andreas@enge.fr>
# Copyright © 2016 Mathieu Lirzin <mthl@gnu.org>
# Copyright © 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020, 2021 Mark H Weaver <mhw@netris.org>
# Copyright © 2016 Chris Marusich <cmmarusich@gmail.com>
# Copyright © 2016, 2017, 2018 Kei Kebreau <kkebreau@posteo.net>
# Copyright © 2016, 2017 Rene Saavedra <rennes@openmailbox.org>
# Copyright © 2016 Adonay "adfeno" Felipe Nogueira <https://libreplanet.org/wiki/User:Adfeno> <adfeno@openmailbox.org>
# Copyright © 2016-2025 Ricardo Wurmus <rekado@elephly.net>
# Copyright © 2016 Ben Woodcroft <donttrustben@gmail.com>
# Copyright © 2016, 2017, 2018, 2019 Alex Vong <alexvong1995@gmail.com>
# Copyright © 2016-2023 Efraim Flashner <efraim@flashner.co.il>
# Copyright © 2016, 2017, 2018, 2019, 2020, 2021, 2022, 2023, 2024 Janneke Nieuwenhuizen <janneke@gnu.org>
# Copyright © 2017, 2018, 2019, 2020 Tobias Geerinckx-Rice <me@tobias.gr>
# Copyright © 2017, 2018, 2023, 2024 Clément Lassieur <clement@lassieur.org>
# Copyright © 2017, 2020 Mathieu Othacehe <m.othacehe@gmail.com>
# Copyright © 2017, 2018, 2019 Gábor Boskovits <boskovits@gmail.com>
# Copyright © 2018 Amirouche Boubekki <amirouche@hypermove.net>
# Copyright © 2018, 2019, 2020, 2021, 2022, 2024, 2025 Oleg Pykhalov <go.wigust@gmail.com>
# Copyright © 2018 Stefan Stefanović <stefanx2ovic@gmail.com>
# Copyright © 2018, 2020-2025 Maxim Cournoyer <maxim@guixotic.coop>
# Copyright © 2019, 2020, 2021, 2022, 2024 Guillaume Le Vaillant <glv@posteo.net>
# Copyright © 2019, 2020 John Soo <jsoo1@asu.edu>
# Copyright © 2019 Jonathan Brielmaier <jonathan.brielmaier@web.de>
# Copyright © 2019 Evan Straw <evan.straw99@gmail.com>
# Copyright © 2019, 2020 Brett Gilio <brettg@gnu.org>
# Copyright © 2019 Amin Bandali <bandali@gnu.org>
# Copyright © 2020 Brendan Tildesley <mail@brendan.scot>
# Copyright © 2020 Vincent Legoll <vincent.legoll@gmail.com>
# Copyright © 2020 R Veera Kumar <vkor@vkten.in>
# Copyright © 2020 Nicolò Balzarotti <nicolo@nixo.xyz>
# Copyright © 2020 Michael Rohleder <mike@rohleder.de>
# Copyright © 2020, 2021, 2022, 2023 Felix Gruber <felgru@posteo.net>
# Copyright © 2020 Ryan Prior <rprior@protonmail.com>
# Copyright © 2020 Jan Wielkiewicz <tona_kosmicznego_smiecia@interia.pl>
# Copyright © 2020, 2021 Brice Waegeneire <brice@waegenei.re>
# Copyright © 2020, 2023 Tanguy Le Carrour <tanguy@bioneland.org>
# Copyright © 2020 Martin Becze <mjbecze@riseup.net>
# Copyright © 2020 Malte Frank Gerdes <mate.f.gerdes@gmail.com>
# Copyright © 2020, 2023 Vinicius Monego <monego@posteo.net>
# Copyright © 2021 Björn Höfling <bjoern.hoefling@bjoernhoefling.de>
# Copyright © 2021 Greg Hogan <code@greghogan.com>
# Copyright © 2021-2024 Philip McGrath <philip@philipmcgrath.com>
# Copyright © 2021 Arun Isaac <arunisaac@systemreboot.net>
# Copyright © 2021 Sharlatan Hellseher <sharlatanus@gmail.com>
# Copyright © 2021 Dmitry Polyakov <polyakov@liltechdude.xyz>
# Copyright © 2021 Andrew Tropin <andrew@trop.in>
# Copyright © 2021 Simon Tournier <zimon.toutoune@gmail.com>
# Copyright © 2022 Daniel Meißner <daniel.meissner-i4k@ruhr-uni-bochum.de>
# Copyright © 2022, 2024, 2025 Remco van 't Veer <remco@remworks.net>
# Copyright © 2022, 2024, 2025 Artyom V. Poptsov <poptsov.artyom@gmail.com>
# Copyright © 2022, 2023, 2025 John Kehayias <john.kehayias@protonmail.com>
# Copyright © 2022 muradm <mail@muradm.net>
# Copyright © 2022 Hilton Chain <hako@ultrarare.space>
# Copyright © 2022 Alex Griffin <a@ajgrf.com>
# Copyright © 2022 ( <paren@disroot.org>
# Copyright © 2022 jgart <jgart@dismail.de>
# Copyright © 2023-2025 Zheng Junjie <z572@z572.online>
# Copyright © 2023 Ivana Drazovic <iv.dra@hotmail.com>
# Copyright © 2023 Andy Tai <atai@atai.org>
# Copyright © 2023 B. Wilson <elaexuotee@wilsonb.com>
# Copyright © 2023 Bruno Victal <mirai@makinata.eu>
# Copyright © 2023, 2024 gemmaro <gemmaro.dev@gmail.com>
# Copyright © 2023 Herman Rimm <herman@rimm.ee>
# Copyright © 2023 Troy Figiel <troy@troyfigiel.com>
# Copyright © 2024, 2025 David Elsing <david.elsing@posteo.net>
# Copyright © 2024 Ashish SHUKLA <ashish.is@lostca.se>
# Copyright © 2024 Fabio Natali <me@fabionatali.com>
# Copyright © 2024 Noé Lopez <noelopez@free.fr>
# Copyright © 2024 Runciter <runciter@whispers-vpn.org>
# Copyright © 2024 Ashvith Shetty <ashvithshetty10@gmail.com>
# Copyright © 2024 James Smith <jsubuntuxp@disroot.org>
# Copyright © 2025 Nigko Yerden <nigko.yerden@gmail.com>
# Copyright © 2025 Cayetano Santos <csantosb@inventati.org>
# Copyright © 2025 bdunahu <bdunahu@operationnull.com>
#
# This file is part of GNU Guix.
#
# GNU Guix is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or (at
# your option) any later version.
#
# GNU Guix is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

# Definitions for the GNU System: package modules, patches, bootstrap
# binaries.

GNU_SYSTEM_MODULES =				\
  gnu.scm					\
  %D%/artwork.scm				\
  %D%/bootloader.scm				\
  %D%/bootloader/grub.scm                       \
  %D%/bootloader/extlinux.scm                   \
  %D%/bootloader/u-boot.scm                     \
  %D%/bootloader/depthcharge.scm                \
  %D%/ci.scm					\
  %D%/compression.scm				\
  %D%/home.scm					\
  %D%/home/services.scm			\
  %D%/home/services/admin.scm			\
  %D%/home/services/backup.scm			\
  %D%/home/services/containers.scm		\
  %D%/home/services/desktop.scm			\
  %D%/home/services/dict.scm			\
  %D%/home/services/dotfiles.scm		\
  %D%/home/services/symlink-manager.scm		\
  %D%/home/services/fontutils.scm		\
  %D%/home/services/gnome.scm			\
  %D%/home/services/gnupg.scm			\
  %D%/home/services/guix.scm			\
  %D%/home/services/mail.scm			\
  %D%/home/services/media.scm			\
  %D%/home/services/messaging.scm		\
  %D%/home/services/mpv.scm     		\
  %D%/home/services/music.scm			\
  %D%/home/services/niri.scm			\
  %D%/home/services/pm.scm			\
  %D%/home/services/secrets.scm			\
  %D%/home/services/shells.scm			\
  %D%/home/services/shepherd.scm		\
  %D%/home/services/sound.scm			\
  %D%/home/services/ssh.scm			\
  %D%/home/services/sway.scm			\
  %D%/home/services/syncthing.scm		\
  %D%/home/services/mcron.scm			\
  %D%/home/services/upnp.scm			\
  %D%/home/services/utils.scm			\
  %D%/home/services/xdg.scm			\
  %D%/image.scm					\
  %D%/packages.scm				\
  %D%/packages/abiword.scm			\
  %D%/packages/accessibility.scm		\
  %D%/packages/acct.scm				\
  %D%/packages/acl.scm				\
  %D%/packages/ada.scm				\
  %D%/packages/admin.scm			\
  %D%/packages/adns.scm				\
  %D%/packages/agda.scm				\
  %D%/packages/algebra.scm			\
  %D%/packages/aidc.scm				\
  %D%/packages/android.scm			\
  %D%/packages/animation.scm			\
  %D%/packages/anthy.scm			\
  %D%/packages/antivirus.scm			\
  %D%/packages/apl.scm				\
  %D%/packages/apparmor.scm			\
  %D%/packages/appimage.scm			\
  %D%/packages/apr.scm				\
  %D%/packages/arcan.scm			\
  %D%/packages/aspell.scm			\
  %D%/packages/assembly.scm			\
  %D%/packages/astronomy.scm			\
  %D%/packages/attr.scm				\
  %D%/packages/audio.scm			\
  %D%/packages/augeas.scm			\
  %D%/packages/authentication.scm		\
  %D%/packages/autogen.scm			\
  %D%/packages/autotools.scm			\
  %D%/packages/avahi.scm			\
  %D%/packages/avr.scm				\
  %D%/packages/avr-xyz.scm			\
  %D%/packages/axoloti.scm			\
  %D%/packages/backup.scm			\
  %D%/packages/base.scm				\
  %D%/packages/bash.scm				\
  %D%/packages/batik.scm			\
  %D%/packages/bdw-gc.scm			\
  %D%/packages/benchmark.scm			\
  %D%/packages/bioconductor.scm			\
  %D%/packages/bioinformatics.scm		\
  %D%/packages/bittorrent.scm			\
  %D%/packages/bison.scm			\
  %D%/packages/books.scm			\
  %D%/packages/boost.scm			\
  %D%/packages/bootloaders.scm			\
  %D%/packages/bootstrap.scm			\
  %D%/packages/browser-extensions.scm		\
  %D%/packages/build-tools.scm			\
  %D%/packages/busybox.scm			\
  %D%/packages/bqn.scm				\
  %D%/packages/c.scm				\
  %D%/packages/calcurse.scm			\
  %D%/packages/ccache.scm			\
  %D%/packages/cdrom.scm			\
  %D%/packages/certs.scm			\
  %D%/packages/check.scm			\
  %D%/packages/chemistry.scm			\
  %D%/packages/chez.scm				\
  %D%/packages/chicken.scm				\
  %D%/packages/chromium.scm			\
  %D%/packages/ci.scm				\
  %D%/packages/cinnamon.scm			\
  %D%/packages/clifm.scm			\
  %D%/packages/clojure.scm			\
  %D%/packages/cluster.scm			\
  %D%/packages/cmake.scm			\
  %D%/packages/cobol.scm			\
  %D%/packages/code.scm				\
  %D%/packages/commencement.scm			\
  %D%/packages/compression.scm			\
  %D%/packages/compton.scm 			\
  %D%/packages/configuration-management.scm	\
  %D%/packages/conky.scm			\
  %D%/packages/connman.scm			\
  %D%/packages/containers.scm			\
  %D%/packages/convmv.scm			\
  %D%/packages/cook.scm				\
  %D%/packages/coq.scm				\
  %D%/packages/cpio.scm				\
  %D%/packages/cpp.scm 				\
  %D%/packages/cppi.scm				\
  %D%/packages/cran.scm				\
  %D%/packages/cross-base.scm			\
  %D%/packages/cross-toolchain.scm		\
  %D%/packages/crypto.scm			\
  %D%/packages/cryptsetup.scm			\
  %D%/packages/cups.scm				\
  %D%/packages/curl.scm				\
  %D%/packages/cvassistant.scm			\
  %D%/packages/cybersecurity.scm		\
  %D%/packages/cyrus-sasl.scm			\
  %D%/packages/darwin.scm			\
  %D%/packages/data-language.scm		\
  %D%/packages/databases.scm			\
  %D%/packages/datamash.scm			\
  %D%/packages/datastructures.scm		\
  %D%/packages/dav.scm				\
  %D%/packages/dbm.scm				\
  %D%/packages/dc.scm				\
  %D%/packages/debian.scm			\
  %D%/packages/debug.scm			\
  %D%/packages/dejagnu.scm			\
  %D%/packages/dezyne.scm			\
  %D%/packages/decker.scm			\
  %D%/packages/dhall.scm			\
  %D%/packages/dotnet.scm			\
  %D%/packages/dictionaries.scm			\
  %D%/packages/diffoscope.scm			\
  %D%/packages/digest.scm			\
  %D%/packages/disk.scm			\
  %D%/packages/distributed.scm			\
  %D%/packages/display-managers.scm		\
  %D%/packages/django.scm			\
  %D%/packages/djvu.scm				\
  %D%/packages/dlang.scm			\
  %D%/packages/dns.scm				\
  %D%/packages/docbook.scm			\
  %D%/packages/docker.scm			\
  %D%/packages/documentation.scm		\
  %D%/packages/dpdk.scm        \
  %D%/packages/duckdb.scm			\
  %D%/packages/dvtm.scm				\
  %D%/packages/easyrpg.scm			\
  %D%/packages/ebook.scm			\
  %D%/packages/education.scm			\
  %D%/packages/efi.scm				\
  %D%/packages/electronics.scm			\
  %D%/packages/elf.scm				\
  %D%/packages/elixir.scm			\
  %D%/packages/elixir-databases.scm		\
  %D%/packages/elixir-i18n.scm		\
  %D%/packages/elixir-markup.scm		\
  %D%/packages/elixir-web.scm			\
  %D%/packages/elixir-xyz.scm			\
  %D%/packages/elm.scm				\
  %D%/packages/embedded.scm			\
  %D%/packages/emacs.scm			\
  %D%/packages/emacs-build.scm			\
  %D%/packages/emacs-xyz.scm			\
  %D%/packages/emulators.scm			\
  %D%/packages/enchant.scm			\
  %D%/packages/engineering.scm			\
  %D%/packages/enlightenment.scm		\
  %D%/packages/entr.scm				\
  %D%/packages/erlang.scm			\
  %D%/packages/erlang-xyz.scm			\
  %D%/packages/esolangs.scm			\
  %D%/packages/fabric-management.scm		\
  %D%/packages/fcitx5.scm			\
  %D%/packages/fediverse.scm			\
  %D%/packages/figlet.scm			\
  %D%/packages/file.scm				\
  %D%/packages/file-systems.scm			\
  %D%/packages/finance.scm			\
  %D%/packages/firmware.scm			\
  %D%/packages/flashing-tools.scm		\
  %D%/packages/flex.scm				\
  %D%/packages/fltk.scm				\
  %D%/packages/fluidplug.scm			\
  %D%/packages/fonts.scm			\
  %D%/packages/fontutils.scm			\
  %D%/packages/forth.scm			\
  %D%/packages/fortran-check.scm			\
  %D%/packages/fortran-xyz.scm			\
  %D%/packages/freedesktop.scm			\
  %D%/packages/freeipmi.scm			\
  %D%/packages/ftp.scm				\
  %D%/packages/fribidi.scm			\
  %D%/packages/gambas.scm			\
  %D%/packages/game-development.scm		\
  %D%/packages/games.scm			\
  %D%/packages/gawk.scm				\
  %D%/packages/gcc.scm				\
  %D%/packages/gd.scm				\
  %D%/packages/gdb.scm				\
  %D%/packages/genealogy.scm			\
  %D%/packages/genimage.scm			\
  %D%/packages/geo.scm				\
  %D%/packages/gettext.scm			\
  %D%/packages/ghostscript.scm			\
  %D%/packages/gimp.scm				\
  %D%/packages/gkrellm.scm			\
  %D%/packages/gl.scm				\
  %D%/packages/glib.scm				\
  %D%/packages/gnome.scm			\
  %D%/packages/gnome-xyz.scm			\
  %D%/packages/gnu-doc.scm			\
  %D%/packages/gnucash.scm			\
  %D%/packages/gnunet.scm			\
  %D%/packages/gnupg.scm			\
  %D%/packages/gnustep.scm			\
  %D%/packages/gnuzilla.scm			\
  %D%/packages/gnu-pw-mgr.scm			\
  %D%/packages/gobby.scm			\
  %D%/packages/golang.scm			\
  %D%/packages/golang-apps.scm			\
  %D%/packages/golang-build.scm		\
  %D%/packages/golang-check.scm		\
  %D%/packages/golang-compression.scm		\
  %D%/packages/golang-crypto.scm	      	\
  %D%/packages/golang-maths.scm		\
  %D%/packages/golang-vcs.scm	        	\
  %D%/packages/golang-web.scm	        	\
  %D%/packages/golang-xyz.scm	        	\
  %D%/packages/gperf.scm			\
  %D%/packages/gpodder.scm			\
  %D%/packages/gps.scm				\
  %D%/packages/graph.scm			\
  %D%/packages/graphics.scm			\
  %D%/packages/graphviz.scm			\
  %D%/packages/groff.scm			\
  %D%/packages/groovy.scm			\
  %D%/packages/gsasl.scm			\
  %D%/packages/gstreamer.scm			\
  %D%/packages/gtk.scm				\
  %D%/packages/guile.scm			\
  %D%/packages/guile-wm.scm			\
  %D%/packages/guile-xyz.scm			\
  %D%/packages/gv.scm				\
  %D%/packages/gxmessage.scm			\
  %D%/packages/hardware.scm			\
  %D%/packages/hare.scm				\
  %D%/packages/hare-apps.scm			\
  %D%/packages/hare-xyz.scm			\
  %D%/packages/haskell.scm			\
  %D%/packages/haskell-apps.scm			\
  %D%/packages/haskell-check.scm		\
  %D%/packages/haskell-crypto.scm		\
  %D%/packages/haskell-web.scm			\
  %D%/packages/haskell-xyz.scm			\
  %D%/packages/haxe.scm				\
  %D%/packages/heads.scm			\
  %D%/packages/hexedit.scm			\
  %D%/packages/high-availability.scm			\
  %D%/packages/hugs.scm				\
  %D%/packages/hunspell.scm				\
  %D%/packages/hurd.scm				\
  %D%/packages/i2p.scm				\
  %D%/packages/ibus.scm				\
  %D%/packages/icu4c.scm			\
  %D%/packages/idris.scm			\
  %D%/packages/idutils.scm			\
  %D%/packages/image.scm			\
  %D%/packages/image-processing.scm	\
  %D%/packages/image-viewers.scm	\
  %D%/packages/imagemagick.scm			\
  %D%/packages/inferno.scm			\
  %D%/packages/inklingreader.scm		\
  %D%/packages/inkscape.scm			\
  %D%/packages/installers.scm			\
  %D%/packages/instrumentation.scm		\
  %D%/packages/ipfs.scm			\
  %D%/packages/irc.scm  			\
  %D%/packages/iso-codes.scm			\
  %D%/packages/jami.scm				\
  %D%/packages/java.scm				\
  %D%/packages/java-bootstrap.scm		\
  %D%/packages/java-compression.scm		\
  %D%/packages/java-graphics.scm		\
  %D%/packages/java-maths.scm			\
  %D%/packages/java-rdf.scm			\
  %D%/packages/java-xml.scm			\
  %D%/packages/javascript.scm			\
  %D%/packages/jemalloc.scm			\
  %D%/packages/jose.scm				\
  %D%/packages/julia.scm			\
  %D%/packages/julia-jll.scm			\
  %D%/packages/julia-xyz.scm			\
  %D%/packages/jupyter.scm			\
  %D%/packages/kawa.scm				\
  %D%/packages/kde-education.scm		\
  %D%/packages/kde-frameworks.scm		\
  %D%/packages/kde-games.scm			\
  %D%/packages/kde-graphics.scm			\
  %D%/packages/kde-internet.scm			\
  %D%/packages/kde-multimedia.scm		\
  %D%/packages/kde-office.scm			\
  %D%/packages/kde-pim.scm			\
  %D%/packages/kde-plasma.scm			\
  %D%/packages/kde-sdk.scm			\
  %D%/packages/kde-systemtools.scm		\
  %D%/packages/kde-utils.scm			\
  %D%/packages/kerberos.scm			\
  %D%/packages/kodi.scm				\
  %D%/packages/language.scm			\
  %D%/packages/lc0.scm			\
  %D%/packages/lean.scm				\
  %D%/packages/lego.scm				\
  %D%/packages/less.scm				\
  %D%/packages/lesstif.scm			\
  %D%/packages/libbsd.scm			\
  %D%/packages/libcanberra.scm			\
  %D%/packages/libdaemon.scm			\
  %D%/packages/libedit.scm			\
  %D%/packages/libevent.scm			\
  %D%/packages/libffcall.scm			\
  %D%/packages/libffi.scm			\
  %D%/packages/libftdi.scm			\
  %D%/packages/license.scm			\
  %D%/packages/calendar.scm			\
  %D%/packages/libidn.scm			\
  %D%/packages/libphidget.scm			\
  %D%/packages/libreoffice.scm			\
  %D%/packages/librewolf.scm			\
  %D%/packages/libsigsegv.scm			\
  %D%/packages/libunistring.scm			\
  %D%/packages/libusb.scm			\
  %D%/packages/libunwind.scm			\
  %D%/packages/lighting.scm                     \
  %D%/packages/linphone.scm			\
  %D%/packages/linux.scm			\
  %D%/packages/lirc.scm				\
  %D%/packages/lisp.scm				\
  %D%/packages/lisp-check.scm			\
  %D%/packages/lisp-xyz.scm			\
  %D%/packages/llvm.scm				\
  %D%/packages/llvm-meta.scm			\
  %D%/packages/lout.scm				\
  %D%/packages/logging.scm			\
  %D%/packages/logo.scm				\
  %D%/packages/lsof.scm				\
  %D%/packages/lua.scm				\
  %D%/packages/luanti.scm			\
  %D%/packages/lxde.scm				\
  %D%/packages/lxqt.scm				\
  %D%/packages/m4.scm				\
  %D%/packages/machine-learning.scm		\
  %D%/packages/magic-wormhole.scm		\
  %D%/packages/man.scm				\
  %D%/packages/mail.scm				\
  %D%/packages/make-bootstrap.scm		\
  %D%/packages/markup.scm			\
  %D%/packages/marst.scm			\
  %D%/packages/mate.scm             \
  %D%/packages/maths.scm			\
  %D%/packages/matrix.scm			\
  %D%/packages/maven.scm			\
  %D%/packages/maven-parent-pom.scm		\
  %D%/packages/mc.scm				\
  %D%/packages/mcrypt.scm			\
  %D%/packages/medical.scm			\
  %D%/packages/mercury.scm			\
  %D%/packages/mes.scm				\
  %D%/packages/messaging.scm			\
  %D%/packages/minetest.scm			\
  %D%/packages/mingw.scm			\
  %D%/packages/mold.scm				\
  %D%/packages/motti.scm			\
  %D%/packages/monitoring.scm			\
  %D%/packages/moreutils.scm			\
  %D%/packages/mpd.scm				\
  %D%/packages/mp3.scm				\
  %D%/packages/mpi.scm				\
  %D%/packages/mruby-xyz.scm			\
  %D%/packages/multiprecision.scm		\
  %D%/packages/music.scm			\
  %D%/packages/musl.scm				\
  %D%/packages/mtools.scm			\
  %D%/packages/myrddin.scm			\
  %D%/packages/ncdu.scm				\
  %D%/packages/ncurses.scm			\
  %D%/packages/netpbm.scm			\
  %D%/packages/nettle.scm			\
  %D%/packages/networking.scm			\
  %D%/packages/nfs.scm                          \
  %D%/packages/nickle.scm                       \
  %D%/packages/nicotine.scm                     \
  %D%/packages/nim.scm  			\
  %D%/packages/ninja.scm			\
  %D%/packages/node.scm				\
  %D%/packages/node-xyz.scm			\
  %D%/packages/notcurses.scm			\
  %D%/packages/noweb.scm			\
  %D%/packages/nss.scm				\
  %D%/packages/ntp.scm				\
  %D%/packages/nushell.scm			\
  %D%/packages/nutrition.scm			\
  %D%/packages/nvi.scm				\
  %D%/packages/nx.scm				\
  %D%/packages/ocaml.scm			\
  %D%/packages/ocr.scm				\
  %D%/packages/openkinect.scm			\
  %D%/packages/onc-rpc.scm			\
  %D%/packages/opencl.scm			\
  %D%/packages/opencog.scm			\
  %D%/packages/openldap.scm			\
  %D%/packages/openpgp.scm			\
  %D%/packages/openstack.scm			\
  %D%/packages/orange.scm			\
  %D%/packages/orpheus.scm			\
  %D%/packages/ots.scm				\
  %D%/packages/oyacc.scm			\
  %D%/packages/package-management.scm		\
  %D%/packages/pantheon.scm			\
  %D%/packages/parallel.scm			\
  %D%/packages/pascal.scm			\
  %D%/packages/password-utils.scm		\
  %D%/packages/patool.scm			\
  %D%/packages/patchutils.scm			\
  %D%/packages/pciutils.scm			\
  %D%/packages/pcre.scm				\
  %D%/packages/pdf.scm				\
  %D%/packages/pem.scm				\
  %D%/packages/perl.scm				\
  %D%/packages/perl-check.scm			\
  %D%/packages/perl-compression.scm		\
  %D%/packages/perl-maths.scm			\
  %D%/packages/perl-web.scm			\
  %D%/packages/perl6.scm			\
  %D%/packages/photo.scm			\
  %D%/packages/phabricator.scm 			\
  %D%/packages/php.scm				\
  %D%/packages/php-xyz.scm			\
  %D%/packages/piet.scm			\
  %D%/packages/diagram.scm			\
  %D%/packages/pkg-config.scm			\
  %D%/packages/plan9.scm			\
  %D%/packages/plotutils.scm			\
  %D%/packages/poedit.scm				\
  %D%/packages/polkit.scm			\
  %D%/packages/popt.scm				\
  %D%/packages/postmarketos.scm			\
  %D%/packages/potassco.scm				\
  %D%/packages/power.scm			\
  %D%/packages/printers.scm			\
  %D%/packages/profiling.scm			\
  %D%/packages/prolog.scm			\
  %D%/packages/prometheus.scm		\
  %D%/packages/pth.scm				\
  %D%/packages/pulseaudio.scm			\
  %D%/packages/pumpio.scm			\
  %D%/packages/pretty-print.scm			\
  %D%/packages/protobuf.scm			\
  %D%/packages/purescript.scm			\
  %D%/packages/pv.scm				\
  %D%/packages/pypy.scm				\
  %D%/packages/python.scm			\
  %D%/packages/python-build.scm			\
  %D%/packages/python-check.scm			\
  %D%/packages/python-compression.scm		\
  %D%/packages/python-crypto.scm		\
  %D%/packages/python-graphics.scm			\
  %D%/packages/python-science.scm		\
  %D%/packages/python-web.scm			\
  %D%/packages/python-xyz.scm			\
  %D%/packages/toys.scm				\
  %D%/packages/tryton.scm			\
  %D%/packages/qt.scm				\
  %D%/packages/quantum.scm			\
  %D%/packages/racket.scm			\
  %D%/packages/radio.scm			\
  %D%/packages/ragel.scm			\
  %D%/packages/rails.scm			\
  %D%/packages/raspberry-pi.scm			\
  %D%/packages/ratpoison.scm			\
  %D%/packages/rcm.scm				\
  %D%/packages/rdesktop.scm			\
  %D%/packages/rdf.scm				\
  %D%/packages/re2c.scm				\
  %D%/packages/readline.scm			\
  %D%/packages/rednotebook.scm			\
  %D%/packages/regex.scm				\
  %D%/packages/robotics.scm			\
  %D%/packages/rocm.scm				\
  %D%/packages/rpc.scm				\
  %D%/packages/rpm.scm				\
  %D%/packages/rrdtool.scm			\
  %D%/packages/rsync.scm			\
  %D%/packages/ruby.scm				\
  %D%/packages/ruby-check.scm				\
  %D%/packages/ruby-xyz.scm				\
  %D%/packages/rust.scm				\
  %D%/packages/rust-apps.scm			\
  %D%/packages/rust-crates.scm			\
  %D%/packages/rust-sources.scm			\
  %D%/packages/samba.scm			\
  %D%/packages/sagemath.scm			\
  %D%/packages/scanner.scm			\
  %D%/packages/scheme.scm			\
  %D%/packages/spreadsheet.scm			\
  %D%/packages/screen.scm			\
  %D%/packages/scribus.scm			\
  %D%/packages/scsi.scm				\
  %D%/packages/sdl.scm				\
  %D%/packages/search.scm			\
  %D%/packages/security-token.scm		\
  %D%/packages/selinux.scm			\
  %D%/packages/sequoia.scm			\
  %D%/packages/serialization.scm		\
  %D%/packages/serveez.scm			\
  %D%/packages/shells.scm			\
  %D%/packages/shellutils.scm			\
  %D%/packages/simh.scm				\
  %D%/packages/simulation.scm			\
  %D%/packages/skarnet.scm			\
  %D%/packages/skribilo.scm			\
  %D%/packages/slang.scm			\
  %D%/packages/smalltalk.scm			\
  %D%/packages/sml.scm				\
  %D%/packages/solidity.scm			\
  %D%/packages/sourcehut.scm			\
  %D%/packages/specifications.scm		\
  %D%/packages/speech.scm			\
  %D%/packages/sphinx.scm			\
  %D%/packages/spice.scm			\
  %D%/packages/sqlite.scm			\
  %D%/packages/squirrel.scm			\
  %D%/packages/ssh.scm				\
  %D%/packages/sssd.scm				\
  %D%/packages/statistics.scm			\
  %D%/packages/stb.scm				\
  %D%/packages/stenography.scm			\
  %D%/packages/storage.scm			\
  %D%/packages/suckless.scm			\
  %D%/packages/sugar.scm			\
  %D%/packages/swift.scm			\
  %D%/packages/swig.scm				\
  %D%/packages/sycl.scm				\
  %D%/packages/sync.scm			\
  %D%/packages/syncthing.scm			\
  %D%/packages/synergy.scm			\
  %D%/packages/syndication.scm			\
  %D%/packages/task-management.scm		\
  %D%/packages/task-runners.scm			\
  %D%/packages/tbb.scm				\
  %D%/packages/tcl.scm				\
  %D%/packages/telegram.scm                 \
  %D%/packages/telephony.scm			\
  %D%/packages/terminals.scm			\
  %D%/packages/terraform.scm			\
  %D%/packages/texinfo.scm			\
  %D%/packages/tex.scm				\
  %D%/packages/texlive.scm                      \
  %D%/packages/textutils.scm			\
  %D%/packages/text-editors.scm			\
  %D%/packages/time.scm				\
  %D%/packages/tls.scm				\
  %D%/packages/tmux.scm				\
  %D%/packages/toolkits.scm			\
  %D%/packages/tor-browsers.scm			\
  %D%/packages/tor.scm				\
  %D%/packages/tree-sitter.scm			\
  %D%/packages/tv.scm				\
  %D%/packages/uglifyjs.scm			\
  %D%/packages/uml.scm				\
  %D%/packages/unicode.scm			\
  %D%/packages/unrtf.scm			\
  %D%/packages/upnp.scm				\
  %D%/packages/usb-modeswitch.scm		\
  %D%/packages/uucp.scm				\
  %D%/packages/oneapi.scm			\
  %D%/packages/valgrind.scm			\
  %D%/packages/version-control.scm		\
  %D%/packages/video.scm			\
  %D%/packages/vim.scm				\
  %D%/packages/virtualization.scm		\
  %D%/packages/vlang.scm			\
  %D%/packages/vnc.scm				\
  %D%/packages/vpn.scm				\
  %D%/packages/vulkan.scm			\
  %D%/packages/w3m.scm				\
  %D%/packages/weather.scm			\
  %D%/packages/web.scm				\
  %D%/packages/web-browsers.scm			\
  %D%/packages/webkit.scm			\
  %D%/packages/wget.scm				\
  %D%/packages/wine.scm				\
  %D%/packages/wireservice.scm				\
  %D%/packages/wm.scm				\
  %D%/packages/wordnet.scm			\
  %D%/packages/wv.scm				\
  %D%/packages/wxwidgets.scm			\
  %D%/packages/xfig.scm				\
  %D%/packages/xiph.scm				\
  %D%/packages/xml.scm				\
  %D%/packages/xdisorg.scm			\
  %D%/packages/xorg.scm				\
  %D%/packages/xfce.scm				\
  %D%/packages/zig.scm				\
  %D%/packages/zig-xyz.scm			\
  %D%/packages/zile.scm				\
  %D%/packages/zwave.scm			\
						\
  %D%/services.scm				\
  %D%/services/admin.scm			\
  %D%/services/audio.scm                        \
  %D%/services/auditd.scm			\
  %D%/services/avahi.scm			\
  %D%/services/base.scm				\
  %D%/services/backup.scm			\
  %D%/services/certbot.scm			\
  %D%/services/cgit.scm			\
  %D%/services/ci.scm				\
  %D%/services/configuration.scm		\
  %D%/services/containers.scm   		\
  %D%/services/cuirass.scm			\
  %D%/services/cups.scm				\
  %D%/services/databases.scm			\
  %D%/services/dbus.scm				\
  %D%/services/desktop.scm			\
  %D%/services/dict.scm				\
  %D%/services/dns.scm				\
  %D%/services/docker.scm			\
  %D%/services/authentication.scm		\
  %D%/services/file-sharing.scm			\
  %D%/services/games.scm			\
  %D%/services/ganeti.scm			\
  %D%/services/getmail.scm				\
  %D%/services/guix.scm			\
  %D%/services/hurd.scm				\
  %D%/services/kerberos.scm			\
  %D%/services/ldap.scm		      		\
  %D%/services/lightdm.scm      		\
  %D%/services/linux.scm			\
  %D%/services/lirc.scm				\
  %D%/services/virtualization.scm		\
  %D%/services/mail.scm				\
  %D%/services/mcron.scm			\
  %D%/services/messaging.scm			\
  %D%/services/monitoring.scm			\
  %D%/services/networking.scm			\
  %D%/services/nix.scm				\
  %D%/services/nfs.scm			\
  %D%/services/pam-mount.scm			\
  %D%/services/power.scm			\
  %D%/services/science.scm			\
  %D%/services/security.scm			\
  %D%/services/security-token.scm		\
  %D%/services/shepherd.scm			\
  %D%/services/sound.scm			\
  %D%/services/herd.scm				\
  %D%/services/pm.scm				\
  %D%/services/high-availability.scm			\
  %D%/services/rsync.scm			\
  %D%/services/samba.scm			\
  %D%/services/sddm.scm				\
  %D%/services/spice.scm				\
  %D%/services/ssh.scm				\
  %D%/services/syncthing.scm			\
  %D%/services/sysctl.scm			\
  %D%/services/telephony.scm			\
  %D%/services/upnp.scm				\
  %D%/services/version-control.scm              \
  %D%/services/vnc.scm				\
  %D%/services/vpn.scm				\
  %D%/services/web.scm				\
  %D%/services/xorg.scm				\
						\
  %D%/system.scm				\
  %D%/system/accounts.scm			\
  %D%/system/file-systems.scm			\
  %D%/system/hurd.scm				\
  %D%/system/image.scm 				\
  %D%/system/install.scm			\
  %D%/system/keyboard.scm			\
  %D%/system/linux-container.scm		\
  %D%/system/linux-initrd.scm			\
  %D%/system/locale.scm				\
  %D%/system/mapped-devices.scm			\
  %D%/system/nss.scm				\
  %D%/system/pam.scm				\
  %D%/system/privilege.scm			\
  %D%/system/setuid.scm				\
  %D%/system/shadow.scm				\
  %D%/system/uuid.scm				\
  %D%/system/vm.scm				\
						\
  %D%/system/images/hurd.scm			\
  %D%/system/images/novena.scm			\
  %D%/system/images/orangepi-r1-plus-lts-rk3328.scm	\
  %D%/system/images/pine64.scm			\
  %D%/system/images/pinebook-pro.scm		\
  %D%/system/images/rock64.scm			\
  %D%/system/images/rock-4c-plus.scm		\
  %D%/system/images/unmatched.scm		\
  %D%/system/images/visionfive2.scm		\
  %D%/system/images/wsl2.scm			\
						\
  %D%/machine.scm				\
						\
  %D%/build/accounts.scm			\
  %D%/build/activation.scm			\
  %D%/build/bootloader.scm			\
  %D%/build/chromium-extension.scm		\
  %D%/build/cross-toolchain.scm			\
  %D%/build/dbus-service.scm			\
  %D%/build/icecat-extension.scm		\
  %D%/build/image.scm				\
  %D%/build/jami-service.scm			\
  %D%/build/file-systems.scm			\
  %D%/build/hurd-boot.scm			\
  %D%/build/install.scm				\
  %D%/build/linux-boot.scm			\
  %D%/build/linux-container.scm			\
  %D%/build/linux-initrd.scm			\
  %D%/build/linux-modules.scm			\
  %D%/build/marionette.scm			\
  %D%/build/oci-containers.scm			\
  %D%/build/secret-service.scm			\
						\
  %D%/tests.scm					\
  %D%/tests/audio.scm				\
  %D%/tests/avahi.scm				\
  %D%/tests/base.scm				\
  %D%/tests/cachefilesd.scm			\
  %D%/tests/ci.scm				\
  %D%/tests/containers.scm			\
  %D%/tests/cups.scm				\
  %D%/tests/databases.scm			\
  %D%/tests/desktop.scm				\
  %D%/tests/dns.scm				\
  %D%/tests/dict.scm				\
  %D%/tests/docker.scm				\
  %D%/tests/emacs.scm				\
  %D%/tests/file-sharing.scm			\
  %D%/tests/foreign.scm				\
  %D%/tests/ganeti.scm				\
  %D%/tests/gdm.scm				\
  %D%/tests/guix.scm				\
  %D%/tests/high-availability.scm		\
  %D%/tests/monitoring.scm                      \
  %D%/tests/nfs.scm				\
  %D%/tests/image.scm				\
  %D%/tests/install.scm				\
  %D%/tests/ldap.scm				\
  %D%/tests/lightdm.scm			\
  %D%/tests/linux-modules.scm			\
  %D%/tests/mail.scm				\
  %D%/tests/mcron.scm				\
  %D%/tests/messaging.scm			\
  %D%/tests/networking.scm			\
  %D%/tests/package-management.scm		\
  %D%/tests/pam.scm				\
  %D%/tests/reconfigure.scm			\
  %D%/tests/rsync.scm				\
  %D%/tests/samba.scm				\
  %D%/tests/sddm.scm				\
  %D%/tests/security.scm			\
  %D%/tests/security-token.scm			\
  %D%/tests/shadow.scm  			\
  %D%/tests/singularity.scm			\
  %D%/tests/ssh.scm				\
  %D%/tests/telephony.scm		        \
  %D%/tests/upnp.scm				\
  %D%/tests/version-control.scm			\
  %D%/tests/virtualization.scm			\
  %D%/tests/vnc.scm				\
  %D%/tests/vnstat.scm				\
  %D%/tests/web.scm

INSTALLER_MODULES =                             \
  %D%/installer.scm      			\
  %D%/installer/connman.scm			\
  %D%/installer/dump.scm			\
  %D%/installer/final.scm			\
  %D%/installer/hardware.scm			\
  %D%/installer/hostname.scm			\
  %D%/installer/kernel.scm			\
  %D%/installer/keymap.scm			\
  %D%/installer/locale.scm			\
  %D%/installer/newt.scm			\
  %D%/installer/parted.scm			\
  %D%/installer/proxy.scm			\
  %D%/installer/record.scm		        \
  %D%/installer/services.scm			\
  %D%/installer/steps.scm			\
  %D%/installer/substitutes.scm			\
  %D%/installer/tests.scm			\
  %D%/installer/timezone.scm			\
  %D%/installer/user.scm			\
  %D%/installer/utils.scm			\
						\
  %D%/installer/newt/ethernet.scm		\
  %D%/installer/newt/final.scm  		\
  %D%/installer/newt/parameters.scm		\
  %D%/installer/newt/hostname.scm		\
  %D%/installer/newt/kernel.scm			\
  %D%/installer/newt/keymap.scm			\
  %D%/installer/newt/locale.scm			\
  %D%/installer/newt/menu.scm			\
  %D%/installer/newt/network.scm		\
  %D%/installer/newt/page.scm			\
  %D%/installer/newt/partition.scm		\
  %D%/installer/newt/services.scm		\
  %D%/installer/newt/substitutes.scm		\
  %D%/installer/newt/timezone.scm		\
  %D%/installer/newt/user.scm			\
  %D%/installer/newt/utils.scm			\
  %D%/installer/newt/welcome.scm		\
  %D%/installer/newt/wifi.scm

if HAVE_GUILE_SSH

GNU_SYSTEM_MODULES +=         			\
  %D%/machine/digital-ocean.scm			\
  %D%/machine/hetzner.scm			\
  %D%/machine/hetzner/http.scm			\
  %D%/machine/ssh.scm

endif HAVE_GUILE_SSH

# Always ship the installer modules but compile them only when
# ENABLE_INSTALLER is true.
if ENABLE_INSTALLER
GNU_SYSTEM_MODULES += $(INSTALLER_MODULES)
else !ENABLE_INSTALLER
MODULES_NOT_COMPILED += $(INSTALLER_MODULES)
endif

installerdir = $(guilemoduledir)/%D%/installer
dist_installer_DATA =				\
  %D%/installer/aux-files/logo.txt

# Modules that do not need to be compiled.
MODULES_NOT_COMPILED +=				\
  %D%/build/locale.scm				\
  %D%/build/shepherd.scm			\
  %D%/build/svg.scm				\
  %D%/tests/data/jami-dummy-account.dat

patchdir = $(guilemoduledir)/%D%/packages/patches
dist_patch_DATA =						\
  %D%/packages/patches/389-ds-base-legacy-version.patch		\
  %D%/packages/patches/8mq-enable-imx_hab_handler.patch		\
  %D%/packages/patches/8mq-move-stack-to-ocram_s.patch		\
  %D%/packages/patches/abcl-fix-build-xml.patch	\
  %D%/packages/patches/ableton-link-system-libraries-debian.patch	\
  %D%/packages/patches/abiword-explictly-cast-bools.patch	\
  %D%/packages/patches/abseil-cpp-20220623.1-no-kepsilon-i686.patch	\
  %D%/packages/patches/abseil-cpp-fix-strerror_test.patch	\
  %D%/packages/patches/adb-add-libraries.patch			\
  %D%/packages/patches/adb-libssl_11-compatibility.patch	\
  %D%/packages/patches/accountsservice-extensions.patch		\
  %D%/packages/patches/aegis-constness-error.patch         	\
  %D%/packages/patches/aegis-perl-tempdir1.patch           	\
  %D%/packages/patches/aegis-perl-tempdir2.patch           	\
  %D%/packages/patches/aegis-test-fixup-1.patch            	\
  %D%/packages/patches/aegis-test-fixup-2.patch            	\
  %D%/packages/patches/aegisub-icu59-include-unistr.patch	\
  %D%/packages/patches/aegisub-boost68.patch			\
  %D%/packages/patches/aegisub-boost81.patch			\
  %D%/packages/patches/aegisub-make43.patch			\
  %D%/packages/patches/agda-categories-remove-incompatible-flags.patch	\
  %D%/packages/patches/agda-categories-use-find.patch	\
  %D%/packages/patches/agda-categories-use-newer-stdlib.patch	\
  %D%/packages/patches/agda-libdirs-env-variable.patch	\
  %D%/packages/patches/agda-use-sphinx-5.patch	\
  %D%/packages/patches/agda-stdlib-use-runhaskell.patch	\
  %D%/packages/patches/agg-am_c_prototype.patch			\
  %D%/packages/patches/agg-2.5-gcc8.patch			\
  %D%/packages/patches/akonadi-paths.patch		\
  %D%/packages/patches/akonadi-not-relocatable.patch		\
  %D%/packages/patches/akonadi-timestamps.patch		\
  %D%/packages/patches/alure-dumb-2.patch			\
  %D%/packages/patches/amd-smi-python.patch			\
  %D%/packages/patches/ibus-anthy-fix-tests.patch		\
  %D%/packages/patches/ibus-table-paths.patch			\
  %D%/packages/patches/anki-mpv-args.patch			\
  %D%/packages/patches/antiword-CVE-2014-8123.patch			\
  %D%/packages/patches/antlr3-3_1-fix-java8-compilation.patch	\
  %D%/packages/patches/antlr3-3_3-fix-java8-compilation.patch	\
  %D%/packages/patches/apr-fix-atomics.patch			\
  %D%/packages/patches/apr-skip-getservbyname-test.patch	\
  %D%/packages/patches/aria-maestosa-scons-python3.patch	\
  %D%/packages/patches/aria2-unbundle-wslay.patch		\
  %D%/packages/patches/ark-skip-xar-test.patch			\
  %D%/packages/patches/asli-use-system-libs.patch		\
  %D%/packages/patches/aspell-CVE-2019-25051.patch		\
  %D%/packages/patches/aspell-default-dict-dir.patch		\
  %D%/packages/patches/atf-execute-with-shell.patch		\
  %D%/packages/patches/ath9k-htc-firmware-binutils.patch	\
  %D%/packages/patches/ath9k-htc-firmware-gcc.patch		\
  %D%/packages/patches/ath9k-htc-firmware-gcc-compat.patch	\
  %D%/packages/patches/atlas-gfortran-compat.patch		\
  %D%/packages/patches/audacity-ffmpeg-fallback.patch		\
  %D%/packages/patches/audiofile-fix-datatypes-in-tests.patch	\
  %D%/packages/patches/audiofile-fix-sign-conversion.patch	\
  %D%/packages/patches/audiofile-CVE-2015-7747.patch		\
  %D%/packages/patches/audiofile-CVE-2018-13440.patch		\
  %D%/packages/patches/audiofile-CVE-2018-17095.patch		\
  %D%/packages/patches/audiofile-CVE-2022-24599.patch		\
  %D%/packages/patches/audiofile-check-number-of-coefficients.patch \
  %D%/packages/patches/audiofile-Fail-on-error-in-parseFormat.patch \
  %D%/packages/patches/audiofile-Fix-index-overflow-in-IMA.cpp.patch \
  %D%/packages/patches/audiofile-multiply-overflow.patch	\
  %D%/packages/patches/audiofile-overflow-in-MSADPCM.patch	\
  %D%/packages/patches/audiofile-division-by-zero.patch 	\
  %D%/packages/patches/audiofile-hurd.patch 			\
  %D%/packages/patches/audiofile-function-signature.patch	\
  %D%/packages/patches/automake-skip-amhello-tests.patch	\
  %D%/packages/patches/avahi-localstatedir.patch		\
  %D%/packages/patches/avalon-toolkit-rdkit-fixes.patch		\
  %D%/packages/patches/avidemux-install-to-lib.patch		\
  %D%/packages/patches/awesome-reproducible-png.patch		\
  %D%/packages/patches/awesome-4.3-fno-common.patch		\
  %D%/packages/patches/azr3.patch				\
  %D%/packages/patches/azr3-remove-lash.patch			\
  %D%/packages/patches/barony-fix-textures.patch		\
  %D%/packages/patches/bash-completion-directories.patch	\
  %D%/packages/patches/bash-linux-pgrp-pipe.patch		\
  %D%/packages/patches/basis-universal-unbundle-libs.patch	\
  %D%/packages/patches/bastet-change-source-of-unordered_set.patch	\
  %D%/packages/patches/bdb-4-5-configure.patch                  \
  %D%/packages/patches/bdb-5.3-atomics-on-gcc-9.patch		\
  %D%/packages/patches/biboumi-cmake-ignore-git.patch		\
  %D%/packages/patches/brasero-fix-gcc-14-build-failure.patch	\
  %D%/packages/patches/brightnessctl-elogind-support.patch	\
  %D%/packages/patches/bsd-games-2.17-64bit.patch		\
  %D%/packages/patches/bsd-games-add-configure-config.patch	\
  %D%/packages/patches/bsd-games-add-wrapper.patch		\
  %D%/packages/patches/bsd-games-bad-ntohl-cast.patch		\
  %D%/packages/patches/bsd-games-dont-install-empty-files.patch	\
  %D%/packages/patches/bsd-games-gamescreen.h.patch		\
  %D%/packages/patches/bsd-games-getline.patch			\
  %D%/packages/patches/bsd-games-null-check.patch		\
  %D%/packages/patches/bsd-games-number.c-and-test.patch	\
  %D%/packages/patches/bsd-games-prevent-name-collisions.patch	\
  %D%/packages/patches/bsd-games-stdio.h.patch			\
  %D%/packages/patches/beancount-disable-googleapis-fonts.patch	\
  %D%/packages/patches/beignet-correct-file-names.patch		\
  %D%/packages/patches/bidiv-update-fribidi.patch		\
  %D%/packages/patches/binutils-boot-2.20.1a.patch		\
  %D%/packages/patches/binutils-loongson-workaround.patch	\
  %D%/packages/patches/binutils-mingw-w64-deterministic.patch	\
  %D%/packages/patches/binutils-2.41-fix-cross.patch		\
  %D%/packages/patches/bloomberg-bde-tools-fix-install-path.patch	\
  %D%/packages/patches/boolector-find-googletest.patch	\
  %D%/packages/patches/boost-fix-duplicate-definitions-bug.patch	\
  %D%/packages/patches/btanks-scons-python.patch		\
  %D%/packages/patches/btanks-sl08-python.patch			\
  %D%/packages/patches/byobu-writable-status.patch		\
  %D%/packages/patches/bubblewrap-fix-locale-in-tests.patch	\
  %D%/packages/patches/busybox-add-missing-sha-NI-guard.patch	\
  %D%/packages/patches/busybox-no-cbq.patch			\
  %D%/packages/patches/cadical-add-shared-library.patch		\
  %D%/packages/patches/calibre-no-updates-dialog.patch		\
  %D%/packages/patches/calibre-remove-test-sqlite.patch		\
  %D%/packages/patches/calibre-remove-test-unrar.patch		\
  %D%/packages/patches/calibre-remove-test-import-modules.patch	\
  %D%/packages/patches/calligra-qt-6.9.patch                    \
  %D%/packages/patches/calls-disable-application-test.patch	\
  %D%/packages/patches/calls-disable-sip-test.patch		\
  %D%/packages/patches/camlboot-dynamically-allocate-stack-signal.patch	\
  %D%/packages/patches/capstone-fix-python-constants.patch	\
  %D%/packages/patches/catdoc-CVE-2017-11110.patch		\
  %D%/packages/patches/chez-irregex-import-cond-expand.patch	\
  %D%/packages/patches/chez-scheme-bin-sh.patch			\
  %D%/packages/patches/circos-remove-findbin.patch		\
  %D%/packages/patches/cdparanoia-fpic.patch			\
  %D%/packages/patches/cdrkit-libre-cross-compile.patch	\
  %D%/packages/patches/cdrtools-3.01-mkisofs-isoinfo.patch 	\
  %D%/packages/patches/ceph-disable-cpu-optimizations.patch	\
  %D%/packages/patches/ceph-fix-for-newer-boost.patch		\
  %D%/packages/patches/cf-tool-add-languages.patch		\
  %D%/packages/patches/chmlib-inttypes.patch			\
  %D%/packages/patches/cl-asdf-config-directories.patch		\
  %D%/packages/patches/clamav-config-llvm-libs.patch		\
  %D%/packages/patches/clamav-system-tomsfastmath.patch		\
  %D%/packages/patches/clang-11.0-libc-search-path.patch	\
  %D%/packages/patches/clang-12.0-libc-search-path.patch	\
  %D%/packages/patches/clang-13.0-libc-search-path.patch	\
  %D%/packages/patches/clang-13-remove-crypt-interceptors.patch	\
  %D%/packages/patches/clang-14.0-libc-search-path.patch	\
  %D%/packages/patches/clang-14-remove-crypt-interceptors.patch	\
  %D%/packages/patches/clang-15.0-libc-search-path.patch	\
  %D%/packages/patches/clang-16.0-libc-search-path.patch	\
  %D%/packages/patches/clang-16-remove-crypt-interceptors.patch	\
  %D%/packages/patches/clang-17.0-libc-search-path.patch	\
  %D%/packages/patches/clang-17.0-link-dsymutil-latomic.patch	\
  %D%/packages/patches/clang-17.0-fix-build-with-gcc-14-on-arm.patch    \
  %D%/packages/patches/clang-18.0-libc-search-path.patch	\
  %D%/packages/patches/clang-runtime-esan-build-fixes.patch	\
  %D%/packages/patches/clang-runtime-12-remove-crypt-interceptors.patch \
  %D%/packages/patches/clang-runtime-13-glibc-2.36-compat.patch	\
  %D%/packages/patches/clang-runtime-14-glibc-2.36-compat.patch	\
  %D%/packages/patches/clang-runtime-3.9-libsanitizer-mode-field.patch	\
  %D%/packages/patches/clasp-hide-event-ids.patch		\
  %D%/packages/patches/classpath-aarch64-support.patch		\
  %D%/packages/patches/classpath-miscompilation.patch		\
  %D%/packages/patches/clitest-grep-compat.patch		\
  %D%/packages/patches/clog-fix-shared-build.patch		\
  %D%/packages/patches/clucene-gcc-14.patch			\
  %D%/packages/patches/clucene-pkgconfig.patch			\
  %D%/packages/patches/coda-use-system-libs.patch		\
  %D%/packages/patches/cogl-fix-double-free.patch		\
  %D%/packages/patches/collectd-5.11.0-noinstallvar.patch		\
  %D%/packages/patches/combinatorial-blas-awpm.patch		\
  %D%/packages/patches/combinatorial-blas-io-fix.patch		\
  %D%/packages/patches/compsize-fix-btrfs-progs-compatibility.patch	\
  %D%/packages/patches/containerd-create-pid-file.patch	\
  %D%/packages/patches/containerd-fix-includes.patch            \
  %D%/packages/patches/cool-retro-term-wctype.patch		\
  %D%/packages/patches/coq-autosubst-1.8-remove-deprecated-files.patch		\
  %D%/packages/patches/corectrl-locate-polkit-with-pkg-config.patch	\
  %D%/packages/patches/corefx-mono-5.4.0-patches.patch		\
  %D%/packages/patches/corefx-mono-pre-5.8.0-patches.patch	\
  %D%/packages/patches/coreutils-gnulib-tests.patch		\
  %D%/packages/patches/corrosion-honor-CARGO_BUILD_TARGET.patch	\
  %D%/packages/patches/cppcheck-fix-basedir-test.patch	\
  %D%/packages/patches/cppdap-add-CPPDAP_USE_EXTERNAL_GTEST_PACKAGE.patch\
  %D%/packages/patches/cproc-extra-linkflags.patch	\
  %D%/packages/patches/cpulimit-with-glib-2.32.patch		\
  %D%/packages/patches/crawl-upgrade-saves.patch		\
  %D%/packages/patches/crc32c-unbundle-googletest.patch		\
  %D%/packages/patches/crda-optional-gcrypt.patch		\
  %D%/packages/patches/clucene-contribs-lib.patch               \
  %D%/packages/patches/csvkit-set-locale-for-tests.patch			\
  %D%/packages/patches/ctranslate2-local-build.patch		\
  %D%/packages/patches/ctune-cmake-disable-git-clone.patch		\
  %D%/packages/patches/cube-nocheck.patch			\
  %D%/packages/patches/cups-relax-root-ownership-check.patch		\
  %D%/packages/patches/cura-engine-gcc-14.patch			\
  %D%/packages/patches/curl-CVE-2024-8096.patch			\
  %D%/packages/patches/curl-use-ssl-cert-env.patch		\
  %D%/packages/patches/curlftpfs-fix-error-closing-file.patch	\
  %D%/packages/patches/curlftpfs-fix-file-names.patch		\
  %D%/packages/patches/curlftpfs-fix-memory-leak.patch		\
  %D%/packages/patches/curlftpfs-fix-no_verify_hostname.patch	\
  %D%/packages/patches/cursynth-wave-rand.patch			\
  %D%/packages/patches/cvs-CVE-2017-12836.patch		\
  %D%/packages/patches/cyrus-sasl-fix-time-h.patch              \
  %D%/packages/patches/d-feet-drop-unused-meson-argument.patch	\
  %D%/packages/patches/daemontools-gcc14.patch                  \
  %D%/packages/patches/dante-non-darwin.patch			\
  %D%/packages/patches/date-ignore-zonenow.patch	\
  %D%/packages/patches/date-output-pkg-config-files.patch	\
  %D%/packages/patches/dbacl-include-locale.h.patch		\
  %D%/packages/patches/dbacl-icheck-multiple-definitions.patch	\
  %D%/packages/patches/dblatex-inkscape-1.0.patch		\
  %D%/packages/patches/dbus-helper-search-path.patch		\
  %D%/packages/patches/dbus-c++-gcc-compat.patch		\
  %D%/packages/patches/dbus-c++-threading-mutex.patch		\
  %D%/packages/patches/ddd-build.patch				\
  %D%/packages/patches/debops-setup-py-avoid-git.patch	\
  %D%/packages/patches/dee-vapi.patch			\
  %D%/packages/patches/dfu-programmer-fix-libusb.patch		\
  %D%/packages/patches/dhclient-script-resolvconf-support.patch \
  %D%/packages/patches/dicedb-remove-init-from-config-subpkg.patch	\
  %D%/packages/patches/directfb-davinci-glibc-228-compat.patch	\
  %D%/packages/patches/django-compressor-build-with-beautifulsoup-4.14+.patch	\
  %D%/packages/patches/dkimproxy-add-ipv6-support.patch		\
  %D%/packages/patches/doc++-gcc-14.patch			\
  %D%/packages/patches/docbook-utils-documentation-edits.patch	\
  %D%/packages/patches/docbook-utils-escape-characters.patch	\
  %D%/packages/patches/docbook-utils-remove-jade-sp.patch	\
  %D%/packages/patches/docbook-utils-respect-refentry-for-name.patch	\
  %D%/packages/patches/docbook-utils-source-date-epoch.patch	\
  %D%/packages/patches/docbook-utils-use-date-element.patch	\
  %D%/packages/patches/docbook2x-entity-lt.patch                \
  %D%/packages/patches/docbook2x-filename-handling.patch	\
  %D%/packages/patches/docbook2x-fix-synopsis.patch		\
  %D%/packages/patches/docbook2x-manpage-typo.patch		\
  %D%/packages/patches/docbook2x-preprocessor-declaration.patch	\
  %D%/packages/patches/docbook2x-static-datadir-evaluation.patch	\
  %D%/packages/patches/doc++-include-directives.patch		\
  %D%/packages/patches/doc++-segfault-fix.patch			\
  %D%/packages/patches/dolphin-emu-unbundle-tinygltf.patch      \
  %D%/packages/patches/dolphin-emu-unbundle-watcher.patch       \
  %D%/packages/patches/dovecot-opensslv3.patch			\
  %D%/packages/patches/dovecot-trees-support-dovecot-2.3.patch	\
  %D%/packages/patches/dstat-fix-crash-when-specifying-delay.patch	\
  %D%/packages/patches/dstat-skip-devices-without-io.patch	\
  %D%/packages/patches/dtc-fix-test.patch	\
  %D%/packages/patches/duc-fix-test-sh.patch                    \
  %D%/packages/patches/dune-common-skip-failing-tests.patch	\
  %D%/packages/patches/durden-shadow-arcan.patch		\
  %D%/packages/patches/dvdbackup-with-libdvdread-6.1.0+.patch	\
  %D%/packages/patches/dvd+rw-tools-add-include.patch 		\
  %D%/packages/patches/dwarves-threading-reproducibility.patch	\
  %D%/packages/patches/efivar-fix-fprint-format.patch		\
  %D%/packages/patches/eigen-fix-strict-aliasing-bug.patch	\
  %D%/packages/patches/einstein-build.patch			\
  %D%/packages/patches/elfutils-tests-ptrace.patch		\
  %D%/packages/patches/elixir-httpoison-tag-network-dependent-test-cases.patch			\
  %D%/packages/patches/elixir-path-length.patch			\
  %D%/packages/patches/elm-ghc9.2.patch	\
  %D%/packages/patches/python-treelib-remove-python2-compat.patch	\
  %D%/packages/patches/elm-offline-package-registry.patch	\
  %D%/packages/patches/elm-reactor-static-files.patch		\
  %D%/packages/patches/emacs-all-the-icons-remove-duplicate-rs.patch	\
  %D%/packages/patches/emacs-deferred-fix-number-of-arguments.patch	\
  %D%/packages/patches/emacs-disable-jit-compilation.patch			\
  %D%/packages/patches/emacs-elisp-autofmt-fix-region-send.patch	\
  %D%/packages/patches/emacs-exec-path.patch			\
  %D%/packages/patches/emacs-fix-scheme-indent-function.patch	\
  %D%/packages/patches/emacs-gnus-alias-reference-signature.patch	\
  %D%/packages/patches/emacs-helpful-fix-signature.patch	\
  %D%/packages/patches/emacs-helpful-fix-tests.patch	\
  %D%/packages/patches/emacs-highlight-stages-add-gexp.patch	\
  %D%/packages/patches/emacs-json-reformat-fix-tests.patch	\
  %D%/packages/patches/emacs-kv-fix-tests.patch	\
  %D%/packages/patches/emacs-lispy-fix-thread-last-test.patch   \
  %D%/packages/patches/emacs-native-comp-driver-options.patch   \
  %D%/packages/patches/emacs-native-comp-fix-filenames.patch   \
  %D%/packages/patches/emacs-native-comp-pin-packages.patch   \
  %D%/packages/patches/emacs-next-disable-jit-compilation.patch			\
  %D%/packages/patches/emacs-next-exec-path.patch   \
  %D%/packages/patches/emacs-next-native-comp-fix-filenames.patch   \
  %D%/packages/patches/emacs-pasp-mode-quote-file-names.patch  \
  %D%/packages/patches/emacs-pgtk-super-key-fix.patch	\
  %D%/packages/patches/emacs-polymode-fix-lexical-variable-error.patch  \
  %D%/packages/patches/emacs-shx-byte-compilation-test.patch	\
  %D%/packages/patches/emacs-telega-path-placeholder.patch	\
  %D%/packages/patches/emacs-telega-test-env.patch		\
  %D%/packages/patches/emacs-wordnut-require-adaptive-wrap.patch	\
  %D%/packages/patches/emacs-zoom-image-test-fix.patch	\
  %D%/packages/patches/enblend-enfuse-reproducible.patch	\
  %D%/packages/patches/enjarify-setup-py.patch			\
  %D%/packages/patches/enlightenment-fix-setuid-path.patch	\
  %D%/packages/patches/ergodox-firmware-fix-json-target.patch	\
  %D%/packages/patches/ergodox-firmware-fix-numpad.patch	\
  %D%/packages/patches/ericw-tools-add-check-for-sse2-in-light.cc.patch	\
  %D%/packages/patches/ericw-tools-gcc-11-pass-const-to-offsetof.patch	\
  %D%/packages/patches/erlang-binpp-disable-failing-tests.patch	\
  %D%/packages/patches/erlang-man-path.patch			\
  %D%/packages/patches/erlang-mochiweb-disable-known-to-fail-tests.patch	\
  %D%/packages/patches/esmini-use-pkgconfig.patch		\
  %D%/packages/patches/esmtp-add-lesmtp.patch		\
  %D%/packages/patches/esound-c99.patch         		\
  %D%/packages/patches/exercism-disable-self-update.patch	\
  %D%/packages/patches/extundelete-e2fsprogs-1.44.patch		\
  %D%/packages/patches/fail2ban-fix-sshd-filter.patch           \
  %D%/packages/patches/fail2ban-paths-guix-conf.patch		\
  %D%/packages/patches/faiss-tests-CMakeLists-find-googletest.patch	\
  %D%/packages/patches/falcosecurity-libs-bpf-probes-fix.patch  \
  %D%/packages/patches/falcosecurity-libs-shared-build.patch	\
  %D%/packages/patches/farstream-gupnp.patch                         \
  %D%/packages/patches/farstream-make.patch                          \
  %D%/packages/patches/fastcap-mulGlobal.patch			\
  %D%/packages/patches/fastcap-mulSetup.patch			\
  %D%/packages/patches/fasthenry-spAllocate.patch		\
  %D%/packages/patches/fasthenry-spBuild.patch			\
  %D%/packages/patches/fasthenry-spUtils.patch			\
  %D%/packages/patches/fasthenry-spSolve.patch			\
  %D%/packages/patches/fasthenry-spFactor.patch			\
  %D%/packages/patches/fbgemm-use-system-libraries.patch	\
  %D%/packages/patches/fbreader-curl-7.62.patch		\
  %D%/packages/patches/fbreader-fix-icon.patch		\
  %D%/packages/patches/fenics-dolfin-algorithm.patch		\
  %D%/packages/patches/fenics-dolfin-demo-init.patch		\
  %D%/packages/patches/fenics-dolfin-boost.patch		\
  %D%/packages/patches/fenics-dolfin-config-slepc.patch		\
  %D%/packages/patches/fenics-dolfin-hdf5-version-check.patch	\
  %D%/packages/patches/fenics-dolfin-integer-types.patch	\
  %D%/packages/patches/ffmpeg-add-av_stream_get_first_dts-for-chromium.patch	\
  %D%/packages/patches/ffmpeg-jami-change-RTCP-ratio.patch	\
  %D%/packages/patches/ffmpeg-jami-rtp_ext_abs_send_time.patch	\
  %D%/packages/patches/ffmpeg-jami-libopusdec-enable-FEC.patch	\
  %D%/packages/patches/ffmpeg-jami-libopusenc-enable-FEC.patch	\
  %D%/packages/patches/ffmpeg-jami-libopusenc-reload-packet-loss-at-encode.patch \
  %D%/packages/patches/ffmpeg-jami-pipewiregrab-source-filter.patch	\
  %D%/packages/patches/ffmpeg-jami-remove-mjpeg-log.patch	\
  %D%/packages/patches/ffmpeg-jami-screen-sharing-x11-fix.patch	\
  %D%/packages/patches/ffmpeg-4-binutils-2.41.patch	\
  %D%/packages/patches/ffmpeg-svt-av1-v3.patch			\
  %D%/packages/patches/fgallery-also-look-for-7z.patch		\
  %D%/packages/patches/fifengine-boost-compat.patch		\
  %D%/packages/patches/fifengine-python-3.9-compat.patch	\
  %D%/packages/patches/fifengine-swig-compat.patch		\
  %D%/packages/patches/fifo-map-fix-flags-for-gcc.patch		\
  %D%/packages/patches/fifo-map-remove-catch.hpp.patch		\
  %D%/packages/patches/findutils-localstatedir.patch		\
  %D%/packages/patches/firebird-riscv64-support-pt1.patch	\
  %D%/packages/patches/firebird-riscv64-support-pt2.patch	\
  %D%/packages/patches/flann-cmake-3.11.patch			\
  %D%/packages/patches/flatpak-fix-fonts-icons.patch	\
  %D%/packages/patches/flatpak-fix-icon-validation.patch	\
  %D%/packages/patches/flatpak-unset-gdk-pixbuf-for-sandbox.patch	\
  %D%/packages/patches/fluxbox-1.3.7-no-dynamic-cursor.patch	\
  %D%/packages/patches/fluxbox-1.3.7-gcc.patch			\
  %D%/packages/patches/fmt-9-overspecified-tests.patch	\
  %D%/packages/patches/font-gnu-freefont-python3-compat.patch	\
  %D%/packages/patches/fontconfig-cache-ignore-mtime.patch	\
  %D%/packages/patches/fontforge-hurd.patch			\
  %D%/packages/patches/foobillard++-pkg-config.patch		\
  %D%/packages/patches/foomatic-filters-CVE-2015-8327.patch	\
  %D%/packages/patches/foomatic-filters-CVE-2015-8560.patch	\
  %D%/packages/patches/foxi-fix-build.patch			\
  %D%/packages/patches/fp16-implicit-double.patch		\
  %D%/packages/patches/fp16-system-libraries.patch		\
  %D%/packages/patches/fpc-reproducibility.patch		\
  %D%/packages/patches/fpc-glibc-2.34-compat.patch		\
  %D%/packages/patches/fritzing-0.9.6-fix-types.patch		\
  %D%/packages/patches/freedink-engine-fix-const-char.patch	\
  %D%/packages/patches/freedict-tools-fix-determinism.patch	\
  %D%/packages/patches/freedink-engine-fix-sdl-hints.patch	\
  %D%/packages/patches/freeimage-libtiff-compat.patch		\
  %D%/packages/patches/freeimage-libraw-0.21-compat.patch	\
  %D%/packages/patches/freeimage-unbundle.patch		\
  %D%/packages/patches/freeimage-CVE-2020-21428.patch		\
  %D%/packages/patches/freeimage-CVE-2020-22524.patch		\
  %D%/packages/patches/freesolid-automake.patch			\
  %D%/packages/patches/freesolid-autotools.patch		\
  %D%/packages/patches/freesolid-configure.patch		\
  %D%/packages/patches/freesolid-pkgconfig.patch		\
  %D%/packages/patches/fulcrum-1.9.1-unbundled-libraries.patch	\
  %D%/packages/patches/fuse-glibc-2.34.patch			\
  %D%/packages/patches/fuse-overlapping-headers.patch		\
  %D%/packages/patches/fxdiv-system-libraries.patch		\
  %D%/packages/patches/gajim-honour-GAJIM_PLUGIN_PATH.patch	\
  %D%/packages/patches/ganeti-disable-version-symlinks.patch	\
  %D%/packages/patches/ganeti-haskell-pythondir.patch		\
  %D%/packages/patches/ganeti-lens-compat.patch			\
  %D%/packages/patches/ganeti-openssh-test-fix.patch		\
  %D%/packages/patches/ganeti-pyyaml-compat.patch		\
  %D%/packages/patches/ganeti-procps-compat.patch		\
  %D%/packages/patches/ganeti-reorder-arbitrary-definitions.patch	\
  %D%/packages/patches/ganeti-relax-dependencies.patch		\
  %D%/packages/patches/ganeti-shepherd-master-failover.patch	\
  %D%/packages/patches/ganeti-shepherd-support.patch		\
  %D%/packages/patches/ganeti-sphinx-import.patch		\
  %D%/packages/patches/ganeti-template-haskell-2.17.patch	\
  %D%/packages/patches/ganeti-template-haskell-2.18.patch	\
  %D%/packages/patches/gawk-shell.patch				\
  %D%/packages/patches/gcc-arm-bug-71399.patch			\
  %D%/packages/patches/gcc-arm-link-spec-fix.patch		\
  %D%/packages/patches/gcc-asan-missing-include.patch		\
  %D%/packages/patches/gcc-boot-2.95.3.patch			\
  %D%/packages/patches/gcc-boot-4.6.4.patch			\
  %D%/packages/patches/gcc-cross-environment-variables.patch	\
  %D%/packages/patches/gcc-cross-gxx-include-dir.patch          \
  %D%/packages/patches/gcc-fix-texi2pod.patch			\
  %D%/packages/patches/gcc-libstdc++-newer-gcc.patch		\
  %D%/packages/patches/gcc-4.8-libsanitizer-fix.patch		\
  %D%/packages/patches/gcc-4.9-inline.patch		\
  %D%/packages/patches/gcc-4.9-libsanitizer-fix.patch		\
  %D%/packages/patches/gcc-4.9-libsanitizer-ustat.patch		\
  %D%/packages/patches/gcc-libsanitizer-ustat.patch		\
  %D%/packages/patches/gcc-4.9-libsanitizer-mode-size.patch	\
  %D%/packages/patches/gcc-6-fix-isl-includes.patch	\
  %D%/packages/patches/gcc-6-fix-buffer-size.patch	\
  %D%/packages/patches/gcc-6-libsanitizer-mode-size.patch	\
  %D%/packages/patches/gcc-7-libsanitizer-fsconfig-command.patch \
  %D%/packages/patches/gcc-7-libsanitizer-mode-size.patch	\
  %D%/packages/patches/gcc-libvtv-runpath.patch			\
  %D%/packages/patches/gcc-strmov-store-file-names.patch	\
  %D%/packages/patches/gcc-4-compile-with-gcc-5.patch		 \
  %D%/packages/patches/gcc-4.6-gnu-inline.patch			\
  %D%/packages/patches/gcc-4.9.3-mingw-gthr-default.patch	\
  %D%/packages/patches/gcc-5-hurd.patch				\
  %D%/packages/patches/gcc-5.0-libvtv-runpath.patch		\
  %D%/packages/patches/gcc-5-fix-powerpc64le-build.patch	\
  %D%/packages/patches/gcc-5-source-date-epoch-1.patch		\
  %D%/packages/patches/gcc-5-source-date-epoch-2.patch		\
  %D%/packages/patches/gcc-5.5.0-libstdc++-xmlcatalog.patch	\
  %D%/packages/patches/gcc-6-arm-none-eabi-multilib.patch	\
  %D%/packages/patches/gcc-6-cross-environment-variables.patch	\
  %D%/packages/patches/gcc-6-source-date-epoch-1.patch		\
  %D%/packages/patches/gcc-6-source-date-epoch-2.patch		\
  %D%/packages/patches/gcc-7-cross-mingw.patch			\
  %D%/packages/patches/gcc-7-cross-environment-variables.patch	\
  %D%/packages/patches/gcc-7-cross-toolexeclibdir.patch		\
  %D%/packages/patches/gcc-8-cross-environment-variables.patch	\
  %D%/packages/patches/gcc-8-sort-libtool-find-output.patch	\
  %D%/packages/patches/gcc-8-strmov-store-file-names.patch	\
  %D%/packages/patches/gcc-9-asan-fix-limits-include.patch	\
  %D%/packages/patches/gcc-9-strmov-store-file-names.patch	\
  %D%/packages/patches/gcc-12-strmov-store-file-names.patch	\
  %D%/packages/patches/gcc-10-cross-environment-variables.patch \
  %D%/packages/patches/gcc-10-libsanitizer-no-crypt.patch	\
  %D%/packages/patches/gcc-11-libstdc++-hurd-libpthread.patch   \
  %D%/packages/patches/gcc-12-cross-environment-variables.patch \
  %D%/packages/patches/gcc-11-libstdc++-powerpc.patch           \
  %D%/packages/patches/gcc-13-cross-system-header-dir.patch     \
  %D%/packages/patches/gcc-12-libsanitizer-no-crypt.patch	\
  %D%/packages/patches/gcc-13-libsanitizer-no-crypt.patch	\
  %D%/packages/patches/gcc-13.2.0-libstdc++-docbook-xsl-uri.patch	\
  %D%/packages/patches/gcc-13.2.0-libstdc++-info-install-fix.patch	\
  %D%/packages/patches/gcolor3-update-libportal-usage.patch	\
  %D%/packages/patches/gd-fix-tests-on-i686.patch		\
  %D%/packages/patches/gd-brect-bounds.patch			\
  %D%/packages/patches/gdb-hurd64.patch				\
  %D%/packages/patches/gdb-16-hurd64.patch				\
  %D%/packages/patches/gdbm-lockwait-test.patch			\
  %D%/packages/patches/gdk-pixbuf-honor-GUIX_GDK_PIXBUF_MODULE_FILES.patch	\
  %D%/packages/patches/gdm-default-session.patch		\
  %D%/packages/patches/gdm-remove-hardcoded-xwayland-path.patch	\
  %D%/packages/patches/gdm-wayland-session-wrapper-from-env.patch	\
  %D%/packages/patches/gdm-pass-gdk-pixbuf-loader-env.patch	\
  %D%/packages/patches/gemmi-fix-pegtl-usage.patch		\
  %D%/packages/patches/gemmi-fix-sajson-types.patch		\
  %D%/packages/patches/gemrb-remove-ifdef-and-externalize-path-setting-to-cmake.patch	\
  %D%/packages/patches/genimage-mke2fs-test.patch		\
  %D%/packages/patches/geoclue-config.patch			\
  %D%/packages/patches/gettext-libunicode-update.patch		\
  %D%/packages/patches/ghc-8.0-fall-back-to-madv_dontneed.patch	\
  %D%/packages/patches/ghc-9.2-cabal-support-package-path.patch \
  %D%/packages/patches/ghc-9-StgCRunAsm-only-when-needed.patch	\
  %D%/packages/patches/ghc-9.2-grep-warnings.patch \
  %D%/packages/patches/ghc-basement-fix-32-bit.patch		\
  %D%/packages/patches/ghc-testsuite-dlopen-pie.patch		\
  %D%/packages/patches/ghc-testsuite-grep-compat.patch		\
  %D%/packages/patches/ghc-testsuite-recomp015-execstack.patch	\
  %D%/packages/patches/ghc-aeson-encodeDouble.patch		\
  %D%/packages/patches/ghc-basement-fix-32bit.patch		\
  %D%/packages/patches/ghc-bytestring-handle-ghc9.patch	\
  %D%/packages/patches/ghc-clock-realfrag.patch	\
  %D%/packages/patches/ghc-language-haskell-extract-ghc-8.10.patch	\
  %D%/packages/patches/ghc-memory-fix-32bit.patch		\
  %D%/packages/patches/ghc-persistent-fix-32bit.patch		\
  %D%/packages/patches/ghc-unique-support-newer-hashable.patch	\
  %D%/packages/patches/ghostscript-CVE-2023-36664.patch		\
  %D%/packages/patches/ghostscript-CVE-2023-36664-fixup.patch	\
  %D%/packages/patches/ghostscript-leptonica-hurd.patch		\
  %D%/packages/patches/ghostscript-no-header-id.patch		\
  %D%/packages/patches/ghostscript-no-header-uuid.patch		\
  %D%/packages/patches/ghostscript-no-header-creationdate.patch \
  %D%/packages/patches/gimp-fix-metadata-editor.patch		\
  %D%/packages/patches/gimp-fix-tiff-load.patch			\
  %D%/packages/patches/git-clar-path-max.patch			\
  %D%/packages/patches/git-filter-repo-generate-doc.patch	\
  %D%/packages/patches/gklib-suitesparse.patch			\
  %D%/packages/patches/glib-appinfo-watch.patch			\
  %D%/packages/patches/glib-skip-failing-test.patch		\
  %D%/packages/patches/glibc-2.33-riscv64-miscompilation.patch	\
  %D%/packages/patches/glibc-2.35-CVE-2023-4911.patch	\
  %D%/packages/patches/glibc-2.37-hurd-clock_t_centiseconds.patch	\
  %D%/packages/patches/glibc-2.37-versioned-locpath.patch	\
  %D%/packages/patches/glibc-2.38-ldd-x86_64.patch		\
  %D%/packages/patches/glibc-2.39-git-updates.patch	\
  %D%/packages/patches/glibc-2.40-dl-cache.patch		\
  %D%/packages/patches/glibc-2.41-bootstrap-system.patch	\
  %D%/packages/patches/glibc-2.41-hurd-local-clock_gettime_MONOTONIC.patch	\
  %D%/packages/patches/glibc-2.41-ldd-x86_64.patch		\
  %D%/packages/patches/glibc-allow-kernel-2.6.32.patch		\
  %D%/packages/patches/glibc-boot-2.2.5.patch			\
  %D%/packages/patches/glibc-boot-2.16.0.patch			\
  %D%/packages/patches/glibc-bootstrap-system-2.2.5.patch 	\
  %D%/packages/patches/glibc-bootstrap-system-2.16.0.patch 	\
  %D%/packages/patches/glibc-bootstrap-system.patch		\
  %D%/packages/patches/glibc-cross-objcopy.patch		\
  %D%/packages/patches/glibc-cross-objdump.patch		\
  %D%/packages/patches/glibc-dl-cache.patch			\
  %D%/packages/patches/glibc-hidden-visibility-ldconfig.patch	\
  %D%/packages/patches/glibc-hurd-clock_gettime_monotonic.patch	\
  %D%/packages/patches/glibc-hurd-clock_t_centiseconds.patch	\
  %D%/packages/patches/glibc-hurd-getauxval.patch		\
  %D%/packages/patches/glibc-hurd-gettyent.patch		\
  %D%/packages/patches/glibc-hurd-mach-print.patch		\
  %D%/packages/patches/glibc-hurd-pthread_setcancelstate.patch	\
  %D%/packages/patches/glibc-hurd-signal-fpe-exception.patch 	\
  %D%/packages/patches/glibc-hurd-signal-sa-siginfo.patch	\
  %D%/packages/patches/glibc-hurd-2.41-pthread-once.patch	\
  %D%/packages/patches/glibc-hurd-2.41-pthread-sigmask.patch	\
  %D%/packages/patches/glibc-hurd-2.41-symlink.patch		\
  %D%/packages/patches/glibc-hurd-xstate.patch  		\
  %D%/packages/patches/glibc-hurd64-gcc-14.2-tls-bug.patch	\
  %D%/packages/patches/glibc-hurd64-intr-msg-clobber.patch	\
  %D%/packages/patches/glibc-ldd-powerpc.patch			\
  %D%/packages/patches/glibc-ldd-x86_64.patch			\
  %D%/packages/patches/glibc-locales.patch			\
  %D%/packages/patches/glibc-reinstate-prlimit64-fallback.patch	\
  %D%/packages/patches/glibc-supported-locales.patch     	\
  %D%/packages/patches/glibc-versioned-locpath.patch		\
  %D%/packages/patches/gmime-disable-tests.patch		\
  %D%/packages/patches/gmp-arm-asm-nothumb.patch		\
  %D%/packages/patches/gmp-faulty-test.patch			\
  %D%/packages/patches/gnome-2048-fix-positional-argument.patch	\
  %D%/packages/patches/gnome-control-center-firmware-security.patch	\
  %D%/packages/patches/gnome-control-center-libexecdir.patch	\
  %D%/packages/patches/gnome-dictionary-meson-i18n.patch	\
  %D%/packages/patches/gnome-online-miners-tracker-3.patch	\
  %D%/packages/patches/gnome-settings-daemon-gc.patch		\
  %D%/packages/patches/gnome-settings-daemon-screensaver-error.patch	\
  %D%/packages/patches/gnome-session-support-elogind.patch	\
  %D%/packages/patches/gnome-tweaks-search-paths.patch		\
  %D%/packages/patches/gnulib-bootstrap.patch			\
  %D%/packages/patches/gnumach-div0.patch			\
  %D%/packages/patches/gnumach-version.patch			\
  %D%/packages/patches/gnupg-default-pinentry.patch		\
  %D%/packages/patches/gnupg-1-build-with-gcc10.patch		\
  %D%/packages/patches/gnutls-skip-trust-store-test.patch	\
  %D%/packages/patches/gobject-introspection-absolute-shlib-path.patch \
  %D%/packages/patches/gobject-introspection-absolute-shlib-path-1.72.patch \
  %D%/packages/patches/gobject-introspection-cc.patch		\
  %D%/packages/patches/gobject-introspection-cc-1.72.patch	\
  %D%/packages/patches/gobject-introspection-girepository.patch	\
  %D%/packages/patches/go-fix-script-tests.patch			\
  %D%/packages/patches/go-gopkg-in-yaml-v3-32bit.patch		\
  %D%/packages/patches/go-github-com-golang-snappy-32bit-test.patch \
  %D%/packages/patches/go-github-com-jbenet-go-context-fix-import-error.patch	\
  %D%/packages/patches/go-github-com-skip2-go-qrcode-fix-tests.patch \
  %D%/packages/patches/go-github-com-warpfork-go-wish-fix-tests.patch \
  %D%/packages/patches/go-github-com-wraparound-wrap-free-fonts.patch \
  %D%/packages/patches/go-skip-gc-test.patch			\
  %D%/packages/patches/godot-libjpeg-turbo-unbundle.patch	\
  %D%/packages/patches/gourmet-sqlalchemy-compat.patch		\
  %D%/packages/patches/gpaste-fix-paths.patch			\
  %D%/packages/patches/gpm-glibc-2.26.patch			\
  %D%/packages/patches/gpodder-disable-updater.patch		\
  %D%/packages/patches/grantlee-fix-i586-precision.patch	\
  %D%/packages/patches/grantlee-register-metaenumvariable.patch	\
  %D%/packages/patches/grep-timing-sensitive-test.patch		\
  %D%/packages/patches/grfcodec-gcc-compat.patch		\
  %D%/packages/patches/groovy-add-exceptionutilsgenerator.patch	\
  %D%/packages/patches/grub-efi-fat-serial-number.patch		\
  %D%/packages/patches/grub-hurd64.patch			\
  %D%/packages/patches/grub-setup-root.patch			\
  %D%/packages/patches/guile-1.8-cpp-4.5.patch			\
  %D%/packages/patches/guile-2.2-skip-oom-test.patch            \
  %D%/packages/patches/guile-2.2-skip-so-test.patch             \
  %D%/packages/patches/guile-default-utf8.patch			\
  %D%/packages/patches/guile-2.2-default-utf8.patch		\
  %D%/packages/patches/guile-relocatable.patch			\
  %D%/packages/patches/guile-3.0-relocatable.patch		\
  %D%/packages/patches/guile-linux-syscalls.patch		\
  %D%/packages/patches/guile-3.0-linux-syscalls.patch		\
  %D%/packages/patches/guile-ac-d-bus-fix-tests.patch		\
  %D%/packages/patches/guile-lib-fix-tests-for-guile2.2.patch		\
  %D%/packages/patches/guile-fibers-cross-build-fix.patch 	\
  %D%/packages/patches/guile-fibers-destroy-peer-schedulers.patch \
  %D%/packages/patches/guile-fibers-epoll-instance-is-dead.patch \
  %D%/packages/patches/guile-fibers-fd-finalizer-leak.patch	\
  %D%/packages/patches/guile-fibers-wait-for-io-readiness.patch \
  %D%/packages/patches/guile-fibers-libevent-32-bit.patch	\
  %D%/packages/patches/guile-fibers-libevent-timeout.patch	\
  %D%/packages/patches/guile-fix-invalid-unicode-handling.patch \
  %D%/packages/patches/guile-gdbm-ffi-support-gdbm-1.14.patch	\
  %D%/packages/patches/guile-gi-fix-marshall-tests.patch	\
  %D%/packages/patches/guile-hurd-posix-spawn.patch		\
  %D%/packages/patches/guile-lzlib-gcc-14.patch			\
  %D%/packages/patches/guile-lzlib-hurd64.patch			\
  %D%/packages/patches/guile-present-coding.patch		\
  %D%/packages/patches/guile-rsvg-pkgconfig.patch		\
  %D%/packages/patches/gtk2-fix-builder-test.patch		\
  %D%/packages/patches/gtk2-harden-list-store.patch		\
  %D%/packages/patches/gtk2-respect-GUIX_GTK2_PATH.patch	\
  %D%/packages/patches/gtk2-respect-GUIX_GTK2_IM_MODULE_FILE.patch \
  %D%/packages/patches/gtk2-theme-paths.patch			\
  %D%/packages/patches/gtk3-respect-GUIX_GTK3_PATH.patch	\
  %D%/packages/patches/gtk3-respect-GUIX_GTK3_IM_MODULE_FILE.patch \
  %D%/packages/patches/gtk-doc-respect-xml-catalog.patch	\
  %D%/packages/patches/gtk-doc-mkhtml-test-fix.patch	\
  %D%/packages/patches/gtk4-respect-GUIX_GTK4_PATH.patch    	\
  %D%/packages/patches/gtkglext-disable-disable-deprecated.patch \
  %D%/packages/patches/gtksourceview-2-add-default-directory.patch \
  %D%/packages/patches/gzdoom-search-in-installed-share.patch	\
  %D%/packages/patches/gzdoom-find-system-libgme.patch	\
  %D%/packages/patches/hare-fallback-cache.patch 		\
  %D%/packages/patches/hare-toolpath.patch 		\
  %D%/packages/patches/hdf4-reproducibility.patch 		\
  %D%/packages/patches/hdf4-shared-fortran.patch 		\
  %D%/packages/patches/hdf5-config-date.patch			\
  %D%/packages/patches/hdf-eos2-build-shared.patch 		\
  %D%/packages/patches/hdf-eos2-remove-gctp.patch		\
  %D%/packages/patches/hdf-eos2-fortrantests.patch		\
  %D%/packages/patches/hdf-eos5-build-shared.patch 		\
  %D%/packages/patches/hdf-eos5-remove-gctp.patch		\
  %D%/packages/patches/hdf-eos5-fix-szip.patch			\
  %D%/packages/patches/hdf-eos5-fortrantests.patch		\
  %D%/packages/patches/heatshrink-add-cmake.patch		\
  %D%/packages/patches/heimdal-CVE-2022-45142.patch		\
  %D%/packages/patches/helm-fix-gcc-9-build.patch		\
  %D%/packages/patches/highlight-gui-data-dir.patch		\
  %D%/packages/patches/hplip-usb-timeout.patch			\
  %D%/packages/patches/http-parser-CVE-2020-8287.patch		\
  %D%/packages/patches/hubbub-sort-entities.patch		\
  %D%/packages/patches/hueplusplus-mbedtls.patch		\
  %D%/packages/patches/hugs-fix-build.patch			\
  %D%/packages/patches/hurd-refcounts-assert.patch		\
  %D%/packages/patches/hurd-rumpdisk-no-hd.patch		\
  %D%/packages/patches/hurd-startup.patch			\
  %D%/packages/patches/hurd-proc-zombies.patch			\
  %D%/packages/patches/hwloc-1-test-btrfs.patch			\
  %D%/packages/patches/i3lock-blur-fix-build-on-gcc-10.patch	\
  %D%/packages/patches/i7z-gcc-10.patch				\
  %D%/packages/patches/icecat-adjust-mozilla-desktop.patch      \
  %D%/packages/patches/icecat-makeicecat.patch			\
  %D%/packages/patches/icecat-avoid-bundled-libraries.patch	\
  %D%/packages/patches/icecat-compare-paths.patch		\
  %D%/packages/patches/icecat-fhs-configure-option.patch        \
  %D%/packages/patches/icecat-use-system-graphite2+harfbuzz.patch	\
  %D%/packages/patches/icecat-use-system-media-libs.patch	\
  %D%/packages/patches/icecat-use-system-wide-dir.patch		\
  %D%/packages/patches/icedove-observer-fix.patch               \
  %D%/packages/patches/icedtea-7-hotspot-aarch64-use-c++98.patch	\
  %D%/packages/patches/icedtea-7-hotspot-pointer-comparison.patch	\
  %D%/packages/patches/icu4c-icu-22132-fix-vtimezone.patch	\
  %D%/packages/patches/icu4c-fix-TestHebrewCalendarInTemporalLeapYear.patch	\
  %D%/packages/patches/id3lib-CVE-2007-4460.patch			\
  %D%/packages/patches/id3lib-UTF16-writing-bug.patch			\
  %D%/packages/patches/idris-test-ffi008.patch			\
  %D%/packages/patches/ilmbase-fix-tests.patch			\
  %D%/packages/patches/inferno-fix-crash.patch		\
  %D%/packages/patches/inkscape-libxml2.patch		\
  %D%/packages/patches/instead-use-games-path.patch		\
  %D%/packages/patches/intltool-perl-compatibility.patch	\
  %D%/packages/patches/inetutils-hurd64.patch			\
  %D%/packages/patches/insight-toolkit-fix-build.patch			\
  %D%/packages/patches/irrlicht-use-system-libs.patch		\
  %D%/packages/patches/irrlicht-link-against-needed-libs.patch	\
  %D%/packages/patches/isl-0.11.1-aarch64-support.patch		\
  %D%/packages/patches/ispell-for-linphone-cmake.patch		\
  %D%/packages/patches/jami-find-package-avutil.patch		\
  %D%/packages/patches/jami-libjami-headers-search.patch	\
  %D%/packages/patches/jami-qwindowkit.patch			\
  %D%/packages/patches/jami-skip-tests-requiring-internet.patch	\
  %D%/packages/patches/jami-unbundle-dependencies.patch		\
  %D%/packages/patches/jamvm-1.5.1-aarch64-support.patch	\
  %D%/packages/patches/jamvm-1.5.1-armv7-support.patch	\
  %D%/packages/patches/jamvm-2.0.0-aarch64-support.patch	\
  %D%/packages/patches/jamvm-2.0.0-disable-branch-patching.patch	\
  %D%/packages/patches/jamvm-2.0.0-opcode-guard.patch		\
  %D%/packages/patches/java-antlr4-Add-standalone-generator.patch	\
  %D%/packages/patches/java-tunnelvisionlabs-antlr-code-too-large.patch	\
  %D%/packages/patches/java-apache-ivy-port-to-latest-bouncycastle.patch	\
  %D%/packages/patches/java-commons-collections-fix-java8.patch \
  %D%/packages/patches/java-commons-lang-fix-dependency.patch \
  %D%/packages/patches/java-guava-remove-annotation-deps.patch \
  %D%/packages/patches/java-jeromq-fix-tests.patch		\
  %D%/packages/patches/java-openjfx-build-jdk_version.patch     \
  %D%/packages/patches/java-powermock-fix-java-files.patch		\
  %D%/packages/patches/java-simple-xml-fix-tests.patch		\
  %D%/packages/patches/java-svg-salamander-Fix-non-det.patch	\
  %D%/packages/patches/java-xerces-bootclasspath.patch	\
  %D%/packages/patches/java-xerces-build_dont_unzip.patch	\
  %D%/packages/patches/java-xerces-xjavac_taskdef.patch	\
  %D%/packages/patches/jbr-17-xcursor-no-dynamic.patch	\
  %D%/packages/patches/jdk-currency-time-bomb.patch		\
  %D%/packages/patches/jdk-currency-time-bomb2.patch		\
  %D%/packages/patches/jfsutils-add-sysmacros.patch		\
  %D%/packages/patches/jfsutils-gcc-compat.patch		\
  %D%/packages/patches/jfsutils-include-systypes.patch		\
  %D%/packages/patches/john-the-ripper-jumbo-with-gcc-11.patch	\
  %D%/packages/patches/json-c-0.12-CVE-2020-12762.patch		\
  %D%/packages/patches/json-c-0.13-CVE-2020-12762.patch		\
  %D%/packages/patches/jsonnet-include-cstdint-for-gcc-13-builds.patch	\
  %D%/packages/patches/julia-SOURCE_DATE_EPOCH-mtime.patch	\
  %D%/packages/patches/julia-Use-MPFR-4.2.patch	                \
  %D%/packages/patches/komikku-python-3.11-compat.patch	                \
  %D%/packages/patches/komikku-future-servers-compat.patch	                \
  %D%/packages/patches/libcall-ui-make-it-installable.patch	\
  %D%/packages/patches/libcamera-ipa_manager-disable-signature-verification.patch	\
  %D%/packages/patches/libconfuse-CVE-2022-40320.patch		\
  %D%/packages/patches/libcss-check-format.patch		\
  %D%/packages/patches/libeb-gcc-14.patch			\
  %D%/packages/patches/libextractor-tidy-support.patch		\
  %D%/packages/patches/libftdi-fix-paths-when-FTDIPP-set.patch	\
  %D%/packages/patches/libgeotiff-fix-tests-with-proj-9.1.1.patch	\
  %D%/packages/patches/libgeotiff-fix-tests-with-proj-9.3.0.patch	\
  %D%/packages/patches/libgeotiff-fix-tests-with-proj-9.3.1.patch	\
  %D%/packages/patches/libgeotiff-fix-tests-on-i386.patch	\
  %D%/packages/patches/libguestfs-syms.patch            	\
  %D%/packages/patches/libinfinity-renew-test-certificate.patch \
  %D%/packages/patches/libretro-dolphin-emu-data.patch		\
  %D%/packages/patches/libretro-dolphin-emu-gc-font-tool.patch  \
  %D%/packages/patches/libretro-dolphin-emu-libusb-assert.patch \
  %D%/packages/patches/libretro-dolphin-emu-vulkan-headers.patch        \
  %D%/packages/patches/librewolf-add-store-to-rdd-allowlist.patch       \
  %D%/packages/patches/librewolf-compare-paths.patch		\
  %D%/packages/patches/librewolf-neuter-locale-download.patch	\
  %D%/packages/patches/librewolf-use-system-wide-dir.patch	\
  %D%/packages/patches/libvirt-add-install-prefix.patch	\
  %D%/packages/patches/libvirt-respect-modules-path.patch	\
  %D%/packages/patches/libzmf-doxygen-1.14.patch		\
  %D%/packages/patches/libziparchive-add-includes.patch		\
  %D%/packages/patches/lightdm-arguments-ordering.patch		\
  %D%/packages/patches/lightdm-vnc-ipv6.patch			\
  %D%/packages/patches/lightdm-vnc-color-depth.patch		\
  %D%/packages/patches/lightdm-vncserver-check.patch		\
  %D%/packages/patches/linphone-desktop-cmake-belcard.patch	\
  %D%/packages/patches/linphone-desktop-cmake-find-modules.patch	\
  %D%/packages/patches/localed-xorg-keyboard.patch		\
  %D%/packages/patches/kaldi-ignore-failing-test.patch		\
  %D%/packages/patches/kaldi-openblas-0.3.29-compatibility.patch	\
  %D%/packages/patches/kcontacts-incorrect-country-name.patch	\
  %D%/packages/patches/kde-cli-tools-delay-mime-db.patch	\
  %D%/packages/patches/kdiagram-Fix-missing-link-libraries.patch \
  %D%/packages/patches/kiki-level-selection-crash.patch		\
  %D%/packages/patches/kiki-makefile.patch			\
  %D%/packages/patches/kiki-missing-includes.patch		\
  %D%/packages/patches/kiki-portability-64bit.patch		\
  %D%/packages/patches/kinit-kdeinit-extra_libs.patch		\
  %D%/packages/patches/kio-search-smbd-on-PATH.patch		\
  %D%/packages/patches/kismet-unbundle-boost.patch		\
  %D%/packages/patches/kissfft-tflite-micro.patch               \
  %D%/packages/patches/kitty-fix-wayland-protocols.patch	\
  %D%/packages/patches/kmod-module-directory.patch		\
  %D%/packages/patches/kmscon-runtime-keymap-switch.patch	\
  %D%/packages/patches/knot-remove-runtime-deps.patch		\
  %D%/packages/patches/kobodeluxe-paths.patch			\
  %D%/packages/patches/kobodeluxe-enemies-pipe-decl.patch	\
  %D%/packages/patches/kobodeluxe-const-charp-conversion.patch	\
  %D%/packages/patches/kobodeluxe-manpage-minus-not-hyphen.patch	\
  %D%/packages/patches/kobodeluxe-midicon-segmentation-fault.patch	\
  %D%/packages/patches/kobodeluxe-graphics-window-signed-char.patch	\
  %D%/packages/patches/kodi-set-libcurl-ssl-parameters.patch		\
  %D%/packages/patches/krita-bump-sip-abi-version-to-12.8.patch	\
  %D%/packages/patches/kvantum-1.1.5-xdg-dirs-support.patch	\
  %D%/packages/patches/kwayland-5-fix-build.patch		\
  %D%/packages/patches/kwin-unwrap-executable-name-for-dot-desktop-search.patch\
  %D%/packages/patches/laby-make-install.patch			\
  %D%/packages/patches/laby-use-tmpdir-from-runtime.patch	\
  %D%/packages/patches/ldns-drill-examples.patch		\
  %D%/packages/patches/leela-zero-gtest.patch			\
  %D%/packages/patches/less-hurd-path-max.patch			\
  %D%/packages/patches/libaio-32bit-test.patch                  \
  %D%/packages/patches/libaio-riscv-test5.patch			\
  %D%/packages/patches/libbase-fix-includes.patch		\
  %D%/packages/patches/libbase-use-own-logging.patch		\
  %D%/packages/patches/libbonobo-activation-test-race.patch	\
  %D%/packages/patches/libbraiding-no-s.patch                   \
  %D%/packages/patches/libcaca-CVE-2021-3410-pt1.patch		\
  %D%/packages/patches/libcaca-CVE-2021-3410-pt2.patch		\
  %D%/packages/patches/libcap-magic-glibc-constant.patch	\
  %D%/packages/patches/libcanberra-sound-theme-freedesktop.patch \
  %D%/packages/patches/libcanberra-wayland-crash.patch \
  %D%/packages/patches/libcroco-CVE-2020-12825.patch		\
  %D%/packages/patches/libcyaml-libyaml-compat.patch		\
  %D%/packages/patches/libexpected-use-provided-catch2.patch	\
  %D%/packages/patches/libfaketime-32bit.patch			\
  %D%/packages/patches/libgcrypt-arm32-register-pressure.patch	\
  %D%/packages/patches/libgda-CVE-2021-39359.patch		\
  %D%/packages/patches/libgda-disable-data-proxy-test.patch     \
  %D%/packages/patches/libgda-fix-build.patch			\
  %D%/packages/patches/libgda-fix-missing-initialization.patch	\
  %D%/packages/patches/libgda-skip-postgresql-tests.patch	\
  %D%/packages/patches/libgdata-fix-tests.patch	\
  %D%/packages/patches/libgit2-mtime-0.patch			\
  %D%/packages/patches/libgit2-path-max.patch			\
  %D%/packages/patches/libgit2-proxy-reconnection.patch		\
  %D%/packages/patches/libgit2-uninitialized-proxy-settings.patch	\
  %D%/packages/patches/libgnome-encoding.patch			\
  %D%/packages/patches/libgnomeui-utf8.patch			\
  %D%/packages/patches/libgrss-CVE-2016-2001.patch		\
  %D%/packages/patches/libjxr-fix-function-signature.patch	\
  %D%/packages/patches/libjxr-fix-typos.patch			\
  %D%/packages/patches/libofa-ftbfs-1.diff		\
  %D%/packages/patches/libofa-curl.diff		\
  %D%/packages/patches/libofa-ftbfs-2.diff		\
  %D%/packages/patches/libosinfo-libxml2-fix.patch		\
  %D%/packages/patches/libotr-test-auth-fix.patch		\
  %D%/packages/patches/libksieve-Fix-missing-link-libraries.patch \
  %D%/packages/patches/libmad-armv7-thumb-pt1.patch		\
  %D%/packages/patches/libmad-armv7-thumb-pt2.patch		\
  %D%/packages/patches/libmad-length-check.patch		\
  %D%/packages/patches/libmad-md_size.patch			\
  %D%/packages/patches/libmad-mips-newgcc.patch			\
  %D%/packages/patches/libmp4v2-c++11.patch			\
  %D%/packages/patches/libmpeg2-arm-private-symbols.patch	\
  %D%/packages/patches/libmpeg2-global-symbol-test.patch	\
  %D%/packages/patches/liblinphone-jsoncpp.patch		\
  %D%/packages/patches/libphonenumber-reproducible-build.patch	\
  %D%/packages/patches/libqalculate-3.8.0-libcurl-ssl-fix.patch	\
  %D%/packages/patches/libquicktime-ffmpeg.patch 		\
  %D%/packages/patches/libsecret-fix-test-paths.patch		\
  %D%/packages/patches/libsepol-versioned-docbook.patch		\
  %D%/packages/patches/libskk-fix-invalid-escape.patch		\
  %D%/packages/patches/libspatialite-libxml2-2.14.patch		\
  %D%/packages/patches/libtar-CVE-2013-4420.patch 		\
  %D%/packages/patches/libtar-CVE-2021-33643-CVE-2021-33644.patch	\
  %D%/packages/patches/libtar-CVE-2021-33645-CVE-2021-33646.patch	\
  %D%/packages/patches/libtgvoip-disable-sse2.patch 		\
  %D%/packages/patches/libtgvoip-disable-webrtc.patch 		\
  %D%/packages/patches/libtheora-config-guess.patch		\
  %D%/packages/patches/libtiff-CVE-2022-34526.patch		\
  %D%/packages/patches/libtirpc-CVE-2021-46828.patch		\
  %D%/packages/patches/libtirpc-hurd.patch			\
  %D%/packages/patches/libtool-grep-compat.patch		\
  %D%/packages/patches/libtool-skip-tests2.patch		\
  %D%/packages/patches/libtree-fix-check-non-x86.patch		\
  %D%/packages/patches/libusb-0.1-disable-tests.patch		\
  %D%/packages/patches/libusb-for-axoloti.patch			\
  %D%/packages/patches/libutils-add-includes.patch		\
  %D%/packages/patches/libutils-remove-damaging-includes.patch	\
  %D%/packages/patches/libvdpau-va-gl-unbundle.patch		\
  %D%/packages/patches/libvpx-CVE-2016-2818.patch		\
  %D%/packages/patches/libxcb-path-max.patch			\
  %D%/packages/patches/libxml2-xpath0-Add-option-xpath0.patch	\
  %D%/packages/patches/libwpd-gcc-compat.patch			\
  %D%/packages/patches/libxt-guix-search-paths.patch		\
  %D%/packages/patches/lierolibre-check-unaligned-access.patch	\
  %D%/packages/patches/lierolibre-is-free-software.patch	\
  %D%/packages/patches/lierolibre-newer-libconfig.patch		\
  %D%/packages/patches/lierolibre-remove-arch-warning.patch	\
  %D%/packages/patches/lierolibre-try-building-other-arch.patch	\
  %D%/packages/patches/libcdio-glibc-compat.patch		\
  %D%/packages/patches/linphone-desktop-ispell.patch	\
  %D%/packages/patches/linphone-desktop-qtkeychain.patch	\
  %D%/packages/patches/linux-libre-infodocs-target.patch	\
  %D%/packages/patches/linux-libre-support-for-Pinebook-Pro.patch \
  %D%/packages/patches/linux-libre-arm64-mnt-reform-revert-phy-rockchip-samsung.patch	\
  %D%/packages/patches/linux-libre-arm64-mnt-reform-revert-rk-samsung-hdptx.patch	\
  %D%/packages/patches/linux-libre-arm64-mnt-reform-revert-vop2-display-modes.patch	\
  %D%/packages/patches/linux-pam-no-setfsuid.patch		\
  %D%/packages/patches/linux-pam-unix_chkpwd.patch		\
  %D%/packages/patches/lirc-localstatedir.patch			\
  %D%/packages/patches/lirc-reproducible-build.patch		\
  %D%/packages/patches/llvm-13-gcc-14.patch			\
  %D%/packages/patches/lm-sensors-hwmon-attrs.patch		\
  %D%/packages/patches/lsof-compat-linux-6.9.patch		\
  %D%/packages/patches/lsof-fatal-test-failures.patch		\
  %D%/packages/patches/lua-CVE-2014-5461.patch                      \
  %D%/packages/patches/lua-pkgconfig.patch                      \
  %D%/packages/patches/lua51-liblua-so.patch                    \
  %D%/packages/patches/lua51-pkgconfig.patch                    \
  %D%/packages/patches/luajit-add-riscv64-support.patch         \
  %D%/packages/patches/lua-liblua-so.patch                      \
  %D%/packages/patches/lua-5.4-pkgconfig.patch			\
  %D%/packages/patches/lua-5.4-liblua-so.patch			\
  %D%/packages/patches/luanti-paths.patch			\
  %D%/packages/patches/lugaru-fix-sound.patch			\
  %D%/packages/patches/luit-posix.patch				\
  %D%/packages/patches/lxc-no-static-bin.patch	\
  %D%/packages/patches/lxsession-potfiles-ignore.patch		\
  %D%/packages/patches/mactelnet-remove-init.patch		\
  %D%/packages/patches/mailutils-variable-lookup.patch		\
  %D%/packages/patches/mandoc-support-zstd-compression.patch	\
  %D%/packages/patches/make-impure-dirs.patch			\
  %D%/packages/patches/makem-replace-git.patch			\
  %D%/packages/patches/marisa-fix-MARISA_WORD_SIZE.patch	\
  %D%/packages/patches/mash-add-missing-headers.patch           \
  %D%/packages/patches/mathjax-disable-webpack.patch			\
  %D%/packages/patches/mathjax-no-a11y.patch			\
  %D%/packages/patches/mathjax-3.1.2-no-a11y.patch		\
  %D%/packages/patches/maxima-defsystem-mkdir.patch		\
  %D%/packages/patches/maven-generate-component-xml.patch		\
  %D%/packages/patches/maven-generate-javax-inject-named.patch		\
  %D%/packages/patches/mc2mt-add-packaging-support.patch	\
  %D%/packages/patches/mcrypt-CVE-2012-4409.patch			\
  %D%/packages/patches/mcrypt-CVE-2012-4426.patch			\
  %D%/packages/patches/mcrypt-CVE-2012-4527.patch			\
  %D%/packages/patches/mono-msbuild-15.7.179-fix-build.patch	\
  %D%/packages/patches/mono-msbuild-15.7.179-fix-resources.patch	\
  %D%/packages/patches/libmemcached-build-with-gcc7.patch	\
  %D%/packages/patches/libmhash-hmac-fix-uaf.patch		\
  %D%/packages/patches/libmodbus-disable-networking-test.patch \
  %D%/packages/patches/lib-tl-for-telegram-memcpy.patch	\
  %D%/packages/patches/llhttp-ponyfill-object-fromentries.patch	\
  %D%/packages/patches/lvm2-no-systemd.patch    		\
  %D%/packages/patches/maturin-no-cross-compile.patch		\
  %D%/packages/patches/mecab-variable-param.patch		\
  %D%/packages/patches/mediastreamer2-cmake-findgsm.patch	\
  %D%/packages/patches/mediasdk-gcc-14.patch			\
  %D%/packages/patches/memtest86+-build-reproducibly.patch	\
  %D%/packages/patches/mercurial-hg-extension-path.patch	\
  %D%/packages/patches/mhash-keygen-test-segfault.patch		\
  %D%/packages/patches/mia-fix-boost-headers.patch		\
  %D%/packages/patches/mia-gcc11.patch				\
  %D%/packages/patches/mia-openexr3.patch			\
  %D%/packages/patches/mia-vtk9.patch				\
  %D%/packages/patches/mia-vtk92.patch				\
  %D%/packages/patches/mia-vtk-version.patch			\
  %D%/packages/patches/minisat-friend-declaration.patch		\
  %D%/packages/patches/minisat-install.patch			\
  %D%/packages/patches/miniz-for-pytorch.patch			\
  %D%/packages/patches/mit-krb5-hurd.patch			\
  %D%/packages/patches/mpc123-initialize-ao.patch		\
  %D%/packages/patches/mpg321-CVE-2019-14247.patch		\
  %D%/packages/patches/mpg321-gcc-10.patch			\
  %D%/packages/patches/mpv-0.40.0-fix-ffmpeg-8.0.patch		\
  %D%/packages/patches/mpv-0.40.0-fix-wayland-cpu-usage.patch	\
  %D%/packages/patches/modglue-fix-build.patch		\
  %D%/packages/patches/modem-manager-fix-test-wrapper.patch	\
  %D%/packages/patches/module-init-tools-moduledir.patch	\
  %D%/packages/patches/monero-use-system-miniupnpc.patch			\
  %D%/packages/patches/mono-1.2.6-bootstrap.patch		\
  %D%/packages/patches/mono-1.9.1-add-MONO_CREATE_IMAGE_VERSION.patch		\
  %D%/packages/patches/mono-1.9.1-fixes.patch			\
  %D%/packages/patches/mono-1.9.1-reproducibility.patch	\
  %D%/packages/patches/mono-2.4.2.3-fixes.patch			\
  %D%/packages/patches/mono-2.4.2.3-fix-parallel-builds.patch	\
  %D%/packages/patches/mono-2.4.2.3-reproducibility.patch	\
  %D%/packages/patches/mono-2.6.4-fixes.patch			\
  %D%/packages/patches/mono-2.11.4-fixes.patch			\
  %D%/packages/patches/mono-4.9.0-fix-runtimemetadataversion.patch		\
  %D%/packages/patches/mono-5.4.0-patches.patch		\
  %D%/packages/patches/mono-5.8.0-patches.patch		\
  %D%/packages/patches/mono-5.10.0-later-mcs-changes.patch	\
  %D%/packages/patches/mono-6.12.0-add-runpath.patch		\
  %D%/packages/patches/mono-6.12.0-fix-AssemblyResolver.patch	\
  %D%/packages/patches/mono-6.12.0-fix-ConditionParser.patch	\
  %D%/packages/patches/mono-mcs-patches-from-5.10.0.patch	\
  %D%/packages/patches/mosaicatcher-unbundle-htslib.patch	\
  %D%/packages/patches/mrrescue-support-love-11.patch		\
  %D%/packages/patches/mrustc-patches.patch			\
  %D%/packages/patches/mswebrtc-b64-refactor.patch		\
  %D%/packages/patches/mswebrtc-cmake.patch			\
  %D%/packages/patches/mtools-mformat-uninitialized.patch	\
  %D%/packages/patches/mupen64plus-ui-console-notice.patch	\
  %D%/packages/patches/musl-cross-locale.patch			\
  %D%/packages/patches/mutt-store-references.patch		\
  %D%/packages/patches/m17n-lib-1.8.0-use-pkg-config-for-freetype.patch	\
  %D%/packages/patches/nanosvg-prusa-slicer.patch		\
  %D%/packages/patches/nautilus-extension-search-path.patch	\
  %D%/packages/patches/ncompress-fix-softlinks.patch		\
  %D%/packages/patches/ncftp-paths.patch				\
  %D%/packages/patches/ncftp-reproducible.patch			\
  %D%/packages/patches/netcdf-date-time.patch			\
  %D%/packages/patches/netdde-build-fix.patch			\
  %D%/packages/patches/netdde-csum.patch			\
  %D%/packages/patches/netpbm-CVE-2017-2586.patch		\
  %D%/packages/patches/netpbm-CVE-2017-2587.patch		\
  %D%/packages/patches/netsurf-message-timestamp.patch		\
  %D%/packages/patches/netsurf-system-utf8proc.patch		\
  %D%/packages/patches/netsurf-y2038-tests.patch		\
  %D%/packages/patches/netsurf-longer-test-timeout.patch	\
  %D%/packages/patches/nextpnr-gtest.patch			\
  %D%/packages/patches/nextpnr-imgui.patch			\
  %D%/packages/patches/nhc98-c-update.patch			\
  %D%/packages/patches/nix-dont-build-html-doc.diff		\
  %D%/packages/patches/nfs4-acl-tools-0.3.7-fixpaths.patch	\
  %D%/packages/patches/network-manager-plugin-ownership.patch	\
  %D%/packages/patches/network-manager-plugin-path.patch	\
  %D%/packages/patches/newlib-getentropy.patch			\
  %D%/packages/patches/nginx-socket-cloexec.patch		\
  %D%/packages/patches/nickle-man-release-date.patch		\
  %D%/packages/patches/nlopt_CMake-Assume-working-c-compiler-597.patch \
  %D%/packages/patches/nnpack-system-libraries.patch		\
  %D%/packages/patches/nsis-env-passthru.patch			\
  %D%/packages/patches/nss-getcwd-nonnull.patch			\
  %D%/packages/patches/nss-increase-test-timeout.patch		\
  %D%/packages/patches/nss-3.56-pkgconfig.patch			\
  %D%/packages/patches/nss-disable-broken-tests.patch           \
  %D%/packages/patches/nss-3.115-disable-broken-tests.patch     \
  %D%/packages/patches/nss-3.115-disable-pkix-ocsp-tests.patch  \
  %D%/packages/patches/ntp-fix-dereferencing-the-wrong-variable.patch   \
  %D%/packages/patches/nvi-add-function-prototypes.patch	\
  %D%/packages/patches/nvi-assume-preserve-path.patch		\
  %D%/packages/patches/nvi-dbpagesize-binpower.patch		\
  %D%/packages/patches/nvi-db4.patch				\
  %D%/packages/patches/obs-modules-location.patch		\
  %D%/packages/patches/ocaml-ctypes-test-oo.patch		\
  %D%/packages/patches/ocaml-multiple-definitions.patch		\
  %D%/packages/patches/ogre-next-add-riscv64-support.patch		\
  %D%/packages/patches/ocaml-4.07-dynamically-allocate-signal-stack.patch	\
  %D%/packages/patches/ocaml-4.09-dynamically-allocate-signal-stack.patch	\
  %D%/packages/patches/ocaml-4.09-multiple-definitions.patch	\
  %D%/packages/patches/omake-fix-non-determinism.patch	\
  %D%/packages/patches/oneko-remove-nonfree-characters.patch	\
  %D%/packages/patches/onetbb-other-arches.patch	\
  %D%/packages/patches/online-judge-tools.patch		\
  %D%/packages/patches/onnx-optimizer-system-library.patch	\
  %D%/packages/patches/onnx-1.13.1-use-system-googletest.patch	\
  %D%/packages/patches/onnx-shared-libraries.patch	\
  %D%/packages/patches/onnx-skip-model-downloads.patch		\
  %D%/packages/patches/openbios-aarch64-riscv64-support.patch	\
  %D%/packages/patches/openboardview-use-system-imgui.patch	\
  %D%/packages/patches/openboardview-use-system-mpc.patch	\
  %D%/packages/patches/openbox-add-fix-for-glib2-exposed-segfault.patch \
  %D%/packages/patches/openbox-python3.patch			\
  %D%/packages/patches/opendht-nanosleep.patch			\
  %D%/packages/patches/openexr-2-gcc-14.patch			\
  %D%/packages/patches/openfst-for-vosk-fix-unique-ptr.patch	\
  %D%/packages/patches/openjdk-currency-time-bomb.patch		\
  %D%/packages/patches/openjdk-currency-time-bomb2.patch	\
  %D%/packages/patches/openjdk-9-pointer-comparison.patch       \
  %D%/packages/patches/openjdk-9-setsignalhandler.patch         \
  %D%/packages/patches/openjdk-9-classlist-reproducibility.patch	\
  %D%/packages/patches/openjdk-9-idlj-reproducibility.patch	\
  %D%/packages/patches/openjdk-9-jar-reproducibility.patch	\
  %D%/packages/patches/openjdk-9-module-reproducibility.patch	\
  %D%/packages/patches/openjdk-9-module2-reproducibility.patch	\
  %D%/packages/patches/openjdk-9-module3-reproducibility.patch	\
  %D%/packages/patches/openjdk-10-char-reproducibility.patch	\
  %D%/packages/patches/openjdk-10-classlist-reproducibility.patch	\
  %D%/packages/patches/openjdk-10-corba-reproducibility.patch	\
  %D%/packages/patches/openjdk-10-idlj-reproducibility.patch	\
  %D%/packages/patches/openjdk-10-jar-reproducibility.patch	\
  %D%/packages/patches/openjdk-10-jtask-reproducibility.patch	\
  %D%/packages/patches/openjdk-10-module-reproducibility.patch	\
  %D%/packages/patches/openjdk-10-module3-reproducibility.patch	\
  %D%/packages/patches/openjdk-10-module4-reproducibility.patch	\
  %D%/packages/patches/openjdk-10-pointer-comparison.patch      \
  %D%/packages/patches/openjdk-10-setsignalhandler.patch        \
  %D%/packages/patches/openjdk-11-classlist-reproducibility.patch	\
  %D%/packages/patches/openjdk-13-classlist-reproducibility.patch	\
  %D%/packages/patches/openjdk-15-jtask-reproducibility.patch	\
  %D%/packages/patches/openjdk-15-xcursor-no-dynamic.patch	\
  %D%/packages/patches/openjdk-21-fix-rpath.patch		\
  %D%/packages/patches/openmpi-mtl-priorities.patch		\
  %D%/packages/patches/openssh-trust-guix-store-directory.patch	\
  %D%/packages/patches/openresolv-restartcmd-guix.patch	\
  %D%/packages/patches/openrgb-unbundle-hueplusplus.patch	\
  %D%/packages/patches/openscad-fix-path-in-expected-test-results-to-acommodate-diff.patch \
  %D%/packages/patches/opensles-add-license-file.patch			\
  %D%/packages/patches/openssl-1.1-c-rehash-in.patch		\
  %D%/packages/patches/openssl-3.0-c-rehash-in.patch		\
  %D%/packages/patches/openssl-hurd64.patch			\
  %D%/packages/patches/opentaxsolver-file-browser-fix.patch     \
  %D%/packages/patches/open-zwave-hidapi.patch			\
  %D%/packages/patches/opusfile-CVE-2022-47021.patch		\
  %D%/packages/patches/orangeduck-mpc-fix-pkg-config.patch	\
  %D%/packages/patches/orbit2-fix-array-allocation-32bit.patch \
  %D%/packages/patches/orpheus-cast-errors-and-includes.patch	\
  %D%/packages/patches/ots-no-include-missing-file.patch	\
  %D%/packages/patches/owncloud-disable-updatecheck.patch	\
  %D%/packages/patches/pnet-fix-line-number-info.patch		\
  %D%/packages/patches/pnet-fix-off-by-one.patch		\
  %D%/packages/patches/pnet-newer-libgc-fix.patch		\
  %D%/packages/patches/pnet-newer-texinfo-fix.patch		\
  %D%/packages/patches/pam-krb5-CVE-2020-10595.patch		\
  %D%/packages/patches/pango-skip-libthai-test.patch		\
  %D%/packages/patches/password-store-tree-compat.patch		\
  %D%/packages/patches/pciutils-hurd64.patch			\
  %D%/packages/patches/pcsxr-find-harfbuzz.patch			\
  %D%/packages/patches/pcsxr-fix-definitions.patch			\
  %D%/packages/patches/pdl-2.019-glut-bitmap-fonts.patch	\
  %D%/packages/patches/pdl-2.100-reproducibility.patch	\
  %D%/packages/patches/petri-foo-0.1.87-fix-recent-file-not-exist.patch			\
  %D%/packages/patches/pharo-vm-cmake.patch                     \
  %D%/packages/patches/plasma-framework-fix-KF5PlasmaMacros.cmake.patch \
  %D%/packages/patches/plasp-fix-normalization.patch \
  %D%/packages/patches/plasp-include-iostream.patch \
  %D%/packages/patches/pocketfft-cpp-prefer-preprocessor-if.patch			\
  %D%/packages/patches/podofo-gcc-14.patch			\
  %D%/packages/patches/pokerth-boost.patch			\
  %D%/packages/patches/pounce-readable-checks.patch             \
  %D%/packages/patches/ppsspp-disable-upgrade-and-gold.patch		\
  %D%/packages/patches/procps-strtod-test.patch                 \
  %D%/packages/patches/prusa-slicer-add-cmake-module.patch \
  %D%/packages/patches/prusa-wxwidgets-makefile-fix.patch	\
  %D%/packages/patches/pthreadpool-system-libraries.patch	\
  %D%/packages/patches/python-3.11-fix-tests.patch		\
  %D%/packages/patches/python-3.12-fix-tests.patch		\
  %D%/packages/patches/python-accupy-use-matplotx.patch		\
  %D%/packages/patches/python-accupy-fix-use-of-perfplot.patch	\
  %D%/packages/patches/python-bed-reader-use-store-samples.patch	\
  %D%/packages/patches/python-chai-drop-python2.patch		\
  %D%/packages/patches/python-clarabel-blas.patch		\
  %D%/packages/patches/python-docrepr-fix-tests.patch		\
  %D%/packages/patches/python-feedparser-missing-import.patch	\
  %D%/packages/patches/python-gpg-setup-72.patch                \
  %D%/packages/patches/python-hdmedians-replace-nose.patch	\
  %D%/packages/patches/python-louvain-fix-test.patch		\
  %D%/packages/patches/python-matplotlib-fix-legend-loc-best-test.patch	\
  %D%/packages/patches/python-mohawk-pytest.patch	\
  %D%/packages/patches/python-msal-requests.patch	\
  %D%/packages/patches/python-norns-nose.patch			\
  %D%/packages/patches/python-numpy-gcc-14.patch		\
  %D%/packages/patches/python-random2-getrandbits-test.patch		\
  %D%/packages/patches/python-pillow-use-zlib-1.3.patch	\
  %D%/packages/patches/python-pydocstyle-add-support-for-pep701.patch	\
  %D%/packages/patches/python-pypytools-python-3-fixes.patch	\
  %D%/packages/patches/python-pyreadstat-link-libiconv.patch	\
  %D%/packages/patches/python-sip-include-dirs.patch	\
  %D%/packages/patches/python-scikit-build-setuptools-compat.patch	\
  %D%/packages/patches/python-sgmllib3k-assertions.patch	\
  %D%/packages/patches/python-sphobjinv-defer-ssl-import.patch	\
  %D%/packages/patches/python-sphinx-prompt-docutils-0.19.patch	\
  %D%/packages/patches/python-sshtunnel-pep518.patch	\
  %D%/packages/patches/python-zeroc-ice-3.6.5-python-3.11-support.patch	\
  %D%/packages/patches/qcodeeditor-qt6.patch			\
  %D%/packages/patches/qgit-2.12-fix-search-style.patch		\
  %D%/packages/patches/qtdeclarative-5-disable-qmlcache.patch	\
  %D%/packages/patches/qtdeclarative-disable-qmlcache.patch	\
  %D%/packages/patches/qtlocation-5.15.8-mapboxgl-gcc13.patch	\
  %D%/packages/patches/qtwebengine-revert-egl.patch		\
  %D%/packages/patches/quodlibet-disable-bundled-packages.patch	\
  %D%/packages/patches/qxlsx-fix-include-directory.patch	\
  %D%/packages/patches/schiffbruch-fix-build-for-gcc-13.patch	\
  %D%/packages/patches/scn-fast-float-compat.patch		\
  %D%/packages/patches/sdcc-disable-non-free-code.patch		\
  %D%/packages/patches/sdl-pango-api_additions.patch		\
  %D%/packages/patches/sdl-pango-blit_overflow.patch		\
  %D%/packages/patches/sdl-pango-fillrect_crash.patch		\
  %D%/packages/patches/sdl-pango-header-guard.patch		\
  %D%/packages/patches/sdl-pango-matrix_declarations.patch	\
  %D%/packages/patches/sdl-pango-sans-serif.patch		\
  %D%/packages/patches/smalltalk-multiplication-overflow.patch	\
  %D%/packages/patches/soci-mysql-ddl-types.patch		\
  %D%/packages/patches/sqlite-hurd.patch			\
  %D%/packages/patches/squeak-vm-gcc-14-fix.patch		\
  %D%/packages/patches/stepmania-ffmpeg-compat.patch			\
  %D%/packages/patches/stk-5.0.1-fix-typo.patch			\
  %D%/packages/patches/strace-readlink-tests.patch		\
  %D%/packages/patches/sunxi-tools-remove-sys-io.patch	\
  %D%/packages/patches/p11-kit-hurd.patch			\
  %D%/packages/patches/patch-hurd-path-max.patch		\
  %D%/packages/patches/perl-5.14-autosplit-default-time.patch	\
  %D%/packages/patches/perl-5.14-module-pluggable-search.patch	\
  %D%/packages/patches/perl-5.14-no-sys-dirs.patch		\
  %D%/packages/patches/perl-autosplit-default-time.patch	\
  %D%/packages/patches/perl-class-methodmaker-reproducible.patch \
  %D%/packages/patches/perl-crypt-des-implicit-func-decl.patch	\
  %D%/packages/patches/perl-image-exiftool-CVE-2021-22204.patch	\
  %D%/packages/patches/perl-net-amazon-s3-moose-warning.patch	\
  %D%/packages/patches/perl-net-dns-resolver-programmable-fix.patch	\
  %D%/packages/patches/perl-net-ssleay-colon-parsing.patch	\
  %D%/packages/patches/perl-no-sys-dirs.patch			\
  %D%/packages/patches/perl-text-markdown-discount-unbundle.patch	\
  %D%/packages/patches/perl-module-pluggable-search.patch	\
  %D%/packages/patches/perl-reproducible-build-date.patch	\
  %D%/packages/patches/perl-www-curl-fix-struct-void.patch	\
  %D%/packages/patches/perl-www-curl-remove-symbol.patch	\
  %D%/packages/patches/perl-xml-libxml-fix-function-prototypes.patch	\
  %D%/packages/patches/phoronix-test-suite-fsdg.patch		\
  %D%/packages/patches/picprog-non-intel-support.patch		\
  %D%/packages/patches/pidgin-add-search-path.patch		\
  %D%/packages/patches/pinball-system-ltdl.patch		\
  %D%/packages/patches/pingus-boost-headers.patch		\
  %D%/packages/patches/pingus-sdl-libs-config.patch		\
  %D%/packages/patches/pipewire-0.2.7-fno-common.patch		\
  %D%/packages/patches/pixman-CVE-2016-5296.patch		\
  %D%/packages/patches/plink-1.07-unclobber-i.patch		\
  %D%/packages/patches/plink-endian-detection.patch		\
  %D%/packages/patches/plib-CVE-2011-4620.patch		\
  %D%/packages/patches/plib-CVE-2012-4552.patch		\
  %D%/packages/patches/ploticus-pointer-types.patch		\
  %D%/packages/patches/plotutils-spline-test.patch		\
  %D%/packages/patches/polkit-disable-systemd.patch		\
  %D%/packages/patches/portaudio-audacity-compat.patch		\
  %D%/packages/patches/portmidi-modular-build.patch		\
  %D%/packages/patches/postgresql-disable-resolve_symlinks.patch	\
  %D%/packages/patches/postgresql-disable-normalize_exec_path.patch	\
  %D%/packages/patches/procmail-ambiguous-getline-debian.patch  \
  %D%/packages/patches/procmail-CVE-2014-3618.patch		\
  %D%/packages/patches/procmail-CVE-2017-16844.patch		\
  %D%/packages/patches/procmail-gcc-14.patch		\
  %D%/packages/patches/proj-7-initialize-memory.patch		\
  %D%/packages/patches/proot-add-clone3.patch			\
  %D%/packages/patches/proot-add-missing-include.patch		\
  %D%/packages/patches/protobuf-fix-build-on-32bit.patch	\
  %D%/packages/patches/psm2-compile-ctor-without-avx.patch	\
  %D%/packages/patches/psm-arch.patch				\
  %D%/packages/patches/psm-disable-memory-stats.patch		\
  %D%/packages/patches/psm-ldflags.patch			\
  %D%/packages/patches/psm-repro.patch				\
  %D%/packages/patches/pstoedit-fix-gcc12.patch			\
  %D%/packages/patches/pstoedit-fix-plainC.patch		\
  %D%/packages/patches/pstoedit-pkglibdir.patch			\
  %D%/packages/patches/pulseaudio-fix-mult-test.patch		\
  %D%/packages/patches/pulseaudio-longer-test-timeout.patch	\
  %D%/packages/patches/pulseview-qt515-compat.patch		\
  %D%/packages/patches/pulseview-glib-2.68.patch		\
  %D%/packages/patches/pybugz-encode-error.patch		\
  %D%/packages/patches/pybugz-stty.patch			\
  %D%/packages/patches/python-2-deterministic-build-info.patch	\
  %D%/packages/patches/python-2.7-adjust-tests.patch		\
  %D%/packages/patches/python-2.7-expat-compat.patch		\
  %D%/packages/patches/python-2.7-search-paths.patch		\
  %D%/packages/patches/python-2.7-site-prefixes.patch		\
  %D%/packages/patches/python-2.7-source-date-epoch.patch	\
  %D%/packages/patches/python-2.7-CVE-2021-3177.patch		\
  %D%/packages/patches/python-2.7-no-static-lib.patch		\
  %D%/packages/patches/python-3-arm-alignment.patch		\
  %D%/packages/patches/python-3-deterministic-build-info.patch	\
  %D%/packages/patches/python-3-search-paths.patch		\
  %D%/packages/patches/python-3-fix-tests.patch			\
  %D%/packages/patches/python-3-hurd-configure.patch		\
  %D%/packages/patches/python-angr-check-exec-deps.patch	\
  %D%/packages/patches/python-3-reproducible-build.patch	\
  %D%/packages/patches/python-cross-compile.patch		\
  %D%/packages/patches/python-colour-remove-d2to1.patch		\
  %D%/packages/patches/python-debugpy-unbundle-pydevd.patch	\
  %D%/packages/patches/python-docopt-pytest6-compat.patch	\
  %D%/packages/patches/python-fixtures-remove-monkeypatch-test.patch	\
  %D%/packages/patches/python-hiredis-use-system-hiredis.patch	\
  %D%/packages/patches/python-online-judge-api-client-tests.patch \
  %D%/packages/patches/python-peachpy-determinism.patch	\
  %D%/packages/patches/python-pep8-stdlib-tokenize-compat.patch \
  %D%/packages/patches/python-piexif-fix-tests-with-pillow-7.2.patch	\
  %D%/packages/patches/python-pillow-CVE-2022-45199.patch	\
  %D%/packages/patches/python-libxml2-utf8.patch		\
  %D%/packages/patches/python-memcached-syntax-warnings.patch	\
  %D%/packages/patches/python-packaging-test-arch.patch		\
  %D%/packages/patches/python-pandas-2-no-pytz_datetime.patch		\
  %D%/packages/patches/python-property-cached-asyncio-3_11.patch	\
  %D%/packages/patches/python-pyan3-fix-absolute-path-bug.patch \
  %D%/packages/patches/python-pyan3-fix-positional-arguments.patch \
  %D%/packages/patches/python-pytorch-fix-codegen.patch		\
  %D%/packages/patches/python-pytorch-for-r-torch-fix-codegen.patch \
  %D%/packages/patches/python-pytorch-for-r-torch-system-libraries.patch \
  %D%/packages/patches/python-pytorch-for-r-torch-without-kineto.patch \
  %D%/packages/patches/python-pytorch-runpath.patch		\
  %D%/packages/patches/python-pytorch-system-libraries.patch	\
  %D%/packages/patches/python-pytorch-without-kineto.patch	\
  %D%/packages/patches/python-robotframework-sshlibrary-rf5-compat.patch \
  %D%/packages/patches/python-scipy-i686.patch 			\
  %D%/packages/patches/python-vaex-core-fix-tsl-use.patch	\
  %D%/packages/patches/python-vega-datasets-remove-la-riots-code.patch	\
  %D%/packages/patches/python-versioneer-guix-support.patch	\
  %D%/packages/patches/python-werkzeug-tests.patch		\
  %D%/packages/patches/python-xmp-toolkit-add-missing-error-codes.patch	\
  %D%/packages/patches/qdigidoc-bundle-config-files.patch       \
  %D%/packages/patches/qdigidoc-bundle-tsl-files.patch          \
  %D%/packages/patches/qemu-build-info-manual.patch		\
  %D%/packages/patches/qemu-glibc-2.27.patch 			\
  %D%/packages/patches/qemu-glibc-2.30.patch 			\
  %D%/packages/patches/qemu-fix-agent-paths.patch 		\
  %D%/packages/patches/qemu-fix-test-virtio-version.patch       \
  %D%/packages/patches/qemu-disable-aarch64-migration-test.patch	\
  %D%/packages/patches/qrcodegen-cpp-cmake.patch		\
  %D%/packages/patches/qtbase-absolute-runpath.patch		\
  %D%/packages/patches/qtbase-qmake-fix-includedir.patch 	\
  %D%/packages/patches/qtbase-qmlimportscanner-qml-import-path.patch 	\
  %D%/packages/patches/qtbase-moc-ignore-gcc-macro.patch	\
  %D%/packages/patches/qtbase-patch-libvulkan.patch		\
  %D%/packages/patches/qtbase-qmake-use-libname.patch		\
  %D%/packages/patches/qtbase-5-use-TZDIR.patch			\
  %D%/packages/patches/qtscript-disable-tests.patch		\
  %D%/packages/patches/quagga-reproducible-build.patch          \
  %D%/packages/patches/quilt-grep-compat.patch 			\
  %D%/packages/patches/qmk-firmware-fix-hacker-dvorak.patch 	\
  %D%/packages/patches/qtwayland-dont-recreate-callbacks.patch	\
  %D%/packages/patches/qtwayland-cleanup-callbacks.patch	\
  %D%/packages/patches/qtwayland-update-wayland-xml.patch	\
  %D%/packages/patches/qtwebsockets-6.9-fix-tst_QWebSocket.patch\
  %D%/packages/patches/rabbitmq-defaults.patch		\
  %D%/packages/patches/radare2-fix-meson-build-to-use-sys-qjs.patch	\
  %D%/packages/patches/radare2-fix-meson-build-to-use-sys-sdb.patch	\
  %D%/packages/patches/ragel-char-signedness.patch		\
  %D%/packages/patches/randomjungle-disable-static-build.patch	\
  %D%/packages/patches/rapidcheck-fix-libs.patch		\
  %D%/packages/patches/ratpoison-shell.patch			\
  %D%/packages/patches/retroarch-unbundle-spirv-cross.patch	\
  %D%/packages/patches/rct-add-missing-headers.patch		\
  %D%/packages/patches/readline-link-ncurses.patch		\
  %D%/packages/patches/renpy-python-3.11-compat.patch			\
  %D%/packages/patches/renpy-fix-integer-slots.patch			\
  %D%/packages/patches/reposurgeon-add-missing-docbook-files.patch	\
  %D%/packages/patches/rdkit-unbundle-external-dependencies.patch	\
  %D%/packages/patches/r-httpuv-1.6.6-unvendor-libuv.patch	\
  %D%/packages/patches/r-sapa-lapack.patch			\
  %D%/packages/patches/ripperx-missing-file.patch		\
  %D%/packages/patches/rpcbind-CVE-2017-8779.patch		\
  %D%/packages/patches/rtags-separate-rct.patch			\
  %D%/packages/patches/rtosc-0.3.1-fix-invalid-comparison-operator.patch	\
  %D%/packages/patches/racket-chez-scheme-bin-sh.patch		\
  %D%/packages/patches/racket-launcher-config-dir.patch		\
  %D%/packages/patches/raptor2-libxml2.patch			\
  %D%/packages/patches/racket-rktio-bin-sh.patch		\
  %D%/packages/patches/re2c-Use-maximum-alignment.patch         \
  %D%/packages/patches/readymedia-ffmpeg7.patch         \
  %D%/packages/patches/reduce-unbundle-libffi.patch             \
  %D%/packages/patches/remake-impure-dirs.patch			\
  %D%/packages/patches/restartd-update-robust.patch             \
  %D%/packages/patches/restic-0.9.6-fix-tests-for-go1.15.patch	\
  %D%/packages/patches/rlwrap-no-rbgen.patch	\
  %D%/packages/patches/rng-tools-revert-build-randstat.patch	\
  %D%/packages/patches/rocclr-5.6.0-enable-gfx800.patch		\
  %D%/packages/patches/rocm-opencl-runtime-4.3-noclinfo.patch 	\
  %D%/packages/patches/rottlog-direntry.patch 			\
  %D%/packages/patches/ruby-actionpack-remove-browser-tests.patch	\
  %D%/packages/patches/ruby-activesupport-fix-deprecation-warning.patch	\
  %D%/packages/patches/ruby-asciidoctor-pdf-support-prawn-svg-0_36.patch	\
  %D%/packages/patches/ruby-chunky-png-ruby-3-2-support.patch	\
  %D%/packages/patches/ruby-hiredis-use-system-hiredis.patch	\
  %D%/packages/patches/ruby-hydra-minimal-no-byebug.patch	\
  %D%/packages/patches/ruby-anystyle-data-immutable-install.patch	\
  %D%/packages/patches/ruby-anystyle-fix-dictionary-populate.patch	\
  %D%/packages/patches/ruby-flores-fix-deprecations.patch	\
  %D%/packages/patches/ruby-latex-decode-fix-test.patch		\
  %D%/packages/patches/ruby-mustache-1.1.1-fix-race-condition-tests.patch \
  %D%/packages/patches/ruby-pg-fix-connect-timeout.patch	\
  %D%/packages/patches/ruby-x25519-automatic-fallback-non-x86_64.patch \
  %D%/packages/patches/rust-1.64-fix-riscv64-bootstrap.patch	\
  %D%/packages/patches/rust-1.70-fix-rustix-build.patch	\
  %D%/packages/patches/rust-1.78-unwinding-fix.patch		\
  %D%/packages/patches/rust-1.81-fix-riscv64-bootstrap.patch	\
  %D%/packages/patches/rust-ring-0.17-ring-core.patch		\
  %D%/packages/patches/rw-igraph-0.10.patch			\
  %D%/packages/patches/rxvt-unicode-fix-cursor-position.patch	\
  %D%/packages/patches/s7-flint-3.patch                      	\
  %D%/packages/patches/safeint-disable-tests.patch		\
  %D%/packages/patches/sajson-for-gemmi-numbers-as-strings.patch	\
  %D%/packages/patches/sajson-build-with-gcc10.patch		\
  %D%/packages/patches/sane-look-for-plugins-in-SANE_BACKEND_LIB_PATH.patch	\
  %D%/packages/patches/sbc-fix-build-non-x86.patch		\
  %D%/packages/patches/sbcl-fix-arm64-shared-lib.patch		\
  %D%/packages/patches/sbcl-aserve-add-HTML-5-elements.patch	\
  %D%/packages/patches/sbcl-aserve-fix-rfe12668.patch	\
  %D%/packages/patches/sbcl-burgled-batteries3-fix-signals.patch	\
  %D%/packages/patches/sbcl-ciel-repl.patch			\
  %D%/packages/patches/sbcl-clml-fix-types.patch		\
  %D%/packages/patches/sbcl-cl-redis-replace-sbcl-specific-calls.patch	\
  %D%/packages/patches/sbcl-eazy-gnuplot-skip-path-check.patch	\
  %D%/packages/patches/sbcl-lack-fix-tests.patch		\
  %D%/packages/patches/sbcl-png-fix-sbcl-compatibility.patch	\
  %D%/packages/patches/sbcl-s-sysdeps-bt2.patch			\
  %D%/packages/patches/scheme48-tests.patch			\
  %D%/packages/patches/scilab-better-compiler-detection.patch	\
  %D%/packages/patches/scilab-tbx_build_help.patch		\
  %D%/packages/patches/scons-test-environment.patch		\
  %D%/packages/patches/scotch-cmake-remove-metis.patch		\
  %D%/packages/patches/screen-hurd-path-max.patch		\
  %D%/packages/patches/serious-sam-classic-engine-patch-paths.patch		\
  %D%/packages/patches/scsh-nonstring-search-path.patch	\
  %D%/packages/patches/seed-webkit.patch			\
  %D%/packages/patches/sendgmail-accept-ignored-gsuite-flag.patch	\
  %D%/packages/patches/sendgmail-remove-domain-restriction.patch	\
  %D%/packages/patches/seq24-rename-mutex.patch			\
  %D%/packages/patches/libsequoia-fix-ffi-Makefile.patch	\
  %D%/packages/patches/libsequoia-remove-store.patch		\
  %D%/packages/patches/shaderc-for-pcsx2-changes.patch		\
  %D%/packages/patches/shakespeare-spl-fix-grammar.patch		\
  %D%/packages/patches/shared-mime-info-xdgmime-path.patch	\
  %D%/packages/patches/sharutils-CVE-2018-1000097.patch		\
  %D%/packages/patches/sipwitch-fix-build-with-exosip5.patch	\
  %D%/packages/patches/slim-config.patch			\
  %D%/packages/patches/slim-gcc-14.patch			\
  %D%/packages/patches/slim-login.patch				\
  %D%/packages/patches/slim-display.patch			\
  %D%/packages/patches/slurm-23-salloc-fallback-shell.patch	\
  %D%/packages/patches/slurm-drmaa-25.patch			\
  %D%/packages/patches/stex-copy-from-immutable-store.patch	\
  %D%/packages/patches/sysdig-shared-falcosecurity-libs.patch	\
  %D%/packages/patches/syslinux-gcc10.patch			\
  %D%/packages/patches/syslinux-strip-gnu-property.patch	\
  %D%/packages/patches/snappy-add-O2-flag-in-CmakeLists.txt.patch	\
  %D%/packages/patches/snappy-add-inline-for-GCC.patch		\
  %D%/packages/patches/source-highlight-gcc-compat.patch	\
  %D%/packages/patches/sourcetrail-fix-cmakelists-and-paths.patch		\
  %D%/packages/patches/softhsm-fix-openssl3-tests.patch		\
  %D%/packages/patches/spectre-meltdown-checker-externalize-fwdb.patch \
  %D%/packages/patches/sphinxbase-fix-doxygen.patch		\
  %D%/packages/patches/spice-vdagent-monitor-size-calculation.patch     \
  %D%/packages/patches/guile-srfi-125-fix-r7rs-rename-clause.patch \
  %D%/packages/patches/sssd-system-directories.patch		\
  %D%/packages/patches/steghide-fixes.patch			\
  %D%/packages/patches/suitesparse-mongoose-cmake.patch		\
  %D%/packages/patches/strutcpp-fix-includes.patch              \
  %D%/packages/patches/superlu-dist-awpm-grid.patch		\
  %D%/packages/patches/superlu-dist-scotchmetis.patch		\
  %D%/packages/patches/supertux-unbundle-squirrel.patch		\
  %D%/packages/patches/swift-5.7.3-sdk-path.patch			\
  %D%/packages/patches/swift-5.7.3-sourcekit-rpath.patch		\
  %D%/packages/patches/swift-6.2-cplus-include-path.patch		\
  %D%/packages/patches/swift-6.2-exclude-scan-test.patch		\
  %D%/packages/patches/swift-corelibs-libdispatch-5.6.3-lock-cpp.patch	\
  %D%/packages/patches/swift-corelibs-libdispatch-5.7.3-modulemap.patch	\
  %D%/packages/patches/swift-llvm-5.7.3-linux.patch	\
  %D%/packages/patches/swig-support-gcc-12.patch		\
  %D%/packages/patches/swish-e-search.patch			\
  %D%/packages/patches/swish-e-format-security.patch		\
  %D%/packages/patches/t1lib-CVE-2010-2642.patch		\
  %D%/packages/patches/t1lib-CVE-2011-0764.patch		\
  %D%/packages/patches/t1lib-CVE-2011-1552+.patch		\
  %D%/packages/patches/t4k-common-libpng16.patch		\
  %D%/packages/patches/tao-add-missing-headers.patch		\
  %D%/packages/patches/tao-fix-parser-types.patch		\
  %D%/packages/patches/tar-remove-wholesparse-check.patch	\
  %D%/packages/patches/tar-skip-unreliable-tests.patch		\
  %D%/packages/patches/tbb-gcc-14.patch				\
  %D%/packages/patches/tbb-other-arches.patch			\
  %D%/packages/patches/tclxml-3.2-install.patch			\
  %D%/packages/patches/tcsh-fix-autotest.patch			\
  %D%/packages/patches/teensy-loader-cli-help.patch		\
  %D%/packages/patches/tensorflow-c-api-fix.patch		\
  %D%/packages/patches/texinfo-headings-single.patch		\
  %D%/packages/patches/texinfo-5-perl-compat.patch		\
  %D%/packages/patches/telegram-desktop-hashmap-incomplete-value.patch	\
  %D%/packages/patches/telegram-desktop-qguiapp.patch		\
  %D%/packages/patches/telegram-desktop-unbundle-cppgir.patch   \
  %D%/packages/patches/telegram-purple-adjust-test.patch	\
  %D%/packages/patches/telepathy-glib-fix-test.patch	\
  %D%/packages/patches/teuchos-remove-duplicate-using.patch	\
  %D%/packages/patches/texi2html-document-encoding.patch	\
  %D%/packages/patches/texi2html-i18n.patch			\
  %D%/packages/patches/texmacs-wayland-hidpi.patch	\
  %D%/packages/patches/tflite-micro_disable_download.patch 	\
  %D%/packages/patches/thefuck-test-environ.patch		\
  %D%/packages/patches/thefuck-remove-broken-tests.patch	\
  %D%/packages/patches/tidy-CVE-2015-5522+5523.patch		\
  %D%/packages/patches/timewarrior-time-sensitive-tests.patch	\
  %D%/packages/patches/tinydir-fix-cbehave-test.patch		\
  %D%/packages/patches/tinyxml-CVE-2023-34194.patch		\
  %D%/packages/patches/tinyxml-use-stl.patch			\
  %D%/packages/patches/tk-find-library.patch			\
  %D%/packages/patches/tla2tools-build-xml.patch		\
  %D%/packages/patches/tlf-support-hamlib-4.2+.patch		\
  %D%/packages/patches/tofi-32bit-compat.patch			\
  %D%/packages/patches/torbrowser-compare-paths.patch           \
  %D%/packages/patches/torbrowser-use-system-wide-dir.patch     \
  %D%/packages/patches/torbrowsers-add-store-to-rdd-allowlist.patch     \
  %D%/packages/patches/tpetra-remove-duplicate-using.patch	\
  %D%/packages/patches/transcode-ffmpeg.patch	\
  %D%/packages/patches/transmission-4.0.6-fix-build.patch	\
  %D%/packages/patches/trytond-add-guix_trytond_path.patch	\
  %D%/packages/patches/ttf2eot-cstddef.patch			\
  %D%/packages/patches/turbovnc-custom-paths.patch		\
  %D%/packages/patches/turbovnc-find-system-packages.patch	\
  %D%/packages/patches/tuxpaint-stamps-path.patch		\
  %D%/packages/patches/tvm_fix_cpptest_build.patch              \
  %D%/packages/patches/twinkle-bcg729.patch			\
  %D%/packages/patches/u-boot-allow-disabling-openssl.patch	\
  %D%/packages/patches/u-boot-nintendo-nes-serial.patch		\
  %D%/packages/patches/u-boot-rockchip-inno-usb.patch		\
  %D%/packages/patches/ucx-tcp-iface-ioctl.patch		\
  %D%/packages/patches/uftrace-fix-tests.patch			\
  %D%/packages/patches/ultrastar-deluxe-no-freesans.patch		\
  %D%/packages/patches/ungoogled-chromium-extension-search-path.patch	\
  %D%/packages/patches/ungoogled-chromium-RUNPATH.patch		\
  %D%/packages/patches/ungoogled-chromium-system-nspr.patch	\
  %D%/packages/patches/ungoogled-chromium-unbundle-icu-target.patch     \
  %D%/packages/patches/unknown-horizons-python-3.8-distro.patch	\
  %D%/packages/patches/unknown-horizons-python-3.9.patch	\
  %D%/packages/patches/unknown-horizons-python-3.10.patch	\
  %D%/packages/patches/unzip-CVE-2014-8139.patch		\
  %D%/packages/patches/unzip-CVE-2014-8140.patch		\
  %D%/packages/patches/unzip-CVE-2014-8141.patch		\
  %D%/packages/patches/unzip-CVE-2014-9636.patch		\
  %D%/packages/patches/unzip-CVE-2015-7696.patch		\
  %D%/packages/patches/unzip-CVE-2015-7697.patch		\
  %D%/packages/patches/unzip-CVE-2022-0529+CVE-2022-0530.patch	\
  %D%/packages/patches/unzip-allow-greater-hostver-values.patch	\
  %D%/packages/patches/unzip-attribs-overflow.patch		\
  %D%/packages/patches/unzip-overflow-on-invalid-input.patch	\
  %D%/packages/patches/unzip-format-secure.patch		\
  %D%/packages/patches/unzip-initialize-symlink-flag.patch	\
  %D%/packages/patches/unzip-overflow-long-fsize.patch		\
  %D%/packages/patches/unzip-remove-build-date.patch		\
  %D%/packages/patches/unzip-case-insensitive.patch		\
  %D%/packages/patches/unzip-COVSCAN-fix-unterminated-string.patch	\
  %D%/packages/patches/unzip-CVE-2016-9844.patch		\
  %D%/packages/patches/unzip-CVE-2018-1000035.patch		\
  %D%/packages/patches/unzip-CVE-2018-18384.patch		\
  %D%/packages/patches/unzip-alt-iconv-utf8-print.patch	\
  %D%/packages/patches/unzip-alt-iconv-utf8.patch		\
  %D%/packages/patches/unzip-close.patch			\
  %D%/packages/patches/unzip-exec-shield.patch			\
  %D%/packages/patches/unzip-fix-recmatch.patch		\
  %D%/packages/patches/unzip-manpage-fix.patch			\
  %D%/packages/patches/unzip-overflow.patch			\
  %D%/packages/patches/unzip-timestamp.patch			\
  %D%/packages/patches/unzip-valgrind.patch			\
  %D%/packages/patches/unzip-x-option.patch			\
  %D%/packages/patches/unzip-zipbomb-manpage.patch		\
  %D%/packages/patches/unzip-zipbomb-part1.patch		\
  %D%/packages/patches/unzip-zipbomb-part2.patch		\
  %D%/packages/patches/unzip-zipbomb-part3.patch		\
  %D%/packages/patches/unzip-32bit-zipbomb-fix.patch    \
  %D%/packages/patches/ustr-fix-build-with-gcc-5.patch		\
  %D%/packages/patches/util-linux-tests.patch			\
  %D%/packages/patches/vagrant-bin-vagrant-silence-warning-about-installer.patch	\
  %D%/packages/patches/vagrant-Support-system-installed-plugins.patch	\
  %D%/packages/patches/vagrant-Use-a-private-temporary-dir.patch	\
  %D%/packages/patches/vboot-utils-fix-format-load-address.patch	\
  %D%/packages/patches/vboot-utils-fix-tests-show-contents.patch	\
  %D%/packages/patches/vboot-utils-skip-test-workbuf.patch	\
  %D%/packages/patches/vcmi-disable-privacy-breach.patch	\
  %D%/packages/patches/vinagre-newer-freerdp.patch             \
  %D%/packages/patches/vinagre-newer-rdp-parameters.patch      \
  %D%/packages/patches/vlc-livemedia-2024.11.28.patch          \
  %D%/packages/patches/vsearch-unbundle-cityhash.patch		\
  %D%/packages/patches/vst3sdk-3.7.7-allow-winelib-compilation.patch	\
  %D%/packages/patches/vte-CVE-2012-2738-pt1.patch			\
  %D%/packages/patches/vte-CVE-2012-2738-pt2.patch			\
  %D%/packages/patches/vtk-7-gcc-10-compat.patch		\
  %D%/packages/patches/vtk-7-gcc-11-compat.patch		\
  %D%/packages/patches/vtk-7-hdf5-compat.patch			\
  %D%/packages/patches/vtk-7-python-compat.patch		\
  %D%/packages/patches/vulkan-tools-wayland-1.24.patch          \
  %D%/packages/patches/warsow-qfusion-fix-bool-return-type.patch	\
  %D%/packages/patches/warzone2100-unbundle-libs.patch		\
  %D%/packages/patches/wcstools-extend-makefiles.patch	\
  %D%/packages/patches/wdl-link-libs-and-fix-jnetlib.patch	\
  %D%/packages/patches/webkitgtk-adjust-bubblewrap-paths.patch	\
  %D%/packages/patches/webrtc-audio-processing-big-endian.patch	\
  %D%/packages/patches/webrtc-audio-processing-byte-order-pointer-size.patch \
  %D%/packages/patches/webrtc-audio-processing-x86-no-sse.patch	\
  %D%/packages/patches/websocketpp-fix-for-cmake-3.15.patch	\
  %D%/packages/patches/wmctrl-64-fix.patch			\
  %D%/packages/patches/wmfire-dont-inline-draw-fire.patch	\
  %D%/packages/patches/wmfire-update-for-new-gdk-versions.patch	\
  %D%/packages/patches/woof-doom-unbundle-spng-miniz.patch	\
  %D%/packages/patches/wordnet-CVE-2008-2149.patch			\
  %D%/packages/patches/wordnet-CVE-2008-3908-pt1.patch			\
  %D%/packages/patches/wordnet-CVE-2008-3908-pt2.patch			\
  %D%/packages/patches/wpa-supplicant-dbus-group-policy.patch		\
  %D%/packages/patches/x2goclient-fix-makefile.patch            \
  %D%/packages/patches/x265-arm-flags.patch			\
  %D%/packages/patches/x265-4-arm-flags.patch			\
  %D%/packages/patches/xdg-desktop-portal-disable-portal-tests.patch\
  %D%/packages/patches/xdg-desktop-portal-disable-configuration-search-exit.patch\
  %D%/packages/patches/xdg-desktop-portal-1.20.3-disable-configuration-search-exit.patch\
  %D%/packages/patches/xdg-desktop-portal-wlr-harcoded-length.patch\
  %D%/packages/patches/xf86-video-siliconmotion-fix-ftbfs.patch \
  %D%/packages/patches/xfig-Enable-error-message-for-missing-libraries.patch		\
  %D%/packages/patches/xfig-Fix-double-free-when-requesting-MediaBox.patch		\
  %D%/packages/patches/xfig-Use-pkg-config-to-set-fontconfig-CFLAGS-and-LIBS.patch	\
  %D%/packages/patches/xfce4-settings-defaults.patch		\
  %D%/packages/patches/xgboost-use-system-dmlc-core.patch	\
  %D%/packages/patches/xiphos-glib.patch                        \
  %D%/packages/patches/xlispstat-fix-compilation-with-modern-gcc.patch \
  %D%/packages/patches/xmonad-dynamic-linking.patch		\
  %D%/packages/patches/xplanet-1.3.1-cxx11-eof.patch		\
  %D%/packages/patches/xplanet-1.3.1-libdisplay_DisplayOutput.cpp.patch	\
  %D%/packages/patches/xplanet-1.3.1-libimage_gif.c.patch	\
  %D%/packages/patches/xplanet-1.3.1-xpUtil-Add2017LeapSecond.cpp.patch	\
  %D%/packages/patches/xpra-5.0-install_libs.patch              \
  %D%/packages/patches/xpra-5.0-systemd-run.patch              \
  %D%/packages/patches/xpra-6.0-systemd-run.patch		\
  %D%/packages/patches/xpra-6.1-install_libs.patch		\
  %D%/packages/patches/xterm-370-explicit-xcursor.patch		\
  %D%/packages/patches/xygrib-fix-finding-data.patch		\
  %D%/packages/patches/xygrib-newer-proj.patch			\
  %D%/packages/patches/yajl-CVE-2023-33460.patch		\
  %D%/packages/patches/yggdrasil-extra-config.patch	\
  %D%/packages/patches/zabbix-agent2-test-timezone-fix.patch	\
  %D%/packages/patches/zig-0.9-build-respect-PKG_CONFIG-env-var.patch	\
  %D%/packages/patches/zig-0.9-fix-runpath.patch		\
  %D%/packages/patches/zig-0.9-riscv-support.patch		\
  %D%/packages/patches/zig-0.9-use-baseline-cpu-by-default.patch	\
  %D%/packages/patches/zig-0.9-use-system-paths.patch		\
  %D%/packages/patches/zig-0.10-build-respect-PKG_CONFIG-env-var.patch	\
  %D%/packages/patches/zig-0.10-fix-runpath.patch		\
  %D%/packages/patches/zig-0.10-use-system-paths.patch		\
  %D%/packages/patches/zig-0.10.0-610-bootstrap-resolve-conflicts.patch	\
  %D%/packages/patches/zig-0.10.0-675-TypeOf-hack.patch		\
  %D%/packages/patches/zig-0.10.0-747-CallOptions.patch		\
  %D%/packages/patches/zig-0.10.0-1638-re-add-qualCast.patch	\
  %D%/packages/patches/zig-0.11-build-respect-PKG_CONFIG-env-var.patch	\
  %D%/packages/patches/zig-0.11-fix-runpath.patch		\
  %D%/packages/patches/zig-0.11-use-system-paths.patch		\
  %D%/packages/patches/zig-0.12-build-respect-PKG_CONFIG-env-var.patch	\
  %D%/packages/patches/zig-0.12-fix-runpath.patch		\
  %D%/packages/patches/zig-0.12-use-baseline-cpu-by-default.patch	\
  %D%/packages/patches/zig-0.12-use-system-paths.patch		\
  %D%/packages/patches/zig-0.13-build-respect-PKG_CONFIG-env-var.patch	\
  %D%/packages/patches/zig-0.13-fix-runpath.patch		\
  %D%/packages/patches/zig-0.14-fix-runpath.patch		\
  %D%/packages/patches/zig-0.14-use-baseline-cpu-by-default.patch	\
  %D%/packages/patches/zig-0.14-use-system-paths.patch		\
  %D%/packages/patches/zig-0.15-fix-runpath.patch		\
  %D%/packages/patches/zsh-egrep-failing-test.patch		\
  %D%/packages/patches/zuo-bin-sh.patch			\
  %D%/packages/patches/zxing-cpp-1.2.0-gcc-14.patch	\
  %D%/packages/patches/zynaddsubfx-3.0.6-include-cstdint.patch	\
  %D%/packages/patches/zynaddsubfx-3.0.6-system-rtosc.patch

MISC_DISTRO_FILES =				\
  %D%/packages/ld-wrapper.in
