# ./play.it action games collection

The codebase is maintained at [https://git.dotslashplay.it/games-action/]

Bug reports should be sent to [bugs@dotslashplay.it], and support requests to [requests@dotslashplay.it]

[https://git.dotslashplay.it/games-action/]: https://git.dotslashplay.it/games-action/
[bugs@dotslashplay.it]: mailto:bugs@dotslashplay.it
[requests@dotslashplay.it]: mailto:requests@dotslashplay.it

## Description

./play.it is a free software building native packages from installers for Windows or Linux, mainly those sold by stores focusing on DRM-free games distribution. The goal is that a game installed via ./play.it is indistinguishable from a game installed via the official repositories of your favourite distribution.

This specific collection includes only action games. These games challenge the player dexterity, providing obstacles requiring reflexes and coordination to overcome. This is a broad genre that spans from shooters to rhythm games. Platform games are excluded, as they already get their own dedicated collection.

## Installation

### Distributions providing ./play.it

The following distributions provide installation instructions in their official documentation:

- [Debian]
- [Gentoo]
- [Ubuntu] (French article)

[Debian]: https://wiki.debian.org/Games/PlayIt#Installation
[Gentoo]: https://wiki.gentoo.org/wiki/Play.it#Installation
[Ubuntu]: https://doc.ubuntu-fr.org/play.it#installation

In most cases, these instructions should work in the same way for derivatives of these distributions.

### Installation from git

If your distribution does not already have a package for this ./play.it collection, you can install it from this git repository.

```
git clone --branch main --depth 1 https://git.dotslashplay.it/games-action play.it-action.git
cd play.it-action.git
make install
```

## Usage

Usage instructions are provided on the main ./play.it repository: [./play.it: Installer for DRM-free commercial games — Usage]

[./play.it: Installer for DRM-free commercial games — Usage]: https://git.dotslashplay.it/play.it/about/#usage

## Contributing

### First contribution

There is no real rule for your first contribution. You can host your updated code anywhere you like and contact us via any way described in the [Contact information] section below. It is OK to expose your updated code through GitHub or GitLab.com if you have nothing better at hand, but we would be thankful if you would instead use some hosting outside of these big silos.

[Contact information]: #contact-information

We do not enforce any workflow like merge/pull requests or any such thing. We are interested in the result of your work, not in how you got to it. So shatter your shackles, and for once take pleasure in working *however you like*! You are not even required to use git if you do not know or do not like this tool.

Please try to follow these simple guidelines, and your contribution is probably going to be accepted quickly:

- Run `make check` before submitting your code, to ensure you did not break anything by accident;
- Use tabs for indentation. No real developer would ever indent anything with spaces.

### Regular contributions

If you keep contributing on a more regular basis (sending 3 patches in the same year would already make you a regular) we can grant you direct write access to the repositories hosted at git.dotslashplay.it. This is not mandatory, if for some reason you can not or do not want to work with git you can simply keep following the "First contribution" guidelines, and forget about this whole "Regular contributions" section.

To grant you such an access we need nothing but a public SSH key, that you can send us through any way described in the [Contact information] section below.

[Contact information]: #contact-information

Once you have been granted access, you should add the following to your local SSH configuration:

```
Host git.dotslashplay.it
    Port 1962
    User gitolite3
```

You should then update the remote of your local repository, with the following command (assuming a remote named "upstream"):

```
git remote set-url --push upstream ssh://git.dotslashplay.it/games-action
```

Since these repositories are worked on by several people, there are a couple extra guidelines that you should follow:

- Your work should always be pushed to a dedicated branch, never on the main branch;
- Game script updates, including bug fixes, should be pushed to branches named with a "update/" prefix;
- Addition of new game scripts should be pushed to branches named with a "new/" prefix;
- You are allowed to push code to branches opened by other contributors, but please communicate with them if you plan to do so;
- Force push and branches deletion are not allowed, if you want a branch to be deleted please ask us to do it for you.

## Supported games

- A Dance of Fire and Ice
- A Musical Story
- Accelerate
- Action Henk
- Alan Wake's American Nightmare
- Anarcute
- Ape Out
- Art of Fighting 2
- Assault Android Cactus
- Aztez
- Baseball Stars 2
- Basingstoke
- Battle Chef Brigade
- BFF or Die
- Bio Menace
- BioShock
- Bit.Trip Beat
- Bit.Trip Runner series:
    - Bit.Trip Runner
    - Bit.Trip Runner 2
    - Bit.Trip Runner 3
- Bleed series:
    - Bleed
    - Bleed 2
- Bombshell
- Broforce
- Butcher
- Cook, Serve, Delicious 2
- Crypt of the NecroDancer
- Cryptark
- Deadbolt
- Duet
- Duke Nukem 3D
- Enter the Gungeon
- Fatal Fury Special
- Flashout 3D
- FlatOut series:
    - FlatOut
    - FlatOut 2
- Grip
- Gun-Toting Cats
- Hot Pot Panic
- Hotline Miami
- Hounds of Valor
- Iconoclasts
- Intrusion 2
- Jydge
- King of the Monsters
- Lo-Fi Room
- Lovers in a Dangerous Spacetime
- Melody's Escape
- Metal Slug series:
    - Metal Slug 2
    - Metal Slug 3
- Mortal Kombat series:
    - Mortal Kombat
    - Mortal Kombat 2
    - Mortal Kombat 3
- Neon Drive
- Octodad: Dadliest Catch
- Osmos
- Overgrowth
- Overload
- Pacapong
- Painkiller
- Particulars
- Peck N Run
- Race the Sun
- Risk of Rain
- Sales Gosses
- Samurai Shodown 2
- Sengoku 3
- Sentris
- Shogo: Mobile Armor Division
- Solar 2
- SpringBack
- Star Wars: Battlefront II
- Stargunner
- Strafe
- Strike Suit Zero
- Superhot
- Symphony
- The Binding of Isaac
- The King of Fighters 2000
- Thief: Deadly Shadows
- Tonight We Riot
- Touhou series:
    - Touhou Koumakyou ~ the Embodiment of Scarlet Devil
    - Touhou Kaeizuka ~ Phantasmagoria of Flower View
    - Touhou Chireiden ~ Subterranean Animism
    - Touhou Seirensen ~ Undefined Fantastic Object
    - Touhou Touhou Shinreibyou ~ Ten Desires
    - Touhou Kishinjou ~ Double Dealing Character
    - Touhou Hifuu Nightmare Diary ~ Violet Detector
- Tower of Guns
- TrackMania Nations Forever
- Warhammer 40,000: Dakka Squadron
- Warsow
- Wing Commander series:
    - Wing Commander
    - Wing Commander 2
    - Wing Commander: Privateer
    - Wing Commander 3
- Witch Thief
- Ziggurat

## Contact information

### IRC channel

Some ./play.it developers and users can be reached on IRC, channel is `#play.it` on network `irc.oftc.net`. The main language on this IRC channel is English, but most of us can speak French too.

### E-mail

A contact e-mail for feedback can usually be found in each ./play.it game script, as well as in the library. Open one of these files with any text editor to see the contact e-mail.
