// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {TemplateResult} from 'chrome://resources/mwc/lit/index.js';

/**
 * Mapping of SVG file path (relative to images/, without the .svg extension)
 * to it's content as lit template.
 *
 * The real file is generated by scripts/gen_images_js.py.
 *
 * Example of svg path to the key:
 *   images/foo.svg -> "foo"
 *   images/icons/bar.svg -> "icons/bar".
 */
export const images: Map<string, TemplateResult>;
