# This script was generated by crazy-complete.
# crazy-complete: A tool that creates robust and reliable autocompletion scripts for Bash, Fish and Zsh.
# For more information, visit: https://github.com/crazy-complete/crazy-complete

function _fpm_fish_query
  # ===========================================================================
  #
  # This function implements the parsing of options and positionals in the Fish shell.
  #
  # Usage: __fish_query <OPTIONS> <COMMAND> [ARGS...]
  #
  # The first argument is a comma-separated list of options that the parser should know about.
  # Short options (-o), long options (--option), and old-style options (-option) are supported.
  #
  # If an option takes an argument, it is suffixed by '='.
  # If an option takes an optional argument, it is suffixed by '=?'.
  #
  # For example:
  #   __fish_query '-f,--flag,-old-style,--with-arg=,--with-optional=?' [...]
  #
  #   Here, -f, --flag and -old-style don't take options, --with-arg requires an
  #   argument and --with-optional takes an optional argument.
  #
  # COMMANDS
  #   positional_contains <NUM> <WORDS...>
  #     Checks if the positional argument number NUM is one of WORDS.
  #     NUM counts from one.
  #
  #   has_option <OPTIONS...>
  #     Checks if an option given in OPTIONS is passed on commandline.
  #
  #   option_is <OPTIONS...> -- <VALUES...>
  #     Checks if any option in OPTIONS has a value of VALUES.
  #
  #   num_of_positionals [<OPERATOR> <NUMBER>]
  #     Checks the number of positional arguments.
  #     If no arguments are provided, print the total count of positional arguments.
  #     If two arguments are provided, the first argument should be one of
  #     the comparison operators: '-lt', '-le', '-eq', '-ne', '-gt', '-ge'.
  #     Returns 0 if the count of positional arguments matches the
  #     specified NUMBER according to the comparison operator, otherwise returns 1.
  #
  # ===========================================================================

  set -l positionals
  set -l having_options
  set -l option_values

  set -l options $argv[1]
  set -e argv[1]

  set -l cmd $argv[1]
  set -e argv[1]

  set -l my_cache_key "$(commandline -b) $options"

  if test "$__QUERY_CACHE_KEY" = "$my_cache_key"
    set positionals    $__QUERY_CACHE_POSITIONALS
    set having_options $__QUERY_CACHE_HAVING_OPTIONS
    set option_values  $__QUERY_CACHE_OPTION_VALUES
  else
    # =========================================================================
    # Parsing of OPTIONS argument
    # =========================================================================

    set -l short_opts_with_arg
    set -l short_opts_without_arg
    set -l short_opts_with_optional_arg
    set -l long_opts_with_arg
    set -l long_opts_without_arg
    set -l long_opts_with_optional_arg

    set -l option

    if test -n "$options"
      for option in (string split -- ',' $options)
        # Using one big switch case is the fastest way
        switch $option
          case '--?*=';   set -a long_opts_with_arg           (string replace -- '='  '' $option)
          case '--?*=\?'; set -a long_opts_with_optional_arg  (string replace -- '=?' '' $option)
          case '--?*';    set -a long_opts_without_arg        $option
          case '-?=';     set -a short_opts_with_arg          (string replace -- '='  '' $option)
          case '-?=\?';   set -a short_opts_with_optional_arg (string replace -- '=?' '' $option)
          case '-?';      set -a short_opts_without_arg       $option
        end
      end
    end

    # =========================================================================
    # Parsing of options and positionals
    # =========================================================================

    set -l cmdline (commandline -poc)
    set -l cmdline_count (count $cmdline)

    set -l argi 2 # cmdline[1] is command name
    while test $argi -le $cmdline_count
      set -l arg "$cmdline[$argi]"
      set -l have_trailing_arg (test $argi -lt $cmdline_count && echo true || echo false)

      switch $arg
        case '-'
          set -a positionals -
        case '--'
          for argi in (seq (math $argi + 1) $cmdline_count)
            set -a positionals $cmdline[$argi]
          end
          break
        case '--*=*'
          set -l split (string split -m 1 -- '=' $arg)
          set -a having_options $split[1]
          set -a option_values "$split[2]"
        case '--*'
          if contains -- $arg $long_opts_with_arg
            if $have_trailing_arg
              set -a having_options $arg
              set -a option_values $cmdline[(math $argi + 1)]
              set argi (math $argi + 1)
            end
          else
            set -a having_options $arg
            set -a option_values ""
          end
        case '-*'
          set -l end_of_parsing false

          set -l arg_length (string length -- $arg)
          set -l i 2
          while not $end_of_parsing; and test $i -le $arg_length
            set -l option "-$(string sub -s $i -l 1 -- $arg)"
            set -l trailing_chars "$(string sub -s (math $i + 1) -- $arg)"

            if contains -- $option $short_opts_without_arg
              set -a having_options $option
              set -a option_values ""
            else if contains -- $option $short_opts_with_arg
              set end_of_parsing true

              if test -n "$trailing_chars"
                set -a having_options $option
                set -a option_values $trailing_chars
              else if $have_trailing_arg
                set -a having_options $option
                set -a option_values $cmdline[(math $argi + 1)]
                set argi (math $argi + 1)
              end
            else if contains -- $option $short_opts_with_optional_arg
              set -a having_options $option
              set end_of_parsing true
              set -a option_values "$trailing_chars" # may be empty
            end

            set i (math $i + 1)
          end
        case '*'
          set -a positionals $arg
      end

      set argi (math $argi + 1)
    end

    set -g __QUERY_CACHE_POSITIONALS    $positionals
    set -g __QUERY_CACHE_HAVING_OPTIONS $having_options
    set -g __QUERY_CACHE_OPTION_VALUES  $option_values
    set -g __QUERY_CACHE_KEY            $my_cache_key
  end

  # ===========================================================================
  # Commands
  # ===========================================================================

  switch $cmd
    case 'num_of_positionals'
      switch (count $argv)
        case 0
          count $positionals
        case 1
          echo "_fpm_fish_query: num_of_positionals: $argv[1]: missing operand" >&2
          return 1
        case 2
          if contains -- $argv[1] -lt -le -eq -ne -gt -ge;
            test (count $positionals) $argv[1] $argv[2] && return 0 || return 1
          else
            echo "_fpm_fish_query: num_of_positionals: $argv[1]: unknown operator" >&2
            return 1
          end
        case '*'
          echo "_fpm_fish_query: num_of_positionals: too many arguments" >&2
          return 1
      end
    case 'option_is'
      set -l options
      set -l values

      for arg in $argv
        set -e argv[1]

        if string match -q -- -- $arg
          set values $argv
          break
        else
          set -a options $arg
        end
      end

      if test (count $values) -eq 0
        echo "_fpm_fish_query: missing values" >&2
        return 1
      end

      set -l i (count $having_options)
      while test $i -ge 1
        if contains -- $having_options[$i] $options
          if contains -- $option_values[$i] $values
            return 0
          end
        end

        set i (math $i - 1)
      end

      return 1
  end
end

set -l prog "fpm"
set -l query "_fpm_fish_query"

# Generally disable file completion
complete -c $prog -x

# command fpm
set -l opts "-t=,--output-type=,-s=,--input-type=,-C=,--chdir=,--prefix=,-p=,--package=,-f,--force,-n=,--name=,--log=,--verbose,--debug,--debug-workspace,-v=,--version=,--iteration=,--epoch=,--license=,--vendor=,--category=,-d=,--depends=,--no-depends,--no-auto-depends,--provides=,--conflicts=,--replaces=,--config-files=,--directories=,-a=,--architecture=,-m=,--maintainer=,-S=,--package-name-suffix=,-e,--edit,-x=,--exclude=,--exclude-file=,--description=,--url=,--inputs=,--post-install=,--pre-install=,--post-uninstall=,--pre-uninstall=,--after-install=,--before-install=,--after-remove=,--before-remove=,--after-upgrade=,--before-upgrade=,--template-scripts,--template-value=,--workdir=,--source-date-epoch-from-changelog,--source-date-epoch-default=,--fpm-options-file=,--gem-bin-path=,--gem-package-prefix=,--gem-package-name-prefix=,--gem-gem=,--gem-shebang=,--gem-fix-name,--no-gem-fix-name,--gem-fix-dependencies,--no-gem-fix-dependencies,--gem-env-shebang,--no-gem-env-shebang,--gem-prerelease,--no-gem-prerelease,--gem-disable-dependency=,--gem-embed-dependencies,--no-gem-embed-dependencies,--gem-version-bins,--no-gem-version-bins,--gem-stagingdir=,--gem-git-repo=,--gem-git-branch=,--cpan-perl-bin=,--cpan-cpanm-bin=,--cpan-mirror=,--cpan-mirror-only,--no-cpan-mirror-only,--cpan-package-name-prefix=,--cpan-test,--no-cpan-test,--cpan-verbose,--no-cpan-verbose,--cpan-perl-lib-path=,--cpan-sandbox-non-core,--no-cpan-sandbox-non-core,--cpan-cpanm-force,--no-cpan-cpanm-force,--deb-ignore-iteration-in-dependencies,--no-deb-ignore-iteration-in-dependencies,--deb-build-depends=,--deb-pre-depends=,--deb-compression=,--deb-dist=,--deb-custom-control=,--deb-config=,--deb-templates=,--deb-installed-size=,--deb-priority=,--deb-use-file-permissions,--no-deb-use-file-permissions,--deb-user=,--deb-group=,--deb-changelog=,--deb-generate-changes,--no-deb-generate-changes,--deb-upstream-changelog=,--deb-recommends=,--deb-suggests=,--deb-meta-file=,--deb-interest=,--deb-activate=,--deb-interest-noawait=,--deb-activate-noawait=,--deb-field=,--deb-no-default-config-files,--no-deb-no-default-config-files,--deb-auto-config-files,--no-deb-auto-config-files,--deb-shlibs=,--deb-init=,--deb-default=,--deb-upstart=,--deb-systemd=,--deb-systemd-enable,--no-deb-systemd-enable,--deb-systemd-auto-start,--no-deb-systemd-auto-start,--deb-systemd-restart-after-upgrade,--no-deb-systemd-restart-after-upgrade,--deb-after-purge=,--deb-maintainerscripts-force-errorchecks,--no-deb-maintainerscripts-force-errorchecks,--npm-bin=,--npm-package-name-prefix=,--npm-registry=,--rpm-use-file-permissions,--no-rpm-use-file-permissions,--rpm-user=,--rpm-group=,--rpm-defattrfile=,--rpm-defattrdir=,--rpm-rpmbuild-define=,--rpm-dist=,--rpm-digest=,--rpm-compression-level=,--rpm-compression=,--rpm-os=,--rpm-changelog=,--rpm-summary=,--rpm-sign,--no-rpm-sign,--rpm-auto-add-directories,--no-rpm-auto-add-directories,--rpm-auto-add-exclude-directories=,--rpm-autoreqprov,--no-rpm-autoreqprov,--rpm-autoreq,--no-rpm-autoreq,--rpm-autoprov,--no-rpm-autoprov,--rpm-attr=,--rpm-init=,--rpm-filter-from-provides=,--rpm-filter-from-requires=,--rpm-tag=,--rpm-ignore-iteration-in-dependencies,--no-rpm-ignore-iteration-in-dependencies,--rpm-verbatim-gem-dependencies,--no-rpm-verbatim-gem-dependencies,--rpm-macro-expansion,--no-rpm-macro-expansion,--rpm-verifyscript=,--rpm-pretrans=,--rpm-posttrans=,--rpm-trigger-before-install=,--rpm-trigger-after-install=,--rpm-trigger-before-uninstall=,--rpm-trigger-after-target-uninstall=,--pear-package-name-prefix=,--pear-channel=,--pear-channel-update,--no-pear-channel-update,--pear-bin-dir=,--pear-php-bin=,--pear-php-dir=,--pear-data-dir=,--python-bin=,--python-easyinstall=,--python-pip=,--python-pypi=,--python-trusted-host=,--python-package-prefix=,--python-package-name-prefix=,--python-fix-name,--no-python-fix-name,--python-fix-dependencies,--no-python-fix-dependencies,--python-downcase-name,--no-python-downcase-name,--python-downcase-dependencies,--no-python-downcase-dependencies,--python-install-bin=,--python-install-lib=,--python-install-data=,--python-dependencies,--no-python-dependencies,--python-obey-requirements-txt,--no-python-obey-requirements-txt,--python-scripts-executable=,--python-disable-dependency=,--python-setup-py-arguments=,--python-internal-pip,--no-python-internal-pip,--osxpkg-identifier-prefix=,--osxpkg-payload-free,--no-osxpkg-payload-free,--osxpkg-ownership=,--osxpkg-postinstall-action=,--osxpkg-dont-obsolete=,--solaris-user=,--solaris-group=,--p5p-user=,--p5p-group=,--p5p-zonetype=,--p5p-publisher=,--p5p-lint,--no-p5p-lint,--p5p-validate,--no-p5p-validate,--freebsd-origin=,--snap-yaml=,--snap-confinement=,--snap-grade=,--pacman-optional-depends=,--pacman-use-file-permissions,--no-pacman-use-file-permissions,--pacman-user=,--pacman-group=,--pacman-compression=,--pleaserun-name=,--pleaserun-chdir=,--pleaserun-user=,--virtualenv-pypi=,--virtualenv-package-name-prefix=,--virtualenv-install-location=,--virtualenv-fix-name,--no-virtualenv-fix-name,--virtualenv-other-files-dir=,--virtualenv-pypi-extra-url=,--virtualenv-setup-install,--no-virtualenv-setup-install,--virtualenv-system-site-packages,--no-virtualenv-system-site-packages,--virtualenv-find-links="
set -l C000 "$query '$opts' option_is -t --output-type -s --input-type -- gem"
set -l C001 "$query '$opts' option_is -t --output-type -s --input-type -- cpan"
set -l C002 "$query '$opts' option_is -t --output-type -s --input-type -- deb"
set -l C003 "$query '$opts' option_is -t --output-type -s --input-type -- npm"
set -l C004 "$query '$opts' option_is -t --output-type -s --input-type -- rpm"
set -l C005 "$query '$opts' option_is -t --output-type -s --input-type -- pear"
set -l C006 "$query '$opts' option_is -t --output-type -s --input-type -- python"
set -l C007 "$query '$opts' option_is -t --output-type -s --input-type -- osxpkg"
set -l C008 "$query '$opts' option_is -t --output-type -s --input-type -- solaris"
set -l C009 "$query '$opts' option_is -t --output-type -s --input-type -- p5p"
set -l C010 "$query '$opts' option_is -t --output-type -s --input-type -- freebsd"
set -l C011 "$query '$opts' option_is -t --output-type -s --input-type -- snap"
set -l C012 "$query '$opts' option_is -t --output-type -s --input-type -- pacman"
set -l C013 "$query '$opts' option_is -t --output-type -s --input-type -- pleaserun"
set -l C014 "$query '$opts' option_is -t --output-type -s --input-type -- virtualenv"
set -l C015 "$query '$opts' num_of_positionals -ge 0"
complete -c $prog -s t -l output-type -d 'the type of package you want to create (deb, rpm, solaris, etc)' -x -a 'apk cpan deb dir empty freebsd gem npm osxpkg p5p pacman pear pkgin pleaserun puppet python rpm sh snap solaris tar virtualenv zip'
complete -c $prog -s s -l input-type -d 'the package type to use as input (gem, rpm, python, etc)' -x -a 'apk cpan deb dir empty freebsd gem npm osxpkg p5p pacman pear pkgin pleaserun puppet python rpm sh snap solaris tar virtualenv zip'
complete -c $prog -s C -l chdir -d 'Change directory to here before searching for files' -x -a '(__fish_complete_directories)'
complete -c $prog -l prefix -d "A path to prefix files with when building the target package. This may not be necessary for all input packages. For example, the 'gem' type will prefix with your gem directory automatically." -x
complete -c $prog -s p -l package -d 'The package file path to output.' -x
complete -c $prog -s f -l force -d 'Force output even if it will overwrite an existing file (default: false)' -f
complete -c $prog -s n -l name -d 'The name to give to the package' -x
complete -c $prog -l log -d 'Set the log level. Values: error, warn, info, debug.' -x -a 'error warn info debug'
complete -c $prog -l verbose -d 'Enable verbose output' -f
complete -c $prog -l debug -d 'Enable debug output' -f
complete -c $prog -l debug-workspace -d 'Keep any file workspaces around for debugging. This will disable automatic cleanup of package staging and build paths. It will also print which directories are available.' -f
complete -c $prog -s v -l version -d 'The version to give to the package (default: 1.0)' -x
complete -c $prog -l iteration -d "The iteration to give to the package. RPM calls this the 'release'. FreeBSD calls it 'PORTREVISION'. Debian calls this 'debian_revision'" -x
complete -c $prog -l epoch -d "The epoch value for this package. RPM and Debian calls this 'epoch'. FreeBSD calls this 'PORTEPOCH'" -x
complete -c $prog -l license -d '(optional) license name for this package' -x
complete -c $prog -l vendor -d '(optional) vendor name for this package' -x
complete -c $prog -l category -d '(optional) category this package belongs to (default: "none")' -x
complete -c $prog -s d -l depends -d "A dependency. This flag can be specified multiple times. Value is usually in the form of: -d 'name' or -d 'name > version'" -x
complete -c $prog -l no-depends -d 'Do not list any dependencies in this package (default: false)' -f
complete -c $prog -l no-auto-depends -d 'Do not list any dependencies in this package automatically (default: false)' -f
complete -c $prog -l provides -d 'What this package provides (usually a name). This flag can be specified multiple times.' -x
complete -c $prog -l conflicts -d 'Other packages/versions this package conflicts with. This flag can be specified multiple times.' -x
complete -c $prog -l replaces -d "Other packages/versions this package replaces. Equivalent of rpm's 'Obsoletes'. This flag can be specified multiple times." -x
complete -c $prog -l config-files -d "Mark a file in the package as being a config file. This uses 'conffiles' in debs and %config in rpm. If you have multiple files to mark as configuration files, specify this flag multiple times.  If argument is directory all files inside it will be recursively marked as config files." -x
complete -c $prog -l directories -d 'Recursively mark a directory as being owned by the package. Use this flag multiple times if you have multiple directories and they are not under the same parent directory' -x
complete -c $prog -s a -l architecture -d "The architecture name. Usually matches 'uname -m'. For automatic values, you can use '-a all' or '-a native'. These two strings will be translated into the correct value for your platform and target package type." -x
complete -c $prog -s m -l maintainer -d 'The maintainer of this package. (default: "<user@host>")' -x
complete -c $prog -s S -l package-name-suffix -d 'a name suffix to append to package and dependencies.' -x
complete -c $prog -s e -l edit -d 'Edit the package spec before building. (default: false)' -f
complete -c $prog -s x -l exclude -d 'Exclude paths matching pattern (shell wildcard globs valid here). If you have multiple file patterns to exclude, specify this flag multiple times.' -x
complete -c $prog -l exclude-file -d 'The path to a file containing a newline-sparated list of patterns to exclude from input.' -Fr
complete -c $prog -l description -d 'Add a description for this package. You can include '"'"'\n'"'"' sequences to indicate newline breaks. (default: "no description")' -x
complete -c $prog -l url -d 'Add a url for this package. (default: "http://example.com/no-uri-given")' -x
complete -c $prog -l inputs -d 'The path to a file containing a newline-separated list of files and dirs to use as input.' -Fr
complete -c $prog -l post-install -d '(DEPRECATED, use --after-install) A script to be run after package installation' -Fr
complete -c $prog -l pre-install -d '(DEPRECATED, use --before-install) A script to be run before package installation' -Fr
complete -c $prog -l post-uninstall -d '(DEPRECATED, use --after-remove) A script to be run after package removal' -Fr
complete -c $prog -l pre-uninstall -d '(DEPRECATED, use --before-remove) A script to be run before package removal' -Fr
complete -c $prog -l after-install -d 'A script to be run after package installation' -Fr
complete -c $prog -l before-install -d 'A script to be run before package installation' -Fr
complete -c $prog -l after-remove -d 'A script to be run after package removal' -Fr
complete -c $prog -l before-remove -d 'A script to be run before package removal' -Fr
complete -c $prog -l after-upgrade -d 'A script to be run after package upgrade' -Fr
complete -c $prog -l before-upgrade -d 'A script to be run before package upgrade' -Fr
complete -c $prog -l template-scripts -d 'Allow scripts to be templated. This lets you use ERB to template your packaging scripts (for --after-install, etc). For example, you can do things like <%= name %> to get the package name. For more information, see the fpm wiki: https://github.com/jordansissel/fpm/wiki/Script-Templates' -f
complete -c $prog -l template-value -d "Make 'key' available in script templates, so <%= key %> given will be the provided value. Implies --template-scripts" -x
complete -c $prog -l workdir -d 'The directory you want fpm to do its work in, where '"'"'work'"'"' is any file copying, downloading, etc. Roughly any scratch space fpm needs to build your package. (default: "/tmp")' -x -a '(__fish_complete_directories)'
complete -c $prog -l source-date-epoch-from-changelog -d 'Use release date from changelog as timestamp on generated files to reduce nondeterminism. Experimental; only implemented for gem so far.  (default: false)' -f
complete -c $prog -l source-date-epoch-default -d 'If no release date otherwise specified, use this value as timestamp on generated files to reduce nondeterminism. Reproducible build environments such as dpkg-dev and rpmbuild set this via envionment variable SOURCE_DATE_EPOCH variable to the integer unix timestamp to use in generated archives, and expect tools like fpm to use it as a hint to avoid nondeterministic output. This is a Unix timestamp, i.e. number of seconds since 1 Jan 1970 UTC. See https://reproducible-builds.org/specs/source-date-epoch  (default: $SOURCE_DATE_EPOCH)' -x
complete -c $prog -l fpm-options-file -d 'A file that contains additional fpm options. Any fpm flag format is valid in this file. This can be useful on build servers where you want to use a common configuration or inject other parameters from a file instead of from a command-line flag..' -Fr
complete -c $prog -n $C000 -l gem-bin-path -d 'The directory to install gem executables' -x
complete -c $prog -n $C000 -l gem-package-prefix -d '(DEPRECATED, use --package-name-prefix) Name to prefix the package name with.' -x
complete -c $prog -n $C000 -l gem-package-name-prefix -d 'Name to prefix the package name with. (default: "rubygem")' -x
complete -c $prog -n $C000 -l gem-gem -d 'The path to the '"'"'gem'"'"' tool (defaults to '"'"'gem'"'"' and searches your $PATH) (default: "gem")' -x
complete -c $prog -n $C000 -l gem-shebang -d 'Replace the shebang in the executables in the bin path with a custom string (default: nil)' -x
complete -c $prog -n $C000 -l gem-fix-name -d 'Should the target package name be prefixed? (default: true)' -f
complete -c $prog -n $C000 -l no-gem-fix-name -d 'Should the target package name be prefixed? (default: true)' -f
complete -c $prog -n $C000 -l gem-fix-dependencies -d 'Should the package dependencies be prefixed? (default: true)' -f
complete -c $prog -n $C000 -l no-gem-fix-dependencies -d 'Should the package dependencies be prefixed? (default: true)' -f
complete -c $prog -n $C000 -l gem-env-shebang -d 'Should the target package have the shebang rewritten to use env? (default: true)' -f
complete -c $prog -n $C000 -l no-gem-env-shebang -d 'Should the target package have the shebang rewritten to use env? (default: true)' -f
complete -c $prog -n $C000 -l gem-prerelease -d 'Allow prerelease versions of a gem (default: false)' -f
complete -c $prog -n $C000 -l no-gem-prerelease -d 'Allow prerelease versions of a gem (default: false)' -f
complete -c $prog -n $C000 -l gem-disable-dependency -d 'The gem name to remove from dependency list' -x
complete -c $prog -n $C000 -l gem-embed-dependencies -d 'Should the gem dependencies be installed? (default: false)' -f
complete -c $prog -n $C000 -l no-gem-embed-dependencies -d 'Should the gem dependencies be installed? (default: false)' -f
complete -c $prog -n $C000 -l gem-version-bins -d 'Append the version to the bins (default: false)' -f
complete -c $prog -n $C000 -l no-gem-version-bins -d 'Append the version to the bins (default: false)' -f
complete -c $prog -n $C000 -l gem-stagingdir -d 'The directory where fpm installs the gem temporarily before conversion. Normally a random subdirectory of workdir.' -x
complete -c $prog -n $C000 -l gem-git-repo -d 'Use this git repo address as the source of the gem instead of rubygems.org. (default: nil)' -x
complete -c $prog -n $C000 -l gem-git-branch -d 'When using a git repo as the source of the gem instead of rubygems.org, use this git branch. (default: nil)' -x
complete -c $prog -n $C001 -l cpan-perl-bin -d 'The path to the perl executable you wish to run. (default: "perl")' -x -a '(__fish_complete_command)'
complete -c $prog -n $C001 -l cpan-cpanm-bin -d 'The path to the cpanm executable you wish to run. (default: "cpanm")' -x -a '(__fish_complete_command)'
complete -c $prog -n $C001 -l cpan-mirror -d 'The CPAN mirror to use instead of the default.' -x
complete -c $prog -n $C001 -l cpan-mirror-only -d 'Only use the specified mirror for metadata. (default: false)' -f
complete -c $prog -n $C001 -l no-cpan-mirror-only -d 'Only use the specified mirror for metadata. (default: false)' -f
complete -c $prog -n $C001 -l cpan-package-name-prefix -d 'Name to prefix the package name with. (default: "perl")' -x
complete -c $prog -n $C001 -l cpan-test -d 'Run the tests before packaging? (default: true)' -f
complete -c $prog -n $C001 -l no-cpan-test -d 'Run the tests before packaging? (default: true)' -f
complete -c $prog -n $C001 -l cpan-verbose -d 'Produce verbose output from cpanm? (default: false)' -f
complete -c $prog -n $C001 -l no-cpan-verbose -d 'Produce verbose output from cpanm? (default: false)' -f
complete -c $prog -n $C001 -l cpan-perl-lib-path -d 'Path of target Perl Libraries' -x
complete -c $prog -n $C001 -l cpan-sandbox-non-core -d "Sandbox all non-core modules, even if they're already installed (default: true)" -f
complete -c $prog -n $C001 -l no-cpan-sandbox-non-core -d "Sandbox all non-core modules, even if they're already installed (default: true)" -f
complete -c $prog -n $C001 -l cpan-cpanm-force -d 'Pass the --force parameter to cpanm (default: false)' -f
complete -c $prog -n $C001 -l no-cpan-cpanm-force -d 'Pass the --force parameter to cpanm (default: false)' -f
complete -c $prog -n $C002 -l deb-ignore-iteration-in-dependencies -d "For '=' (equal) dependencies, allow iterations on the specified version. Default is to be specific. This option allows the same version of a package but any iteration is permitted" -f
complete -c $prog -n $C002 -l no-deb-ignore-iteration-in-dependencies -d "For '=' (equal) dependencies, allow iterations on the specified version. Default is to be specific. This option allows the same version of a package but any iteration is permitted" -f
complete -c $prog -n $C002 -l deb-build-depends -d 'Add DEPENDENCY as a Build-Depends' -x
complete -c $prog -n $C002 -l deb-pre-depends -d 'Add DEPENDENCY as a Pre-Depends' -x
complete -c $prog -n $C002 -l deb-compression -d 'The compression type to use, must be one of gz, bzip2, xz, none. (default: "gz")' -x -a 'gz bzip2 xz none'
complete -c $prog -n $C002 -l deb-dist -d 'Set the deb distribution. (default: "unstable")' -x
complete -c $prog -n $C002 -l deb-custom-control -d 'Custom version of the Debian control file.' -Fr
complete -c $prog -n $C002 -l deb-config -d 'Add SCRIPTPATH as debconf config file.' -Fr
complete -c $prog -n $C002 -l deb-templates -d 'Add FILEPATH as debconf templates file.' -Fr
complete -c $prog -n $C002 -l deb-installed-size -d 'The installed size, in kilobytes. If omitted, this will be calculated automatically' -x
complete -c $prog -n $C002 -l deb-priority -d 'The debian package '"'"'priority'"'"' value. (default: "optional")' -x
complete -c $prog -n $C002 -l deb-use-file-permissions -d 'Use existing file permissions when defining ownership and modes' -f
complete -c $prog -n $C002 -l no-deb-use-file-permissions -d 'Use existing file permissions when defining ownership and modes' -f
complete -c $prog -n $C002 -l deb-user -d 'The owner of files in this package (default: "root")' -x -a '(__fish_complete_users)'
complete -c $prog -n $C002 -l deb-group -d 'The group owner of files in this package (default: "root")' -x -a '(__fish_complete_groups)'
complete -c $prog -n $C002 -l deb-changelog -d 'Add FILEPATH as debian changelog' -Fr
complete -c $prog -n $C002 -l deb-generate-changes -d 'Generate PACKAGENAME.changes file. (default: false)' -f
complete -c $prog -n $C002 -l no-deb-generate-changes -d 'Generate PACKAGENAME.changes file. (default: false)' -f
complete -c $prog -n $C002 -l deb-upstream-changelog -d 'Add FILEPATH as upstream changelog' -Fr
complete -c $prog -n $C002 -l deb-recommends -d 'Add PACKAGE to Recommends' -x
complete -c $prog -n $C002 -l deb-suggests -d 'Add PACKAGE to Suggests' -x
complete -c $prog -n $C002 -l deb-meta-file -d 'Add FILEPATH to DEBIAN directory' -Fr
complete -c $prog -n $C002 -l deb-interest -d 'Package is interested in EVENT trigger' -x
complete -c $prog -n $C002 -l deb-activate -d 'Package activates EVENT trigger' -x
complete -c $prog -n $C002 -l deb-interest-noawait -d 'Package is interested in EVENT trigger without awaiting' -x
complete -c $prog -n $C002 -l deb-activate-noawait -d 'Package activates EVENT trigger' -x
complete -c $prog -n $C002 -l deb-field -d "'FIELD: VALUE' Add custom field to the control file" -x
complete -c $prog -n $C002 -l deb-no-default-config-files -d 'Do not add all files in /etc as configuration files by default for Debian packages. (default: false)' -f
complete -c $prog -n $C002 -l no-deb-no-default-config-files -d 'Do not add all files in /etc as configuration files by default for Debian packages. (default: false)' -f
complete -c $prog -n $C002 -l deb-auto-config-files -d 'Init script and default configuration files will be labeled as configuration files for Debian packages. (default: true)' -f
complete -c $prog -n $C002 -l no-deb-auto-config-files -d 'Init script and default configuration files will be labeled as configuration files for Debian packages. (default: true)' -f
complete -c $prog -n $C002 -l deb-shlibs -d 'Include control/shlibs content. This flag expects a string that is used as the contents of the shlibs file. See the following url for a description of this file and its format: http://www.debian.org/doc/debian-policy/ch-sharedlibs.html#s-shlibs' -x
complete -c $prog -n $C002 -l deb-init -d 'Add FILEPATH as an init script' -Fr
complete -c $prog -n $C002 -l deb-default -d 'Add FILEPATH as /etc/default configuration' -Fr
complete -c $prog -n $C002 -l deb-upstart -d 'Add FILEPATH as an upstart script' -Fr
complete -c $prog -n $C002 -l deb-systemd -d 'Add FILEPATH as a systemd script' -Fr
complete -c $prog -n $C002 -l deb-systemd-enable -d 'Enable service on install or upgrade (default: false)' -f
complete -c $prog -n $C002 -l no-deb-systemd-enable -d 'Enable service on install or upgrade (default: false)' -f
complete -c $prog -n $C002 -l deb-systemd-auto-start -d 'Start service after install or upgrade (default: false)' -f
complete -c $prog -n $C002 -l no-deb-systemd-auto-start -d 'Start service after install or upgrade (default: false)' -f
complete -c $prog -n $C002 -l deb-systemd-restart-after-upgrade -d 'Restart service after upgrade (default: true)' -f
complete -c $prog -n $C002 -l no-deb-systemd-restart-after-upgrade -d 'Restart service after upgrade (default: true)' -f
complete -c $prog -n $C002 -l deb-after-purge -d 'A script to be run after package removal to purge remaining (config) files (a.k.a. postrm purge within apt-get purge)' -Fr
complete -c $prog -n $C002 -l deb-maintainerscripts-force-errorchecks -d 'Activate errexit shell option according to lintian. https://lintian.debian.org/tags/maintainer-script-ignores-errors.html (default: false)' -f
complete -c $prog -n $C002 -l no-deb-maintainerscripts-force-errorchecks -d 'Activate errexit shell option according to lintian. https://lintian.debian.org/tags/maintainer-script-ignores-errors.html (default: false)' -f
complete -c $prog -n $C003 -l npm-bin -d 'The path to the npm executable you wish to run. (default: "npm")' -x -a '(__fish_complete_command)'
complete -c $prog -n $C003 -l npm-package-name-prefix -d 'Name to prefix the package name with. (default: "node")' -x
complete -c $prog -n $C003 -l npm-registry -d 'The npm registry to use instead of the default.' -x
complete -c $prog -n $C004 -l rpm-use-file-permissions -d 'Use existing file permissions when defining ownership and modes.' -f
complete -c $prog -n $C004 -l no-rpm-use-file-permissions -d 'Use existing file permissions when defining ownership and modes.' -f
complete -c $prog -n $C004 -l rpm-user -d 'Set the user to USER in the %files section. Overrides the user when used with use-file-permissions setting.' -x -a '(__fish_complete_users)'
complete -c $prog -n $C004 -l rpm-group -d 'Set the group to GROUP in the %files section. Overrides the group when used with use-file-permissions setting.' -x -a '(__fish_complete_groups)'
complete -c $prog -n $C004 -l rpm-defattrfile -d 'Set the default file mode (%defattr). (default: "-")' -x
complete -c $prog -n $C004 -l rpm-defattrdir -d 'Set the default dir mode (%defattr). (default: "-")' -x
complete -c $prog -n $C004 -l rpm-rpmbuild-define -d 'Pass a --define argument to rpmbuild.' -x
complete -c $prog -n $C004 -l rpm-dist -d 'Set the rpm distribution.' -x
complete -c $prog -n $C004 -l rpm-digest -d 'Select a digest algorithm. md5 works on the most platforms. md5|sha1|sha256|sha384|sha512 (default: "md5")' -x -a 'md5 sha1 sha256 sha384 sha512'
complete -c $prog -n $C004 -l rpm-compression-level -d 'Select a compression level. 0 is store-only. 9 is max compression. (default: "9")' -x -a '(command seq 0 9)'
complete -c $prog -n $C004 -l rpm-compression -d 'Select a compression method. gzip works on the most platforms. none|xz|xzmt|gzip|bzip2 (default: "gzip")' -x -a 'none xz xzmt gzip bzip2'
complete -c $prog -n $C004 -l rpm-os -d "The operating system to target this rpm for. You want to set this to 'linux' if you are using fpm on OS X, for example" -x
complete -c $prog -n $C004 -l rpm-changelog -d 'Add changelog from FILEPATH contents' -Fr
complete -c $prog -n $C004 -l rpm-summary -d 'Set the RPM summary. Overrides the first line on the description if set' -x
complete -c $prog -n $C004 -l rpm-sign -d 'Pass --sign to rpmbuild' -f
complete -c $prog -n $C004 -l no-rpm-sign -d 'Pass --sign to rpmbuild' -f
complete -c $prog -n $C004 -l rpm-auto-add-directories -d 'Auto add directories not part of filesystem' -f
complete -c $prog -n $C004 -l no-rpm-auto-add-directories -d 'Auto add directories not part of filesystem' -f
complete -c $prog -n $C004 -l rpm-auto-add-exclude-directories -d "Additional directories ignored by '--rpm-auto-add-directories' flag" -x
complete -c $prog -n $C004 -l rpm-autoreqprov -d "Enable RPM's AutoReqProv option" -f
complete -c $prog -n $C004 -l no-rpm-autoreqprov -d "Enable RPM's AutoReqProv option" -f
complete -c $prog -n $C004 -l rpm-autoreq -d "Enable RPM's AutoReq option" -f
complete -c $prog -n $C004 -l no-rpm-autoreq -d "Enable RPM's AutoReq option" -f
complete -c $prog -n $C004 -l rpm-autoprov -d "Enable RPM's AutoProv option" -f
complete -c $prog -n $C004 -l no-rpm-autoprov -d "Enable RPM's AutoProv option" -f
complete -c $prog -n $C004 -l rpm-attr -d 'Set the attribute for a file (%attr), e.g. --rpm-attr 750,user1,group1:/some/file' -x
complete -c $prog -n $C004 -l rpm-init -d 'Add FILEPATH as an init script' -Fr
complete -c $prog -n $C004 -l rpm-filter-from-provides -d 'Set %filter_from_provides to the supplied REGEX.' -x
complete -c $prog -n $C004 -l rpm-filter-from-requires -d 'Set %filter_from_requires to the supplied REGEX.' -x
complete -c $prog -n $C004 -l rpm-tag -d "Adds a custom tag in the spec file as is. Example: --rpm-tag 'Requires(post): /usr/sbin/alternatives'" -x
complete -c $prog -n $C004 -l rpm-ignore-iteration-in-dependencies -d "For '=' (equal) dependencies, allow iterations on the specified version. Default is to be specific. This option allows the same version of a package but any iteration is permitted" -f
complete -c $prog -n $C004 -l no-rpm-ignore-iteration-in-dependencies -d "For '=' (equal) dependencies, allow iterations on the specified version. Default is to be specific. This option allows the same version of a package but any iteration is permitted" -f
complete -c $prog -n $C004 -l rpm-verbatim-gem-dependencies -d "When converting from a gem, leave the old (fpm 0.4.x) style dependency names. This flag will use the old 'rubygem-foo' names in rpm requires instead of the redhat style rubygem(foo). (default: false)" -f
complete -c $prog -n $C004 -l no-rpm-verbatim-gem-dependencies -d "When converting from a gem, leave the old (fpm 0.4.x) style dependency names. This flag will use the old 'rubygem-foo' names in rpm requires instead of the redhat style rubygem(foo). (default: false)" -f
complete -c $prog -n $C004 -l rpm-macro-expansion -d 'install-time macro expansion in %pre %post %preun %postun scripts (see: https://rpm.org/user_doc/scriptlet_expansion.html) (default: false)' -f
complete -c $prog -n $C004 -l no-rpm-macro-expansion -d 'install-time macro expansion in %pre %post %preun %postun scripts (see: https://rpm.org/user_doc/scriptlet_expansion.html) (default: false)' -f
complete -c $prog -n $C004 -l rpm-verifyscript -d 'a script to be run on verification' -Fr
complete -c $prog -n $C004 -l rpm-pretrans -d 'pretrans script' -Fr
complete -c $prog -n $C004 -l rpm-posttrans -d 'posttrans script' -Fr
complete -c $prog -n $C004 -l rpm-trigger-before-install -d "'[OPT]PACKAGE: FILEPATH' Adds a rpm trigger script located in FILEPATH, having 'OPT' options and linking to 'PACKAGE'. PACKAGE can be a comma seperated list of packages. See: http://rpm.org/api/4.4.2.2/triggers.html" -x
complete -c $prog -n $C004 -l rpm-trigger-after-install -d "'[OPT]PACKAGE: FILEPATH' Adds a rpm trigger script located in FILEPATH, having 'OPT' options and linking to 'PACKAGE'. PACKAGE can be a comma seperated list of packages. See: http://rpm.org/api/4.4.2.2/triggers.html" -x
complete -c $prog -n $C004 -l rpm-trigger-before-uninstall -d "'[OPT]PACKAGE: FILEPATH' Adds a rpm trigger script located in FILEPATH, having 'OPT' options and linking to 'PACKAGE'. PACKAGE can be a comma seperated list of packages. See: http://rpm.org/api/4.4.2.2/triggers.html" -x
complete -c $prog -n $C004 -l rpm-trigger-after-target-uninstall -d "'[OPT]PACKAGE: FILEPATH' Adds a rpm trigger script located in FILEPATH, having 'OPT' options and linking to 'PACKAGE'. PACKAGE can be a comma seperated list of packages. See: http://rpm.org/api/4.4.2.2/triggers.html" -x
complete -c $prog -n $C005 -l pear-package-name-prefix -d 'Name prefix for pear package (default: "php-pear")' -x
complete -c $prog -n $C005 -l pear-channel -d 'The pear channel url to use instead of the default.' -x
complete -c $prog -n $C005 -l pear-channel-update -d "call 'pear channel-update' prior to installation" -f
complete -c $prog -n $C005 -l no-pear-channel-update -d "call 'pear channel-update' prior to installation" -f
complete -c $prog -n $C005 -l pear-bin-dir -d 'Directory to put binaries in' -x
complete -c $prog -n $C005 -l pear-php-bin -d 'Specify php executable path if differs from the os used for packaging' -x
complete -c $prog -n $C005 -l pear-php-dir -d 'Specify php dir relative to prefix if differs from pear default (pear/php)' -x
complete -c $prog -n $C005 -l pear-data-dir -d 'Specify php dir relative to prefix if differs from pear default (pear/data)' -x
complete -c $prog -n $C006 -l python-bin -d 'The path to the python executable you wish to run. (default: "python")' -x -a '(__fish_complete_command)'
complete -c $prog -n $C006 -l python-easyinstall -d 'The path to the easy_install executable tool (default: "easy_install")' -x -a '(__fish_complete_command)'
complete -c $prog -n $C006 -l python-pip -d 'The path to the pip executable tool. If not specified, easy_install is used instead (default: nil)' -x -a '(__fish_complete_command)'
complete -c $prog -n $C006 -l python-pypi -d 'PyPi Server uri for retrieving packages. (default: "https://pypi.python.org/simple")' -x
complete -c $prog -n $C006 -l python-trusted-host -d 'Mark this host or host:port pair as trusted for pip (default: nil)' -x
complete -c $prog -n $C006 -l python-package-prefix -d '(DEPRECATED, use --package-name-prefix) Name to prefix the package name with.' -x
complete -c $prog -n $C006 -l python-package-name-prefix -d 'Name to prefix the package name with. (default: "python")' -x
complete -c $prog -n $C006 -l python-fix-name -d 'Should the target package name be prefixed? (default: true)' -f
complete -c $prog -n $C006 -l no-python-fix-name -d 'Should the target package name be prefixed? (default: true)' -f
complete -c $prog -n $C006 -l python-fix-dependencies -d 'Should the package dependencies be prefixed? (default: true)' -f
complete -c $prog -n $C006 -l no-python-fix-dependencies -d 'Should the package dependencies be prefixed? (default: true)' -f
complete -c $prog -n $C006 -l python-downcase-name -d 'Should the target package name be in lowercase? (default: true)' -f
complete -c $prog -n $C006 -l no-python-downcase-name -d 'Should the target package name be in lowercase? (default: true)' -f
complete -c $prog -n $C006 -l python-downcase-dependencies -d 'Should the package dependencies be in lowercase? (default: true)' -f
complete -c $prog -n $C006 -l no-python-downcase-dependencies -d 'Should the package dependencies be in lowercase? (default: true)' -f
complete -c $prog -n $C006 -l python-install-bin -d 'The path to where python scripts should be installed to.' -x
complete -c $prog -n $C006 -l python-install-lib -d "The path to where python libs should be installed to (default depends on your python installation). Want to find out what your target platform is using? Run this: python -c 'from distutils.sysconfig import get_python_lib; print get_python_lib()'" -x
complete -c $prog -n $C006 -l python-install-data -d "The path to where data should be installed to. This is equivalent to 'python setup.py --install-data DATA_PATH" -x
complete -c $prog -n $C006 -l python-dependencies -d 'Include requirements defined in setup.py as dependencies. (default: true)' -f
complete -c $prog -n $C006 -l no-python-dependencies -d 'Include requirements defined in setup.py as dependencies. (default: true)' -f
complete -c $prog -n $C006 -l python-obey-requirements-txt -d 'Use a requirements.txt file in the top-level directory of the python package for dependency detection. (default: false)' -f
complete -c $prog -n $C006 -l no-python-obey-requirements-txt -d 'Use a requirements.txt file in the top-level directory of the python package for dependency detection. (default: false)' -f
complete -c $prog -n $C006 -l python-scripts-executable -d "Set custom python interpreter in installing scripts. By default distutils will replace python interpreter in installing scripts (specified by shebang) with current python interpreter (sys.executable). This option is equivalent to appending 'build_scripts --executable PYTHON_EXECUTABLE' arguments to 'setup.py install' command." -x -a '(__fish_complete_command)'
complete -c $prog -n $C006 -l python-disable-dependency -d 'The python package name to remove from dependency list (default: [])' -x
complete -c $prog -n $C006 -l python-setup-py-arguments -d 'Arbitrary argument(s) to be passed to setup.py (default: [])' -x
complete -c $prog -n $C006 -l python-internal-pip -d "Use the pip module within python to install modules - aka 'python -m pip'. This is the recommended usage since Python 3.4 (2014) instead of invoking the 'pip' script (default: true)" -f
complete -c $prog -n $C006 -l no-python-internal-pip -d "Use the pip module within python to install modules - aka 'python -m pip'. This is the recommended usage since Python 3.4 (2014) instead of invoking the 'pip' script (default: true)" -f
complete -c $prog -n $C007 -l osxpkg-identifier-prefix -d "Reverse domain prefix prepended to package identifier, ie. 'org.great.my'. If this is omitted, the identifer will be the package name." -x
complete -c $prog -n $C007 -l osxpkg-payload-free -d 'Define no payload, assumes use of script options. (default: false)' -f
complete -c $prog -n $C007 -l no-osxpkg-payload-free -d 'Define no payload, assumes use of script options. (default: false)' -f
complete -c $prog -n $C007 -l osxpkg-ownership -d '--ownership option passed to pkgbuild. Defaults to '"'"'recommended'"'"'. See pkgbuild(1). (default: "recommended")' -x
complete -c $prog -n $C007 -l osxpkg-postinstall-action -d "Post-install action provided in package metadata. Optionally one of 'logout', 'restart', 'shutdown'." -x -a 'logout restart shutdown'
complete -c $prog -n $C007 -l osxpkg-dont-obsolete -d "A file path for which to 'dont-obsolete' in the built PackageInfo. Can be specified multiple times." -x
complete -c $prog -n $C008 -l solaris-user -d 'Set the user to USER in the prototype files. (default: "root")' -x -a '(__fish_complete_users)'
complete -c $prog -n $C008 -l solaris-group -d 'Set the group to GROUP in the prototype file. (default: "root")' -x -a '(__fish_complete_groups)'
complete -c $prog -n $C009 -l p5p-user -d 'Set the user to USER in the prototype files. (default: "root")' -x
complete -c $prog -n $C009 -l p5p-group -d 'Set the group to GROUP in the prototype file. (default: "root")' -x
complete -c $prog -n $C009 -l p5p-zonetype -d 'Set the allowed zone types (global, nonglobal, both) (default: "value=global value=nonglobal")' -x
complete -c $prog -n $C009 -l p5p-publisher -d 'Set the publisher name for the repository (default: "FPM")' -x
complete -c $prog -n $C009 -l p5p-lint -d 'Check manifest with pkglint (default: true)' -f
complete -c $prog -n $C009 -l no-p5p-lint -d 'Check manifest with pkglint (default: true)' -f
complete -c $prog -n $C009 -l p5p-validate -d 'Validate with pkg install (default: true)' -f
complete -c $prog -n $C009 -l no-p5p-validate -d 'Validate with pkg install (default: true)' -f
complete -c $prog -n $C010 -l freebsd-origin -d 'Sets the FreeBSD '"'"'origin'"'"' pkg field (default: "fpm/<name>")' -x
complete -c $prog -n $C011 -l snap-yaml -d 'Custom version of the snap.yaml file.' -Fr
complete -c $prog -n $C011 -l snap-confinement -d 'Type of confinement to use for this snap. (default: "devmode")' -x
complete -c $prog -n $C011 -l snap-grade -d 'Grade of this snap. (default: "devel")' -x
complete -c $prog -n $C012 -l pacman-optional-depends -d 'Add an optional dependency to the pacman package.' -x
complete -c $prog -n $C012 -l pacman-use-file-permissions -d 'Use existing file permissions when defining ownership and modes' -f
complete -c $prog -n $C012 -l no-pacman-use-file-permissions -d 'Use existing file permissions when defining ownership and modes' -f
complete -c $prog -n $C012 -l pacman-user -d 'The owner of files in this package (default: "root")' -x -a '(__fish_complete_users)'
complete -c $prog -n $C012 -l pacman-group -d 'The group owner of files in this package (default: "root")' -x -a '(__fish_complete_groups)'
complete -c $prog -n $C012 -l pacman-compression -d 'The compression type to use, must be one of gz, bzip2, xz, zstd, none. (default: "zstd")' -x -a 'gz bzip2 xz zstd none'
complete -c $prog -n $C013 -l pleaserun-name -d 'The name of the service you are creating' -x
complete -c $prog -n $C013 -l pleaserun-chdir -d 'The working directory used by the service' -x -a '(__fish_complete_directories)'
complete -c $prog -n $C013 -l pleaserun-user -d 'The user to use for executing this program.' -x
complete -c $prog -n $C014 -l virtualenv-pypi -d 'PyPi Server uri for retrieving packages. (default: "https://pypi.python.org/simple")' -x
complete -c $prog -n $C014 -l virtualenv-package-name-prefix -d 'Name to prefix the package name with. (default: "virtualenv")' -x
complete -c $prog -n $C014 -l virtualenv-install-location -d 'DEPRECATED: Use --prefix instead.  Location to which to install the virtualenv by default. (default: "/usr/share/python")' -x
complete -c $prog -n $C014 -l virtualenv-fix-name -d 'Should the target package name be prefixed? (default: true)' -f
complete -c $prog -n $C014 -l no-virtualenv-fix-name -d 'Should the target package name be prefixed? (default: true)' -f
complete -c $prog -n $C014 -l virtualenv-other-files-dir -d 'Optionally, the contents of the specified directory may be added to the package. This is useful if the virtualenv needs configuration files, etc. (default: nil)' -x
complete -c $prog -n $C014 -l virtualenv-pypi-extra-url -d 'PyPi extra-index-url for pointing to your priviate PyPi (default: nil)' -x
complete -c $prog -n $C014 -l virtualenv-setup-install -d 'After building virtualenv run setup.py install useful when building a virtualenv for packages and including their requirements from' -f
complete -c $prog -n $C014 -l no-virtualenv-setup-install -d 'After building virtualenv run setup.py install useful when building a virtualenv for packages and including their requirements from' -f
complete -c $prog -n $C014 -l virtualenv-system-site-packages -d 'Give the virtual environment access to the global site-packages' -f
complete -c $prog -n $C014 -l no-virtualenv-system-site-packages -d 'Give the virtual environment access to the global site-packages' -f
complete -c $prog -n $C014 -l virtualenv-find-links -d "If a url or path to an html file, then parse for links to archives. If a local path or file:// url that's a directory, then look for archives in the directory listing. (default: nil)" -x
complete -c $prog -n $C015 -Fr

# vim: ft=fish ts=2 sts=2 sw=2 et
