/*
 * Deskflow -- mouse and keyboard sharing utility
 * SPDX-FileCopyrightText: (C) 2025 Deskflow Developers
 * SPDX-FileCopyrightText: (C) 2024 Symless Ltd.
 * SPDX-License-Identifier: GPL-2.0-only WITH LicenseRef-OpenSSL-Exception
 */

#pragma once

#include <QLabel>
#include <QObject>
#include <QString>

namespace validators {

class ValidationError : public QObject
{
public:
  explicit ValidationError(QObject *parent, QLabel *label = nullptr);
  const QString &message() const;
  void setMessage(const QString &message);

private:
  void clear();
  QString m_message;
  QLabel *m_label = nullptr;
};

} // namespace validators
