"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GsubReverseWriter = exports.GsubReverseReader = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const errors_1 = require("@ot-builder/errors");
const ot_layout_1 = require("@ot-builder/ot-layout");
const primitive_1 = require("@ot-builder/primitive");
const coverage_1 = require("../shared/coverage");
const shared_types_1 = require("./shared-types");
const SubtableFormat1 = {
    read(view, lookup, ctx) {
        const format = view.uint16();
        errors_1.Assert.FormatSupported(`ReverseChainSingleSubstFormat1`, format, 1);
        const covInput = view.next(coverage_1.Ptr16GidCoverage);
        const gsInput = coverage_1.CovUtils.glyphSetFromGidList(covInput, ctx.gOrd);
        const gssBacktrack = view.next(shared_types_1.SimpleCoverageArray, ctx.gOrd).reverse();
        const gssLookAhead = view.next(shared_types_1.SimpleCoverageArray, ctx.gOrd);
        const rule = {
            match: [...gssBacktrack, gsInput, ...gssLookAhead],
            doSubAt: gssBacktrack.length,
            replacement: new Map()
        };
        const glyphCount = view.uint16();
        errors_1.Assert.SizeMatch(`ReverseChainSingleSubstFormat1::glyphCount`, covInput.length, glyphCount);
        for (const from of covInput) {
            rule.replacement.set(ctx.gOrd.at(from), ctx.gOrd.at(view.uint16()));
        }
        lookup.rules.push(rule);
    },
    write(frag, rule, ctx) {
        let gm = [];
        for (const input of rule.match[rule.doSubAt]) {
            gm.push([
                ctx.gOrd.reverse(input),
                ctx.gOrd.reverse(rule.replacement.get(input) || input)
            ]);
        }
        gm = coverage_1.CovUtils.sortAuxMap(gm);
        frag.uint16(1)
            .push(coverage_1.Ptr16GidCoverage, coverage_1.CovUtils.gidListFromAuxMap(gm), ctx.trick)
            .push(shared_types_1.SimpleCoverageArray, rule.match.slice(0, rule.doSubAt), ctx.gOrd, ctx.trick)
            .push(shared_types_1.SimpleCoverageArray, rule.match.slice(rule.doSubAt + 1), ctx.gOrd, ctx.trick)
            .uint16(gm.length)
            .array(primitive_1.UInt16, coverage_1.CovUtils.valueListFromAuxMap(gm));
    }
};
class GsubReverseReader {
    createLookup() {
        return new ot_layout_1.Gsub.ReverseSub();
    }
    parseSubtable(view, lookup, ctx) {
        const format = view.lift(0).uint16();
        switch (format) {
            case 1:
                view.next(SubtableFormat1, lookup, ctx);
                break;
            default:
                throw errors_1.Errors.FormatNotSupported(`chaining subtable`, format);
        }
    }
}
exports.GsubReverseReader = GsubReverseReader;
class GsubReverseWriter {
    canBeUsed(l) {
        return l.type === ot_layout_1.Gsub.LookupType.Reverse;
    }
    getLookupType() {
        return 8;
    }
    getLookupTypeSymbol() {
        return ot_layout_1.Gsub.LookupType.Reverse;
    }
    createSubtableFragments(lookup, ctx) {
        const frags = [];
        for (const rule of lookup.rules) {
            ctx.stat.setContext(rule.match.length);
            frags.push(bin_util_1.Frag.from(SubtableFormat1, rule, ctx));
        }
        return frags;
    }
}
exports.GsubReverseWriter = GsubReverseWriter;
//# sourceMappingURL=gsub-reverse.js.map