"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.displayVersion = exports.displayHelp = exports.ArgParser = void 0;
const cli_help_shower_1 = require("@ot-builder/cli-help-shower");
const cli_shared_1 = require("@ot-builder/cli-shared");
const package_version_1 = require("./package-version");
class ArgParser {
    constructor() {
        this.inputs = [];
        this.unify = false;
        this.sparse = false;
        this.displayVersion = false;
        this.displayHelp = false;
        this.verbose = false;
        this.optimizationLevel = cli_shared_1.OptimizationLevel.None;
        this.recalcOs2XAvgCharWidth = false; // Never re-calculate this
        this.acceptArgs = true;
        this.argName = null;
    }
    arg(x) {
        if (x[0] === "-" && this.acceptArgs) {
            this.handleOption(x);
        }
        else {
            this.handleArgument(x);
        }
    }
    handleOption(x) {
        switch (x) {
            case "--":
                this.acceptArgs = false;
                return;
            case "-h":
            case "--help":
                this.displayHelp = true;
                return;
            case "-v":
            case "--version":
                this.displayVersion = true;
                return;
            case "-u":
            case "--unify":
                this.unify = true;
                return;
            case "-x":
            case "--sparse":
                this.sparse = true;
                return;
            case "--verbose":
                this.verbose = true;
                return;
            case "-o":
                this.argName = x;
                return;
            case `--optimize-speed`:
            case `-Op`:
                this.optimizationLevel = cli_shared_1.OptimizationLevel.Speed;
                return;
            case `--optimize-size`:
            case `-Oz`:
                this.optimizationLevel = cli_shared_1.OptimizationLevel.Size;
                return;
            default:
                throw new Error("Unrecognized option " + x);
        }
    }
    handleArgument(x) {
        if (this.argName) {
            if (this.argName === "-o")
                this.output = x;
            this.argName = null;
        }
        else {
            this.inputs.push(x);
        }
    }
}
exports.ArgParser = ArgParser;
function displayHelp() {
    new cli_help_shower_1.CliHelpShower()
        .message(`otb-ttc-bundle: TTC bundler, version ${package_version_1.packageVersion}`)
        .message(cli_help_shower_1.Style.Rule)
        .message(`Usage:`)
        .withIndent(cli_help_shower_1.Style.Bullet, s => {
        s.message(cli_help_shower_1.Style.Cmd `otb-ttc-bundle`, cli_help_shower_1.Style.Option `-h`, ";", cli_help_shower_1.Style.Cmd `otb-ttc-bundle`, cli_help_shower_1.Style.Option `--help`)
            .indent("")
            .message("Display help message");
    })
        .withIndent(cli_help_shower_1.Style.Bullet, s => {
        s.message(cli_help_shower_1.Style.Cmd `otb-ttc-bundle`, cli_help_shower_1.Style.Option `-v`, ";", cli_help_shower_1.Style.Cmd `otb-ttc-bundle`, cli_help_shower_1.Style.Option `--version`)
            .indent("")
            .message("Display version of this utility.");
    })
        .withIndent(cli_help_shower_1.Style.Bullet, s => {
        s.hangingIndent("  ").message(cli_help_shower_1.Style.Cmd `otb-ttc-bundle`, ...cli_help_shower_1.Style.OptRun(`options`), ...cli_help_shower_1.Style.OptRun(cli_help_shower_1.Style.Option `-o`, cli_help_shower_1.Style.Param `output`), ...[cli_help_shower_1.Style.Param `input_1`, `...`, cli_help_shower_1.Style.Param `input_n`]);
        s.indent("").message(`Bundles multiple TTF into one TTC with glyph sharing.`);
        s.withIndent(cli_help_shower_1.Style.Bullet, s => {
            s.message(cli_help_shower_1.Style.Option `-o`, cli_help_shower_1.Style.Param `output`)
                .indent(``)
                .message(`Set output file path.`);
            s.message(cli_help_shower_1.Style.Param `input_1`, `...`, cli_help_shower_1.Style.Param `input_n`)
                .indent(``)
                .message(`Input files, could be either TTF, OTF or TTC.`);
        });
        s.indent("").message(``).message(`Options:`);
        s.withIndent(cli_help_shower_1.Style.Bullet, s => {
            s.message(cli_help_shower_1.Style.Option `--verbose`)
                .indent(``)
                .message(`Set to verbose mode.`);
            s.message(cli_help_shower_1.Style.Option `-u`, `;`, cli_help_shower_1.Style.Option `--unify`)
                .indent(``)
                .message(`Unify glyph set.`);
            s.message(cli_help_shower_1.Style.Option `-x`, `;`, cli_help_shower_1.Style.Option `--sparse`)
                .indent(``)
                .message(`Enable sparse glyph sharing (TrueType outline only).`);
            s.message(cli_help_shower_1.Style.Option `-Op`, `;`, cli_help_shower_1.Style.Option `--optimize-speed`)
                .indent(``)
                .message(`Optimize the output data arrangement for faster layout.`);
            s.message(cli_help_shower_1.Style.Option `-Oz`, `;`, cli_help_shower_1.Style.Option `--optimize-size`)
                .indent(``)
                .message(`Optimize the output data arrangement for smaller file size.`);
        });
    });
}
exports.displayHelp = displayHelp;
function displayVersion() {
    console.log(package_version_1.packageVersion);
}
exports.displayVersion = displayVersion;
//# sourceMappingURL=arg-parser.js.map