import { IIntPoint, IntPoint } from "clipper-lib";
import { Bez3Slice } from "../shared/slice-arc";
import { FIntersection } from "./intersections";
export type IntKnot = IIntPoint & {
    t: number;
};
export declare function keyOfZ(z: IIntPoint): string;
export declare class SegEntry {
    readonly arc: Bez3Slice;
    start: number;
    end: number;
    readonly sid: number;
    readonly jid: number;
    readonly kid: number;
    constructor(arc: Bez3Slice, start: number, end: number, sid?: number, jid?: number, kid?: number);
    compare(b: SegEntry): number;
    tryAnnex(b: SegEntry): boolean;
    toArc(): Bez3Slice;
}
export declare function toPoly(shape: Bez3Slice[][], sid: number, splats: FIntersection[][], segHash: Map<string, SegEntry>, termHash: Set<string>, resolution: number): IntPoint[][];
