"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CombinedArc = void 0;
const derivable_1 = require("../../derivable");
const fn_1 = require("../../fn");
const point_1 = require("../../point/point");
const seg_index_search_1 = require("./seg-index-search");
class CombinedArc {
    constructor(segments) {
        this.segments = segments;
        this.stops = [];
        let totalLength = 0;
        for (let j = 0; j < this.segments.length; j++) {
            totalLength += segments[j].getLength();
        }
        let lengthSofar = 0;
        for (let j = 0; j < this.segments.length; j++) {
            let segLen = segments[j].getLength();
            this.stops[j] = lengthSofar / totalLength;
            lengthSofar += segLen;
        }
    }
    eval(t) {
        const j = (0, seg_index_search_1.segTSearch)(this.stops, t);
        const tBefore = this.stops[j];
        const tNext = j < this.stops.length - 1 ? this.stops[j + 1] : 1;
        const tRelative = (t - tBefore) / (tNext - tBefore);
        return this.segments[j].eval(tRelative);
    }
    derivative(t) {
        const j = (0, seg_index_search_1.segTSearch)(this.stops, t);
        const tBefore = this.stops[j];
        const tNext = j < this.stops.length - 1 ? this.stops[j + 1] : 1;
        const tRelative = (t - tBefore) / (tNext - tBefore);
        const d = this.segments[j].derivative(tRelative);
        return new point_1.Point2(d.x / (tNext - tBefore), d.y / (tNext - tBefore));
    }
    reduceIfStraight() {
        if (!this.segments.length)
            return this;
        const z0 = this.segments[0].a, z1 = this.segments[this.segments.length - 1].d;
        for (const seg of this.segments) {
            if (!(0, fn_1.numberClose)(0, point_1.Point2.pointLineDist(z0, z1, seg.a)) ||
                !(0, fn_1.numberClose)(0, point_1.Point2.pointLineDist(z0, z1, seg.b)) ||
                !(0, fn_1.numberClose)(0, point_1.Point2.pointLineDist(z0, z1, seg.c)) ||
                !(0, fn_1.numberClose)(0, point_1.Point2.pointLineDist(z0, z1, seg.d))) {
                return this;
            }
        }
        return new derivable_1.Arcs.StraightSegment(z0, z1);
    }
}
exports.CombinedArc = CombinedArc;
