"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultStylizer = exports.HighlightedRun = exports.jsCallStyle = exports.commandStylizer = void 0;
const tslib_1 = require("tslib");
const chalk_1 = tslib_1.__importDefault(require("chalk"));
const util = tslib_1.__importStar(require("util"));
exports.commandStylizer = {
    trail: "...",
    styledTrail: chalk_1.default.gray("..."),
    joiner(line) {
        return line > 0 ? "|" : "";
    },
    escape(term, lineNo, termNo) {
        return typeof term === "string"
            ? /[ ']/.test(term)
                ? "'" + term.replace(/[\\']/g, "\\$&") + "'"
                : term
            : util.inspect(term) || "";
    },
    stylize(term, lineNo, termNo, text, slicedText) {
        if (termNo === -1)
            return chalk_1.default.cyanBright(slicedText);
        if (termNo === 0)
            return chalk_1.default.blueBright.underline(slicedText);
        if (typeof term !== "string")
            return slicedText;
        if (/^-/.test(text))
            return chalk_1.default.yellow(slicedText);
        if (/^'/.test(text))
            return chalk_1.default.green(slicedText);
        return slicedText;
    },
};
exports.jsCallStyle = {
    trail: "...",
    styledTrail: chalk_1.default.gray("..."),
    joiner(line) {
        return "";
    },
    escape(term, lineNo, termNo) {
        return JSON.stringify(term) || "";
    },
    stylize(term, lineNo, termNo, text, slicedText) {
        if (termNo === 0)
            return chalk_1.default.blueBright.underline(slicedText);
        return slicedText;
    },
};
class HighlightedRun {
    constructor(style, text) {
        this.style = style;
        this.text = text;
    }
    resolve() {
        const s = HighlightedRun.styleMap[this.style];
        if (s)
            return s(String(this.text));
        else
            return String(this.text);
    }
}
exports.HighlightedRun = HighlightedRun;
HighlightedRun.styleMap = Object.create(null, {
    directive: { value: chalk_1.default.cyanBright },
    operator: { value: chalk_1.default.cyan },
    command: { value: chalk_1.default.blueBright },
    param: { value: chalk_1.default.yellow },
    quote: { value: chalk_1.default.green },
    numeric: { value: chalk_1.default.magentaBright },
});
exports.defaultStylizer = {
    trail: "...",
    styledTrail: chalk_1.default.gray("..."),
    joiner(line) {
        return "";
    },
    escape(term, lineNo, termNo) {
        if (term instanceof HighlightedRun) {
            return String(term.text);
        }
        else {
            return String(term);
        }
    },
    stylize(term, lineNo, termNo, text, slicedText) {
        if (term instanceof HighlightedRun) {
            return term.resolve();
        }
        else {
            return slicedText;
        }
    },
};
