"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GsubTableIo = void 0;
const errors_1 = require("@ot-builder/errors");
const ot_layout_1 = require("@ot-builder/ot-layout");
const table_1 = require("../gsub-gpos-shared/table");
const contextual_read_1 = require("../lookups/contextual-read");
const contextual_write_1 = require("../lookups/contextual-write");
const gsub_ligature_1 = require("../lookups/gsub-ligature");
const gsub_multi_alternate_1 = require("../lookups/gsub-multi-alternate");
const gsub_reverse_1 = require("../lookups/gsub-reverse");
const gsub_single_1 = require("../lookups/gsub-single");
const gsub = {
    extendedFormat: 7,
    isExtendedFormat: x => x === 7,
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    createReader(x) {
        switch (x) {
            case 1:
                return new gsub_single_1.GsubSingleReader();
            case 2:
                return new gsub_multi_alternate_1.GsubMultiReader();
            case 3:
                return new gsub_multi_alternate_1.GsubAlternateReader();
            case 4:
                return new gsub_ligature_1.GsubLigatureReader();
            case 5:
                return new contextual_read_1.GsubContextualReader();
            case 6:
                return new contextual_read_1.GsubChainingReader();
            case 8:
                return new gsub_reverse_1.GsubReverseReader();
            default:
                throw errors_1.Errors.FormatNotSupported(`GSUB lookup`, x);
        }
    },
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    *writers() {
        yield new gsub_single_1.GsubSingleWriter();
        yield new gsub_multi_alternate_1.GsubMultiWriter();
        yield new gsub_multi_alternate_1.GsubAlternateWriter();
        yield new gsub_ligature_1.GsubLigatureWriter();
        yield new contextual_write_1.GsubChainingContextualWriter();
        yield new gsub_reverse_1.GsubReverseWriter();
    },
    queryDependencies(lookup) {
        if (lookup.type !== ot_layout_1.Gsub.LookupType.Chaining)
            return [];
        const sink = [];
        for (const rule of lookup.rules)
            for (const app of rule.applications)
                sink.push(app.apply);
        return sink;
    }
};
exports.GsubTableIo = {
    read(view, cfg, trc) {
        const o = view.next(new table_1.CGsubGposTable(), cfg, gsub, trc);
        return new ot_layout_1.Gsub.Table(o.scripts, o.features, o.lookups, o.featureVariations);
    },
    write(frag, table, cfg, twc) {
        return frag.push(new table_1.CGsubGposTable(), table, cfg, gsub, twc);
    }
};
//# sourceMappingURL=index.js.map