import { OtGlyph } from "@ot-builder/ot-glyphs";
import { CaseType, Data } from "@ot-builder/prelude";
import * as Primitive from "@ot-builder/primitive";
import { OtVar } from "@ot-builder/variance";
import * as LayoutCommon from "../common";
import * as GeneralLookup from "./general/lookup";
import { Gsub as LookupType } from "./general/lookup-type";
import * as GsubGpos from "./table-shared";
export * as FeatureParams from "./feature-params";
export { Gsub as LookupType } from "./general/lookup-type";
export declare const Tag = "GSUB";
export declare class Table implements GsubGpos.TableT<Lookup> {
    scripts: Map<Primitive.Tag, Script>;
    features: Feature[];
    lookups: Lookup[];
    featureVariations: Data.Maybe<FeatureVariation[]>;
    constructor(scripts?: Map<Primitive.Tag, Script>, features?: Feature[], lookups?: Lookup[], featureVariations?: Data.Maybe<FeatureVariation[]>);
}
export type Feature = GsubGpos.FeatureT<Lookup>;
export type Language = GsubGpos.LanguageT<Lookup>;
export type Script = GsubGpos.ScriptT<Lookup>;
export type AxisRangeCondition = GsubGpos.AxisRangeCondition;
export type FeatureVariationCondition = GsubGpos.AxisRangeCondition;
export type FeatureVariation = GsubGpos.FeatureVariationT<Lookup>;
export type SingleProp = GeneralLookup.GsubSinglePropT<OtGlyph, OtVar.Value>;
export type Single = CaseType<typeof LookupType.Single, SingleProp>;
export declare const Single: import("@ot-builder/prelude").CaseClassType<typeof LookupType.Single, SingleProp, [props?: SingleProp | undefined]>;
export type MultipleAlternateProp = GeneralLookup.GsubMultipleAlternatePropT<OtGlyph, OtVar.Value>;
export type Multiple = CaseType<typeof LookupType.Multi, MultipleAlternateProp>;
export declare const Multiple: import("@ot-builder/prelude").CaseClassType<typeof LookupType.Multi, MultipleAlternateProp, [props?: MultipleAlternateProp | undefined]>;
export type Alternate = CaseType<typeof LookupType.Alternate, MultipleAlternateProp>;
export declare const Alternate: import("@ot-builder/prelude").CaseClassType<typeof LookupType.Alternate, MultipleAlternateProp, [props?: MultipleAlternateProp | undefined]>;
export type LigatureProp = GeneralLookup.GsubLigaturePropT<OtGlyph, OtVar.Value>;
export type Ligature = CaseType<typeof LookupType.Ligature, LigatureProp>;
export declare const Ligature: import("@ot-builder/prelude").CaseClassType<typeof LookupType.Ligature, LigatureProp, [props?: LigatureProp | undefined]>;
export type ChainingProp = GeneralLookup.ForwardChainingPropT<OtGlyph, OtVar.Value, Lookup>;
export type Chaining = CaseType<typeof LookupType.Chaining, ChainingProp>;
export declare const Chaining: import("@ot-builder/prelude").CaseClassType<typeof LookupType.Chaining, ChainingProp, [props?: ChainingProp | undefined]>;
export type ReverseSubProp = GeneralLookup.GsubReverseSingleSubPropT<OtGlyph, OtVar.Value>;
export type ReverseSub = CaseType<typeof LookupType.Reverse, ReverseSubProp>;
export declare const ReverseSub: import("@ot-builder/prelude").CaseClassType<typeof LookupType.Reverse, ReverseSubProp, [props?: ReverseSubProp | undefined]>;
export type Lookup = Single | Multiple | Alternate | Ligature | Chaining | ReverseSub;
export type Coverage = LayoutCommon.Coverage.T<OtGlyph>;
export type ClassDef = LayoutCommon.ClassDef.T<OtGlyph>;
export type LigatureEntry = GeneralLookup.GsubLigatureLookupEntryT<OtGlyph>;
export type ChainingApplication<E> = GsubGpos.ChainingApplication<E>;
export type ChainingRule<E> = GsubGpos.ChainingRule<E>;
export type ChainingClassRule = GsubGpos.ChainingClassRule<Lookup>;
export type ReverseRule = GeneralLookup.GsubReverseRuleT<OtGlyph, Set<OtGlyph>>;
//# sourceMappingURL=table-gsub.d.ts.map