// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Defines the parameters for retrieving Amazon Web Services cost and usage data.
// Includes specifications for metrics, time periods, granularity, grouping
// dimensions, and filtering conditions.
type CostAndUsageQuery struct {

	// The granularity of the retrieved data: HOURLY , DAILY , or MONTHLY .
	//
	// This member is required.
	Granularity Granularity

	// The specific cost and usage metrics to retrieve.
	//
	// Valid values for CostAndUsageQuery metrics are AmortizedCost , BlendedCost ,
	// NetAmortizedCost , NetUnblendedCost , NormalizedUsageAmount , UnblendedCost ,
	// and UsageQuantity .
	//
	// This member is required.
	Metrics []MetricName

	// The time period for which to retrieve data. Can be specified as absolute dates
	// or relative time periods.
	//
	// This member is required.
	TimeRange *DateTimeRange

	// The filter expression to be applied to the cost and usage data.
	Filter *Expression

	// Specifies how to group the retrieved data, such as by SERVICE , ACCOUNT , or TAG
	// .
	GroupBy []GroupDefinition

	noSmithyDocumentSerde
}

// Specifies the values and match options for cost category-based filtering in
// cost and usage queries.
type CostCategoryValues struct {

	// The key of the cost category to filter on.
	Key *string

	// The match options for cost category values, such as EQUALS , CONTAINS ,
	// STARTS_WITH , or ENDS_WITH .
	MatchOptions []MatchOption

	// The values to match for the specified cost category key.
	Values []string

	noSmithyDocumentSerde
}

// Contains basic information about a dashboard, including its ARN, name, type,
// and timestamps.
type DashboardReference struct {

	// The ARN of the referenced dashboard.
	//
	// This member is required.
	Arn *string

	// The timestamp when the dashboard was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The name of the referenced dashboard.
	//
	// This member is required.
	Name *string

	// The dashboard type.
	//
	// This member is required.
	Type DashboardType

	// The timestamp when the dashboard was last modified.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the referenced dashboard.
	Description *string

	noSmithyDocumentSerde
}

// Defines a time period with explicit start and end times for data queries.
type DateTimeRange struct {

	// The end time of the date range for querying data.
	//
	// This member is required.
	EndTime *DateTimeValue

	// The start time of the date range for querying data.
	//
	// This member is required.
	StartTime *DateTimeValue

	noSmithyDocumentSerde
}

// Represents a point in time that can be specified as either an absolute date
// (for example, "2025-07-01") or a relative time period using ISO 8601 duration
// format (for example, "-P3M" for three months ago).
type DateTimeValue struct {

	// The type of date/time value: ABSOLUTE for specific dates or RELATIVE for
	// dynamic time periods.
	//
	// This member is required.
	Type DateTimeType

	// The actual date/time value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Specifies the values and match options for dimension-based filtering in cost
// and usage queries.
type DimensionValues struct {

	// The key of the dimension to filter on (for example, SERVICE , USAGE_TYPE , or
	// OPERATION ).
	//
	// This member is required.
	Key Dimension

	// The values to match for the specified dimension key.
	//
	// This member is required.
	Values []string

	// The match options for dimension values, such as EQUALS , CONTAINS , STARTS_WITH
	// , or ENDS_WITH .
	MatchOptions []MatchOption

	noSmithyDocumentSerde
}

// Defines how the widget's data should be visualized, including chart type, color
// schemes, axis configurations, and other display preferences.
//
// The following types satisfy this interface:
//
//	DisplayConfigMemberGraph
//	DisplayConfigMemberTable
type DisplayConfig interface {
	isDisplayConfig()
}

// The configuration for graphical display of the widget data, including chart
// type and visual options.
type DisplayConfigMemberGraph struct {
	Value map[string]GraphDisplayConfig

	noSmithyDocumentSerde
}

func (*DisplayConfigMemberGraph) isDisplayConfig() {}

// The configuration for tabular display of the widget data.
type DisplayConfigMemberTable struct {
	Value TableDisplayConfigStruct

	noSmithyDocumentSerde
}

func (*DisplayConfigMemberTable) isDisplayConfig() {}

// Defines complex filtering conditions using logical operators ( AND , OR , NOT )
// and various filter types.
type Expression struct {

	// A list of expressions to combine with AND logic.
	And []Expression

	// The cost category values to include in the filter expression.
	CostCategories *CostCategoryValues

	// The dimension values to include in the filter expression.
	Dimensions *DimensionValues

	// An expression to negate with NOT logic.
	Not *Expression

	// A list of expressions to combine with OR logic.
	Or []Expression

	// The tag values to include in the filter expression.
	Tags *TagValues

	noSmithyDocumentSerde
}

// Defines the visual representation settings for widget data, including the
// visualization type, styling options, and display preferences for different
// metric types.
type GraphDisplayConfig struct {

	// The type of visualization to use for the data.
	//
	// This member is required.
	VisualType VisualType

	noSmithyDocumentSerde
}

// Specifies how to group cost and usage data.
type GroupDefinition struct {

	// The key to use for grouping cost and usage data.
	//
	// This member is required.
	Key *string

	// The type of grouping to apply.
	Type GroupDefinitionType

	noSmithyDocumentSerde
}

// Defines the data retrieval parameters for a widget.
//
// The following types satisfy this interface:
//
//	QueryParametersMemberCostAndUsage
//	QueryParametersMemberReservationCoverage
//	QueryParametersMemberReservationUtilization
//	QueryParametersMemberSavingsPlansCoverage
//	QueryParametersMemberSavingsPlansUtilization
type QueryParameters interface {
	isQueryParameters()
}

// The parameters for querying cost and usage data, including metrics, time range,
// granularity, grouping dimensions, and filters.
type QueryParametersMemberCostAndUsage struct {
	Value CostAndUsageQuery

	noSmithyDocumentSerde
}

func (*QueryParametersMemberCostAndUsage) isQueryParameters() {}

// The parameters for querying Reserved Instance coverage data, showing how much
// of your eligible instance usage is covered by Reserved Instances.
type QueryParametersMemberReservationCoverage struct {
	Value ReservationCoverageQuery

	noSmithyDocumentSerde
}

func (*QueryParametersMemberReservationCoverage) isQueryParameters() {}

// The parameters for querying Reserved Instance utilization data, showing how
// effectively your Reserved Instances are being used.
type QueryParametersMemberReservationUtilization struct {
	Value ReservationUtilizationQuery

	noSmithyDocumentSerde
}

func (*QueryParametersMemberReservationUtilization) isQueryParameters() {}

// The parameters for querying Savings Plans coverage data, showing how much of
// your eligible compute usage is covered by Savings Plans.
type QueryParametersMemberSavingsPlansCoverage struct {
	Value SavingsPlansCoverageQuery

	noSmithyDocumentSerde
}

func (*QueryParametersMemberSavingsPlansCoverage) isQueryParameters() {}

// The parameters for querying Savings Plans utilization data, showing how
// effectively your Savings Plans are being used.
type QueryParametersMemberSavingsPlansUtilization struct {
	Value SavingsPlansUtilizationQuery

	noSmithyDocumentSerde
}

func (*QueryParametersMemberSavingsPlansUtilization) isQueryParameters() {}

// Defines the parameters for querying Reserved Instance coverage data, including
// grouping options, metrics, and sorting preferences.
type ReservationCoverageQuery struct {

	// Defines a time period with explicit start and end times for data queries.
	//
	// This member is required.
	TimeRange *DateTimeRange

	// Defines complex filtering conditions using logical operators ( AND , OR , NOT )
	// and various filter types.
	Filter *Expression

	// The time granularity of the retrieved data: HOURLY , DAILY , or MONTHLY .
	Granularity Granularity

	// Specifies how to group the Reserved Instance coverage data, such as by service,
	// Region, or instance type.
	GroupBy []GroupDefinition

	// The coverage metrics to include in the results.
	//
	// Valid values for ReservationCoverageQuery metrics are Hour , Unit , and Cost .
	Metrics []MetricName

	noSmithyDocumentSerde
}

// Defines the parameters for querying Reserved Instance utilization data,
// including grouping options and time granularity.
type ReservationUtilizationQuery struct {

	// Defines a time period with explicit start and end times for data queries.
	//
	// This member is required.
	TimeRange *DateTimeRange

	// Defines complex filtering conditions using logical operators ( AND , OR , NOT )
	// and various filter types.
	Filter *Expression

	// The time granularity of the retrieved data: HOURLY , DAILY , or MONTHLY .
	Granularity Granularity

	// Specifies how to group the Reserved Instance utilization data, such as by
	// service, Region, or instance type.
	GroupBy []GroupDefinition

	noSmithyDocumentSerde
}

// A key-value pair that can be attached to a dashboard for organization and
// management purposes.
type ResourceTag struct {

	// The key of the tag to be attached to the dashboard resource.
	//
	// This member is required.
	Key *string

	// The value of the tag to be attached to the dashboard resource.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Defines the parameters for querying Savings Plans coverage data, including
// metrics, grouping options, and time granularity.
type SavingsPlansCoverageQuery struct {

	// Defines a time period with explicit start and end times for data queries.
	//
	// This member is required.
	TimeRange *DateTimeRange

	// Defines complex filtering conditions using logical operators ( AND , OR , NOT )
	// and various filter types.
	Filter *Expression

	// The time granularity of the retrieved data: HOURLY , DAILY , or MONTHLY .
	Granularity Granularity

	// Specifies how to group the Savings Plans coverage data, such as by service or
	// instance family.
	GroupBy []GroupDefinition

	// The coverage metrics to include in the results.
	//
	// Valid value for SavingsPlansCoverageQuery metrics is SpendCoveredBySavingsPlans .
	Metrics []MetricName

	noSmithyDocumentSerde
}

// Defines the parameters for querying Savings Plans utilization data, including
// time granularity and sorting preferences.
type SavingsPlansUtilizationQuery struct {

	// Defines a time period with explicit start and end times for data queries.
	//
	// This member is required.
	TimeRange *DateTimeRange

	// Defines complex filtering conditions using logical operators ( AND , OR , NOT )
	// and various filter types.
	Filter *Expression

	// The time granularity of the retrieved data: HOURLY, DAILY, or MONTHLY.
	Granularity Granularity

	noSmithyDocumentSerde
}

// Configuration structure for customizing the tabular display of widget data.
type TableDisplayConfigStruct struct {
	noSmithyDocumentSerde
}

// Specifies tag-based filtering options for cost and usage queries.
type TagValues struct {

	// The key of the tag to filter on.
	Key *string

	// The match options for tag values, such as EQUALS , CONTAINS , STARTS_WITH , or
	// ENDS_WITH .
	MatchOptions []MatchOption

	// The values to match for the specified tag key.
	Values []string

	noSmithyDocumentSerde
}

// A configurable visualization component within a dashboard that displays
// specific cost and usage metrics. Each widget can show data as charts or tables
// and includes settings for data querying, filtering, and visual presentation.
type Widget struct {

	// An array of configurations that define the data queries and display settings
	// for the widget.
	//
	// This member is required.
	Configs []WidgetConfig

	// The title of the widget.
	//
	// This member is required.
	Title *string

	// A description of the widget's purpose or the data it displays.
	Description *string

	// The height of the widget in row spans. The dashboard layout consists of a grid
	// system.
	Height *int32

	// Specifies the starting column position of the widget in the dashboard's grid
	// layout. Used to control widget placement.
	HorizontalOffset int32

	// The width of the widget in column spans. The dashboard layout consists of a
	// grid system.
	Width *int32

	noSmithyDocumentSerde
}

// Defines the complete configuration for a widget, including data retrieval
// settings and visualization preferences.
type WidgetConfig struct {

	// The configuration that determines how the retrieved data should be visualized
	// in the widget.
	//
	// This member is required.
	DisplayConfig DisplayConfig

	// The parameters that define what data the widget should retrieve and how it
	// should be filtered or grouped.
	//
	// This member is required.
	QueryParameters QueryParameters

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isDisplayConfig()   {}
func (*UnknownUnionMember) isQueryParameters() {}
