//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armazurestackhci

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
)

// GuestAgentsClient contains the methods for the GuestAgents group.
// Don't use this type directly, use NewGuestAgentsClient() instead.
type GuestAgentsClient struct {
	internal *arm.Client
}

// NewGuestAgentsClient creates a new instance of GuestAgentsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewGuestAgentsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*GuestAgentsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &GuestAgentsClient{
		internal: cl,
	}
	return client, nil
}

// NewListPager - Returns the list of GuestAgent of the given vm.
//
// Generated from API version 2023-09-01-preview
//   - resourceURI - The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
//   - options - GuestAgentsClientListOptions contains the optional parameters for the GuestAgentsClient.NewListPager method.
func (client *GuestAgentsClient) NewListPager(resourceURI string, options *GuestAgentsClientListOptions) *runtime.Pager[GuestAgentsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[GuestAgentsClientListResponse]{
		More: func(page GuestAgentsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *GuestAgentsClientListResponse) (GuestAgentsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "GuestAgentsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceURI, options)
			}, nil)
			if err != nil {
				return GuestAgentsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *GuestAgentsClient) listCreateRequest(ctx context.Context, resourceURI string, options *GuestAgentsClientListOptions) (*policy.Request, error) {
	urlPath := "/{resourceUri}/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default/guestAgents"
	urlPath = strings.ReplaceAll(urlPath, "{resourceUri}", resourceURI)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *GuestAgentsClient) listHandleResponse(resp *http.Response) (GuestAgentsClientListResponse, error) {
	result := GuestAgentsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GuestAgentList); err != nil {
		return GuestAgentsClientListResponse{}, err
	}
	return result, nil
}
