# Contributing

Before making any changes to this repository, we kindly request you to initiate discussions for proposed changes that do not yet have an associated [issue](https://github.com/gofiber/fiber/issues). Please use our [Discord](https://gofiber.io/discord) server to initiate these discussions. For [issue](https://github.com/gofiber/fiber/issues) that already exist, you may proceed with discussions using our [issue](https://github.com/gofiber/fiber/issues) tracker or any other suitable method, in consultation with the repository owners. Your collaboration is greatly appreciated.

Please note: we have a [code of conduct](https://github.com/gofiber/fiber/blob/main/.github/CODE_OF_CONDUCT.md), please follow it in all your interactions with the `Fiber` project.

## Pull Requests or Commits

Titles always we must use prefix according to below:

> 🔥 Feature, ♻️ Refactor, 🩹 Fix, 🚨 Test, 📚 Doc, 🎨 Style

- 🔥 Feature: Add flow to add person
- ♻️ Refactor: Rename file X to Y
- 🩹 Fix: Improve flow
- 🚨 Test: Validate to add a new person
- 📚 Doc: Translate to Portuguese middleware redirect
- 🎨 Style: Respected pattern Golint

All pull requests that contain a feature or fix are mandatory to have unit tests. Your PR is only to be merged if you respect this flow.

## 👍 Contribute

If you want to say **thank you** and/or support the active development of `Fiber`:

1. Add a [GitHub Star](https://github.com/gofiber/fiber/stargazers) to the project.
2. Tweet about the project [on your 𝕏 (Twitter)](https://x.com/intent/tweet?text=%F0%9F%9A%80%20Fiber%20%E2%80%94%20is%20an%20Express.js%20inspired%20web%20framework%20build%20on%20Fasthttp%20for%20%23Go%20https%3A%2F%2Fgithub.com%2Fgofiber%2Ffiber).
3. Write a review or tutorial on [Medium](https://medium.com/), [Dev.to](https://dev.to/) or personal blog.
4. Support the project by donating a [cup of coffee](https://buymeacoff.ee/fenny).
