// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package accounts

import (
	"bytes"
	"context"
	"fmt"
	"io"
	"math"
	"net/http"
	"net/url"

	accountspb "cloud.google.com/go/shopping/merchant/accounts/apiv1beta/accountspb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/googleapi"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/encoding/protojson"
)

var newEmailPreferencesClientHook clientHook

// EmailPreferencesCallOptions contains the retry settings for each method of EmailPreferencesClient.
type EmailPreferencesCallOptions struct {
	GetEmailPreferences    []gax.CallOption
	UpdateEmailPreferences []gax.CallOption
}

func defaultEmailPreferencesGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("merchantapi.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("merchantapi.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("merchantapi.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://merchantapi.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultEmailPreferencesCallOptions() *EmailPreferencesCallOptions {
	return &EmailPreferencesCallOptions{
		GetEmailPreferences:    []gax.CallOption{},
		UpdateEmailPreferences: []gax.CallOption{},
	}
}

func defaultEmailPreferencesRESTCallOptions() *EmailPreferencesCallOptions {
	return &EmailPreferencesCallOptions{
		GetEmailPreferences:    []gax.CallOption{},
		UpdateEmailPreferences: []gax.CallOption{},
	}
}

// internalEmailPreferencesClient is an interface that defines the methods available from Merchant API.
type internalEmailPreferencesClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	GetEmailPreferences(context.Context, *accountspb.GetEmailPreferencesRequest, ...gax.CallOption) (*accountspb.EmailPreferences, error)
	UpdateEmailPreferences(context.Context, *accountspb.UpdateEmailPreferencesRequest, ...gax.CallOption) (*accountspb.EmailPreferences, error)
}

// EmailPreferencesClient is a client for interacting with Merchant API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Service to support the EmailPreferences API.
//
// This service only permits retrieving and updating email preferences for the
// authenticated user.
type EmailPreferencesClient struct {
	// The internal transport-dependent client.
	internalClient internalEmailPreferencesClient

	// The call options for this service.
	CallOptions *EmailPreferencesCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *EmailPreferencesClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *EmailPreferencesClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *EmailPreferencesClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// GetEmailPreferences returns the email preferences for a Merchant Center account user.
//
// Use the name=accounts/*/users/me/emailPreferences alias to get preferences
// for the authenticated user.
func (c *EmailPreferencesClient) GetEmailPreferences(ctx context.Context, req *accountspb.GetEmailPreferencesRequest, opts ...gax.CallOption) (*accountspb.EmailPreferences, error) {
	return c.internalClient.GetEmailPreferences(ctx, req, opts...)
}

// UpdateEmailPreferences updates the email preferences for a Merchant Center account user. MCA users
// should specify the MCA account rather than a sub-account of the MCA.
//
// Preferences which are not explicitly selected in the update mask will not
// be updated.
//
// It is invalid for updates to specify an UNCONFIRMED opt-in status value.
//
// Use the name=accounts/*/users/me/emailPreferences alias to update
// preferences
// for the authenticated user.
func (c *EmailPreferencesClient) UpdateEmailPreferences(ctx context.Context, req *accountspb.UpdateEmailPreferencesRequest, opts ...gax.CallOption) (*accountspb.EmailPreferences, error) {
	return c.internalClient.UpdateEmailPreferences(ctx, req, opts...)
}

// emailPreferencesGRPCClient is a client for interacting with Merchant API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type emailPreferencesGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing EmailPreferencesClient
	CallOptions **EmailPreferencesCallOptions

	// The gRPC API client.
	emailPreferencesClient accountspb.EmailPreferencesServiceClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewEmailPreferencesClient creates a new email preferences service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Service to support the EmailPreferences API.
//
// This service only permits retrieving and updating email preferences for the
// authenticated user.
func NewEmailPreferencesClient(ctx context.Context, opts ...option.ClientOption) (*EmailPreferencesClient, error) {
	clientOpts := defaultEmailPreferencesGRPCClientOptions()
	if newEmailPreferencesClientHook != nil {
		hookOpts, err := newEmailPreferencesClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := EmailPreferencesClient{CallOptions: defaultEmailPreferencesCallOptions()}

	c := &emailPreferencesGRPCClient{
		connPool:               connPool,
		emailPreferencesClient: accountspb.NewEmailPreferencesServiceClient(connPool),
		CallOptions:            &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *emailPreferencesGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *emailPreferencesGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *emailPreferencesGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type emailPreferencesRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing EmailPreferencesClient
	CallOptions **EmailPreferencesCallOptions
}

// NewEmailPreferencesRESTClient creates a new email preferences service rest client.
//
// Service to support the EmailPreferences API.
//
// This service only permits retrieving and updating email preferences for the
// authenticated user.
func NewEmailPreferencesRESTClient(ctx context.Context, opts ...option.ClientOption) (*EmailPreferencesClient, error) {
	clientOpts := append(defaultEmailPreferencesRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultEmailPreferencesRESTCallOptions()
	c := &emailPreferencesRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
	}
	c.setGoogleClientInfo()

	return &EmailPreferencesClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultEmailPreferencesRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://merchantapi.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://merchantapi.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://merchantapi.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://merchantapi.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *emailPreferencesRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *emailPreferencesRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *emailPreferencesRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *emailPreferencesGRPCClient) GetEmailPreferences(ctx context.Context, req *accountspb.GetEmailPreferencesRequest, opts ...gax.CallOption) (*accountspb.EmailPreferences, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetEmailPreferences[0:len((*c.CallOptions).GetEmailPreferences):len((*c.CallOptions).GetEmailPreferences)], opts...)
	var resp *accountspb.EmailPreferences
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.emailPreferencesClient.GetEmailPreferences(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *emailPreferencesGRPCClient) UpdateEmailPreferences(ctx context.Context, req *accountspb.UpdateEmailPreferencesRequest, opts ...gax.CallOption) (*accountspb.EmailPreferences, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "email_preferences.name", url.QueryEscape(req.GetEmailPreferences().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateEmailPreferences[0:len((*c.CallOptions).UpdateEmailPreferences):len((*c.CallOptions).UpdateEmailPreferences)], opts...)
	var resp *accountspb.EmailPreferences
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.emailPreferencesClient.UpdateEmailPreferences(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// GetEmailPreferences returns the email preferences for a Merchant Center account user.
//
// Use the name=accounts/*/users/me/emailPreferences alias to get preferences
// for the authenticated user.
func (c *emailPreferencesRESTClient) GetEmailPreferences(ctx context.Context, req *accountspb.GetEmailPreferencesRequest, opts ...gax.CallOption) (*accountspb.EmailPreferences, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/accounts/v1beta/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetEmailPreferences[0:len((*c.CallOptions).GetEmailPreferences):len((*c.CallOptions).GetEmailPreferences)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &accountspb.EmailPreferences{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateEmailPreferences updates the email preferences for a Merchant Center account user. MCA users
// should specify the MCA account rather than a sub-account of the MCA.
//
// Preferences which are not explicitly selected in the update mask will not
// be updated.
//
// It is invalid for updates to specify an UNCONFIRMED opt-in status value.
//
// Use the name=accounts/*/users/me/emailPreferences alias to update
// preferences
// for the authenticated user.
func (c *emailPreferencesRESTClient) UpdateEmailPreferences(ctx context.Context, req *accountspb.UpdateEmailPreferencesRequest, opts ...gax.CallOption) (*accountspb.EmailPreferences, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetEmailPreferences()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/accounts/v1beta/%v", req.GetEmailPreferences().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "email_preferences.name", url.QueryEscape(req.GetEmailPreferences().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateEmailPreferences[0:len((*c.CallOptions).UpdateEmailPreferences):len((*c.CallOptions).UpdateEmailPreferences)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &accountspb.EmailPreferences{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
