#pragma once
/*
 *  $Id: grains.h 28952 2025-12-05 18:34:48Z yeti-dn $
 *  Copyright (C) 2003-2022 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_GRAINS_H__
#define __GWY_GRAINS_H__

#include <libgwyddion/field.h>
#include <libgwyddion/types.h>
#include <libgwyddion/distance-transform.h>
#include <libgwyddion/grain-quantities.h>

G_BEGIN_DECLS

void                 gwy_field_grains_mark_watershed            (GwyField *field,
                                                                 GwyField *grain_field,
                                                                 gint locate_steps,
                                                                 gint locate_thresh,
                                                                 gdouble locate_dropsize,
                                                                 gint wshed_steps,
                                                                 gdouble wshed_dropsize,
                                                                 gboolean prefilter,
                                                                 gboolean below);
gboolean             gwy_field_grains_remove_grain              (GwyField *grain_field,
                                                                 gint col,
                                                                 gint row);
gboolean             gwy_field_grains_extract_grain             (GwyField *grain_field,
                                                                 gint col,
                                                                 gint row);
void                 gwy_field_grains_remove_by_number          (GwyField *grain_field,
                                                                 gint number);
void                 gwy_field_grains_remove_by_size            (GwyField *grain_field,
                                                                 gint size);
void                 gwy_field_grains_remove_by_height          (GwyField *field,
                                                                 GwyField *grain_field,
                                                                 gdouble threshval,
                                                                 gboolean below);
void                 gwy_field_grains_remove_touching_border    (GwyField *grain_field);
GwyComputationState* gwy_field_grains_watershed_init            (GwyField *field,
                                                                 GwyField *grain_field,
                                                                 gint locate_steps,
                                                                 gint locate_thresh,
                                                                 gdouble locate_dropsize,
                                                                 gint wshed_steps,
                                                                 gdouble wshed_dropsize,
                                                                 gboolean prefilter,
                                                                 gboolean below);
void                 gwy_field_grains_watershed_iteration       (GwyComputationState *state);
void                 gwy_field_grains_watershed_finalize        (GwyComputationState *state);
void                 gwy_field_grains_mark_height               (GwyField *field,
                                                                 GwyField *grain_field,
                                                                 gdouble threshval,
                                                                 gboolean below);
void                 gwy_field_grains_mark_slope                (GwyField *field,
                                                                 GwyField *grain_field,
                                                                 gdouble threshval,
                                                                 gboolean below);
void                 gwy_field_grains_mark_curvature            (GwyField *field,
                                                                 GwyField *grain_field,
                                                                 gdouble threshval,
                                                                 gboolean below);
void                 gwy_field_grains_add                       (GwyField *grain_field,
                                                                 GwyField *add_field);
void                 gwy_field_grains_intersect                 (GwyField *grain_field,
                                                                 GwyField *intersect_field);
void                 gwy_field_grains_invert                    (GwyField *grain_field);
gboolean             gwy_field_grains_autocrop                  (GwyField *mask_field,
                                                                 gboolean symmetrically,
                                                                 guint *left,
                                                                 guint *right,
                                                                 guint *up,
                                                                 guint *down);
gint                 gwy_field_number_grains                    (GwyField *mask_field,
                                                                 gint *grains);
gint                 gwy_field_number_grains_periodic           (GwyField *mask_field,
                                                                 gint *grains);
gint*                gwy_field_get_grain_bounding_boxes         (GwyField *mask_field,
                                                                 gint ngrains,
                                                                 const gint *grains,
                                                                 gint *bboxes);
gint*                gwy_field_get_grain_bounding_boxes_periodic(GwyField *mask_field,
                                                                 gint ngrains,
                                                                 const gint *grains,
                                                                 gint *bboxes);
gint*                gwy_field_get_grain_sizes                  (GwyField *mask_field,
                                                                 gint ngrains,
                                                                 const gint *grains,
                                                                 gint *sizes);
gint*                gwy_field_get_grain_inscribed_boxes        (GwyField *mask_field,
                                                                 gint ngrains,
                                                                 const gint *grains,
                                                                 gint *iboxes);
gint*                gwy_field_grains_find_boundaries           (GwyField *field,
                                                                 const gint *grains,
                                                                 gint ngrains,
                                                                 gint *bindex,
                                                                 gboolean from_border);
GwyLine*             gwy_field_grains_get_distribution          (GwyField *field,
                                                                 GwyField *grain_field,
                                                                 GwyLine *distribution,
                                                                 gint ngrains,
                                                                 const gint *grains,
                                                                 GwyGrainQuantity quantity,
                                                                 gint nstats);
gdouble*             gwy_field_grains_get_values                (GwyField *field,
                                                                 gdouble *values,
                                                                 gint ngrains,
                                                                 const gint *grains,
                                                                 GwyGrainQuantity quantity);
gdouble**            gwy_field_grains_get_quantities            (GwyField *field,
                                                                 gdouble **values,
                                                                 const GwyGrainQuantity *quantities,
                                                                 guint nquantities,
                                                                 guint ngrains,
                                                                 const gint *grains);
void                 gwy_field_grains_splash_water              (GwyField *field,
                                                                 GwyField *minima,
                                                                 gint locate_steps,
                                                                 gdouble locate_dropsize);
void                 gwy_field_grain_distance_transform         (GwyField *field);
void                 gwy_field_grain_simple_dist_trans          (GwyField *field,
                                                                 GwyDistanceTransformType dtype,
                                                                 gboolean from_border);
void                 gwy_field_grains_shrink                    (GwyField *field,
                                                                 gdouble amount,
                                                                 GwyDistanceTransformType dtype,
                                                                 gboolean from_border);
void                 gwy_field_grains_grow                      (GwyField *field,
                                                                 gdouble amount,
                                                                 GwyDistanceTransformType dtype,
                                                                 gboolean prevent_merging);
void                 gwy_field_grains_thin                      (GwyField *field);
gboolean             gwy_field_fill_voids                       (GwyField *field,
                                                                 gboolean nonsimple);
gint                 gwy_field_waterpour                        (GwyField *field,
                                                                 GwyField *result,
                                                                 gint *grains);
void                 gwy_field_mark_extrema                     (GwyField *dfield,
                                                                 GwyField *extrema,
                                                                 gboolean maxima);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
