/*
 * Logserver
 * Copyright (C) 2017-2025 Joel Reardon
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include "test.h"

#include "run.h"

TEST_CASE("one command") {
	Run run("echo hello world");
	CHECK(run.command() == "echo hello world");
	run();
	string result = run.read();
	CHECK(result == "hello world\n");
}

TEST_CASE("one command with data") {
	string input = "one\ntwo\nthree\nfour\nfive";
	string sorted = "five\nfour\none\nthree\ntwo\n";
	Run run("sort");
	CHECK(static_cast<int>(input.size())==
	      ::write(run.write_fd(), input.data(),
				      input.size()));
	close(run.write_fd());
	CHECK(run.command() == "sort");
	run();
	string result = run.read();
	CHECK(result == sorted);
}

TEST_CASE("piped command with data") {
	string input = "one\ntwo\none\none\nfive";
	string sorted = "five\none\ntwo\n";
	Run run("sort | uniq", input);
	close(run.write_fd());
	run();
	run.finish();
	string result = run.read();
	CHECK(result == sorted);
}

TEST_CASE("piped command with data and args") {
	string input = "one\ntwo\none\none\nfive";
	stringstream ss;
	ss << "1 five 3 one 1 two";
	Run run("sort | uniq -c", input);
	close(run.write_fd());
	run();
	run.finish();
	string result = run.read();
	stringstream ss_result;
	ss_result << result;
	while (ss.good()) {
		CHECK(ss_result.good());
		string s1, s2;
		ss >> s1;
		ss_result >> s2;
		CHECK(s1 == s2);
	}
}
