/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QTreeView>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/Ionizer.hpp>


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "MzCalculationTreeViewItem.hpp"
#include "MzCalculationDlg.hpp"


namespace MsXpS
{
namespace MassXpert
{


class MzCalculationTreeViewItem;
class MzCalculationDlg;


class MzCalculationTreeViewModel : public QAbstractItemModel
{
  Q_OBJECT
  public:
  MzCalculationTreeViewModel(std::vector<IonSPtr> *ions_p, QObject *parent);

  ~MzCalculationTreeViewModel();

  MzCalculationDlg *getParentDlg();

  void setTreeView(QTreeView *);
  QTreeView *treeView();

  QVariant data(const QModelIndex &, int) const;

  QVariant headerData(int, Qt::Orientation, int = Qt::DisplayRole) const;

  Qt::ItemFlags flags(const QModelIndex &) const;

  QModelIndex index(int, int, const QModelIndex & = QModelIndex()) const;

  QModelIndex parent(const QModelIndex &) const;

  int rowCount(const QModelIndex & = QModelIndex()) const;
  int columnCount(const QModelIndex & = QModelIndex()) const;

  void removeAll();

  void addIon(IonSPtr ion_sp);
  bool setupModelData(MzCalculationTreeViewItem *);

  protected:
  std::vector<IonSPtr> *mp_ions;
  MzCalculationTreeViewItem *mpa_rootItem;
  QTreeView *mp_treeView;
  MzCalculationDlg *mp_parentDlg;
};


} // namespace MassXpert
} // namespace MsXpS
