/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/PkaPhPi.hpp>


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "ui_PkaPhPiDlg.h"
#include "AbstractSeqEdWndDependentDlg.hpp"
#include "SequenceEditorWnd.hpp"


namespace MsXpS
{
namespace MassXpert
{


enum
{
  TARGET_PI         = 0,
  TARGET_NET_CHARGE = 1
};


class PkaPhPiDlg : public AbstractSeqEdWndDependentDlg
{
  Q_OBJECT

  public:
  PkaPhPiDlg(SequenceEditorWnd *editor_wnd_p,
             libXpertMassCore::PolymerQSPtr polymer_sp,
             /* no libXpertMassCore::PolChemDef **/
             const QString &config_settings_file_path,
             const QString &application_name,
             const QString &description,
             const libXpertMassCore::PkaPhPi &pka_ph_pi,
             const libXpertMassCore::CalcOptions &calc_options);

  ~PkaPhPiDlg();

  bool initialize();

  public slots:
  void netCharge();
  void isoelectricPoint();
  void exportResults(int);

  private:
  Ui::PkaPhPiDlg m_ui;

  // The results-exporting strings. ////////////////////////////////
  QString *mpa_resultsString;
  QString m_resultsFilePath;
  //////////////////////////////////// The results-exporting strings.

  libXpertMassCore::PkaPhPi m_pkaPhPi;

  libXpertMassCore::CalcOptions m_calcOptions;

  int m_startIndex       = 0;
  int m_endIndex         = 0;
  int m_chemGroupsTested = 0;

  bool fetchValidateInputData();

  // The results-exporting functions. ////////////////////////////////
  void prepareResultsTxtString(int);
  bool exportResultsClipboard();
  bool exportResultsFile();
  bool selectResultsFile();
  //////////////////////////////////// The results-exporting functions.
};


} // namespace MassXpert
} // namespace MsXpS
