#include "testing/testing.hpp"

#include "coding/sha1.hpp"


namespace sha1_test
{
using namespace coding;

UNIT_TEST(SHA1_Smoke)
{
  char const * bytes[] =
  {
    "H",
    "He",
    "Hel",
    "Hell",
    "Hello",
    "Hello,",
    "Hello, ",
    "Hello, World!",
    "Organic Maps is the ultimate companion app for travellers, tourists, hikers, and cyclists!",
  };

  SHA1::Hash encoded[] =
  {
    {0x7C, 0xF1, 0x84, 0xF4, 0xC6, 0x7A, 0xD5, 0x82, 0x83, 0xEC, 0xB1, 0x93, 0x49, 0x72, 0x0B, 0x0C, 0xAE, 0x75, 0x68, 0x29},
    {0x53, 0xA4, 0x17, 0x79, 0x6C, 0x77, 0x78, 0x51, 0x00, 0x3B, 0x3F, 0x24, 0x31, 0xE8, 0xEE, 0xF5, 0x62, 0x5E, 0xC1, 0x5B},
    {0xDB, 0xC2, 0xD1, 0xFE, 0xD0, 0xDC, 0x37, 0xA7, 0x0A, 0xEA, 0x0F, 0x37, 0x69, 0x58, 0xC8, 0x02, 0xED, 0xDC, 0x05, 0x59},
    {0xED, 0x10, 0xFE, 0x11, 0x3D, 0xE1, 0xC0, 0xBD, 0xAA, 0xAA, 0xF0, 0x9B, 0x88, 0xCD, 0x34, 0x1E, 0xA0, 0xF4, 0x44, 0x28},
    {0xF7, 0xFF, 0x9E, 0x8B, 0x7B, 0xB2, 0xE0, 0x9B, 0x70, 0x93, 0x5A, 0x5D, 0x78, 0x5E, 0x0C, 0xC5, 0xD9, 0xD0, 0xAB, 0xF0},
    {0x65, 0x61, 0x1E, 0x95, 0x20, 0xE7, 0x68, 0x14, 0x5D, 0xAD, 0xAA, 0x1D, 0x10, 0x7F, 0xDD, 0x52, 0x07, 0xE6, 0x30, 0x57},
    {0xF5, 0x2A, 0xB5, 0x7F, 0xA5, 0x1D, 0xFA, 0x71, 0x45, 0x05, 0x29, 0x44, 0x44, 0x46, 0x3A, 0xE5, 0xA0, 0x09, 0xAE, 0x34},
    {0x0A, 0x0A, 0x9F, 0x2A, 0x67, 0x72, 0x94, 0x25, 0x57, 0xAB, 0x53, 0x55, 0xD7, 0x6A, 0xF4, 0x42, 0xF8, 0xF6, 0x5E, 0x01},
    {0x48, 0xF5, 0x4D, 0x3D, 0x08, 0xD5, 0xC0, 0x57, 0x6B, 0x3A, 0xC5, 0x3E, 0xEF, 0x22, 0x4A, 0xB8, 0x46, 0x7B, 0xA2, 0xFC},
  };

  static_assert(std::size(bytes) == std::size(encoded));

  for (size_t i = 0; i < std::size(bytes); ++i)
    TEST_EQUAL(SHA1::CalculateForString(bytes[i]), encoded[i], ());
}
}
