% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/croston.R
\name{croston_model}
\alias{croston_model}
\title{Croston forecast model}
\usage{
croston_model(y, alpha = 0.1, type = c("croston", "sba", "sbj"))
}
\arguments{
\item{y}{a numeric vector or univariate time series of class \code{ts}}

\item{alpha}{Value of alpha. Default value is 0.1.}

\item{type}{Which variant of Croston's method to use. Defaults to \code{"croston"} for
Croston's method, but can also be set to \code{"sba"} for the Syntetos-Boylan
approximation, and \code{"sbj"} for the Shale-Boylan-Johnston method.}
}
\value{
An object of class \code{croston_model}
}
\description{
Based on Croston's (1972) method for intermittent demand forecasting, also described in Shenstone and Hyndman (2005).
Croston's method involves using simple exponential smoothing (SES) on the non-zero elements of the time series
and a separate application of SES to the times between non-zero elements of the time series.
Returns a model object that can be used to generate forecasts using Croston's method
for intermittent demand time series. It isn't a true statistical model in that it
doesn't describe a data generating process that would lead to the forecasts produced
using Croston's method.
}
\details{
Note that prediction intervals are not computed as Croston's method has no
underlying stochastic model.

There are two variant methods available which apply multiplicative correction factors
to the forecasts that result from the original Croston's method. For the
Syntetos-Boylan approximation (\code{type = "sba"}), this factor is \eqn{1 - \alpha / 2},
and for the Shale-Boylan-Johnston method (\code{type = "sbj"}), this factor is
\eqn{1 - \alpha / (2 - \alpha)}, where \eqn{\alpha} is the smoothing parameter for
the interval SES application.
}
\examples{
y <- rpois(20, lambda = 0.3)
fit <- croston_model(y)
forecast(fit) |> autoplot()
}
\references{
Croston, J. (1972) "Forecasting and stock control for
intermittent demands", \emph{Operational Research Quarterly}, \bold{23}(3),
289-303.

Shale, E.A., Boylan, J.E., & Johnston, F.R. (2006). Forecasting for intermittent demand:
the estimation of an unbiased average. \emph{Journal of the Operational Research Society}, \bold{57}(5), 588-592.

Shenstone, L., and Hyndman, R.J. (2005) "Stochastic models underlying
Croston's method for intermittent demand forecasting". \emph{Journal of
Forecasting}, \bold{24}, 389-402.

Syntetos A.A., Boylan J.E. (2001). On the bias of intermittent demand estimates.
\emph{International Journal of Production Economics}, \bold{71}, 457–466.
}
\author{
Rob J Hyndman
}
