% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.table.prodlim.R
\name{as.data.table.prodlim}
\alias{as.data.table.prodlim}
\title{Turn prodlim objects into a \code{\link[data.table]{data.table}}}
\usage{
\method{as.data.table}{prodlim}(x, keep.rownames = FALSE, ...)
}
\arguments{
\item{x}{object obtained with function \code{\link{prodlim}}}

\item{keep.rownames}{Not used}

\item{...}{passed to \code{\link{summary.prodlim}}}
}
\value{
A data.table with the results of the prodlim object
}
\description{
Collect results of a fitted prodlim object in a data.table
}
\details{
By default object contains results for all fitted time points and all strata.
Use arguments times and newdata of \code{\link{summary.prodlim}} to subset.
}
\examples{
library(data.table)
set.seed(8)
d <- SimCompRisk(17)
fit <- prodlim(Hist(time,event)~X1,data=d)
as.data.table(fit)

}
\seealso{
\code{\link{prodlim}}, \code{\link[data.table]{data.table}}
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
