% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{obj_is_list}
\alias{obj_is_list}
\alias{obj_check_list}
\alias{list_all_vectors}
\alias{list_check_all_vectors}
\alias{list_all_size}
\alias{list_check_all_size}
\alias{list_all_recyclable}
\alias{list_check_all_recyclable}
\title{List checks}
\usage{
obj_is_list(x)

obj_check_list(x, ..., arg = caller_arg(x), call = caller_env())

list_all_vectors(x, ..., allow_null = FALSE)

list_check_all_vectors(
  x,
  ...,
  allow_null = FALSE,
  arg = caller_arg(x),
  call = caller_env()
)

list_all_size(x, size, ..., allow_null = FALSE)

list_check_all_size(
  x,
  size,
  ...,
  allow_null = FALSE,
  arg = caller_arg(x),
  call = caller_env()
)

list_all_recyclable(x, size, ..., allow_null = FALSE)

list_check_all_recyclable(
  x,
  size,
  ...,
  allow_null = FALSE,
  arg = caller_arg(x),
  call = caller_env()
)
}
\arguments{
\item{x}{For \verb{vec_*()} functions, an object. For \verb{list_*()} functions, a
list.}

\item{...}{These dots are for future extensions and must be empty.}

\item{arg}{An argument name as a string. This argument
will be mentioned in error messages as the input that is at the
origin of a problem.}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}

\item{allow_null}{Whether \code{NULL} elements should be skipped over
automatically or not.}

\item{size}{The size to check each element for compatibility with.}
}
\description{
\itemize{
\item \code{obj_is_list()} tests if \code{x} is considered a list in the vctrs sense. It
returns \code{TRUE} if all of the following hold:
\itemize{
\item \code{x} must have list storage, i.e. \code{typeof(x)} returns \code{"list"}
\item \code{x} must not have a \code{dim} attribute
\item \code{x} must not have a \code{class} attribute, or must explicitly inherit from
\code{"list"} as the last class
}
\item \code{list_all_vectors()} takes a list and returns \code{TRUE} if all elements of
that list are vectors.
\item \code{list_all_size()} takes a list and returns \code{TRUE} if all elements of that
list have the same \code{size}.
\item \code{list_all_recyclable()} takes a list and returns \code{TRUE} if all elements of
that list can recycle to \code{size}.
\item \code{obj_check_list()}, \code{list_check_all_vectors()}, \code{list_check_all_size()},
and \code{list_check_all_recyclable()} use the above functions, but throw a
standardized and informative error if they return \code{FALSE}.
}
}
\details{
Notably, data frames and S3 record style classes like POSIXlt are not
considered lists.
}
\examples{
obj_is_list(list())
obj_is_list(list_of(1))
obj_is_list(data.frame())

list_all_vectors(list(1, mtcars))
list_all_vectors(list(1, environment()))

list_all_size(list(1:2, 2:3), 2)
list_all_size(list(1:2, 2:4), 2)

list_all_recyclable(list(1, 2:3), 2)
list_all_recyclable(list(1, 2:4), 2)

# `list_`-prefixed functions assume a list:
try(list_all_vectors(environment()))

# `NULL` elements are not considered vectors and generally have a size of 0
try(list_check_all_vectors(list(1, NULL, 2)))
try(list_check_all_size(list(1, NULL, 2), size = 1))

# However, it is often useful to perform upfront vector/size checks on a
# list, excluding `NULL`s, and then filter them out later on
list_check_all_vectors(list(1, NULL, 2), allow_null = TRUE)
list_check_all_size(list(1, NULL, 2), size = 1, allow_null = TRUE)

# Performing the checks before removing `NULL`s from the list ensures that
# any errors report the correct index. Note how the index is incorrect from a
# user's point of view if we filter out `NULL` too soon.
xs <- list(1, NULL, 2:3)
try(list_check_all_size(xs, size = 1, allow_null = TRUE))
xs <- vec_slice(xs, !vec_detect_missing(xs))
try(list_check_all_size(xs, size = 1))
}
\seealso{
\code{\link[=list_sizes]{list_sizes()}}
}
