% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_types.R
\name{cols}
\alias{cols}
\alias{col_types}
\alias{cols_only}
\alias{col_logical}
\alias{col_integer}
\alias{col_big_integer}
\alias{col_double}
\alias{col_character}
\alias{col_skip}
\alias{col_number}
\alias{col_guess}
\alias{col_factor}
\alias{col_datetime}
\alias{col_date}
\alias{col_time}
\title{Create column specification}
\usage{
cols(..., .default = col_guess(), .delim = NULL)

cols_only(...)

col_logical(...)

col_integer(...)

col_big_integer(...)

col_double(...)

col_character(...)

col_skip(...)

col_number(...)

col_guess(...)

col_factor(levels = NULL, ordered = FALSE, include_na = FALSE, ...)

col_datetime(format = "", ...)

col_date(format = "", ...)

col_time(format = "", ...)
}
\arguments{
\item{...}{Either column objects created by \verb{col_*()}, or their abbreviated
character names (as described in the \code{col_types} argument of
\code{\link[=vroom]{vroom()}}). If you're only overriding a few columns, it's
best to refer to columns by name. If not named, the column types must match
the column names exactly. In \verb{col_*()} functions these are stored in the
object.}

\item{.default}{Any named columns not explicitly overridden in \code{...}
will be read with this column type.}

\item{.delim}{The delimiter to use when parsing. If the \code{delim} argument
used in the call to \code{vroom()} it takes precedence over the one specified in
\code{col_types}.}

\item{levels}{Character vector of the allowed levels. When \code{levels = NULL}
(the default), \code{levels} are discovered from the unique values of the data,
in the order in which they are encountered.}

\item{ordered}{Is it an ordered factor?}

\item{include_na}{If \code{TRUE} and the data contains at least one \code{NA}, then
\code{NA} is included in the levels of the constructed factor.}

\item{format}{A format specification. If set to "":
\itemize{
\item \code{col_datetime()} expects ISO8601 datetimes. Here are some examples of
input that should just work:
"2024-01-15", "2024-01-15 14:30:00", "2024-01-15T14:30:00Z".
\item \code{col_date()} uses the \code{date_format} from \code{\link[=locale]{locale()}} (default \code{"\%AD"}).
These inputs should just work: "2024-01-15", "01/15/2024".
\item \code{col_time()} uses the \code{time_format} from \code{\link[=locale]{locale()}} (default \code{"\%AT"}).
These inputs should just work: "14:30:00", "2:30:00 PM".
}

Unlike \code{\link[=strptime]{strptime()}}, the format specification must match the complete
string. For more details, see below.}
}
\description{
\code{cols()} includes all columns in the input data, guessing the column types
as the default. \code{cols_only()} includes only the columns you explicitly
specify, skipping the rest.
}
\details{
The available specifications are: (long names in quotes and string abbreviations in brackets)\tabular{llll}{
   function \tab long name \tab short name \tab description \cr
   \code{col_logical()} \tab "logical" \tab "l" \tab Logical values containing only \code{T}, \code{F}, \code{TRUE} or \code{FALSE}. \cr
   \code{col_integer()} \tab "integer" \tab "i" \tab Integer numbers. \cr
   \code{col_big_integer()} \tab "big_integer" \tab "I" \tab Big Integers (64bit), requires the \code{bit64} package. \cr
   \code{col_double()} \tab "double", "numeric" \tab "d" \tab 64-bit double floating point numbers. \cr
   \code{col_character()} \tab "character" \tab "c" \tab Character string data. \cr
   \code{col_factor(levels, ordered)} \tab "factor" \tab "f" \tab A fixed set of values. \cr
   \code{col_date(format = "")} \tab "date" \tab "D" \tab Calendar dates formatted with the locale's \code{date_format}. \cr
   \code{col_time(format = "")} \tab "time" \tab "t" \tab Times formatted with the locale's \code{time_format}. \cr
   \code{col_datetime(format = "")} \tab "datetime", "POSIXct" \tab "T" \tab ISO8601 date times. \cr
   \code{col_number()} \tab "number" \tab "n" \tab Human readable numbers containing the \code{grouping_mark} \cr
   \code{col_skip()} \tab "skip", "NULL" \tab "_", "-" \tab Skip and don't import this column. \cr
   \code{col_guess()} \tab "guess", "NA" \tab "?" \tab Parse using the "best" guessed type based on the input. \cr
}

\subsection{Date, time, and datetime formats:}{

\pkg{vroom} uses a format specification similar to \code{\link[=strptime]{strptime()}}.
There are three types of element:
\enumerate{
\item A conversion specification that is "\%" followed by a letter. For example
"\%Y" matches a 4 digit year, "\%m", matches a 2 digit month and "\%d" matches
a 2 digit day. Month and day default to \code{1}, (i.e. Jan 1st) if not present,
for example if only a year is given.
\item Whitespace is any sequence of zero or more whitespace characters.
\item Any other character is matched exactly.
}

\pkg{vroom}'s datetime \verb{col_*()} functions recognize the following
specifications:
\itemize{
\item Year: "\%Y" (4 digits). "\%y" (2 digits); 00-69 -> 2000-2069, 70-99 ->
1970-1999.
\item Month: "\%m" (2 digits), "\%b" (abbreviated name in current locale), "\%B"
(full name in current locale).
\item Day: "\%d" (2 digits), "\%e" (optional leading space), "\%a" (abbreviated
name in current locale).
\item Hour: "\%H" or "\%I" or "\%h", use I (and not H) with AM/PM, use h (and not H)
if your times represent durations longer than one day.
\item Minutes: "\%M"
\item Seconds: "\%S" (integer seconds), "\%OS" (partial seconds)
\item Time zone: "\%Z" (as name, e.g. "America/Chicago"), "\%z" (as offset from
UTC, e.g. "+0800")
\item AM/PM indicator: "\%p".
\item Non-digits: "\%." skips one non-digit character, "\%+" skips one or more
non-digit characters, "\%*" skips any number of non-digits characters.
\item Automatic parsers: "\%AD" parses with a flexible YMD parser, "\%AT" parses
with a flexible HMS parser.
\item Shortcuts: "\%D" = "\%m/\%d/\%y", "\%F" = "\%Y-\%m-\%d", "\%R" = "\%H:\%M", "\%T" =
"\%H:\%M:\%S", "\%x" = "\%y/\%m/\%d".
}
\subsection{ISO8601 support}{

Currently, vroom does not support all of ISO8601. Missing features:
\itemize{
\item Week & weekday specifications, e.g. "2013-W05", "2013-W05-10".
\item Ordinal dates, e.g. "2013-095".
\item Using commas instead of a period for decimal separator.
}

The parser is also a little laxer than ISO8601:
\itemize{
\item Dates and times can be separated with a space, not just T.
\item Mostly correct specifications like "2009-05-19 14:" and "200912-01" work.
}
}

}
}
\examples{
cols(a = col_integer())
cols_only(a = col_integer())

# You can also use the standard abbreviations
cols(a = "i")
cols(a = "i", b = "d", c = "_")

# Or long names (like utils::read.csv)
cols(a = "integer", b = "double", c = "skip")

# You can also use multiple sets of column definitions by combining
# them like so:

t1 <- cols(
  column_one = col_integer(),
  column_two = col_number())

t2 <- cols(
 column_three = col_character())

t3 <- t1
t3$cols <- c(t1$cols, t2$cols)
t3
}
