# SPDX-License-Identifier: GPL-2.0-only
# This file is part of Scapy RPC
# See https://scapy.net/ for more information
# Copyright (C) Gabriel Potter

# ms-wkst.idl compiled on 06/07/2025
# This file is a stripped version ! Use scapy-rpc for the full.
"""
RPC definitions for the following interfaces:
- wkssvc (v1.0): 6BFFD098-A112-3610-9833-46C3F87E345A
This file is auto-generated by midl-to-scapy, do not modify.
"""

from enum import IntEnum
import uuid

from scapy.fields import StrFixedLenField
from scapy.layers.dcerpc import (
    NDRPacket,
    DceRpcOp,
    NDRConfPacketListField,
    NDRConfVarStrLenField,
    NDRConfVarStrLenFieldUtf16,
    NDRConfVarStrNullField,
    NDRConfVarStrNullFieldUtf16,
    NDRFullEmbPointerField,
    NDRFullPointerField,
    NDRInt3264EnumField,
    NDRIntField,
    NDRPacketField,
    NDRShortField,
    NDRSignedIntField,
    NDRUnionField,
    register_dcerpc_interface,
)


class LPWKSTA_INFO_100(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("wki100_platform_id", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("wki100_computername", "")),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("wki100_langroup", "")),
        NDRIntField("wki100_ver_major", 0),
        NDRIntField("wki100_ver_minor", 0),
    ]


class LPWKSTA_INFO_101(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("wki101_platform_id", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("wki101_computername", "")),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("wki101_langroup", "")),
        NDRIntField("wki101_ver_major", 0),
        NDRIntField("wki101_ver_minor", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("wki101_lanroot", "")),
    ]


class LPWKSTA_INFO_102(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("wki102_platform_id", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("wki102_computername", "")),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("wki102_langroup", "")),
        NDRIntField("wki102_ver_major", 0),
        NDRIntField("wki102_ver_minor", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("wki102_lanroot", "")),
        NDRIntField("wki102_logged_on_users", 0),
    ]


class LPWKSTA_INFO_502(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [
        NDRIntField("wki502_char_wait", 0),
        NDRIntField("wki502_collection_time", 0),
        NDRIntField("wki502_maximum_collection_count", 0),
        NDRIntField("wki502_keep_conn", 0),
        NDRIntField("wki502_max_cmds", 0),
        NDRIntField("wki502_sess_timeout", 0),
        NDRIntField("wki502_siz_char_buf", 0),
        NDRIntField("wki502_max_threads", 0),
        NDRIntField("wki502_lock_quota", 0),
        NDRIntField("wki502_lock_increment", 0),
        NDRIntField("wki502_lock_maximum", 0),
        NDRIntField("wki502_pipe_increment", 0),
        NDRIntField("wki502_pipe_maximum", 0),
        NDRIntField("wki502_cache_file_timeout", 0),
        NDRIntField("wki502_dormant_file_limit", 0),
        NDRIntField("wki502_read_ahead_throughput", 0),
        NDRIntField("wki502_num_mailslot_buffers", 0),
        NDRIntField("wki502_num_srv_announce_buffers", 0),
        NDRIntField("wki502_max_illegal_datagram_events", 0),
        NDRIntField("wki502_illegal_datagram_event_reset_frequency", 0),
        NDRSignedIntField("wki502_log_election_packets", 0),
        NDRSignedIntField("wki502_use_opportunistic_locking", 0),
        NDRSignedIntField("wki502_use_unlock_behind", 0),
        NDRSignedIntField("wki502_use_close_behind", 0),
        NDRSignedIntField("wki502_buf_named_pipes", 0),
        NDRSignedIntField("wki502_use_lock_read_unlock", 0),
        NDRSignedIntField("wki502_utilize_nt_caching", 0),
        NDRSignedIntField("wki502_use_raw_read", 0),
        NDRSignedIntField("wki502_use_raw_write", 0),
        NDRSignedIntField("wki502_use_write_raw_data", 0),
        NDRSignedIntField("wki502_use_encryption", 0),
        NDRSignedIntField("wki502_buf_files_deny_write", 0),
        NDRSignedIntField("wki502_buf_read_only_files", 0),
        NDRSignedIntField("wki502_force_core_create_mode", 0),
        NDRSignedIntField("wki502_use_512_byte_max_transfer", 0),
    ]


class LPWKSTA_INFO_1013(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("wki1013_keep_conn", 0)]


class LPWKSTA_INFO_1018(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("wki1018_sess_timeout", 0)]


class LPWKSTA_INFO_1046(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("wki1046_dormant_file_limit", 0)]


class NetrWkstaGetInfo_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRIntField("Level", 0),
    ]


class NetrWkstaGetInfo_Response(NDRPacket):
    fields_desc = [
        NDRUnionField(
            [
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "WkstaInfo", LPWKSTA_INFO_100(), LPWKSTA_INFO_100
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 100),
                        (lambda _, val: val.tag == 100),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "WkstaInfo", LPWKSTA_INFO_101(), LPWKSTA_INFO_101
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 101),
                        (lambda _, val: val.tag == 101),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "WkstaInfo", LPWKSTA_INFO_102(), LPWKSTA_INFO_102
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 102),
                        (lambda _, val: val.tag == 102),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "WkstaInfo", LPWKSTA_INFO_502(), LPWKSTA_INFO_502
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 502),
                        (lambda _, val: val.tag == 502),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "WkstaInfo", LPWKSTA_INFO_1013(), LPWKSTA_INFO_1013
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1013),
                        (lambda _, val: val.tag == 1013),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "WkstaInfo", LPWKSTA_INFO_1018(), LPWKSTA_INFO_1018
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1018),
                        (lambda _, val: val.tag == 1018),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "WkstaInfo", LPWKSTA_INFO_1046(), LPWKSTA_INFO_1046
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1046),
                        (lambda _, val: val.tag == 1046),
                    ),
                ),
            ],
            StrFixedLenField("WkstaInfo", "", length=0),
            align=(4, 8),
            switch_fmt=("L", "L"),
        ),
        NDRIntField("status", 0),
    ]


class NET_COMPUTER_NAME_TYPE(IntEnum):
    NetPrimaryComputerName = 0
    NetAlternateComputerNames = 1
    NetAllComputerNames = 2
    NetComputerNameTypeMax = 3


class PUNICODE_STRING(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRShortField("Length", None, size_of="Buffer", adjust=lambda _, x: (x * 2)),
        NDRShortField(
            "MaximumLength", None, size_of="Buffer", adjust=lambda _, x: (x * 2)
        ),
        NDRFullEmbPointerField(
            NDRConfVarStrLenFieldUtf16(
                "Buffer",
                "",
                size_is=lambda pkt: (pkt.MaximumLength // 2),
                length_is=lambda pkt: (pkt.Length // 2),
            )
        ),
    ]


class PNET_COMPUTER_NAME_ARRAY(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("EntryCount", None, size_of="ComputerNames"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "ComputerNames",
                [PUNICODE_STRING()],
                PUNICODE_STRING,
                size_is=lambda pkt: pkt.EntryCount,
            )
        ),
    ]


class NetrEnumerateComputerNames_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRInt3264EnumField("NameType", 0, NET_COMPUTER_NAME_TYPE),
        NDRIntField("Reserved", 0),
    ]


class NetrEnumerateComputerNames_Response(NDRPacket):
    fields_desc = [
        NDRFullPointerField(
            NDRPacketField(
                "ComputerNames", PNET_COMPUTER_NAME_ARRAY(), PNET_COMPUTER_NAME_ARRAY
            )
        ),
        NDRIntField("status", 0),
    ]


WKSSVC_OPNUMS = {
    0: DceRpcOp(NetrWkstaGetInfo_Request, NetrWkstaGetInfo_Response),
    # 3: Opnum3NotUsedOnWire,
    # 4: Opnum4NotUsedOnWire,
    # 12: Opnum12NotUsedOnWire,
    # 14: Opnum14NotUsedOnWire,
    # 15: Opnum15NotUsedOnWire,
    # 16: Opnum16NotUsedOnWire,
    # 17: Opnum17NotUsedOnWire,
    # 18: Opnum18NotUsedOnWire,
    # 19: Opnum19NotUsedOnWire,
    # 21: Opnum21NotUsedOnWire,
    30: DceRpcOp(
        NetrEnumerateComputerNames_Request, NetrEnumerateComputerNames_Response
    ),
}
register_dcerpc_interface(
    name="wkssvc",
    uuid=uuid.UUID("6BFFD098-A112-3610-9833-46C3F87E345A"),
    version="1.0",
    opnums=WKSSVC_OPNUMS,
)
