/*
 * This file is part of LibEuFin.
 * Copyright (C) 2025 Taler Systems S.A.

 * LibEuFin is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation; either version 3, or
 * (at your option) any later version.

 * LibEuFin is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General
 * Public License for more details.

 * You should have received a copy of the GNU Affero General Public
 * License along with LibEuFin; see the file COPYING.  If not, see
 * <http://www.gnu.org/licenses/>
 */

import org.w3c.dom.Document
import com.github.ajalt.clikt.core.CliktCommand
import com.github.ajalt.clikt.testing.test
import kotlinx.coroutines.runBlocking
import io.ktor.http.*
import io.ktor.http.content.*
import org.junit.Test
import tech.libeufin.ebisync.cli.LibeufinEbisync
import tech.libeufin.ebisync.CHECKPOINT_KEY
import tech.libeufin.common.*
import tech.libeufin.common.test.*
import tech.libeufin.common.crypto.CryptoUtil
import tech.libeufin.ebics.test.*
import tech.libeufin.ebics.*
import kotlin.io.path.*
import kotlin.test.*
import java.time.LocalDate

@OptIn(kotlin.io.path.ExperimentalPathApi::class)
class EbicsTest {
    private val cmd = LibeufinEbisync()
    private val bank = EbicsState()
    private val args = "-L TRACE -c conf/test.conf"

    private fun ebicsSetup() {
        // Reset current keys
        val dir = Path("/tmp/ebics-test")
        dir.deleteRecursively()
        dir.createDirectories()

        // Set setup mock
        setMock(sequence {
            yield(bank::hev)
            yield(bank::ini)
            yield(bank::hia)
            yield(bank::hpb)
            yield(bank::hkd)
            yield(bank::receiptOk)
        })

        // Run setup
        cmd.succeed("setup $args --auto-accept-keys")
    }

    @Test
    fun setup() {
        ebicsSetup()
    }
}