/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_check_donau_instance.h
 * @brief implementation of the check_donau_instance function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_CHECK_DONAU_INSTANCE_H
#define PG_CHECK_DONAU_INSTANCE_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"


/**
 * Check if information about a Donau instance exists.
 *
 * @param cls closure
 * @param merchant_pub public key of the instance
 * @param donau_url URL of the Donau instance
 * @param charity_id charity ID of the Donau instance
 */
enum GNUNET_DB_QueryStatus
TMH_PG_check_donau_instance (
  void *cls,
  const struct TALER_MerchantPublicKeyP *merchant_pub,
  const char *donau_url,
  uint64_t charity_id
  );

#endif
